/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QElementDef;
import com.caucho.xml.QEntity;
import com.caucho.xml.QNamedNodeMap;
import com.caucho.xml.QNode;
import com.caucho.xml.QNotation;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QDocumentType
extends QNode
implements DocumentType {
    String name;
    HashMap elements = new HashMap();
    HashMap entities = new HashMap();
    HashMap notations = new HashMap();
    HashMap parameterEntities = new HashMap();
    HashMap ids = new HashMap();
    String systemId;
    String publicId;

    public String getNodeName() {
        return "#documenttype";
    }

    public String getTagName() {
        return "#documenttype";
    }

    public short getNodeType() {
        return 10;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public NamedNodeMap getEntities() {
        return new QNamedNodeMap(this.entities);
    }

    public NamedNodeMap getNotations() {
        return new QNamedNodeMap(this.notations);
    }

    public Node cloneNode(boolean bl) {
        QDocumentType qDocumentType = new QDocumentType(this.name);
        return qDocumentType;
    }

    void addNotation(QNotation qNotation) {
        this.notations.put(qNotation.name, qNotation);
    }

    public String getElementId(String string) {
        return (String)this.ids.get(string);
    }

    public Iterator getElementIdNames() {
        return this.ids.keySet().iterator();
    }

    void setElementId(String string, String string2) {
        this.ids.put(string, string2);
    }

    void addEntity(QEntity qEntity) {
        if (this.entities.get(qEntity.name) == null) {
            this.entities.put(qEntity.name, qEntity);
        }
    }

    QEntity getEntity(String string) {
        return (QEntity)this.entities.get(string);
    }

    void addParameterEntity(QEntity qEntity) {
        if (this.parameterEntities.get(qEntity.name) == null) {
            this.parameterEntities.put(qEntity.name, qEntity);
        }
    }

    QEntity getParameterEntity(String string) {
        return (QEntity)this.parameterEntities.get(string);
    }

    String getEntityValue(String string) {
        QEntity qEntity = (QEntity)this.entities.get(string);
        if (qEntity == null) {
            return null;
        }
        return qEntity.value;
    }

    boolean isExternal() {
        return this.systemId != null || this.publicId != null;
    }

    public QElementDef getElement(String string) {
        return (QElementDef)this.elements.get(string);
    }

    QElementDef addElement(String string) {
        QElementDef qElementDef = (QElementDef)this.elements.get(string);
        if (qElementDef == null) {
            qElementDef = new QElementDef(string);
            this.elements.put(string, qElementDef);
            this.appendChild(qElementDef);
        }
        return qElementDef;
    }

    void print(XmlPrinter xmlPrinter) throws IOException {
        xmlPrinter.print("<!DOCTYPE ");
        xmlPrinter.print(this.getName());
        if (this.publicId != null) {
            xmlPrinter.print(" PUBLIC \"");
            xmlPrinter.print(this.publicId);
            xmlPrinter.print("\" \"");
            xmlPrinter.print(this.systemId);
            xmlPrinter.print("\"");
        } else if (this.systemId != null) {
            xmlPrinter.print(" SYSTEM \"");
            xmlPrinter.print(this.systemId);
            xmlPrinter.print("\"");
        }
        if (this.firstChild != null) {
            xmlPrinter.println(" [");
            QAbstractNode qAbstractNode = this.firstChild;
            while (qAbstractNode != null) {
                qAbstractNode.print(xmlPrinter);
                xmlPrinter.println("");
                qAbstractNode = qAbstractNode.next;
            }
            xmlPrinter.print("]>");
        } else {
            xmlPrinter.print(">");
        }
    }

    QDocumentType(String string) {
        this.name = string;
        this.entities.put("amp", new QEntity("amp", "&"));
        this.entities.put("lt", new QEntity("lt", "<"));
        this.entities.put("gt", new QEntity("gt", ">"));
        this.entities.put("quot", new QEntity("quot", "\""));
        this.entities.put("apos", new QEntity("apos", "'"));
    }
}

