/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.java.LineMap;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.Entities;
import com.caucho.xml.HtmlEntities;
import com.caucho.xml.Latin1Entities;
import com.caucho.xml.OtherEntities;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QAttributedNode;
import com.caucho.xml.QCharacterData;
import com.caucho.xml.QElement;
import com.caucho.xml.XmlEntities;
import com.caucho.xml.XmlLatin1Entities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlPrinter {
    private static HashMap empties = new HashMap();
    private static HashMap booleanAttrs;
    private WriteStream os;
    boolean isHtml;
    boolean isSgml;
    boolean isPretty;
    boolean printDeclaration;
    String standalone;
    String systemId;
    String publicId;
    boolean escapeText = true;
    int indent;
    private HashMap namespace;
    private HashMap cdataElements;
    private Entities entities;
    private String mimeType;
    private LineMap lineMap;
    private int line;

    public static void printXml(WriteStream writeStream, Node node) throws IOException {
        XmlPrinter xmlPrinter = new XmlPrinter(writeStream);
        ((QAbstractNode)node).print(xmlPrinter);
    }

    public static void printHtml(WriteStream writeStream, Node node) throws IOException {
        XmlPrinter xmlPrinter = new XmlPrinter(writeStream);
        xmlPrinter.setHtml(4.0);
        ((QAbstractNode)node).print(xmlPrinter);
    }

    public static void printPrettyXml(WriteStream writeStream, Node node) throws IOException {
        XmlPrinter xmlPrinter = new XmlPrinter(writeStream);
        xmlPrinter.isPretty = true;
        ((QAbstractNode)node).print(xmlPrinter);
    }

    public void setEscaping(boolean bl) {
        this.escapeText = bl;
    }

    public boolean getEscaping() {
        return this.escapeText;
    }

    public void setHtml(double d) {
        if (d <= 0.0) {
            this.isHtml = false;
        } else {
            this.isHtml = true;
            String string = this.os.getEncoding();
            this.entities = string == null || string.equals("ISO-8859-1") ? Latin1Entities.create(d) : (string.equals("US-ASCII") ? HtmlEntities.create(d) : OtherEntities.create(d));
        }
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    boolean isHtml() {
        return this.isHtml;
    }

    public void setPretty(boolean bl) {
        this.isPretty = bl;
    }

    public void setPrintDeclaration(boolean bl) {
        this.printDeclaration = bl;
    }

    boolean getPrintDeclaration() {
        return this.printDeclaration;
    }

    public void setStandalone(String string) {
        this.standalone = string;
    }

    String getStandalone() {
        return this.standalone;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    String getSystemId() {
        return this.systemId;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    String getPublicId() {
        return this.publicId;
    }

    public void setLineMap(String string) {
        this.lineMap = new LineMap(string);
    }

    public LineMap getLineMap() {
        return this.lineMap;
    }

    public void addCdataElement(String string) {
        if (this.cdataElements == null) {
            this.cdataElements = new HashMap();
        }
        this.cdataElements.put(string, "");
    }

    public void printNode(Node node) throws IOException {
        ((QAbstractNode)node).print(this);
    }

    public void print(Node node) throws IOException {
        ((QAbstractNode)node).print(this);
    }

    WriteStream getStream() {
        return this.os;
    }

    void printText(QCharacterData qCharacterData) throws IOException {
        if (this.lineMap != null && qCharacterData.getFilename() != null) {
            this.lineMap.add(qCharacterData.getFilename(), qCharacterData.getLine(), this.line);
        }
        this.printText(qCharacterData.getData());
    }

    void printText(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (!this.escapeText) {
            this.print(string);
        } else {
            this.entities.printText(this, string, false);
        }
    }

    void printElement(QElement qElement) throws IOException {
        String string;
        String string2;
        Iterator iterator;
        HashMap<String, String> hashMap;
        if (this.lineMap != null && qElement.getFilename() != null) {
            this.lineMap.add(qElement.getFilename(), qElement.getLine(), this.line);
        }
        boolean bl = false;
        if (this.isPretty && ((hashMap = qElement.getPreviousSibling()) == null || hashMap.getNodeType() != 3 && hashMap.getNodeType() != 5)) {
            bl = true;
            if (qElement.getParentNode() != qElement.owner) {
                this.println();
                int n = 0;
                while (n < this.indent) {
                    this.os.print(' ');
                    ++n;
                }
            }
        }
        hashMap = null;
        if (qElement.getPrefixName() != null) {
            String string3 = qElement.getPrefixName();
            iterator = qElement.getNamespace();
            string2 = (String)this.namespace.get(string3);
            if (iterator != null && string2 != null && !((String)((Object)iterator)).equals(string2)) {
                hashMap = new HashMap<String, String>();
                hashMap.put(string3, (String)((Object)iterator));
            }
        }
        this.print("<");
        this.print(qElement.getTagName());
        hashMap = this.printAttributes(qElement, hashMap);
        if (qElement.owner.element == qElement) {
            Iterator iterator2 = qElement.owner.getNamespaceKeys();
            while (iterator2 != null && iterator2.hasNext()) {
                iterator = (String)iterator2.next();
                string2 = qElement.owner.getNamespace((String)((Object)iterator));
                this.printNamespaceDecl((String)((Object)iterator), string2);
                this.namespace.put(iterator, string2);
            }
        }
        HashMap hashMap2 = null;
        if (hashMap != null) {
            hashMap2 = new HashMap();
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                string = (String)hashMap.get(string2);
                hashMap2.put(string2, this.namespace.get(string2));
                this.namespace.put(string2, string);
                this.printNamespaceDecl(string2, string);
            }
        }
        if (qElement.getFirstChild() == null) {
            this.printEmptyTag(qElement);
        } else {
            this.printElementContents(qElement, bl);
        }
        if (hashMap2 != null) {
            iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                string = (String)hashMap2.get(string2);
                this.namespace.put(string2, string);
            }
        }
    }

    private void printElementContents(CauchoElement cauchoElement, boolean bl) throws IOException {
        this.print(">");
        this.indent += 2;
        boolean bl2 = this.escapeText;
        boolean bl3 = this.isPretty;
        if (this.isHtml) {
            this.printHtmlSpecial(cauchoElement);
        }
        Node node = (QAbstractNode)cauchoElement.getFirstChild();
        while (node != null) {
            if (this.cdataElements != null && node.getNodeType() == 3 && this.cdataElements.get(cauchoElement.getNodeName()) != null) {
                this.print("<![CDATA[");
                this.print(((QAbstractNode)node).getTextValue());
                this.print("]]>");
            } else {
                ((QAbstractNode)node).print(this);
            }
            node = (QAbstractNode)((QAbstractNode)node).getNextSibling();
        }
        this.escapeText = bl2;
        this.indent -= 2;
        if (this.isPretty && ((node = cauchoElement.getLastChild()) == null || node.getNodeType() != 3 && node.getNodeType() != 5)) {
            this.println();
            int n = 0;
            while (n < this.indent) {
                this.os.print(' ');
                ++n;
            }
        }
        this.print("</");
        this.print(cauchoElement.getTagName());
        this.print(">");
        this.isPretty = bl3;
    }

    private void printHtmlSpecial(CauchoElement cauchoElement) throws IOException {
        String string = cauchoElement.getNodeName();
        if (string.equalsIgnoreCase("script") || string.equalsIgnoreCase("style")) {
            this.escapeText = false;
        } else if (string.equalsIgnoreCase("pre")) {
            this.isPretty = false;
        } else if (this.printDeclaration && string.equalsIgnoreCase("html")) {
            String string2;
            Node node = cauchoElement.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("head")) {
                    return;
                }
                if (node.getNodeType() == 1) break;
                node = node.getNextSibling();
            }
            String string3 = this.os.getEncoding();
            if (string3 == null || string3.equals("US-ASCII")) {
                string3 = "ISO-8859-1";
            }
            if ((string2 = this.mimeType) == null) {
                string2 = "text/html";
            }
            this.println("");
            this.println("  <head>");
            this.println("    <meta http-equiv='Content-Type' content='" + string2 + "; charset=" + string3 + "'>");
            this.os.print("  </head>");
        } else if (this.printDeclaration && string.equalsIgnoreCase("head")) {
            Object object;
            Object object2;
            Node node = cauchoElement.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("meta")) {
                    object2 = (CauchoElement)node;
                    object = object2.getFirstAttribute();
                    while (object != null) {
                        if (object.getNodeName().equalsIgnoreCase("http-equiv") && object.getNodeValue().equalsIgnoreCase("content-type")) {
                            return;
                        }
                        object = object.getNextSibling();
                    }
                }
                node = node.getNextSibling();
            }
            object2 = this.os.getEncoding();
            if (object2 == null || ((String)object2).equals("US-ASCII")) {
                object2 = "ISO-8859-1";
            }
            if ((object = this.mimeType) == null) {
                object = "text/html";
            }
            this.println("");
            this.os.print("    <meta http-equiv='Content-Type' content='" + (String)object + "; charset=" + (String)object2 + "'>");
        }
    }

    private void printNamespaceDecl(String string, String string2) throws IOException {
        if (string == "") {
            this.print(" xmlns=\"");
            this.print(string2);
            this.print("\"");
        } else {
            this.print(" xmlns:");
            this.print(string);
            this.print("=\"");
            this.print(string2);
            this.print("\"");
        }
    }

    HashMap printAttributes(QAttributedNode qAttributedNode, HashMap hashMap) throws IOException {
        if (qAttributedNode.attributes == null) {
            return hashMap;
        }
        Iterator iterator = qAttributedNode.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            QAttr qAttr = (QAttr)entry.getValue();
            if (qAttr.getNodeName().startsWith("xmlns")) continue;
            this.print(" ");
            qAttr.print(this);
            if (qAttr.getPrefixName() == null) continue;
            String string = qAttr.getPrefixName();
            String string2 = qAttr.getNamespace();
            String string3 = (String)this.namespace.get(string);
            if (string2 == null || string3 == null || string2.equals(string3)) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    void printEmptyTag(Element element) throws IOException {
        String string = element.getNodeName();
        if (!this.isHtml) {
            this.os.print("/>");
        } else if (empties.get(string.toLowerCase()) != null) {
            this.os.print(">");
        } else if (element.getNodeName().equals("p") && element.getFirstChild() == null) {
            this.os.print(">");
        } else if (((CauchoElement)element).getNamespace().equals("")) {
            this.os.print(">");
            this.printHtmlSpecial((CauchoElement)element);
            this.os.print("</");
            this.os.print(string);
            this.os.print(">");
        } else {
            this.os.print("/>");
        }
    }

    void printAttr(String string, String string2) throws IOException {
        this.os.print(string);
        if (!this.isHtml || string2 == null) {
            this.os.print("=\"");
            if (string2 != null) {
                this.printAttrValue(string2);
            }
            this.os.print("\"");
        } else if (!string2.equals(string) || booleanAttrs.get(string) == null) {
            this.os.print("=\"");
            this.printAttrValue(string2);
            this.os.print("\"");
        }
    }

    private void printAttrValue(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (!this.escapeText) {
            this.print(string);
        } else {
            this.entities.printText(this, string, true);
        }
    }

    void printDecl(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    if (n + 1 < string.length() && string.charAt(n + 1) == '#') {
                        this.os.print("&#38;");
                        break;
                    }
                    this.os.print(c);
                    break;
                }
                case '\"': {
                    this.os.print("&#34;");
                    break;
                }
                case '\'': {
                    this.os.print("&#39;");
                    break;
                }
                case '\n': {
                    this.os.print("\n");
                    ++this.line;
                    break;
                }
                default: {
                    this.os.print(c);
                }
            }
            ++n;
        }
    }

    void print(char c) throws IOException {
        this.os.print(c);
        if (c == '\n') {
            ++this.line;
        }
    }

    void print(String string) throws IOException {
        this.os.print(string);
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\n') {
                ++this.line;
            }
            ++n;
        }
    }

    void print(char[] cArray) throws IOException {
        this.os.print(cArray);
    }

    void print(int n) throws IOException {
        this.os.print(n);
    }

    void println() throws IOException {
        this.os.println();
        ++this.line;
    }

    void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public XmlPrinter(WriteStream writeStream) {
        this.os = writeStream;
        String string = writeStream.getEncoding();
        this.entities = string == null || string.equals("US-ASCII") || string.equals("ISO-8859-1") ? XmlLatin1Entities.create() : XmlEntities.create();
        this.namespace = new HashMap();
        this.line = 1;
    }

    static {
        empties.put("basefont", "empty");
        empties.put("br", "empty");
        empties.put("area", "empty");
        empties.put("link", "empty");
        empties.put("img", "empty");
        empties.put("param", "empty");
        empties.put("hr", "empty");
        empties.put("input", "empty");
        empties.put("col", "empty");
        empties.put("frame", "empty");
        empties.put("isindex", "empty");
        empties.put("base", "empty");
        empties.put("meta", "empty");
        booleanAttrs = new HashMap();
        booleanAttrs.put("checked", "checked");
        booleanAttrs.put("compact", "compact");
        booleanAttrs.put("declare", "declare");
        booleanAttrs.put("defer", "defer");
        booleanAttrs.put("disabled", "disabled");
        booleanAttrs.put("ismap", "ismap");
        booleanAttrs.put("multiple", "multiple");
        booleanAttrs.put("nohref", "nohref");
        booleanAttrs.put("noresize", "noresize");
        booleanAttrs.put("noshade", "noshade");
        booleanAttrs.put("nowrap", "nowrap");
        booleanAttrs.put("readonly", "readonly");
        booleanAttrs.put("selected", "selected");
    }
}

