/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.Pattern;
import com.caucho.xpath.XPathFun;
import java.util.ArrayList;
import org.w3c.dom.Node;

class FunExpr
extends Expr {
    private String name;
    private Pattern pattern;
    private ArrayList args;

    public boolean evalBoolean(Env env, Node node, Node node2) {
        return Expr.toBoolean(this.evalObject(env, node, node2));
    }

    public double evalNumber(Env env, Node node, Node node2) {
        return Expr.toDouble(this.evalObject(env, node, node2));
    }

    public String evalString(Env env, Node node, Node node2) {
        return Expr.toString(this.evalObject(env, node, node2));
    }

    public Object evalObject(Env env, Node node, Node node2) {
        XPathFun xPathFun = env.getFunction(this.name);
        if (xPathFun == null) {
            throw new RuntimeException("unknown function: " + this.name);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.args.size()) {
            Expr expr = (Expr)this.args.get(n);
            arrayList.add(expr.evalObject(env, node, node2));
            ++n;
        }
        return xPathFun.eval(node2, env, node, this.pattern, arrayList);
    }

    public String toString() {
        CharBuffer charBuffer = new CharBuffer();
        charBuffer.append(this.name);
        charBuffer.append("(");
        int n = 0;
        while (n < this.args.size()) {
            if (n != 0) {
                charBuffer.append(", ");
            }
            charBuffer.append(this.args.get(n));
            ++n;
        }
        charBuffer.append(")");
        return charBuffer.toString();
    }

    FunExpr(String string, Pattern pattern, ArrayList arrayList) {
        this.name = string;
        this.pattern = pattern;
        this.args = arrayList;
    }
}

