/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xml.CauchoNode;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.Pattern;
import java.util.Iterator;
import org.w3c.dom.Node;

class NodeSetExpr
extends Expr {
    private Pattern pattern;

    Pattern getPattern() {
        return this.pattern;
    }

    public boolean isNodeSet() {
        return true;
    }

    public double evalNumber(Env env, Node node, Node node2) {
        String string = this.evalString(env, node2, node2);
        return Expr.stringToNumber(string);
    }

    public boolean evalBoolean(Env env, Node node, Node node2) {
        Iterator iterator = this.evalNodeSet(env, node, node2);
        return iterator.hasNext();
    }

    public String evalString(Env env, Node node, Node node2) {
        Iterator iterator = this.evalNodeSet(env, node, node2);
        if (!iterator.hasNext()) {
            return "";
        }
        CauchoNode cauchoNode = (CauchoNode)iterator.next();
        return cauchoNode.getTextValue();
    }

    public Object evalObject(Env env, Node node, Node node2) {
        return this.pattern.select(node2, env, node2, this.pattern);
    }

    public Iterator evalNodeSet(Env env, Node node, Node node2) {
        return this.pattern.select(node2, env, node2, this.pattern);
    }

    public String toString() {
        return this.pattern.toString();
    }

    NodeSetExpr(Pattern pattern) {
        this.pattern = pattern;
    }
}

