/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Env;
import com.caucho.xpath.Pattern;
import java.util.Iterator;
import org.w3c.dom.Node;

class SelectIterator
implements Iterator {
    private Pattern pattern;
    private Env env;
    private Node context;
    private Node tail;
    private Node here;
    private boolean allowAttr;
    private boolean allowNamespace;

    void init(Pattern pattern, Env env, Node node, Node node2) {
        this.pattern = pattern;
        this.env = env;
        this.context = node;
        this.here = pattern.head(node2, env, node);
        this.tail = pattern.tail(node2, env, node);
        this.allowAttr = pattern.allowAttr();
        this.allowNamespace = pattern.allowNamespace();
        if (!pattern.match(this.here, env, node)) {
            this.next();
        }
    }

    public boolean hasNext() {
        return this.here != null;
    }

    public Object next() {
        Node node = this.here;
        if (node == null) {
            return null;
        }
        do {
            this.here = this.pattern.nextNode(this.here, this.env, this.context, this.tail, this.allowAttr, this.allowNamespace);
            if (this.here != null) continue;
            return node;
        } while (!this.pattern.match(this.here, this.env, this.context));
        return node;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        SelectIterator selectIterator = new SelectIterator(null, this.env, this.context, this.pattern);
        selectIterator.tail = this.tail;
        selectIterator.here = this.here;
        selectIterator.allowAttr = this.allowAttr;
        return selectIterator;
    }

    SelectIterator(Node node, Env env, Node node2, Pattern pattern) {
        this.init(pattern, env, node2, node);
    }
}

