/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Env;
import com.caucho.xpath.Pattern;
import java.util.Iterator;
import org.w3c.dom.Node;

public class UnionPattern
extends Pattern {
    private Pattern left;
    private Pattern right;

    boolean match(Node node, Env env, Node node2) {
        return this.left.match(node, env, node2) || this.right.match(node, env, node2);
    }

    Node head(Node node, Env env, Node node2) {
        Node node3 = this.left.head(node, env, node2);
        Node node4 = this.right.head(node, env, node2);
        while (node3 != null) {
            Node node5 = node4;
            while (node5 != null) {
                if (node3 == node5) {
                    return node3;
                }
                node5 = node5.getParentNode();
            }
            node3 = node3.getParentNode();
        }
        return node4.getOwnerDocument();
    }

    Node tail(Node node, Env env, Node node2) {
        Node node3 = this.left.tail(node, env, node2);
        Node node4 = this.right.tail(node, env, node2);
        while (node3 != null) {
            Node node5 = node4;
            while (node5 != null) {
                if (node3 == node5) {
                    return node3;
                }
                node5 = node5.getParentNode();
            }
            node3 = node3.getParentNode();
        }
        return null;
    }

    boolean allowAttr() {
        return this.left.allowAttr() || this.right.allowAttr();
    }

    boolean allowChildren(Node node, Env env, Node node2) {
        return this.left.allowChildren(node, env, node2) || this.right.allowChildren(node, env, node2);
    }

    int position(Node node, Env env, Node node2, Pattern pattern) {
        Iterator iterator = this.select(node, env, node2, pattern);
        int n = 1;
        while (iterator.hasNext()) {
            if (iterator.next() == node) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    int count(Node node, Env env, Node node2, Pattern pattern) {
        Iterator iterator = this.select(node, env, node2, pattern);
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public Pattern getLeft() {
        return this.left;
    }

    public Pattern getRight() {
        return this.right;
    }

    public String toString() {
        return "(" + this.left.toString() + "|" + this.right.toString() + ")";
    }

    UnionPattern(Pattern pattern, Pattern pattern2) {
        super(null);
        this.left = pattern;
        this.right = pattern2;
    }
}

