/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.SelectIterator;
import org.w3c.dom.Node;

class VarExpr
extends Expr {
    private String name;

    public boolean evalBoolean(Env env, Node node, Node node2) {
        return Expr.toBoolean(env.getVar(this.name));
    }

    public double evalNumber(Env env, Node node, Node node2) {
        return Expr.toDouble(env.getVar(this.name));
    }

    public String evalString(Env env, Node node, Node node2) {
        return Expr.toString(env.getVar(this.name));
    }

    public Object evalObject(Env env, Node node, Node node2) {
        Object object = env.getVar(this.name);
        if (object instanceof SelectIterator) {
            return ((SelectIterator)object).clone();
        }
        return object;
    }

    public String toString() {
        return "$" + this.name;
    }

    VarExpr(String string) {
        this.name = string.intern();
    }
}

