/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.BooleanExpr;
import com.caucho.xpath.CurrentPattern;
import com.caucho.xpath.Expr;
import com.caucho.xpath.FilterPattern;
import com.caucho.xpath.FromAncestors;
import com.caucho.xpath.FromAny;
import com.caucho.xpath.FromAttributes;
import com.caucho.xpath.FromChildren;
import com.caucho.xpath.FromContext;
import com.caucho.xpath.FromDescendants;
import com.caucho.xpath.FromExpr;
import com.caucho.xpath.FromNamespace;
import com.caucho.xpath.FromNext;
import com.caucho.xpath.FromNextSibling;
import com.caucho.xpath.FromParent;
import com.caucho.xpath.FromPrevious;
import com.caucho.xpath.FromPreviousSibling;
import com.caucho.xpath.FromRoot;
import com.caucho.xpath.FromSelf;
import com.caucho.xpath.FunExpr;
import com.caucho.xpath.IdExpr;
import com.caucho.xpath.NSNamePattern;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.NamespacePattern;
import com.caucho.xpath.NodePattern;
import com.caucho.xpath.NodeSetExpr;
import com.caucho.xpath.NodeTypePattern;
import com.caucho.xpath.NumericExpr;
import com.caucho.xpath.ObjectExpr;
import com.caucho.xpath.Pattern;
import com.caucho.xpath.StringExpr;
import com.caucho.xpath.UnionPattern;
import com.caucho.xpath.VarExpr;
import com.caucho.xpath.XPathParseException;
import java.util.ArrayList;

class XPathParser {
    private static WriteStream dbg = LogStream.open("/caucho.com/xpath/parser");
    private static final int ANCESTOR_AXIS = 0;
    private static final int ANCESTOR_OR_SELF_AXIS = 1;
    private static final int ATTRIBUTE_AXIS = 2;
    private static final int CHILD_AXIS = 3;
    private static final int DESCENDANT_AXIS = 4;
    private static final int DESCENDANT_OR_SELF_AXIS = 5;
    private static final int FOLLOWING_AXIS = 6;
    private static final int FOLLOWING_SIBLING_AXIS = 7;
    private static final int NAMESPACE_AXIS = 8;
    private static final int PARENT_AXIS = 9;
    private static final int PRECEDING_AXIS = 10;
    private static final int PRECEDING_SIBLING_AXIS = 11;
    private static final int SELF_AXIS = 12;
    private static final int TEXT = 56;
    private static final int COMMENT = 57;
    private static final int ER = 58;
    private static final int PI = 59;
    private static final int NODE = 60;
    private static final int CURRENT = 61;
    private static final int NODE_TEXT = 62;
    private static final int CONTEXT = 63;
    private static IntMap exprFunctions = new IntMap();
    private static IntMap axisMap;
    private CharBuffer tag = new CharBuffer();
    private String string;
    private int index;
    private int peek;
    private NamespaceContext namespace;

    Pattern parseSelect() throws XPathParseException {
        FromContext fromContext = new FromContext();
        Pattern pattern = this.parseUnion(this.parseTop(fromContext), fromContext);
        if (this.index < this.string.length()) {
            throw new XPathParseException("unexpected character at `" + this.badChar(this.read()) + "'");
        }
        return pattern;
    }

    Pattern parseMatch() throws XPathParseException {
        FromAny fromAny = new FromAny();
        Pattern pattern = this.parseUnion(this.parseTop(fromAny), fromAny);
        if (this.index < this.string.length()) {
            throw new XPathParseException("unexpected character at `" + this.badChar(this.read()) + "'");
        }
        return pattern;
    }

    Expr parseExpr() throws XPathParseException {
        Expr expr = this.parseExpr(null, null);
        if (this.index < this.string.length()) {
            throw new XPathParseException("unexpected character at `" + this.badChar(this.read()) + "'");
        }
        return expr;
    }

    private Pattern parseStep(Pattern pattern) throws XPathParseException {
        return this.parseUnion(this.parseTop(pattern), pattern);
    }

    private Pattern parseUnion(Pattern pattern, Pattern pattern2) throws XPathParseException {
        int n = this.skipWhitespace(this.read());
        while (n >= 0) {
            if (n != 124) break;
            Pattern pattern3 = this.parseUnion(this.parseTop(pattern2), pattern2);
            pattern = new UnionPattern(pattern, pattern3);
            n = this.read();
            while (XmlChar.isWhitespace(n)) {
                n = this.read();
            }
        }
        this.unread();
        return pattern;
    }

    private Pattern parseTop(Pattern pattern) throws XPathParseException {
        int n = this.skipWhitespace(this.read());
        this.unread();
        if (n == 40) {
            Pattern pattern2;
            Expr expr = this.parseTerm(pattern, pattern);
            if (expr instanceof NodeSetExpr && (pattern2 = ((NodeSetExpr)expr).getPattern()).isAscending()) {
                return pattern2;
            }
            return new FromExpr(null, expr);
        }
        return this.parseTerm(pattern, pattern).toNodeList();
    }

    private Pattern parseBasisTop(Pattern pattern) throws XPathParseException {
        int n = this.skipWhitespace(this.read());
        if (n == 47) {
            n = this.read();
            pattern = new FromRoot();
            if (n == 47) {
                n = this.read();
                pattern = new FromDescendants(pattern, true);
                pattern = new NodeTypePattern(pattern, -2);
            }
            if ((n = this.skipWhitespace(n)) == -1) {
                return pattern;
            }
        }
        this.unread();
        if (pattern == null) {
            pattern = new FromContext();
        }
        pattern = this.parseBasis(pattern);
        pattern = this.parseFilter(pattern);
        return this.parsePath(pattern);
    }

    private Pattern parsePath(Pattern pattern) throws XPathParseException {
        int n = this.skipWhitespace(this.read());
        while (n == 47) {
            n = this.read();
            if (n == 47) {
                pattern = new FromDescendants(pattern, true);
                pattern = new NodeTypePattern(pattern, -2);
                pattern = this.parseBasis(pattern);
                pattern = this.parseFilter(pattern);
            } else {
                this.unread();
                pattern = this.parseBasis(pattern);
                pattern = this.parseFilter(pattern);
            }
            n = this.skipWhitespace(this.read());
        }
        this.unread();
        return pattern;
    }

    private Pattern parseFilter(Pattern pattern) throws XPathParseException {
        int n = this.skipWhitespace(this.read());
        while (n == 91) {
            Expr expr = this.parseExpr(new FromContext(), pattern);
            pattern = new FilterPattern(pattern, expr);
            n = this.skipWhitespace(this.read());
            if (n != 93) {
                throw this.error("expected `]' at " + this.badChar(n));
            }
            n = this.skipWhitespace(this.read());
        }
        this.unread();
        return pattern;
    }

    private Pattern parseBasis(Pattern pattern) throws XPathParseException {
        boolean bl = true;
        int n = this.skipWhitespace(this.read());
        int n2 = 1;
        Object var5_5 = null;
        this.tag.clear();
        if (n == 64) {
            pattern = new FromAttributes(pattern);
            n2 = 2;
            bl = false;
            n = this.read();
        } else {
            if (n == 46) {
                n = this.read();
                if (n == 46) {
                    return new NodeTypePattern(new FromParent(pattern), -2);
                }
                this.unread();
                return new NodeTypePattern(new FromSelf(pattern), -1);
            }
            if (n == 40) {
                Expr expr = this.parseExpr(pattern, pattern);
                n = this.read();
                if (n != 41) {
                    throw this.error("expected ')' at " + this.badChar(n));
                }
                return new FromExpr(null, expr);
            }
        }
        if (n == 42) {
            this.tag.append('*');
            n = this.read();
        }
        if (XmlChar.isNameStart(n)) {
            while (XmlChar.isNameChar(n)) {
                this.tag.append((char)n);
                n = this.read();
            }
            if (n == 42) {
                this.tag.append('*');
            } else {
                this.unread();
            }
        } else {
            this.unread();
        }
        String string = this.tag.toString();
        if (string.equals("")) {
            throw this.error("expected name at " + this.badChar(n));
        }
        return this.parseAxis(pattern, string, bl, n2);
    }

    private Pattern parseAxis(Pattern pattern, String string, boolean bl, int n) throws XPathParseException {
        String string2 = "";
        int n2 = string.indexOf("::");
        if (n2 >= 0 && n != 2) {
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 2);
        }
        switch (axisMap.get(string2)) {
            case 0: {
                return this.parseNodeTest(new FromAncestors(pattern, false), string, false, 1);
            }
            case 1: {
                return this.parseNodeTest(new FromAncestors(pattern, true), string, false, 1);
            }
            case 2: {
                return this.parseNodeTest(new FromAttributes(pattern), string, false, 2);
            }
            case 3: {
                return this.parseNodeTest(new FromChildren(pattern), string, false, 1);
            }
            case 4: {
                return this.parseNodeTest(new FromDescendants(pattern, false), string, false, 1);
            }
            case 5: {
                return this.parseNodeTest(new FromDescendants(pattern, true), string, false, 1);
            }
            case 6: {
                return this.parseNodeTest(new FromNext(pattern), string, false, 1);
            }
            case 7: {
                return this.parseNodeTest(new FromNextSibling(pattern), string, false, 1);
            }
            case 8: {
                return this.parseNodeTest(new FromNamespace(pattern), string, false, 2);
            }
            case 9: {
                return this.parseNodeTest(new FromParent(pattern), string, false, 1);
            }
            case 10: {
                return this.parseNodeTest(new FromPrevious(pattern), string, false, 1);
            }
            case 11: {
                return this.parseNodeTest(new FromPreviousSibling(pattern), string, false, 1);
            }
            case 12: {
                return this.parseNodeTest(new FromSelf(pattern), string, false, 1);
            }
        }
        return this.parseNodeTest(pattern, string, bl, n);
    }

    private Pattern parseNodeTest(Pattern pattern, String string, boolean bl, int n) throws XPathParseException {
        int n2 = this.skipWhitespace(this.read());
        if (n2 == 40) {
            Expr expr = this.parseFunction(pattern, pattern, string, bl);
            return expr.toNodeList();
        }
        if (n2 == 123) {
            this.tag.clear();
            while ((n2 = this.read()) >= 0 && n2 != 125) {
                this.tag.append((char)n2);
            }
            String string2 = this.tag.toString();
            this.tag.clear();
            n2 = this.read();
            while (XmlChar.isNameChar(n2)) {
                this.tag.append((char)n2);
                n2 = this.read();
            }
            pattern = new NSNamePattern(pattern, string2, this.tag.toString(), n);
        } else {
            if (bl) {
                pattern = new FromChildren(pattern);
            }
            if (string.equals("*")) {
                pattern = new NodeTypePattern(pattern, n);
            } else if (string.endsWith(":*")) {
                pattern = new NamespacePattern(pattern, string.substring(0, string.length() - 2), n);
            } else {
                int n3 = string.indexOf(58);
                String string3 = null;
                String string4 = string;
                if (n3 > 0) {
                    String string5 = string.substring(0, n3);
                    string3 = NamespaceContext.find(this.namespace, string5);
                    string4 = string.substring(n3 + 1);
                } else {
                    string3 = NamespaceContext.find(this.namespace, "");
                }
                pattern = string3 == null ? new NodePattern(pattern, string, n) : new NSNamePattern(pattern, string3, string4, n);
            }
        }
        this.unread();
        return pattern;
    }

    private String scanValue(int n) throws XPathParseException {
        if (n == 39 || n == 34) {
            int n2 = n;
            CharBuffer charBuffer = new CharBuffer();
            n = this.read();
            while (n != n2 && n >= 0) {
                charBuffer.append((char)n);
                n = this.read();
            }
            return charBuffer.toString();
        }
        throw this.error("expected string at: " + (char)n);
    }

    Expr parseExpr(Pattern pattern, Pattern pattern2) throws XPathParseException {
        this.peek = -1;
        Expr expr = this.parseTerm(pattern, pattern2);
        block7: while (true) {
            int n = this.scanToken();
            switch (n) {
                case 3: {
                    expr = this.parseOrExpr(n, expr, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block7;
                }
                case 4: {
                    expr = this.parseAndExpr(n, expr, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block7;
                }
                case 5: 
                case 9: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    expr = this.parseCmpExpr(n, expr, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block7;
                }
                case 18: 
                case 19: {
                    expr = this.parseAddExpr(n, expr, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block7;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    expr = this.parseMulExpr(n, expr, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block7;
                }
            }
            break;
        }
        return expr;
    }

    private Expr parseOrExpr(int n, Expr expr, Expr expr2, Pattern pattern, Pattern pattern2) throws XPathParseException {
        int n2;
        block7: while (true) {
            n2 = this.scanToken();
            switch (n2) {
                case 3: {
                    expr = new BooleanExpr(n, expr, expr2);
                    n = n2;
                    expr2 = this.parseTerm(pattern, pattern2);
                    continue block7;
                }
                case 4: {
                    expr2 = this.parseAndExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block7;
                }
                case 5: 
                case 9: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    expr2 = this.parseCmpExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block7;
                }
                case 18: 
                case 19: {
                    expr2 = this.parseAddExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block7;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    expr2 = this.parseMulExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block7;
                }
            }
            break;
        }
        this.undoToken(n2);
        return new BooleanExpr(n, expr, expr2);
    }

    private Expr parseAndExpr(int n, Expr expr, Expr expr2, Pattern pattern, Pattern pattern2) throws XPathParseException {
        int n2;
        block6: while (true) {
            n2 = this.scanToken();
            switch (n2) {
                case 4: {
                    expr = new BooleanExpr(n, expr, expr2);
                    n = n2;
                    expr2 = this.parseTerm(pattern, pattern2);
                    continue block6;
                }
                case 5: 
                case 9: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    expr2 = this.parseCmpExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block6;
                }
                case 18: 
                case 19: {
                    expr2 = this.parseAddExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block6;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    expr2 = this.parseMulExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block6;
                }
            }
            break;
        }
        this.undoToken(n2);
        return new BooleanExpr(n, expr, expr2);
    }

    private Expr parseCmpExpr(int n, Expr expr, Expr expr2, Pattern pattern, Pattern pattern2) throws XPathParseException {
        int n2;
        block5: while (true) {
            n2 = this.scanToken();
            switch (n2) {
                case 5: 
                case 9: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    expr = new BooleanExpr(n, expr, expr2);
                    n = n2;
                    expr2 = this.parseTerm(pattern, pattern2);
                    continue block5;
                }
                case 18: 
                case 19: {
                    expr2 = this.parseAddExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block5;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    expr2 = this.parseMulExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block5;
                }
            }
            break;
        }
        this.undoToken(n2);
        return new BooleanExpr(n, expr, expr2);
    }

    private Expr parseAddExpr(int n, Expr expr, Expr expr2, Pattern pattern, Pattern pattern2) throws XPathParseException {
        int n2;
        block4: while (true) {
            n2 = this.scanToken();
            switch (n2) {
                case 18: 
                case 19: {
                    expr = new NumericExpr(n, expr, expr2);
                    n = n2;
                    expr2 = this.parseTerm(pattern, pattern2);
                    continue block4;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    expr2 = this.parseMulExpr(n2, expr2, this.parseTerm(pattern, pattern2), pattern, pattern2);
                    continue block4;
                }
            }
            break;
        }
        this.undoToken(n2);
        return new NumericExpr(n, expr, expr2);
    }

    private Expr parseMulExpr(int n, Expr expr, Expr expr2, Pattern pattern, Pattern pattern2) throws XPathParseException {
        int n2;
        block3: while (true) {
            n2 = this.scanToken();
            switch (n2) {
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    expr = new NumericExpr(n, expr, expr2);
                    n = n2;
                    expr2 = this.parseTerm(pattern, pattern2);
                    continue block3;
                }
            }
            break;
        }
        this.undoToken(n2);
        return new NumericExpr(n, expr, expr2);
    }

    private Expr parseTerm(Pattern pattern, Pattern pattern2) throws XPathParseException {
        int n = this.skipWhitespace(this.read());
        this.unread();
        Expr expr = this.parseSimpleTerm(pattern, pattern2);
        n = this.skipWhitespace(this.read());
        this.unread();
        if (n == 47 || n == 91) {
            Pattern pattern3 = n == 40 ? expr.toNodeList() : new FromExpr(null, expr);
            return new NodeSetExpr(this.parseUnion(this.parsePath(this.parseFilter(pattern3)), pattern3));
        }
        return expr;
    }

    private Expr parseSimpleTerm(Pattern pattern, Pattern pattern2) throws XPathParseException {
        String string;
        int n = this.skipWhitespace(this.read());
        switch (n) {
            case 46: {
                n = this.read();
                this.unread();
                this.unread();
                if (n < 48 || n > 57) {
                    return new NodeSetExpr(this.parseUnion(this.parseBasisTop(pattern), pattern));
                }
                n = 46;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                long l = 0L;
                long l2 = 1L;
                while (n >= 48 && n <= 57) {
                    l = 10L * l + (long)n - 48L;
                    n = this.read();
                }
                if (n == 46) {
                    n = this.read();
                    while (n >= 48 && n <= 57) {
                        l = 10L * l + (long)n - 48L;
                        l2 *= 10L;
                        n = this.read();
                    }
                }
                this.unread();
                return new NumericExpr((double)l / (double)l2);
            }
            case 45: {
                return new NumericExpr(17, this.parseTerm(pattern, pattern2));
            }
            case 43: {
                return this.parseTerm(pattern, pattern2);
            }
            case 40: {
                Expr expr = this.parseExpr(pattern, pattern2);
                n = this.skipWhitespace(this.read());
                if (n != 41) {
                    throw this.error("expected `)' at " + this.badChar(n));
                }
                return expr;
            }
            case 42: 
            case 47: 
            case 64: {
                this.unread();
                return new NodeSetExpr(this.parseUnion(this.parseBasisTop(pattern), pattern));
            }
            case 34: 
            case 39: {
                int n2 = n;
                CharBuffer charBuffer = new CharBuffer();
                n = this.read();
                while (n != n2 && n >= 0) {
                    charBuffer.append((char)n);
                    n = this.read();
                }
                return new StringExpr(charBuffer.toString());
            }
            case 36: {
                String string2 = this.readName(this.read());
                return new VarExpr(string2);
            }
        }
        if (!XmlChar.isNameStart(n)) {
            throw this.error("unknown character at " + this.badChar(n));
        }
        String string3 = this.readName(n);
        n = this.skipWhitespace(this.read());
        int n3 = string3.indexOf("::");
        if (n == 40 && n3 < 0) {
            return this.parseFunction(pattern, pattern2, string3, true);
        }
        if (n == 40 && axisMap.get(string = string3.substring(0, n3)) <= 0) {
            return this.parseFunction(pattern, pattern2, string3, true);
        }
        this.unread();
        if (pattern == null) {
            pattern = new FromContext();
        }
        return this.parseNodeSetExpr(pattern, string3, 1);
    }

    Expr parseFunction(Pattern pattern, Pattern pattern2, String string, boolean bl) throws XPathParseException {
        int n = this.skipWhitespace(this.read());
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        while (n >= 0 && n != 41) {
            if (n != 44) {
                this.unread();
            }
            arrayList.add(this.parseExpr(pattern, pattern2));
            n = this.skipWhitespace(this.read());
        }
        int n2 = exprFunctions.get(string);
        switch (n2) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 39: 
            case 40: 
            case 52: {
                return new BooleanExpr(n2, arrayList);
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 44: {
                return new NumericExpr(n2, arrayList);
            }
            case 34: 
            case 36: {
                if (pattern2 == null) {
                    throw this.error(string + "() must be in a node list");
                }
                return new NumericExpr(n2, pattern2);
            }
            case 30: 
            case 35: {
                if (arrayList.size() == 0) {
                    arrayList.add(new NodeSetExpr(new FromContext()));
                }
                return new NumericExpr(n2, ((Expr)arrayList.get(0)).toNodeList());
            }
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 53: {
                return new StringExpr(n2, arrayList);
            }
            case 37: 
            case 45: {
                return new StringExpr(n2, arrayList);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                if (arrayList.size() == 0) {
                    arrayList.add(new NodeSetExpr(new FromContext()));
                }
                return new StringExpr(n2, arrayList);
            }
            case 2: {
                if (arrayList.size() == 0) {
                    arrayList.add(new NodeSetExpr(pattern));
                    return new IdExpr(arrayList);
                }
                return new IdExpr(arrayList);
            }
            case 54: {
                return new ObjectExpr(n2, arrayList);
            }
            case 56: {
                if (bl) {
                    pattern = new FromChildren(pattern);
                }
                NodeTypePattern nodeTypePattern = new NodeTypePattern(pattern, 3);
                return new NodeSetExpr(nodeTypePattern);
            }
            case 57: {
                if (bl) {
                    pattern = new FromChildren(pattern);
                }
                NodeTypePattern nodeTypePattern = new NodeTypePattern(pattern, 8);
                return new NodeSetExpr(nodeTypePattern);
            }
            case 58: {
                if (bl) {
                    pattern = new FromChildren(pattern);
                }
                NodeTypePattern nodeTypePattern = new NodeTypePattern(pattern, 5);
                return new NodeSetExpr(nodeTypePattern);
            }
            case 59: {
                Pattern pattern3;
                if (bl) {
                    pattern = new FromChildren(pattern);
                }
                if (arrayList.size() == 1) {
                    Expr expr = (Expr)arrayList.get(0);
                    String string2 = null;
                    if (expr instanceof StringExpr) {
                        string2 = ((StringExpr)expr).getValue();
                    }
                    if (string2 == null) {
                        throw this.error("processing-instruction expects string literal");
                    }
                    pattern3 = new NodePattern(pattern, string2, 7);
                } else {
                    pattern3 = new NodeTypePattern(pattern, 7);
                }
                return new NodeSetExpr(pattern3);
            }
            case 60: {
                if (bl) {
                    pattern = new FromChildren(pattern);
                }
                NodeTypePattern nodeTypePattern = new NodeTypePattern(pattern, -2);
                return new NodeSetExpr(nodeTypePattern);
            }
            case 61: {
                return new NodeSetExpr(new CurrentPattern());
            }
            case 63: {
                return new NodeSetExpr(new FromContext());
            }
        }
        if (string.equals("")) {
            throw this.error("expected node-test at `('");
        }
        return new FunExpr(string, pattern, arrayList);
    }

    private Expr parseNodeSetExpr(Pattern pattern, String string, int n) throws XPathParseException {
        Pattern pattern2 = this.parseAxis(pattern, string, true, n);
        pattern2 = this.parseFilter(pattern2);
        return new NodeSetExpr(this.parseUnion(this.parsePath(pattern2), pattern));
    }

    private int scanToken() throws XPathParseException {
        if (this.peek >= 0) {
            int n = this.peek;
            this.peek = -1;
            return n;
        }
        int n = this.skipWhitespace(this.read());
        switch (n) {
            case 43: {
                return 18;
            }
            case 45: {
                return 19;
            }
            case 42: {
                return 20;
            }
            case 61: {
                return 5;
            }
            case 33: {
                n = this.read();
                if (n == 61) {
                    return 9;
                }
                throw this.error("expected `=' at " + this.badChar(n));
            }
            case 60: {
                n = this.read();
                if (n == 61) {
                    return 14;
                }
                this.unread();
                return 13;
            }
            case 62: {
                n = this.read();
                if (n == 61) {
                    return 16;
                }
                this.unread();
                return 15;
            }
        }
        if (XmlChar.isNameStart(n)) {
            String string = this.readName(n);
            if (string.equals("div")) {
                return 21;
            }
            if (string.equals("quo")) {
                return 22;
            }
            if (string.equals("mod")) {
                return 23;
            }
            if (string.equals("and")) {
                return 4;
            }
            if (string.equals("or")) {
                return 3;
            }
            throw this.error("expected binary operation at `" + string + "'");
        }
        this.unread();
        return -1;
    }

    private String readName(int n) {
        this.tag.clear();
        while (XmlChar.isNameChar(n)) {
            this.tag.append((char)n);
            n = this.read();
        }
        if (n == 42) {
            this.tag.append((char)n);
        } else {
            this.unread();
        }
        return this.tag.toString();
    }

    private String readValue(int n) throws XPathParseException {
        this.tag.clear();
        if (n == 39) {
            n = this.read();
            while (n >= 0 && n != 39) {
                this.tag.append((char)n);
                n = this.read();
            }
            if (n != 39) {
                throw this.error("expected '");
            }
            return this.tag.toString();
        }
        if (n == 34) {
            n = this.read();
            while (n >= 0 && n != 34) {
                this.tag.append((char)n);
                n = this.read();
            }
            if (n != 34) {
                throw this.error("expected `\"'");
            }
            return this.tag.toString();
        }
        if (XmlChar.isNameChar(n)) {
            while (XmlChar.isNameChar(n)) {
                this.tag.append((char)n);
                n = this.read();
            }
            this.unread();
            return this.tag.toString();
        }
        throw this.error("bad value");
    }

    private void undoToken(int n) {
        this.peek = n;
    }

    private int read() {
        if (this.index < this.string.length()) {
            return this.string.charAt(this.index++);
        }
        ++this.index;
        return -1;
    }

    private void unread() {
        --this.index;
    }

    private XPathParseException error(String string) {
        return new XPathParseException(string);
    }

    private String badChar(int n) {
        if (n < 0) {
            return "end of file";
        }
        if (n == 10) {
            return "end of line";
        }
        return "`" + (char)n + "'";
    }

    private int skipWhitespace(int n) throws XPathParseException {
        while (n == 32 || n == 9 || n == 10 || n == 13) {
            n = this.read();
        }
        return n;
    }

    XPathParser(String string, NamespaceContext namespaceContext) {
        this.string = string;
        this.namespace = namespaceContext;
    }

    static {
        exprFunctions.put("id", 2);
        exprFunctions.put("true", 24);
        exprFunctions.put("false", 25);
        exprFunctions.put("not", 26);
        exprFunctions.put("boolean", 27);
        exprFunctions.put("starts-with", 39);
        exprFunctions.put("contains", 40);
        exprFunctions.put("lang", 28);
        exprFunctions.put("number", 29);
        exprFunctions.put("sum", 30);
        exprFunctions.put("floor", 31);
        exprFunctions.put("ceiling", 32);
        exprFunctions.put("round", 33);
        exprFunctions.put("position", 34);
        exprFunctions.put("count", 35);
        exprFunctions.put("last", 36);
        exprFunctions.put("string-length", 44);
        exprFunctions.put("string", 37);
        exprFunctions.put("concat", 38);
        exprFunctions.put("substring", 41);
        exprFunctions.put("substring-before", 42);
        exprFunctions.put("substring-after", 43);
        exprFunctions.put("normalize-space", 45);
        exprFunctions.put("translate", 46);
        exprFunctions.put("local-name", 48);
        exprFunctions.put("namespace-uri", 49);
        exprFunctions.put("name", 50);
        exprFunctions.put("generate-id", 51);
        exprFunctions.put("if", 54);
        exprFunctions.put("text", 56);
        exprFunctions.put("comment", 57);
        exprFunctions.put("er", 58);
        exprFunctions.put("entity-reference", 58);
        exprFunctions.put("pi", 59);
        exprFunctions.put("processing-instruction", 59);
        exprFunctions.put("node", 60);
        exprFunctions.put("current", 61);
        exprFunctions.put("context", 63);
        axisMap = new IntMap();
        axisMap.put("ancestor", 0);
        axisMap.put("ancestor-or-self", 1);
        axisMap.put("attribute", 2);
        axisMap.put("child", 3);
        axisMap.put("descendant", 4);
        axisMap.put("descendant-or-self", 5);
        axisMap.put("following", 6);
        axisMap.put("following-sibling", 7);
        axisMap.put("namespace", 8);
        axisMap.put("parent", 9);
        axisMap.put("preceding", 10);
        axisMap.put("preceding-sibling", 11);
        axisMap.put("self", 12);
    }
}

