/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.Pattern;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathFun;
import com.caucho.xsl.CacheableDocument;
import com.caucho.xsl.DocumentFun;
import com.caucho.xsl.ExtensionElementFun;
import com.caucho.xsl.ExtensionFunctionFun;
import com.caucho.xsl.Sort;
import com.caucho.xsl.Stylesheet;
import com.caucho.xsl.SystemPropertyFun;
import com.caucho.xsl.Template;
import com.caucho.xsl.UnparsedEntityFun;
import com.caucho.xsl.XslException;
import com.caucho.xsl.XslNumberFormat;
import com.caucho.xsl.XslWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.jsp.PageContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StylesheetImpl
extends Stylesheet {
    static WriteStream dbg = LogStream.open("/caucho.com/xsl/apply");
    public char[] text;
    protected HashMap templates;
    HashMap ids = new HashMap();
    HashMap funs = new HashMap();
    private HashMap preserve = new HashMap();
    private HashMap strip = new HashMap();
    boolean isCacheable = true;
    protected boolean defaultDisableEscaping;
    Path path;
    Path cachePath;
    long lastModified;
    LineMap lineMap;

    public Path getPath() {
        return this.path;
    }

    void addCacheDepend(Path path) {
        this.cacheDepends.add(path);
    }

    protected void setSpaces(HashMap hashMap, HashMap hashMap2) {
        this.preserve = hashMap;
        this.strip = hashMap2;
    }

    protected void addFunction(String string, XPathFun xPathFun) {
        this.funs.put(string, xPathFun);
    }

    public Document transform(Node node, HashMap hashMap, Path path, PageContext pageContext) throws Exception {
        XslWriter xslWriter = new XslWriter(hashMap, path, pageContext, this);
        this.init(xslWriter, hashMap);
        return this.xslExecute(xslWriter, node);
    }

    public CacheableDocument transformCacheable(Node node, HashMap hashMap, Path path, PageContext pageContext) throws Exception {
        XslWriter xslWriter = new XslWriter(hashMap, path, pageContext, this);
        this.init(xslWriter, hashMap);
        Document document = this.xslExecute(xslWriter, node);
        int n = 0;
        while (n < this.cacheDepends.size()) {
            xslWriter.addCacheDepend(path.lookup((String)this.cacheDepends.get(n)));
            ++n;
        }
        if (xslWriter.isCacheable() && this.isCacheable) {
            return new CacheableDocument(document, xslWriter.getDepends());
        }
        return new CacheableDocument(document, null);
    }

    public void init(Path path) throws Exception {
        this.addFunction("system-property", new SystemPropertyFun());
        this.addFunction("element-available", new ExtensionElementFun());
        this.addFunction("function-available", new ExtensionFunctionFun());
        this.addFunction("unparsed-entity-uri", new UnparsedEntityFun());
    }

    public void init(XslWriter xslWriter, HashMap hashMap) throws Exception {
        this.addFunction("document", new DocumentFun(xslWriter));
    }

    public Document xslExecute(XslWriter xslWriter, Node node) throws Exception {
        Env env = XPath.createEnv();
        env.setFunctions(this.funs);
        xslWriter.init();
        this._xsl_init(xslWriter, node, env);
        try {
            this.applyNode(xslWriter, node, env, null, 0, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            throw new XslException(exception, this.lineMap);
        }
        XPath.freeEnv(env);
        return xslWriter.completeDocument(node.getOwnerDocument());
    }

    protected void _xsl_init(XslWriter xslWriter, Node node, Env env) throws Exception {
    }

    protected void applyNode(XslWriter xslWriter, Node node, Env env, String string, int n, int n2) throws Exception {
    }

    protected Template getTemplate(Node node, Env env, String string, int n, int n2) {
        Template template;
        Template template2 = null;
        if (string == null) {
            string = "";
        }
        Template[] templateArray = (Template[])this.templates.get(node.getNodeName());
        int n3 = 0;
        while (templateArray != null && n3 < templateArray.length) {
            template = templateArray[n3];
            if (template.mode.equals(string) && template.pattern.isMatch(node, env) && n <= template.maxImportance && template.maxImportance <= n2) {
                template2 = template;
                break;
            }
            ++n3;
        }
        templateArray = (Template[])this.templates.get("*");
        n3 = 0;
        while (templateArray != null && n3 < templateArray.length) {
            template = templateArray[n3];
            if (template2 != null && template2.compareTo(template) >= 0) {
                return template2;
            }
            if (template.maxImportance >= n && n2 >= template.maxImportance && template.mode.equals(string) && template.pattern.isMatch(node, env)) {
                return template;
            }
            ++n3;
        }
        return template2;
    }

    protected void applyNodeDefault(XslWriter xslWriter, Node node, Env env, String string) throws Exception {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                if (node instanceof CauchoNode) {
                    CauchoNode cauchoNode = (CauchoNode)node;
                    xslWriter.setLocation(cauchoNode.getFilename(), cauchoNode.getLine());
                }
                boolean bl = xslWriter.disableEscaping(this.defaultDisableEscaping);
                String string2 = node.getNodeValue();
                int n = string2.length() - 1;
                while (n >= 0) {
                    if (!XmlChar.isWhitespace(string2.charAt(n))) {
                        xslWriter.print(string2);
                        xslWriter.disableEscaping(bl);
                        return;
                    }
                    --n;
                }
                if (!this.stripSpaces(node.getParentNode())) {
                    xslWriter.print(string2);
                }
                xslWriter.disableEscaping(bl);
                break;
            }
            case 2: {
                xslWriter.print(node.getNodeValue());
                break;
            }
            case 5: {
                xslWriter.print("&");
                xslWriter.print(node.getNodeName());
                xslWriter.print(";");
                break;
            }
            case 1: 
            case 9: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.applyNode(xslWriter, node2, env, string, 0, Integer.MAX_VALUE);
                    node2 = node2.getNextSibling();
                }
                break;
            }
        }
    }

    public void printValue(XslWriter xslWriter, Node node) throws IOException {
        if (node != null) {
            xslWriter.print(this.getNodeValue(node));
        }
    }

    public String getNodeValue(Node node) {
        CharBuffer charBuffer = new CharBuffer();
        this.nodeValue(charBuffer, node);
        return charBuffer.toString();
    }

    private void nodeValue(CharBuffer charBuffer, Node node) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    switch (node2.getNodeType()) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.nodeValue(charBuffer, node2);
                            break;
                        }
                    }
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 5: {
                charBuffer.append('&');
                charBuffer.append(node.getNodeName());
                charBuffer.append(';');
                break;
            }
            case 9: {
                Document document = (Document)node;
                this.nodeValue(charBuffer, document.getDocumentElement());
                break;
            }
            case 3: 
            case 4: {
                String string = node.getNodeValue();
                int n = string.length() - 1;
                while (n >= 0) {
                    if (!XmlChar.isWhitespace(string.charAt(n))) {
                        charBuffer.append(string);
                        return;
                    }
                    --n;
                }
                if (this.stripSpaces(node.getParentNode())) break;
                charBuffer.append(node.getNodeValue());
                return;
            }
            default: {
                charBuffer.append(node.getNodeValue());
                break;
            }
        }
    }

    protected ArrayList xslSort(Node node, Env env, Pattern pattern, Sort[] sortArray) throws Exception {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Iterator iterator = pattern.select(node, env);
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (node2.getNodeType() != 1) continue;
            arrayList.add(node2);
            int n = 0;
            while (n < sortArray.length) {
                Sort sort = sortArray[n];
                arrayList2.add(sort.sortValue(node2, env));
                ++n;
            }
        }
        this.sort(arrayList, arrayList2, sortArray, 0, arrayList.size());
        return arrayList;
    }

    private void sort(ArrayList arrayList, ArrayList arrayList2, Sort[] sortArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 1) {
            return;
        }
        if (n3 == 2) {
            if (this.lessThan(arrayList2, sortArray, n + 1, n)) {
                this.swap(arrayList, arrayList2, sortArray.length, n, n + 1);
            }
            return;
        }
        if (n3 == 3) {
            if (this.lessThan(arrayList2, sortArray, n + 1, n)) {
                this.swap(arrayList, arrayList2, sortArray.length, n, n + 1);
            }
            if (!this.lessThan(arrayList2, sortArray, n + 1, n + 2)) {
                if (this.lessThan(arrayList2, sortArray, n, n + 2)) {
                    this.swap(arrayList, arrayList2, sortArray.length, n + 1, n + 2);
                } else {
                    this.swap(arrayList, arrayList2, sortArray.length, n, n + 2);
                }
            }
        }
        int n4 = n + 1;
        int n5 = n + 1;
        while (n5 < n2) {
            if (this.lessThan(arrayList2, sortArray, n5, n)) {
                this.swap(arrayList, arrayList2, sortArray.length, n4, n5);
                ++n4;
            }
            ++n5;
        }
        if (n4 == n2) {
            this.swap(arrayList, arrayList2, sortArray.length, n, n2 - 1);
            --n4;
        }
        if (n4 == n || n4 == n2) {
            throw new RuntimeException();
        }
        if (n4 - n > 1) {
            this.sort(arrayList, arrayList2, sortArray, n, n4);
        }
        if (n2 - n4 > 1) {
            this.sort(arrayList, arrayList2, sortArray, n4, n2);
        }
    }

    private void swap(ArrayList arrayList, ArrayList arrayList2, int n, int n2, int n3) {
        Object e = arrayList.get(n2);
        Object e2 = arrayList.get(n3);
        arrayList.set(n3, e);
        arrayList.set(n2, e2);
        int n4 = 0;
        while (n4 < n) {
            Object e3 = arrayList2.get(n * n2 + n4);
            Object e4 = arrayList2.get(n * n3 + n4);
            arrayList2.set(n * n3 + n4, e3);
            arrayList2.set(n * n2 + n4, e4);
            ++n4;
        }
    }

    private boolean lessThan(ArrayList arrayList, Sort[] sortArray, int n, int n2) {
        int n3 = sortArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Object e;
            Object e2 = arrayList.get(n3 * n + n4);
            int n5 = sortArray[n4].cmp(e2, e = arrayList.get(n3 * n2 + n4));
            if (n5 < 0) {
                return true;
            }
            if (n5 > 0) {
                return false;
            }
            ++n4;
        }
        return false;
    }

    public void singleNumber(XslWriter xslWriter, Node node, Env env, Pattern pattern, Pattern pattern2, XslNumberFormat xslNumberFormat) throws Exception {
        if (pattern == null) {
            pattern = XPath.parseMatch(node.getNodeName());
        }
        IntArray intArray = new IntArray();
        while (node != null) {
            if (pattern.isMatch(node, env)) {
                intArray.add(this.countPreviousSiblings(node, env, pattern));
                break;
            }
            if (pattern2 != null && pattern2.isMatch(node, env)) break;
            node = node.getParentNode();
        }
        if (pattern2 != null && !this.findFromAncestor(node, env, pattern2)) {
            intArray.clear();
        }
        xslNumberFormat.format(xslWriter, intArray);
    }

    public void multiNumber(XslWriter xslWriter, Node node, Env env, Pattern pattern, Pattern pattern2, XslNumberFormat xslNumberFormat) throws Exception {
        if (pattern == null) {
            pattern = XPath.parseMatch(node.getNodeName());
        }
        IntArray intArray = new IntArray();
        while (node != null) {
            if (pattern.isMatch(node, env)) {
                intArray.add(this.countPreviousSiblings(node, env, pattern));
            }
            if (pattern2 != null && pattern2.isMatch(node, env)) break;
            node = node.getParentNode();
        }
        if (pattern2 != null && !this.findFromAncestor(node, env, pattern2)) {
            intArray.clear();
        }
        xslNumberFormat.format(xslWriter, intArray);
    }

    public void anyNumber(XslWriter xslWriter, Node node, Env env, Pattern pattern, Pattern pattern2, XslNumberFormat xslNumberFormat) throws Exception {
        if (pattern == null) {
            pattern = XPath.parseMatch(node.getNodeName());
        }
        IntArray intArray = new IntArray();
        int n = 0;
        while (node != null) {
            if (pattern.isMatch(node, env)) {
                ++n;
            }
            if (pattern2 != null && pattern2.isMatch(node, env)) break;
            node = XmlUtil.getPrevious(node);
        }
        intArray.add(n);
        if (pattern2 != null && !this.findFromAncestor(node, env, pattern2)) {
            intArray.clear();
        }
        xslNumberFormat.format(xslWriter, intArray);
    }

    public void exprNumber(XslWriter xslWriter, Node node, Env env, Expr expr, XslNumberFormat xslNumberFormat) throws Exception {
        IntArray intArray = new IntArray();
        intArray.add((int)expr.evalNumber(node, env));
        xslNumberFormat.format(xslWriter, intArray);
    }

    private int countPreviousSiblings(Node node, Env env, String string) {
        int n = 1;
        node = node.getPreviousSibling();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNodeName().equals(string)) {
                ++n;
            }
            node = node.getPreviousSibling();
        }
        return n;
    }

    private int countPreviousSiblings(Node node, Env env, Pattern pattern) {
        int n = 1;
        node = node.getPreviousSibling();
        while (node != null) {
            if (pattern.isMatch(node, env)) {
                ++n;
            }
            node = node.getPreviousSibling();
        }
        return n;
    }

    private boolean findFromAncestor(Node node, Env env, Pattern pattern) {
        while (node != null) {
            if (pattern.isMatch(node, env)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    boolean stripSpaces(Node node) {
        String string;
        Node node2;
        Object object = node;
        while (object != null) {
            if (object instanceof Element) {
                node2 = (Element)object;
                string = node2.getAttribute("xml:space");
                if (string != null && string.equals("preserve")) {
                    return false;
                }
                if (string != null) break;
            }
            object = object.getParentNode();
        }
        object = node.getNodeName();
        if (this.preserve.get(node.getNodeName()) != null) {
            return false;
        }
        if (this.strip.get(node.getNodeName()) != null) {
            return true;
        }
        node2 = (CauchoNode)node;
        string = node2.getPrefixName() + ":*";
        if (this.preserve.get(string) != null) {
            return false;
        }
        if (this.strip.get(string) != null) {
            return true;
        }
        return this.strip.get("*") != null;
    }
}

