/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.JavaCompiler;
import com.caucho.util.CauchoSystem;
import com.caucho.util.Registry;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.Html;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlParser;
import com.caucho.xml.XmlPrinter;
import com.caucho.xsl.Stylesheet;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.XslGenerator;
import com.caucho.xsl.XslParser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Xsl {
    static WriteStream dbg;

    public static Stylesheet parse(ReadStream readStream, Path[] pathArray, Path[] pathArray2, ClassLoader classLoader, String string) throws Exception {
        if (pathArray == null) {
            pathArray = new Path[]{CauchoSystem.getResinHome().lookup("xsl")};
        }
        XslParser xslParser = new XslParser();
        Document document = xslParser.parse(readStream);
        return XslGenerator.generate(document, readStream.getPath(), pathArray, pathArray2, classLoader, string);
    }

    public static Stylesheet parse(Path path, Path[] pathArray, Path[] pathArray2) throws Exception {
        Stylesheet stylesheet;
        ReadStream readStream = path.openRead();
        try {
            stylesheet = Xsl.parse(readStream, pathArray, pathArray2, null, null);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            readStream.close();
            throw throwable;
        }
        readStream.close();
        return stylesheet;
    }

    public static Stylesheet parse(Document document, Path path, Path[] pathArray, Path[] pathArray2, ClassLoader classLoader, String string) throws Exception {
        if (pathArray == null) {
            pathArray = new Path[]{CauchoSystem.getResinHome().lookup("xsl")};
        }
        return XslGenerator.generate(document, path, pathArray, pathArray2, classLoader, string);
    }

    public static Stylesheet getStylesheet(String string, Path[] pathArray, ClassLoader classLoader, Path[] pathArray2) throws IOException {
        StylesheetImpl stylesheetImpl;
        Object object;
        Path path = Xsl.findXslPath(string, pathArray, classLoader);
        if (path == null) {
            return null;
        }
        String string2 = path.getPath();
        String string3 = "_xsl." + JavaCompiler.mangleName(string2);
        try {
            object = Xsl.loadStylesheet("_xsl." + string3, classLoader);
            if (object != null) {
                ((Stylesheet)object).init(path.getParent());
            }
            if (object != null && !((Stylesheet)object).isModified()) {
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = path.openRead();
        try {
            Document document = new Xml().parse((ReadStream)object);
            stylesheetImpl = XslGenerator.generate(document, ((ReadStream)object).getPath(), pathArray, pathArray2, classLoader, string3);
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            ((ReadStream)object).close();
            throw throwable;
        }
        ((ReadStream)object).close();
        return stylesheetImpl;
    }

    public static Stylesheet getLooseStylesheet(String string, Path[] pathArray, ClassLoader classLoader, Path[] pathArray2) throws IOException {
        StylesheetImpl stylesheetImpl;
        Object object;
        Path path;
        if (pathArray == null) {
            pathArray = new Path[]{CauchoSystem.getResinHome().lookup("xsl")};
        }
        if ((path = Xsl.findXslPath(string, pathArray, classLoader)) == null) {
            return null;
        }
        String string2 = path.getPath();
        String string3 = JavaCompiler.mangleName(string2);
        try {
            object = Xsl.loadStylesheet("_xsl." + string3, classLoader);
            if (object != null) {
                ((Stylesheet)object).init(path.getParent());
            }
            if (object != null && !((Stylesheet)object).isModified()) {
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = path.openRead();
        try {
            Document document = new XslParser().parse((ReadStream)object);
            stylesheetImpl = XslGenerator.generate(document, ((ReadStream)object).getPath(), pathArray, pathArray2, classLoader, string3);
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            ((ReadStream)object).close();
            throw throwable;
        }
        ((ReadStream)object).close();
        return stylesheetImpl;
    }

    static Stylesheet loadStylesheet(String string, ClassLoader classLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Path path = CauchoSystem.getWorkPath();
        Path path2 = path.lookup(string.replace('.', '/') + ".class");
        if (!path2.canRead()) {
            throw new ClassNotFoundException("can't find compiled XSL `" + string + "'");
        }
        SimpleClassLoader simpleClassLoader = SimpleClassLoader.create(classLoader, path, string);
        Class<?> clazz = null;
        try {
            clazz = simpleClassLoader.loadClass(string);
        }
        catch (Error error) {
            block5: {
                try {
                    path2.remove();
                }
                catch (IOException iOException) {
                    if (!dbg.canWrite()) break block5;
                    dbg.log(iOException);
                }
            }
            throw error;
        }
        return (Stylesheet)clazz.newInstance();
    }

    public static Path findXslPath(String string, Path[] pathArray, ClassLoader classLoader) {
        URL uRL;
        Object object;
        int n = 0;
        while (n < pathArray.length) {
            object = pathArray[n].lookupNative(string);
            if (((Path)object).canRead()) {
                return object;
            }
            ++n;
        }
        if (classLoader != null) {
            URL uRL2 = classLoader.getResource(string);
            Object object2 = object = uRL2 != null ? uRL2.toString() : null;
            if (uRL2 != null && (((String)object).endsWith(".jar") || ((String)object).endsWith(".zip"))) {
                return new JarPath(Vfs.lookup(uRL2.toString())).lookup(string);
            }
            if (uRL2 != null) {
                return Vfs.lookup(uRL2.toString());
            }
        }
        Object object3 = object = (uRL = ClassLoader.getSystemResource(string)) != null ? uRL.toString() : null;
        if (uRL != null && (((String)object).endsWith(".jar") || ((String)object).endsWith(".zip"))) {
            return new JarPath(Vfs.lookup(uRL.toString())).lookup(string);
        }
        if (uRL != null) {
            return Vfs.lookup(uRL.toString());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        Path path;
        String string = "default.xsl";
        String string2 = null;
        String string3 = null;
        String string4 = "";
        int n = 0;
        String string5 = CauchoSystem.getResinConfig();
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n < stringArray.length) {
            if (stringArray[n].equals("-xsl")) {
                string = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].equals("-lite")) {
                bl = false;
                ++n;
                continue;
            }
            if (stringArray[n].equals("-o")) {
                string2 = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].equals("-suffix")) {
                string3 = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].startsWith("-A")) {
                arrayList.add(stringArray[n].substring(2));
                ++n;
                continue;
            }
            if (stringArray[n].equals("-conf")) {
                string5 = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (!stringArray[n].equals("-h") && !stringArray[n].equals("-help")) break;
            Xsl.usage();
            return;
        }
        if ((path = Pwd.lookup(string5)).exists()) {
            try {
                Registry.setRegistry(Registry.parse(path));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        dbg = LogStream.open("/caucho.com/xsl/main");
        Path path2 = null;
        if (string2 != null) {
            path2 = Pwd.lookup(string2);
        } else if (string3 == null) {
            path2 = Pwd.lookup("stdout:");
        }
        if (stringArray.length - n > 1 && (string2 == null || path2.isFile()) && string3 == null) {
            System.err.println("multiple sources require a destination directory");
            System.exit(1);
        }
        try {
            try {
                Stylesheet stylesheet;
                Object object;
                Path[] pathArray = new Path[]{Pwd.lookup(string).getParent(), Pwd.lookup(), CauchoSystem.getResinHome().lookup("xsl")};
                Path[] pathArray2 = new Path[]{Pwd.lookup(string).getParent(), Pwd.lookup(), CauchoSystem.getResinHome().lookup("scripts")};
                Path path3 = Xsl.findXslPath(string, pathArray, null);
                if (path3 == null) {
                    System.out.println("can't find `" + string + "'");
                    System.exit(1);
                }
                ReadStream readStream = path3.openRead();
                if (bl) {
                    object = new Xml().parse(readStream);
                    stylesheet = Xsl.parse((Document)object, path3, pathArray, pathArray2, null, null);
                } else {
                    stylesheet = Xsl.parse(readStream, pathArray, pathArray2, null, null);
                }
                readStream.close();
                while (n < stringArray.length) {
                    try {
                        String string6;
                        Object object2;
                        object = stringArray[n];
                        Path path4 = Pwd.lookup((String)object);
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        String[] stringArray2 = new String[arrayList.size() + 1];
                        arrayList.toArray(stringArray2);
                        stringArray2[stringArray2.length - 1] = object;
                        hashMap.put("arguments", stringArray2);
                        hashMap.put("File", Pwd.lookup());
                        ReadStream readStream2 = path4.openRead();
                        Document document = null;
                        if (bl) {
                            document = new Xml().parse(readStream2);
                        } else {
                            object2 = new Html();
                            ((XmlParser)object2).setEntitiesAsText(true);
                            document = ((XmlParser)object2).parse(readStream2);
                            readStream2.close();
                        }
                        if (dbg.canWrite()) {
                            XmlPrinter.printHtml(dbg, document);
                            dbg.flush();
                        }
                        object2 = stylesheet.transform(document, hashMap);
                        if (dbg.canWrite()) {
                            stylesheet.print(dbg, (Node)object2);
                            dbg.flush();
                        }
                        Path path5 = null;
                        path5 = string2 != null ? Pwd.lookup(string2) : (string3 != null ? path4.getParent() : Pwd.lookup("stdout:"));
                        if (string3 != null) {
                            int n2 = ((String)object).lastIndexOf(46);
                            if (n2 == -1) {
                                System.err.println("suffix missing for `" + (String)object + "'");
                                System.exit(1);
                            }
                            string6 = ((String)object).substring(0, n2);
                            if (string2 == null && (n2 = string6.lastIndexOf(47)) >= 0) {
                                string6 = string6.substring(n2 + 1);
                            }
                            if (!path5.isFile()) {
                                path5 = path5.lookup(string6 + "." + string3);
                            } else {
                                System.err.println("illegal output combination");
                                System.exit(1);
                            }
                        } else if (path5.isDirectory()) {
                            path5 = path5.lookup((String)object);
                        }
                        try {
                            path5.getParent().mkdirs();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        WriteStream writeStream = path5.openWrite();
                        string6 = stylesheet.getOutputAttribute("encoding");
                        if (string6 != null) {
                            writeStream.setEncoding(string6);
                        }
                        stylesheet.print(writeStream, (Node)object2);
                        writeStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Object var12_32 = null;
                System.exit(0);
                return;
            }
            Object var12_31 = null;
        }
        catch (Throwable throwable) {
            Object var12_33 = null;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    private static void usage() {
        System.err.println("xsl [-xsl stylesheet] file1 file2 ...");
        System.err.println(" -xsl stylesheet : select a stylesheet");
        System.err.println(" -o filename     : output filename/directory");
        System.err.println(" -suffix suffix  : replacement suffix");
        System.err.println(" -lite           : XSLT-lite");
        System.err.println(" -Aarg           : argument passed to script");
        System.err.println(" -h              : this help message");
    }

    private Xsl() {
    }
}

