/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoDocument;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xsl.StylesheetImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.jsp.PageContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XslWriter
extends Writer {
    static WriteStream dbg = LogStream.open("/caucho.com/xsl/stream");
    private Object closure;
    private CauchoDocument doc;
    private Node node;
    private Attr attr;
    String filename;
    int line;
    int tailLine;
    private IntArray flags = new IntArray();
    private CharBuffer text = new CharBuffer();
    private ArrayList depends = new ArrayList();
    private boolean isCacheable = true;
    private boolean disableEscaping;
    private Path pwd;
    private PageContext page;
    private HashMap attributes = this.attributes;
    private StylesheetImpl stylesheet;

    void init() {
        this.doc = Xml.createDocument();
        this.node = this.doc;
        this.text.clear();
        this.flags.clear();
    }

    boolean isCacheable() {
        return this.isCacheable;
    }

    ArrayList getDepends() {
        return this.depends;
    }

    public void setNotCacheable() {
        this.isCacheable = false;
    }

    public void addCacheDepend(Path path) {
        int n = 0;
        while (n < this.depends.size()) {
            Path path2 = (Path)this.depends.get(n);
            if (path2.equals(path)) {
                return;
            }
            ++n;
        }
        this.depends.add(path);
    }

    public Path getPwd() {
        return this.pwd;
    }

    public PageContext getPage() {
        return this.page;
    }

    void setClosure(Object object) {
        this.closure = object;
    }

    Object getClosure() {
        return this.closure;
    }

    public boolean isFlagFirst(int n) {
        while (this.flags.size() <= n) {
            this.flags.add(0);
        }
        int n2 = this.flags.get(n);
        this.flags.set(n, 1);
        return n2 == 0;
    }

    public void write(int n) {
        this.text.append((char)n);
    }

    public void write(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.write(byArray[n + n3]);
            ++n3;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        this.text.append(cArray, n, n2);
    }

    public void print(String string) {
        if (string == null) {
            this.text.append("null");
            return;
        }
        this.text.append(string);
    }

    public void print(boolean bl) {
        this.text.append(bl);
    }

    public void print(char c) {
        this.text.append(c);
    }

    public void print(int n) {
        this.text.append(n);
    }

    public void print(long l) {
        this.text.append(l);
    }

    public void print(float f) {
        this.text.append(f);
    }

    public void print(double d) {
        this.text.append(d);
    }

    public void print(Object object) {
        this.text.append(object);
    }

    public void println() {
        this.text.append('\n');
        ++this.tailLine;
    }

    public void println(boolean bl) {
        this.text.append(bl);
        this.println();
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(int n) {
        this.text.append(n);
        this.println();
    }

    public void println(long l) {
        this.text.append(l);
        this.println();
    }

    public void println(double d) {
        this.text.append(d);
        this.println();
    }

    public void println(float f) {
        this.text.append(f);
        this.println();
    }

    public void println(Object object) {
        this.text.append(object);
        this.println();
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean getDisableEscaping() {
        return this.disableEscaping;
    }

    public boolean disableEscaping(boolean bl) {
        if (this.text.length() != 0 && bl != this.disableEscaping) {
            this.popText();
        }
        boolean bl2 = this.disableEscaping;
        this.disableEscaping = bl;
        return bl2;
    }

    public void setLocation(String string, int n) {
        if (string == null || !string.equals(this.filename) || n != this.tailLine) {
            this.popText();
        }
        this.filename = string;
        this.line = n;
        this.tailLine = n;
    }

    public void popText() {
        Text text = null;
        if (this.text.length() == 0) {
            return;
        }
        text = this.disableEscaping ? this.doc.createUnescapedTextNode(this.text.toString()) : this.doc.createTextNode(this.text.toString());
        if (text != null && this.filename != null) {
            ((CauchoNode)((Object)text)).setLocation(this.filename, this.line, 0);
            this.line = this.tailLine;
        }
        if (text != null) {
            this.node.appendChild(text);
        }
        this.text.clear();
    }

    public void pushElement(String string) throws IOException {
        this.popText();
        Element element = this.doc.createElement(string);
        ((CauchoNode)((Object)element)).setLocation(this.filename, this.line, 0);
        this.node.appendChild(element);
        this.node = element;
    }

    public void pushElement(String string, NamespaceContext namespaceContext) throws IOException {
        String string2;
        this.popText();
        int n = string.indexOf(58);
        String string3 = "";
        if (n > 0) {
            string3 = string.substring(0, n);
        }
        Element element = (string2 = NamespaceContext.find(namespaceContext, string3)) != null ? this.doc.createElement(string3, string.substring(n + 1), string2) : this.doc.createElement(string);
        ((CauchoNode)((Object)element)).setLocation(this.filename, this.line, 0);
        this.node.appendChild(element);
        this.node = element;
    }

    public void pushElementNs(String string, String string2) throws IOException {
        this.popText();
        int n = string.indexOf(58);
        String string3 = "";
        String string4 = string;
        if (n > 0) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        Element element = this.doc.createElement(string3, string4, string2);
        ((CauchoNode)((Object)element)).setLocation(this.filename, this.line, 0);
        this.node.appendChild(element);
        this.node = element;
    }

    public void pushElement(String string, String string2, String string3) throws IOException {
        this.popText();
        if (string3 != null && string3.startsWith("quote:")) {
            string3 = string3.substring(6);
        }
        Element element = this.doc.createElement(string, string2, string3);
        this.node.appendChild(element);
        this.node = element;
    }

    public void pushElementCopy(Node node) throws IOException {
        this.popText();
        if (!(node instanceof Element)) {
            throw new IOException("expected element at `" + this.node.getNodeName() + "'");
        }
        CauchoElement cauchoElement = (CauchoElement)node;
        Element element = this.doc.createElement(cauchoElement.getPrefixName(), cauchoElement.getLocalName(), cauchoElement.getNamespace());
        cauchoElement.setLocation(this.filename, this.line, 0);
        NamedNodeMap namedNodeMap = cauchoElement.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            CauchoNode cauchoNode = (CauchoNode)namedNodeMap.item(n);
            Attr attr = this.doc.createAttribute(cauchoNode.getPrefixName(), cauchoNode.getLocalName(), cauchoNode.getNamespace());
            attr.setNodeValue(cauchoNode.getNodeValue());
            element.setAttributeNode(attr);
            ++n;
        }
        this.node.appendChild(element);
        this.node = element;
    }

    public void popElement() throws IOException {
        this.popText();
        this.node = this.node.getParentNode();
    }

    public void pushAttribute(String string) throws IOException {
        if (!(this.node instanceof Element)) {
            throw new IOException("attribute must be child of element");
        }
        this.popText();
        this.attr = this.doc.createAttribute(string);
        Element element = (Element)this.node;
        element.setAttributeNode(this.attr);
        this.node = this.attr;
    }

    public void pushAttribute(String string, NamespaceContext namespaceContext) throws IOException {
        String string2;
        if (!(this.node instanceof Element)) {
            throw new IOException("attribute must be child of element");
        }
        this.popText();
        int n = string.indexOf(58);
        String string3 = "";
        if (n > 0) {
            string3 = string.substring(0, n);
        }
        Attr attr = (string2 = NamespaceContext.find(namespaceContext, string3)) != null ? this.doc.createAttribute(string3, string.substring(n + 1), string2) : this.doc.createAttribute(string);
        Element element = (Element)this.node;
        element.setAttributeNode(attr);
        this.node = attr;
    }

    public void pushAttributeNs(String string, String string2) throws IOException {
        this.popText();
        int n = string.indexOf(58);
        String string3 = "";
        String string4 = string;
        if (n > 0) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        Attr attr = this.doc.createAttribute(string3, string4, string2);
        Element element = (Element)this.node;
        element.setAttributeNode(attr);
        this.node = attr;
    }

    public void pushAttribute(String string, String string2, String string3) throws IOException {
        this.popText();
        if (string3 != null && string3.startsWith("quote:")) {
            string3 = string3.substring(6);
        }
        Attr attr = this.doc.createAttribute(string, string2, string3);
        Element element = (Element)this.node;
        element.setAttributeNode(attr);
        this.node = attr;
    }

    public void popAttribute() throws IOException {
        Attr attr = (Attr)this.node;
        if (this.text.length() != 0) {
            attr.setValue(this.text.toString());
        }
        this.text.clear();
        this.node = this.node.getParentNode();
    }

    public void pushCopy(Node node) throws IOException {
        this.popText();
        switch (node.getNodeType()) {
            case 2: {
                CauchoNode cauchoNode = (CauchoNode)node;
                Attr attr = this.doc.createAttribute(cauchoNode.getPrefixName(), cauchoNode.getLocalName(), cauchoNode.getNamespace());
                attr.setValue(node.getNodeValue());
                if (this.node instanceof Element) {
                    ((Element)this.node).setAttributeNode(attr);
                }
                this.node = attr;
                break;
            }
            case 9: {
                return;
            }
            case 1: {
                CauchoElement cauchoElement = (CauchoElement)node;
                Element element = this.doc.createElement(cauchoElement.getPrefixName(), cauchoElement.getLocalName(), cauchoElement.getNamespace());
                ((CauchoNode)((Object)element)).setLocation(cauchoElement.getFilename(), cauchoElement.getLine(), 0);
                this.node.appendChild(element);
                this.node = element;
                break;
            }
            case 8: {
                Comment comment = this.doc.createComment(((Comment)node).getData());
                this.node.appendChild(comment);
                this.node = comment;
                break;
            }
            case 3: {
                Text text = this.doc.createTextNode(((Text)node).getData());
                ((CauchoNode)((Object)text)).setLocation(((CauchoNode)node).getFilename(), ((CauchoNode)node).getLine(), 0);
                this.node.appendChild(text);
                this.node = text;
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                ProcessingInstruction processingInstruction2 = this.doc.createProcessingInstruction(processingInstruction.getNodeName(), "");
                this.node.appendChild(processingInstruction2);
                this.node = processingInstruction2;
                break;
            }
        }
    }

    public void popCopy() throws IOException {
        if (this.node.getNodeType() == 1) {
            this.popText();
        }
        this.text.clear();
        if (this.node.getParentNode() != null) {
            this.node = this.node.getParentNode();
        }
    }

    public void pushPi(String string) throws IOException {
        this.popText();
        ProcessingInstruction processingInstruction = this.doc.createProcessingInstruction(string, null);
        this.node.appendChild(processingInstruction);
        this.node = processingInstruction;
    }

    public void popPi() throws IOException {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)this.node;
        if (this.text.length() != 0) {
            processingInstruction.setData(this.text.toString());
        }
        this.text.clear();
        this.node = this.node.getParentNode();
    }

    public void pushComment() throws IOException {
        this.popText();
        Comment comment = this.doc.createComment("");
        this.node.appendChild(comment);
        this.node = comment;
    }

    public void popComment() throws IOException {
        Comment comment = (Comment)this.node;
        if (this.text.length() != 0) {
            comment.setData(this.text.toString());
        }
        this.text.clear();
        this.node = this.node.getParentNode();
    }

    public void pushFragment() throws IOException {
        this.popText();
        Element element = this.doc.createElement("dummy");
        this.node.appendChild(element);
        this.node = element;
    }

    public Node popFragment() throws IOException {
        Node node;
        this.popText();
        Element element = (Element)this.node;
        this.node = this.node.getParentNode();
        this.node.removeChild(element);
        DocumentFragment documentFragment = this.doc.createDocumentFragment();
        while ((node = element.getFirstChild()) != null) {
            documentFragment.appendChild(node);
        }
        return documentFragment;
    }

    public void valueOf(Object object) throws IOException {
        if (object == null) {
            return;
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            if (arrayList.size() > 0) {
                this.valueOf(arrayList.get(0));
            }
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            this.valueOf(iterator.next());
        } else if (object instanceof Element || object instanceof DocumentFragment) {
            Node node = (Node)object;
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this.elementValueOf(node2);
                node2 = node2.getNextSibling();
            }
        } else if (object instanceof Text) {
            String string = ((Text)object).getNodeValue();
            int n = 0;
            while (n < string.length()) {
                if (!XmlChar.isWhitespace(string.charAt(n))) {
                    this.print(string);
                    return;
                }
                ++n;
            }
            if (!this.stylesheet.stripSpaces(((Node)object).getParentNode())) {
                this.print(string);
            }
        } else if (object instanceof Node) {
            this.print(((CauchoNode)object).getNodeValue());
        } else if (object instanceof Double) {
            Double d = (Double)object;
            double d2 = d;
            if ((double)((int)d2) == d2) {
                this.print((int)d2);
            } else {
                this.print(d2);
            }
        } else {
            this.print(object);
        }
    }

    private void elementValueOf(Node node) throws IOException {
        if (node == null) {
            return;
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            Node node2 = element.getFirstChild();
            while (node2 != null) {
                this.elementValueOf(node2);
                node2 = node2.getNextSibling();
            }
        } else if (node instanceof Text) {
            String string = ((Text)node).getNodeValue();
            int n = 0;
            while (n < string.length()) {
                if (!XmlChar.isWhitespace(string.charAt(n))) {
                    this.print(string);
                    return;
                }
                ++n;
            }
            if (!this.stylesheet.stripSpaces(node.getParentNode())) {
                this.print(string);
            }
        }
    }

    public void copyOf(Object object) throws IOException {
        this.popText();
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            int n = 0;
            while (n < arrayList.size()) {
                Node node = (Node)arrayList.get(n);
                this.copyOf(node);
                ++n;
            }
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                this.copyOf(node);
            }
        } else if (object instanceof Attr) {
            Attr attr = (Attr)object;
            if (this.node instanceof Element) {
                Element element = (Element)this.node;
                element.setAttribute(attr.getNodeName(), attr.getNodeValue());
            }
        } else if (object instanceof Node) {
            Node node = (Node)object;
            this.node.appendChild(node.cloneNode(true));
        } else {
            this.print(Expr.toString(object));
        }
    }

    public Object getAttribute(String string) {
        if (this.attributes != null) {
            return this.attributes.get(string);
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, object);
    }

    public void removeAttribute(String string) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.remove(string);
    }

    public Iterator getAttributeNames() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes.keySet().iterator();
    }

    Document completeDocument(Document document) throws IOException {
        this.popText();
        return this.doc;
    }

    XslWriter(HashMap hashMap, Path path, PageContext pageContext, StylesheetImpl stylesheetImpl) {
        this.pwd = path;
        this.page = pageContext;
        this.stylesheet = stylesheetImpl;
    }
}

