/*
 *  Smart Cache, http proxy cache server
 *  Copyright (C) 1998-2001 Radim Kolar
 *
 *    Smart Cache is Open Source Software; you may redistribute it
 *  and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2, or (at your option) any later version.
 *
 *    This program distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *    A copy of the GNU General Public License is available as
 *  /usr/doc/copyright/GPL in the Debian GNU/Linux distribution or on
 *  the World Wide Web at http://www.gnu.org/copyleft/gpl.html. You
 *  can also obtain it by writing to the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import java.io.*;
import java.util.*;
import java.net.*;

public final class scache{

public static String VERSION;

public final static String CACHENAME="Smart Cache";
public final static String CACHEVER="0.53";
public static String CFGFILE="scache.cnf";
public static String GCFGFILE="gc.cnf";

public static boolean faststart;
public static String cfgdir=".";

public static int MAXHTTPCLIENTS=25;

private transient ServerSocket server;

private final static int ACT_RUN=0;
private final static int ACT_GC=1;
private final static int ACT_FAKEGC=2;
private final static int ACT_EXIT=4;
private final static int ACT_KILLUNREF=8;
private final static int ACT_REBALANCE=16;
private final static int ACT_CONVERT020=32;
private final static int ACT_CONVERT030=64;
private final static int ACT_LOCAL=128;
private final static int ACT_REPAIR=256;

/*
 * IF YOU DO NOT LIKE THINGS LIKE THIS, FEEL FREE TO DELETE OR REPLACE
 * THEM BY YOURS FAVOURITE.
 *    Hare Krishna
 */

private final static String[] quotes=
{
 /* classic http://www.iskcon.org/sastra/ */
"\"I was born in the darkest ignorance, and my spiritual master pierced my eyes\n"+
"with the torch of knowledge. I offer my respectful obeisances unto him.\"\n\t\t\t\t- Sri Guru Pranama",
/* the most known mantra in the world, recommended for present age */
"HARE KRSNA HARE KRSNA\nKRSNA KRSNA HARE HARE\nHARE RAMA HARE RAMA\nRAMA RAMA HARE HARE\n\t\t\t\t- Hare Krsna Maha-mantra",

/* Narasimha */
"\"I offer my obeisances to Lord Narasimha, who gives joy to Prahlada Maharaja and\nwhose nails are like chisels on the stonelike chest of the demon Hiranyakasipu.\n\nLord Nrsimha is here and also there. Wherever I go Lord Nrsimha is there. He is\nin the heart and is outside as well. I surrender to Lord Nrsimha, the origin of\nall things and the supreme refuge.\"\n\t\t\t\t- Sri Nrsimha Pranama",

"\"I offer my respectful obeisances unto all the Vaisnava devotees of the Lord.\nThey are just like desire trees who can fulfill the desires of everyone, and\nthey are full of compassion for the fallen conditioned souls.\"\n\t\t\t\t- Sri Vaisnava Pranama",

"\"O my dear Krsna, ocean of mercy, You are the friend of the distressed and the\nsource of creation. You are the master of the cowherd men and the lover of the\ngopis, especially Radharani. I offer my respectful obeisances unto You.\"\n\t\t\t\t- Sri Krsna Pranama",


"\"I offer my repeated obeisances unto Vrnda, Srimati Tulasi Devi, who is very\ndear to Lord Kesava. O goddess, you bestow devotional service to Lord Krsna\nand possess the highest truth.\"\n\t\t\t\t- Sri Tulasi Pranama",

"\"O Kesava! O Lord of the universe! O Lord Hari, who have assumed the form of\nhalf-man, half-lion! All glories to You! Just as one can easily crush a wasp\nbetween one's fingernails, so in the same way the body of the wasp like demon\nHiranyakasipu has been ripped apart by the wonderful pointed nails on Your\nbeautiful lotus hands.\"\n\t\t\t\t- Prayer to Lord Nrsimha\n\t\t\t\t\t(from Sri Dasavatara-stotra, p. 97)",

/* Sri Isopanisad -> http://www.iskcon.net/isopanisad/ */

"\"Everything animate or inanimate that is within the universe is controlled and\nowned by the Lord. One should therefore accept only those things necessary for\nhimself, which are set aside as his quota, and one should not accept other\nthings, knowing well to whom they belong.\"\n\t\t\t\t- Sri Isopanisad, mantra 1",

"\"One may aspire to live for hundreds of years if he continuously goes on working\nin that way, for that sort of work will not bind him to the law of karma.\nThere is no alternative to this way for man.\"\n\t\t\t\t- Sri Isopanisad, mantra 2",

"\"The killer of the soul, whoever he may be, must enter into the planets known as\nthe worlds of the faithless, full of darkness and ignorance.\"\n\t\t\t\t- Sri Isopanisad, mantra 3",

"\"The Supreme Lord walks and does not walk. He is far away, but He is very near\nas well. He is within everything, and yet He is outside of everything.\"\n\t\t\t\t- Sri Isopanisad, mantra 5",

"\"He who sees everything in relation to the Supreme Lord, who sees all living\nentities as His parts and parcels, and who sees the Supreme Lord within\neverything never hates anything or any being.\"\n\t\t\t\t- Sri Isopanisad, mantra 6",


"\"One who always sees all living entities as spiritual sparks, in quality one\nwith the Lord, becomes a true knower of things.\nWhat, then, can be illusion or anxiety for him?\"\n\t\t\t\t- Sri Isopanisad, mantra 7",

"\"Such a person must factually know the greatest of all, the Personality of\nGodhead, who is unembodied, omniscient, beyond reproach, without veins, pure\nand uncontaminated, the self-sufficient philosopher who has been fulfilling\neveryone's desire since time immemorial.\"\n\t\t\t\t- Sri Isopanisad, mantra 8",

"\"Those who engage in the culture of nescient activities shall enter into the\ndarkest region of ignorance. Worse still are those engaged in the culture of\nso-called knowledge.\"\n\t\t\t\t- Sri Isopanisad, mantra 9",

"\"The wise have explained that one result is derived from the culture of\nknowledge and that a different result is obtained from the culture of\nnescience.\"\n\t\t\t\t- Sri Isopanisad, mantra 10",


"\"Only one who can learn the process of nescience and that of transcendental\nknowledge side by side can transcend the influence of repeated birth and death\nand enjoy the full blessings of immortality.\"\n\t\t\t\t- Sri Isopanisad, mantra 11",

"\"Those who are engaged in the worship of demigods enter into the darkest region\nof ignorance, and still more so do the worshipers of the impersonal Absolute.\"\n\t\t\t\t- Sri Isopanisad, mantra 12",

"\"Let this temporary body be burnt to ashes, and let the air of life be merged\nwith the totality of air. Now, O my Lord, please remember all my sacrifices,\nand because You are the ultimate beneficiary, please remember all that I\nhave done for You.\"\n\t\t\t\t- Sri Isopanisad, mantra 17",


"\"O my Lord, as powerful as fire, O omnipotent one, now I offer You all\nobeisances, falling on the ground at Your feet. O my Lord, please lead me on\nthe right path to reach You, and since You know all that I have done in the\npast, please free me from the reactions to my past sins so that there will be\nno hindrance to my progress.\"\n\t\t\t\t- Sri Isopanisad, mantra 18",

 /* BHAGAVAD - GITA quotes -> http://www.gitacd.com */
"\"Never there was a time when I did not exist, nor you, nor all these kings;\nnor in the future shall any of as cease to be.\"\n\t\t\t\t- Bhagavad-gita 2.12",

"\"As the embodied soul continuously passes, in this body, from boyhood to youth\nto old age, the soul similarly passes into another body at death. A sober person\nis not bewildered by such a change.\"\n\t\t\t\t- Bhagavad-gita 2.13",

"\"That which pervades the entire body you should know to be indestructible.\nNo one is able to destroy that imperishable soul.\"\n\t\t\t\t- Bhagavad-gita 2.17",

"\"For the soul there is neither birth nor death at any time. He has not come into\nbeing, does not come into being, and will not come into being. He is unborn,\neternal, ever-existing and primeval. He is not slain when the body is slain.\"\n\t\t\t\t- Bhagavad-gita 2.20",

"\"Whatever action a great man performs, common men follow. And whatever standards\nhe sets by exemplary acts, all the world pursues.\"\n\t\t\t\t- Bhagavad-gita 3.21",

"\"Just try to learn the truth by approaching a spiritual master. Inquire from\nhim submissively and render service unto him. The self-realized souls can\nimpart knowledge unto you because they have seen the truth.\"\n\t\t\t\t- Bhagavad-gita 4.34",

"\"For him who has conquered the mind, the mind is the best of friends;\nbut for one who has failed to do so, his mind will remain the greatest enemy.\"\n\t\t\t\t- Bhagavad-gita 6.6",

"\"A person is said to be established in self-realization and is called a\nyogi [or mystic] when he is fully satisfied by virtue of acquired knowledge\nand realization. Such a person is situated in transcendence and is\nself-controlled. He sees everything--whether it be pebbles, stones or gold --\n -- as the same.\"\n\t\t\t\t- Bhagavad-gita 6.8",

"\"The Supreme Personality of Godhead said: Son of Prtha, a transcendentalist\nengaged in auspicious activities does not meet with destruction either in this\nworld or in the spiritual world; one who does good, My friend, is never\novercome by evil.\"\n\t\t\t\t- Bhagavad-gita 6.40",

"\"O conqueror of wealth, there is no truth superior to Me. Everything rests\nupon Me, as pearls are strung on a thread.\"\n\t\t\t\t- Bhagavad-gita 7.7",

/* learn How you can see God */
"\"O son of Kunti, I am the taste of water, the light of the sun and the moon,\nthe syllable om in the Vedic mantras; I am the sound in ether and ability in\nman.\"\n\t\t\t\t- Bhagavad-gita 7.8",

"\"I am the original fragrance of the earth, and I am the heat in fire.\nI am the life of all that lives, and I am the penances of all ascetics.\"\n\t\t\t\t- Bhagavad-gita 7.9",

"\"O son of Prtha, know that I am the original seed of all existences,\nthe intelligence of the intelligent, and the prowess of all powerful men.\"\n\t\t\t\t- Bhagavad-gita 7.10",

"\"I am the strength of the strong, devoid of passion and desire. I am sex life\nwhich is not contrary to religious principles, O lord of the Bharatas [Arjuna].\"\n\t\t\t\t- Bhagavad-gita 7.11",

"\"Know that all states of being--be they of goodness, passion or ignorance--are\nmanifested by My energy. I am, in one sense, everything, but I am independent.\nI am not under the modes of material nature, for they, on the contrary, are\nwithin Me.\"\n\t\t\t\t- Bhagavad-gita 7.12",

"\"Those miscreants who are grossly foolish, who are lowest among mankind, whose\nknowledge is stolen by illusion, and who partake of the atheistic nature of\ndemons do not surrender unto Me.\"\n\t\t\t\t- Bhagavad-gita 7.15",

"\"O best among the Bharatas, four kinds of pious men begin to render devotional\nservice unto Me--the distressed, the desirer of wealth, the inquisitive, and he\nwho is searching for knowledge of the Absolute.\"\n\t\t\t\t- Bhagavad-gita 7.16",

"\"O Arjuna, as the Supreme Personality of Godhead, I know everything that has\nhappened in the past, all that is happening in the present, and all things that\nare yet to come. I also know all living entities; but Me no one knows.\"\n\t\t\t\t- Bhagavad-gita 7.26",

"\"Those who worship the demigods will take birth among the demigods; those who\nworship the ancestors go to the ancestors; those who worship ghosts and spirits\nwill take birth among such beings; and those who worship Me will live with Me.\"\n\t\t\t\t-Bhagavad-gita 9.25",

"\"If one offers Me with love and devotion a leaf, a flower, fruit or water,\nI will accept it.\"\n\t\t\t\tBhagavad-gita 9.26",

"\"Whatever you do, whatever you eat, whatever you offer or give away,\nand whatever austerities you perform -- do that, O son of Kunti,\nas an offering to Me.\"\n\t\t\t\tBhagavad-gita 9.27",

"\"Engage your mind always in thinking of Me, become My devotee, offer obeisances\nto Me and worship Me. Being completely absorbed in Me, surely you will come\nto Me.\"\n\t\t\t\t- Bhagavad-gita 9.34",

"\"I am the Supersoul, O Arjuna, seated in the hearts of all living entities.\nI am the beginning, the middle and the end of all beings.\"\n\t\t\t\t- Bhagavad-gita 10.20",

"\"Of the Adityas I am Visnu, of lights I am the radiant sun, of the Maruts\nI am Marici, and among the stars I am the moon.\"\n\t\t\t\t- Bhagavad-gita 10.21",

"\"The Supreme Personality of Godhead said: Time I am, the great destroyer of\nthe worlds, and I have come here to destroy all people. With the exception of\nyou [the Pandavas], all the soldiers here on both sides will be slain.\"\n\t\t\t\t- Bhagavad-gita 11.32",

"\"The splendor of the sun, which dissipates the darkness of this whole world,\ncomes from Me. And the splendor of the moon and the splendor of fire are also\nfrom Me.\"\n\t\t\t\t- Bhagavad-gita 15.12",

"\"I enter into each planet, and by My energy they stay in orbit. I become the\nmoon and thereby supply the juice of life to all vegetables.\"\n\t\t\t\t- Bhagavad-gita 15.13",

"\"I am the fire of digestion in the bodies of all living entities, and I join\nwith the air of life, outgoing and incoming, to digest the four kinds of\nfoodstuff.\"\n\t\t\t\t- Bhagavad-gita 15.14",

"\"I am seated in everyone's heart, and from Me come remembrance, knowledge and\nforgetfulness. By all the Vedas, I am to be known. Indeed, I am the compiler\nof Vedanta, and I am the knower of the Vedas.\"\n\t\t\t\t- Bhagavad-gita 15.15",

"\"Always think of Me, become My devotee, worship Me and offer your homage unto\nMe. Thus you will come to Me without fail. I promise you this because you are\nMy very dear friend.\"\n\t\t\t\t- Bhagavad-gita 18.65",

"\"Abandon all varieties of religion and just surrender unto Me. I shall deliver\nyou from all sinful reactions. Do not fear.\"\n\t\t\t\t- Bhagavad-gita 18.66"

};
final public static void main(String argv[]) throws IOException
{
 if(argv==null) argv=new String[0]; // fix for Bernd :)
 faststart=false;

// System.runFinalizersOnExit(true);
 VERSION=CACHENAME+" "+CACHEVER;

 System.err.println(VERSION+" - full featured caching proxy server and web forwarder.\n"+
 "Copyright (c) Radim Kolar 1998-2001. Open source software; There is NO warranty.\n"+
 "See the GNU General Public License version 2 or later for copying conditions.\n");

 /* print quote to stderr */
 System.err.println(quotes[(int)(Math.random()/(1f/(float)quotes.length))]);
 System.err.println("");
 /* scan command line for last -cfgdir */
 for(int i=0;i<argv.length;i++)
 {
   if(argv[i].equals("-cfgdir"))
     if(i+1<argv.length)
     {
       cfgdir=argv[i+1];
       i++;
     }
 }
 // read the configuration
 mgr m=new mgr();
 m.read_config(cfgdir+File.separator+CFGFILE);

 int ACT=0;
 boolean filesystemchecked=false;

 for(int i=0;i<argv.length;i++)
 {
    if(argv[i].equals("-cfgdir"))
    {
      if(i+1<argv.length)
      {
        cfgdir=argv[i+1];
	i++;
      }
    } else
    if(argv[i].equals("-killunref"))  { ACT|=ACT_KILLUNREF|ACT_EXIT;}
     else
    if(argv[i].equals("-ro") || argv[i].equals("-cdrom") ||
       argv[i].equals("-readonly") || argv[i].equals("-read-only"))
          cachedir.readonly=true;
     else
    if(argv[i].equals("-p") ||
       argv[i].equals("-port")
    )
     {
      if(i+1<argv.length && ! argv[i+1].startsWith("-"))
      {
        try
	{
          mgr.ourport=Integer.valueOf(argv[i+1]).intValue();
	}
	catch (Exception exx)
	 {
           System.err.println("[ERROR] -p requires a numeric argument");
	 }
	i++;
      } else
           System.err.println("[ERROR] -p <port>");
     } else
    if(argv[i].equals("-import"))
     {
      if(i+1<argv.length && ! argv[i+1].startsWith("-"))
      {
        if(filesystemchecked==false) {
	                              m.check_filesystem();
				      filesystemchecked=true;
				     }
        m.dirimport(argv[i+1]);
	i++;
	ACT|=ACT_EXIT;
      } else
         System.out.println("[ERROR] -import <Directory>");
     } else
    if(argv[i].equals("-importcache"))
     {
      if(i+1<argv.length && ! argv[i+1].startsWith("-"))
      {
        if(filesystemchecked==false) {
	                              m.check_filesystem();
				      filesystemchecked=true;
				     }
        m.cacheimport(argv[i+1]);
	i++;
	ACT|=ACT_EXIT;
      } else
         System.out.println("[ERROR] -importcache <Directory>");
     }
     else
    if(argv[i].equals("-export")
    || argv[i].equals("-fullexport")
    || argv[i].equals("-lruexport")
    || argv[i].equals("-exportlru")
    || argv[i].equals("-exportfull")
    )
     {
      if(i+2<argv.length && ! argv[i+1].startsWith("-")
                         && ! argv[i+2].startsWith("-") )
      {
        if(filesystemchecked==false) {
	                              m.check_filesystem();
				      filesystemchecked=true;
				     }
        int type;
	type=garbage.EXPORT_FILEDATE;
	if(argv[i].indexOf("full")>0) type=garbage.EXPORT_DATE; else
	if(argv[i].indexOf("lru")>0) type=garbage.EXPORT_LRU;
	
	try
	{
          m.cacheexport(argv[i+1],type,garbage.timestring(argv[i+2]));
	}
	catch (java.lang.NumberFormatException zzz)
	 { m.cacheexport(argv[i+2],type,garbage.timestring(argv[i+1]));
	 }
	i+=2;
	ACT|=ACT_EXIT;
      } else
         System.out.println("[ERROR] -export <Directory> <timediff>");
     }
    else
    if(argv[i].equals("-cachedir") ||
       argv[i].equals("-swapdir") ||
       argv[i].equals("-cacheroot") ||
       argv[i].equals("-root") ||
       argv[i].equals("-dir")
       )
    {
      if(i+1<argv.length && ! argv[i+1].startsWith("-"))
      {
        m.cache_dir=argv[i+1];
	i++;
      } else { System.out.println("[ERROR] -cachedir <Directory> [swap_level1_dirs] [swap_level2_dirs]");
               continue;
	     }
      if(i+1<argv.length && ! argv[i+1].startsWith("-"))
      {
       try
       {
         int z=Integer.valueOf(argv[i+1]).intValue();
	 m.swap_level1_dirs=m.swap_level2_dirs=z;
	 i++;
       }
       catch (NumberFormatException nse)
        {continue;}
      }
      if(i+1<argv.length && ! argv[i+1].startsWith("-"))
            {
	           try
		   {
		    int z=Integer.valueOf(argv[i+1]).intValue();
	            m.swap_level2_dirs=z;
	            i++;
	           }
	           catch (NumberFormatException nse)
			           {continue;}
            }
    } else
    if(argv[i].equals("-gc"))  { ACT|=ACT_GC|ACT_EXIT;}
     else
    if(argv[i].equals("-rebalance")) { ACT|=ACT_REBALANCE|ACT_EXIT;}
     else
    if(argv[i].equals("-fakegc"))  {ACT|=ACT_FAKEGC|ACT_EXIT;}
     else
    if(argv[i].equals("-convert020"))  { ACT|=ACT_CONVERT020|ACT_EXIT;}
     else
    if(argv[i].equals("-convert030"))  { ACT|=ACT_CONVERT030|ACT_EXIT;}
     else
    if(argv[i].equals("-faststart"))  { faststart=true;}
     else
    if(argv[i].equals("-version"))  { System.out.println(CACHEVER);
                                      System.exit(0);
                                    }
     else
    if(argv[i].equals("-local"))  { ACT|=ACT_LOCAL;
                                  }
     else				
    if(argv[i].equals("-direct"))  {
	                     m.parentproxy=null;
	                     m.no_proxy=null;
	   System.err.println("Smart Cache set to DIRECT MODE. Will not use parent proxy.");
                                  }
     else				
   if(argv[i].equals("-http_proxy")) {
      if(i+2<argv.length && (! argv[i+1].startsWith("-")) && (! argv[i+2].startsWith("-")))
       try
        {
           m.setproxy(argv[i+1],Integer.valueOf(argv[i+2]).intValue(),null);
	}
      catch (Exception exx)
        {
	  System.out.println("[ERROR] -http_proxy <Hostname> <Port>");
	}
      finally
       {
        i+=2;
       }
     else
       System.out.println("[ERROR] -http_proxy <Hostname> <Port>");
     }

     else
    if(argv[i].equals("-repair"))  { ACT|=ACT_REPAIR|ACT_EXIT;
                                  }
     else
     {
      if(!argv[i].equals("-?") &&
         !argv[i].equals("-h") &&
	 !argv[i].equals("-help"))
               System.out.println("[ERROR] Unknown command-line switch: "+argv[i]);
      System.err.println("usage: scache [ -option ... ]\n\nOptions:"
      +"\n\t-gc\t\tRun garbage collection and exit"
      +"\n\t-cfgdir <Dir>\tSearch configuration files there"
      +"\n\t-cachedir <Dir> [sw1] [sw2]  Use alternate data directory"
      +"\n\t-rebalance\tRehash directory for new swap levels structure"
      +"\n\t-repair\t\tTry to repair damaged cache structure"
      +"\n\t-p <number>\tRun on alternate port"
      +"\n\t-http_proxy <Hostname> <port>  Use alternate parent http_proxy"
      +"\n\t-ro\t\tUse data directory in read-only mode"
      +"\n\t-import <Dir>\tImport data from external source"
      +"\n\t-importcache <Dir>  Import data from another Smart Cache"
      +"\n\t-version\tPrint program version and exit"
      +"\n\t-[full|lru]export <Dir> <TimeDelta>  Export newly modified data to specific directory"
      +"\n\t-local\t\tRun cache in forced local mode - needed for avoiding DNS lookups and connects timeouts on bad TCP configurations"
      +"\n\t-direct\t\tDo not use http_proxy"
      +"\n\t-killunref\tRemove bad and inaccessible files from cache. Better is to use -gc or -repair instead."
      +"\n\t-fakegc\t\tSimulate garbage collection, (usefull for gc.cnf debug or benchmark)"
      +"\n\nFor more information consult the Smart Cache Manual."

      );return;
    }
  }
  /* check filesystem sanity */
  if(filesystemchecked==false) m.check_filesystem();
  while(ACT>0)
  {
   if( (ACT & ACT_REBALANCE)>0)
    {
     m.rebalance();
     ACT-=ACT_REBALANCE;
    } else
   if( (ACT & ACT_REPAIR)>0)
    {
     System.out.println(new Date()+" Repairing data directory.");
     repair.repairDir(m.cache_dir,true);
     System.out.println(new Date()+" Done.");
     ACT-=ACT_REPAIR;
    } else
   if( (ACT & ACT_FAKEGC)>0)
    {
     m.fake_garbage_collection();
     ACT-=ACT_FAKEGC;
    } else
   if( (ACT & ACT_GC)>0)
    {
     m.garbage_collection();
     ACT-=ACT_GC;
    } else
   if( (ACT & ACT_KILLUNREF)>0)
    {
     m.kill_unref();
     ACT-=ACT_KILLUNREF;
    } else
   if( (ACT & ACT_CONVERT020)>0)
   {
	   m.converto020();
	   ACT-=ACT_CONVERT020;
   } else
   if( (ACT & ACT_CONVERT030)>0)
   {
	   m.converto030();
	   ACT-=ACT_CONVERT030;
   } else
   if( (ACT & ACT_LOCAL)>0)
   {
	   m.parentproxy=InetAddress.getByName("127.0.0.1");
	   m.port=4; // CHECK: I never see any app which uses it
	   m.no_proxy=null;
	   System.err.println("Smart Cache set to FORCED LOCAL MODE. Will not connect to ANY site.");
	   ACT-=ACT_LOCAL;
  } else
  if( (ACT & ACT_EXIT)>0)
  {
	  ACT-=ACT_EXIT;
	  return;
  }
	
  } /* ACT loop */
  m.go();
}


scache(int port,InetAddress adr) throws IOException
{
 if(adr!=null)

  try{
  server=new ServerSocket(port,10,adr);
  }
  catch(IOException e) {System.err.println("[SMARTCACHE] Fatal error: Cannot bind to my port "+port+"/"+adr.getHostAddress()+"\n[SMARTCACHE]    Reason: "+e);System.exit(3);}
   else
  try{
    server=new ServerSocket(port);
  }
  catch(IOException e) {System.err.println("[SMARTCACHE] Fatal error: Cannot bind to my port "+port+"/*");throw e;}
}

public final void httpdloop()
 {
  ThreadGroup clients;
  httpreq client;
  clients=new ThreadGroup("HTTP-clients");
   while (true ) {
            Socket clientSocket = null;
            client=null;
            try {
                clientSocket = server.accept();
                } catch (IOException e) {
                System.err.println("[SMARTCACHE] Warning: Accept failed: "+e);
                continue;
            }
            if(clients.activeCount()>MAXHTTPCLIENTS)
              try {
              System.err.println(new Date()+" [SMARTCACHE] Warning: Active clients limit ("+MAXHTTPCLIENTS+") reached, request rejected.");
              clientSocket.close();}
              catch(IOException e) {}
              finally { continue;}
            client=new httpreq(clientSocket);
            new Thread(clients,client).start();
   }  /* listen */
 }
} /* class scache*/
