/* Utility to edit the init_sta.80 file.
   This is especially useful when you want to remotely
   configure init_sta.80, as by a TELNET session */

/*--------------   Load REXX libraries ----- */
/* Load up advanced REXX functions */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'

  call SysLoadFuncs
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end

if rxfuncquery('sref_fileread')<>0 then do
  ik=rxfuncadd('sref_fileread','rexxlib','LIB_FILEREAD')
  if ik<>0 then ss=sref_error(' SRE-http Monitor: Warning: unable to register SREF_FILEREAD',1)
end
if rxfuncquery('sref_filewrite')<>0 then do
  ik=rxfuncadd('sref_filewrite','rexxlib','LIB_FILEWRITE')
  if ik<>0 then ss=sref_error(' SRE-http Monitor: Warning: unable to register SREF_FILEWRITE',1)
end



parse upper arg aval0
ii=wordpos('NOEXIT',aval0)
if ii>0 then do
    noexit=1
end /* do */


/* some io stuff */
ansion=checkansi()
if ansion=1 then do
  aesc='1B'x
  cy_ye=aesc||'[37;46;m'
  normal=aesc||'[0;m'
  bold=aesc||'[1;m'
  re_wh=aesc||'[31;47;m'
  reverse=aesc||'[7;m'
end
else do
  say " Warning: Could not detect ANSI....  output will look ugly ! "
  cy_ye="" ; normal="" ; bold="" ;re_wh="" ;
  reverse=""
end  /* Do */

cls
say  " " ; say

issref=0
say
say cy_ye " The SRE-http program file configurator " normal
say
say " This is a simple editor for various SRE-http program files:"
say "     including INIT_STA.80, SREFMON.CMD, and COUNTER.RXX "
say "     (it's especially useful for remote (telnet) configuration ) "
say " "
say " "
whatfile:
say "What " bold "SRE-http "normal"  file should be edited?"
call charout , reverse "(ENTER=cfgs\INIT_STA.80):" normal

pull dofile0
if dofile0='' then do
   dofile0='cfgs\INIT_STA.80'
   issref=1
   say " Hint:  If you are unfamiliar with what the INIT_STA.80 parameters "
   say "        control, we recommend perusing INITFILT.DOC"
   say
end
dofile=stream(dofile0,'c','query exists')
if dofile=' ' then do
    say " No such file: " dofile0
    if pos('.RXX',translate(dofile0))>0 then
       say ' Perhaps you meant ADDON\'||dofile0' ?'
    signal whatfile
end

foo=sref_fileread(dofile,lines,,'E')
say " # lines in " dofile " = " lines.0
isbegin=0 ; isend=0
do mm=1 to lines.0
   aline=strip(upper(lines.mm))
   if abbrev(aline,'/*BEGIN')=1 then isbegin=mm
    if abbrev(aline,'/*END')=1 then do
        isend=mm
        leave
    end  /* Do */
end /* do */
if isbegin*isend=0 then do
     say " Sorry, unable to find the /*BEGIN and /*END delimiters"
     say " (EDITSREF is designed to work with SRE-http ver 1.2j and above)"
     signal byebye
end  /* Do */
say " Parameter section between lines " isbegin " and " isend

/* now find variables and descriptions */
/* assume cmt on, find cmt off */
ik= isbegin+1
ivar=0
stuff.1.!c1=ik
do until ik>isend-1
   aline=strip(lines.ik)
   if right(aline,2)='*/' then do
      ivar=ivar+1
      stuff.ivar.!c2=ik
      stuff.ivar=ik+1
      ivar1=ivar+1; ik=ik+2
      stuff.ivar1.!c1=ik
   end
   ik=ik+1
end /* do */
say " There are " ivar " variables to set."
say " "
say bold " Enter values: " normal
say "   ENTER -- retain current value "
say "     ?   -- show a brief description "
say "    !!   -- step backwards  "
say "    ##   -- quit now, without making any changes  "
say "   value -- replace with value (be sure to include ' around strings)"
say " "
say ' #)' reverse left('Variable name ',20) ' = ' normal bold 'Current Value 'normal cy_ye ' ? ' normal '(new value)'
say ' ----------------------------------------------------------------------------'
j1:
ii=1 ;noemp=1
do forever
   if ii>ivar then leave
 
   i1=stuff.ii ; c1=stuff.ii.!c1 ; c2=stuff.ii.!c2
   parse var lines.i1 vname '=' vval
   vname0=left(vname,max(length(vname),24))
  
   call charout,left(ii,2)')' reverse vname0 ' = ' normal bold vval normal
   if length(vval)>35 then do
      say ; call charout,copies(' ',7+length(vname0))
   end
   call charout,cy_ye ' ? ' normal

   parse pull aval
   if aval="" then do 
        ii=ii+1
        iterate
   end  /* Do */
   if aval="?" then do
       say " " ; say " ----> " bold vname0 normal
       do ll=c1 to c2
          if lines.ll=' ' then iterate
          gel=left(lines.ll,min(length(lines.ll),70))
          say "   " cy_ye gel normal
       end /* do */
       iterate
   end  /* Do */
   if aval="!!"  then do
        ii=max(ii-1,1)
        iterate
   end  /* Do */
   if aval='##'  then do
        say " Exiting without making any changes. "
        call syssleep 2
        signal byebye 
   end /* do */
   lines.i1=vname'='aval
end /* do */
foy1:say " "
call charout, " Enter Y to save changes, N to quit, R to reenter: "
pull ans
if ans='R' then do
    say
    say bold " Current changes are retained (but not saved) ... "
    signal j1
end  /* Do */
else
if ans='N' then do
    say " Changes " bold " not "normal " saved."
    signal byebye
end  /* Do */
if ans<>'Y' then signal foy1

ip=pos('.',dofile)
if ip=0 then do
   bakfile=dofile||'.V??'
end
else do
   bakfile=left(dofile,ip)||'V??'
end
bakfile=dostempname(bakfile)
say dofile ' is being renamed as '  bakfile
foo=dosrename(dofile,bakfile)
if foo=0 then   say " Warning: ERROR renaming! "

nn=lines.0+1
lines.nn='/* updated on '||time('n')||' '||date('n')||' */'
lines.0=nn


foo=sref_filewrite(dofile,lines)
if foo=0 then do
    say ' Warning: new version of ' dofile ' was NOT written '
end
else do
  if issref=1 then do
    say " Reminder: changes to the parameters contained in " dofile  
    say "           will take effect only when GoServe is restarted. "
  end
end
signal byebye


byebye:
if noexit=1  then return 1
exit



 /* ------------------------------------------------------------------ */
 /* function: Check if ANSI is activated                               */
 /*                                                                    */
 /* call:     CheckAnsi                                                */
 /*                                                                    */
 /* where:    -                                                        */
 /*                                                                    */
 /* returns:  1 - ANSI support detected                                */
 /*           0 - no ANSI support available                            */
 /*          -1 - error detecting ansi                                 */
 /*                                                                    */
 /* note:     Tested with the German and the US version of OS/2 3.0    */
 /*                                                                    */
 /*                                                                    */
 CheckAnsi: PROCEDURE
   thisRC = -1

   trace off
                         /* install a local error handler              */
   SIGNAL ON ERROR Name InitAnsiEnd

   "@ANSI 2>NUL | rxqueue 2>NUL"

   thisRC = 0

   do while queued() <> 0
     queueLine = lineIN( "QUEUE:" )
     if pos( " on.", queueLine ) <> 0 | ,                       /* USA */
        pos( " (ON).", queueLine ) <> 0 then                    /* GER */
       thisRC = 1
   end /* do while queued() <> 0 */

 InitAnsiEnd:
 signal off error
 RETURN thisRC




