/* this is the SRE-http installation program */

call init_it
crlf='0d0a'x

cls
say  " " ; say

call lineout, bold cy_ye
call lineout, "This is the SRE-http  (v 1.3g) installation program (12 July 1999)."
call lineout, "... an HTTP/1.1 compliant filter for the GoServe OS/2 Internet Server "
call lineout, normal


say " This program will ask for the names of a few directories,"
say " and will copy a number of files to these directories."
say "  "

if yesno(" Are you ready to continue ")=1 then
 nop
else do
 say " See you later?.. "
 exit
end

/* first, check tcp/ip version -- suggest upgrade */
'@inetver | rxqueue '
pull oy
parse var oy . ':' aver 
parse var aver mainver '.' subver
if mainver='4' then do
  if subver<'02T' then do
      say
      say bold"WARNING: " normal" Your TCP/IP version is "aver
      say "           We "bold"STRONGLY"normal" recommend upgrading to 4.02t (or above)"
     if yesno(" Continue installing SRE-http (and upgrade TCP/IP later)?")=1 then do
        say "   Okay, but you may experience sporadic errors."
        say '   (Please see SREHTTP.FAQ for a discussion of "why is response time so slow") '
        say ' '
     end
     else do
        say "As of 10 Dec 1998, 4.02t info can be found at: "
        say "   ftp://ps.software.ibm.com/ps/products/tcpip/rsu/stack/latestv4.html"
        say " (see SREHTTP.FAQ for more info on upgrading tcp/ip) "
        say
        say "See you later.... "
        exit
     end /* do */
  end
end

hh=yesno(" Install (I), or review the installation notes (R)",,'I R')
if hh=0 then do
    say " okay, reviewing installation notes.  ... "
    say ' '
   signal gonotes
end

/* check status of goserve and macrospace routines */
a=dospidlist(l1,l2)
do mm=1 to a
 foo=upper(strip(filespec('n',l2.mm)))
 if foo='GOSERVE.EXE' then do
     say bold " GOSERVE appears to be running " normal
     say " Please shut down GOSERVE  before you (re) install SRE-http! "
      exit
  end  /* Do */
end /* do */

adir=filespec("drive",nowdir)
defname=adir||'\GOSERVE'
defname2=adir||'\WWW'

call check_macro

install_counter=1
install_new=yesno(normal" Is this a: "bold" New installation (N), or an upgrade (U)",,'N U')

if install_new=0 then do
  call make_def_dirs 1
  useoo=result
say ' '
  say " Parameter files will NOT be modified (please see the upgraders notes)"

  crx=stream(addon_dir||'\COUNTER.RXX','c','query size')
  if crx<>0 & crx<>'' then do  /* check vintage of counter.rxx */
      ain=charin(addon_dir||'\COUNTER.RXX',1,crx)
      fcrx=stream(addon_dir||'\COUNTER.RXX','c','close')
      ii=pos('COUNTER_RXX_DIR',ain)
      if ii=0 then do           /* it's pre 1.3d */ 
        say
        say " An old (pre 1.3d) version of COUNTER.RXX was detected "
        install_counter=yesno(normal'   'bold'  Install the latest version of COUNTER.RXX?')
        if install_counter=1 then do
            say "    Note: the new copy of COUNTER.RXX (that will be installed) "
            say "           contains parameters you might need to customize."
         end
         else do
            say "  Warning: HOST specific COUNTER_DIR requires ver 1.3d (or above) of COUNTER.RXX "
         end
       end              /* detected old counter.rxx */
       else do
         install_counter=0
        end
   end                  /* deteced a counter.rxx */
end
else do
  call make_def_dirs 0
  useoo=result
end /* do */


/*** NOt currently needed 
if useoo<>'' then do    
  call read_initfilt_dirs useoo
end
****/

/* -- Done with directory creation -- copy files ... */

/* but first, backup? */
if gmaking=1 then signal oy1   /* if totally new, no need to archive */

  say " "
 if install_new=1 then  call lineout, re_wh "Are you re-installing SRE-http?  " normal
 foo=yesno(normal"     "re_wh"Would you like to archive the various configuration files")
 if foo=1 then do
      say  " Where should SRE-http archive these files"
      aa="\BK"||space(translate(date('o'),' ','/\'),0)
      backup_dir=get_dir(workdir||aa)

/* files to backup*/
      in_workdir=' SREFILTR.80 RENLOGS.CMD LOGFAIL.HTM MAXFAIL.HTM ACCFAIL.HTM INIT_STA.80 INITFILT.80 MEDIATYP.RXX USERCHK.RXX '
      in_workdir=in_workdir||'PREFILTR.80 POSTFILT.80 POSTRCRD.80 POSTMAIL.80 PMPRINTF.RXX SREFMON.CMD '
      in_sdatadir='ALL_FILE.CTL ALIASES.IN VIRTUAL.IN USERS.IN SENDFILE.CNT RECRDALL.CNT  PUBURLS.IN '
      in_sdatadir=in_sdatadir||'COUNTER.CNT SREFLOGS.INI REPSTRGS.IN  HITMETER.CNT'
      in_cfgsdir='INIT_STA.80 INITFILT.80 SCHEDULE.CFG ACCESS.IN ALL_FILE.CTL ALIASES.IN VIRTUAL.IN USERS.IN  SREFLOGS.INI REPSTRGS.IN PUBURLS.IN CFGLIST.CFG ATTRIBS.CFG'
      in_mboxdir='ANYONE.LOG '
      in_adddir='COUNTER.RXX BYBROWSR.RXX '
      in_datadir='INDEX.HTML INDEX.HTM INDEX.SHTML INDEX.SHT DYNPWD.HTM '
      call dobackup
      say bold' Note:'normal" you might be asked to backup a few other files  "
      say "       (for storage in their 'own' directory)"
      yooba=sysfiletree(workdir||'\BK*','goos','OD')
      if goos.0>1  then do
          say bold' Reminder:'normal' you have 'goos.0 ' SRE archive directories; you might want to '
          say '          remove some of the older ones. '
      end /* do */
 end
 else do
    say " "
 end  /* Do */


oy1:                    /* skip here if new directory ! */
foo=yesno(" SRE-http will now be installed. Are you ready? ")
if foo=0 then do
  say " Try again later ??? "
  exit
end

say " "
say " Copying dynamic link libraries and helper executables .. "
if gotrxlib=1 then do
   say " Note: a copy of REXXLIB seems to be on your system "
end  /* Do */
foo=check_copy('REXXLIB.DLL',workdir)
if dropunz=0 then do
   say " Note: a copy of UNZIPAPI seems to be on your system "
end  /* Do */
foo=check_copy('UNZIPAPI.DLL',workdir)
say " "
foo=check_copy('FILEREXX.DLL',workdir)
foo=check_copy('SRXFUNC.DLL',workdir)

foo=check_copy('GZIP.EXE',workdir)
foo=check_copy('MD5.EXE',workdir)

say " "


say " Copying  SRE-http main and misc. program files files to " workdir


foo=check_copy('*.80' ,workdir,,1)  
foo=check_copy('SREFMON.CMD' ,workdir,,1)
foo=check_copy('SREINIT1.CMD' ,workdir,,1)
foo=check_copy('PREREP.CMD' ,workdir,,1)
foo=check_copy('DE_SREA.CMD' ,workdir,,1)
foo=check_copy('DE_SREBF.CMD' ,workdir,,1)
foo=check_copy('SREDOMD5.CMD' ,workdir,,1)
foo=check_copy('NEGOT.CMD' ,workdir,,1)

goo=cfgsdir||'\init_sta.80'
issta=STREAM(goo,'c','query exists')
if issta='' & install_new=0 then do
    say " INIT_STA.80  is new to sre-http (as of 20 March 1999)  "
    say " -- it contains "bold"static-parameters"normal" that used to be set in  SREFILTR.80"
    say " ... copying INIT_STA.80 to "cfgsdir
    foo=check_copy('INIT_STA.A80' ,goo,,1)
end /* do */
else do
   if install_new=1 then do
       foo=check_copy('INIT_STA.A80' ,goo,' This is your "static parameters file". Are you sure? ')
   end
end

foo=check_copy('DO*.CMD' ,workdir,,1)
foo=check_copy('FREEUP.CMD' ,workdir,,1)
foo=check_copy('STATUS.CMD' ,addon_dir,,1)
foo=check_copy('TRYMAX.CMD' ,addon_dir,,1)

foo=check_copy('BROWSERS.CMD' ,addon_dir,,1)
foo=check_copy('CONFIG2.CMD' ,addon_dir,,1)
foo=check_copy('TSTDIGIT.CMD' ,addon_dir,,1)
foo=check_copy('ENC_TEST.CMD' ,addon_dir,,1)
foo=check_copy('CONFCOLR.CMD' ,addon_dir,,1)
foo=check_copy('SREFCONF.CMD' ,addon_dir,,1)
foo=check_copy('ADV_OPTS.CMD' ,workdir,,1)
foo=check_copy('EDITSREF.CMD' ,workdir,,1)
foo=check_copy('EDITINIT.CMD' ,workdir,,1)

foo=check_copy('USERCFG.CMD',addon_dir,,1)
foo=check_copy('ALIASCFG.CMD',addon_dir,,1)
foo=check_copy('REALMCFG.CMD',addon_dir,,1)
foo=check_copy('ACCESCFG.CMD',addon_dir,,1)
foo=check_copy('HTACCFG.CMD',addon_dir,,1)
foo=check_copy('VIRTCFG.CMD',addon_dir,,1)

foo=check_copy('TESTVALU.CMD',addon_dir,,1)
foo=check_copy('CHECKSEL.CMD',addon_dir,,1)
if install_new=1 then do
   foo=check_copy('LOGFAIL.HT0' ,workdir||'\LOGFAIL.HTM',' This is your "logon failure response file". Are you sure? ')
   foo=check_copy('ACCFAIL.HT0' ,workdir||'\ACCFAIL.HTM',' This is your "access failure  response file". Are you sure?')
   foo=check_copy('MAXFAIL.HT0' ,workdir||'\MAXFAIL.HTM',' This is your "MAXUSER failure response file". Are you sure? ')
   foo=check_copy('DYNPWD.RSP',datadir,,'This is your "dynamic passwords" response file. Are you sure?')
   foo=check_copy('ENC_SREB.RSP',datadir,,'This is your "SRE_B encryption" response file. Are you sure?')
   foo=check_copy('ENC_FORM.RSP',datadir,,'This is your "encrypted_FORMS" response file. Are you sure?')
end


say " "
say " Installing simple SRE-http configurator (CONFIG0.HTM) "
foo=check_copy('CONFIGUR.HT0',datadir||'\CONFIGUR.HTM',,1)
foo=check_copy('CONFIG0.HT0',datadir||'\CONFIG0.HTM',,1)
foo=check_copy('CONFIG2a.HT0',datadir||'\CONFIG2a.HTM',,1)
foo=check_copy('CONFIG2b.HT0',datadir||'\CONFIG2b.HTM',,1)
foo=check_copy('CONFIG3.HT0',datadir||'\CONFIG3.HTM',,1)
foo=check_copy('CONFCOLR.HTM' ,datadir,,1)

foo=check_copy('DE_SREA.CMD' ,datadir,,1)
foo=check_copy('DE_SREBF.CMD' ,datadir,,1)


if install_new=1 then do
 foo=check_copy('BYBROWSR.RX0',addon_dir||'\BYBROWSR.RXX',,1)
end

if install_counter=1 then do
    say " Copying COUNTER.RXX to "addon_dir
   foo=check_copy('COUNTER.RX0',addon_dir||'\COUNTER.RXX',,1) 
end /* do */


foo=check_copy('MTCHFILE.RX0',addon_dir||'\MTCFHILE.RXX',,1)

foo=check_copy('ADDPRIVS.RX0',addon_dir||'\ADDPRIVS.RXX',,1)


foo=check_copy('USETABL2.RX0',addon_dir||'\USETABL2.RXX',,1)
foo=check_copy('DIRINFO.RX0',addon_dir||'\DIRINFO.RXX',,1)
foo=check_copy('SAMPCOOK.RX0',addon_dir||'\SAMPCOOK.RXX',,1)


foo=check_copy('*.RXX',workdir,,1)

if install_new=1 then do
   say " "
   say " Copying  user configurable parameter files to " cfgsdir

   foo=check_copy('CFGLIST.CFG', cfgsdir,' *** This contains HOST configuration information: Are you sure?')
   foo=check_copy('ATTRIBS.CFG', cfgsdir,' *** This contains selector-specific options: Are you sure?')

   foo=check_copy('*.IN', cfgsdir,' *** THESE ARE PARAMETER & CONFIGURATION FILES : Are you sure?')

   say " "

   say " Copying common-log-audit-file configuration file, to " cfgsdir
   foo=check_copy('SREFLOGS.INI', cfgsdir,' *** This is the common-log configuration file: Are you sure?')
   foo=check_copy('SCHEDULE.CFG', cfgsdir,' *** This is the scheduled-events configuration file: Are you sure?')

   say " "
   say " Copying  audit files and advanced options files to " sdatadir

   foo1=check_COPY('ADV_OPTS.CTL',sdatadir,,1)
   foo1=check_COPY('FAQ.CTL',sdatadir,,1)
   foo1=check_COPY('*.SEC',sdatadir,,1)

   say ' '

   say " Copying  log-file-archiving program to " workdir
   foo=check_copy('RENLOGS.CMD', workdir,' *** This is the log-file archiver: Are you sure?')


   foo=check_COPY('*.CNT', sdatadir,' These are your "hit-counter" files: Are you sure?')

   say " "
   say " Copying sample message box file to " mboxdir
   foo=check_COPY('ANYONE.LOG', mboxdir,' This is your default "message box": Are you sure?')
   say " "
end

/* if no .cfg files in cfgsdir, copy them there */
if stream(cfgsdir'\SCHEDULE.CFG','c','query exists')='' then
  foo=check_copy('SCHEDULE.CFG',cfgsdir,,1)

if stream(cfgsdir'\CFGLIST.CFG','c','query exists')='' then
  foo=check_copy('CFGLIST.CFG',cfgsdir,,1)

if stream(cfgsdir'\ATTRIBS.CFG','c','query exists')='' then
  foo=check_copy('ATTRIBS.CFG',cfgsdir,,1)

say " Copying sample and help files to " helpdir
foo1=check_COPY('*.HTM',helpdir,,1)
foo1=check_COPY('*.SHT',helpdir,,1)
foo=checK_COPY('SAMPMAP.*',helpdir,,foo1)
foo=check_COPY('TESTTABL.TBL',HELPDIR,,foo1)
foo=check_COPY('TESTTABL.DEF',HELPDIR,,foo1)

foo=check_copy('INTERPET.IN0',sdatadir'\INTERPET.IN',,1)

foo=check_copy('*.IDX',sdatadir,,1)

say " Copying Sample CGI-Bin programs to " cgibin_dir
foo1=check_copy('*.PL',cgibin_dir,,1)
foo=check_copy('XCOUNT.CMD',cgibin_dir,,foo1)
foo=check_copy('JCOUNT.CMD',cgibin_dir,,foo1)
foo=check_copy('TEST-CGI.CMD',cgibin_dir,,foo1)

foo=check_COPY('*.DOC',helpdir,,foo1)
foo=check_COPY('HISTORY.TXT',helpdir,,foo1)

foo=check_COPY('*.FAQ',helpdir,,foo1)


say " "
SAY ' Copying GIF file archive to  ' gifdir
foo=check_COPY('GIFS.ZIP',gifdir,,1)

say " "
SAY ' Copying GIF-DIGITS file archive to  ' digitsdir
foo=check_COPY('DIGITS.ZIP',digitsdir,,1)


say " Copying simple mode configuration files to " config_dir
foo=check_COPY('CONFIGS.ZIP',config_dir,,1)

say " Copying library configuration files to " lib_dir
foo=check_COPY('SREFPRC.ZIP',lib_dir,,1)


if gotunz=0 then do
    say " "
    say bold " UZUNZIP.DLL could not be found " normal
    say "          * you will need to unzip GIFS.ZIP (in " gifdir
    say "          * you will need to unzip DIGITS.ZIP (in " digitsdir
    say '          * you will need to unzip CONFIGS.ZIP (in ' config_dir
    say '          * you will need to unzip SREFPRC.ZIP (in ' lib_dir
    call charout , cy_ye ' (hit any key to continue) ' normal
    foo=SYSGETKEY("NOECHO")
    signal nogotuz
end  /* Do */

meis=directory()

aa1=suzunzip(gifdir,'GIFS.ZIP')
aa2=suzunzip(digitsdir,'DIGITS.ZIP')
aa3=suzunzip(config_dir,'CONFIGS.ZIP')
aa4=suzunzip(lib_dir,'SREFPRC.ZIP')

meis=directory(meis)

if aa1*aa2*aa3*aa4=0 then do
     say " "
    say bold "WARNING: " normal
    say " A problem with the UNZIP dll has occurred (can not find UZUNZIP). "
    say " You can either: "
    say "    a) ^C, shutdown, and try again (that seems to work) "
    say "    b) Complete the installation, and then from an OS/2 prompt: "
    say "        i) UNZIP GIFS.ZIP (in " gifdir
    say "       ii) UNZIP DIGITS.ZIP (in " digitsdir
    say "      iii) UNZIP CONFIGS.ZIP (in " config_dir
    say "       iv) UNZIP fSREFPRC.ZIP (in " lib_dir

    say " I know this is a tedious solution, but it is a very flakey problem!"
    call charout , cy_ye ' (hit any key to continue) ' normal
    foo=sysgetkey("noecho")
end  /* Do */


nogotuz:  nop

IF install_new=0 then SIGNAL DONE1A

say " "
call lineout, cy_ye ' ------------ Configuration: ' normal
say " "

call get_ip_address

say " "
uu=set_params(0)

/* -- add entry to users.in file */
foo=add_user(cfgsdir)


/* --- customize index.htm  -- */
say " "
call lineout, cy_ye  " ... customizing files ... " normal
say " "
say ' Copying sample home page to ' datadir
thefh=grab_file("INDEX.HT0")
if thefh=0 then do
   Say " ERROR : Could not find sample home page "
   say "         You may need to unzip SRE-http  again? "
   signal done1
end
parse var helpdir foo (datadir) thesamp
thesamp=strip(translate(thesamp,'/','\'),,'/')
thefh=replacestrg(thefh,'helpdirectory',thesamp,'ALL')
dog=datadir||'\INDEX.SHT'

drop foo1
tmp=sysfiletree(dog,foo1,'F')
ok=1
if foo1.0>0 & copyall=0 then
  ok=yesno(" Overwrite "||dog"?")

if ok=1 then do
  if foo1.0>0 then do 
    toydog=dostempname(datadir||'\INDEX.???')
    foo=dosrename(dog,toydog)
    say bold " Note: "normal " just to be safe, your old INDEX.SHT has been moved to"
    say      "                " toydog
    call syssleep(2)
  end
  aa=stream(dog,'c','open write')
  if aa<>'READY:' then do
    say " ERROR: could not write " dog
    signal done1
  end
  foo=charout(dog,thefh)
  if foo>0 then do
     say " ERROR: Problem writing " dog
     signal done1
  end
  aa=stream(dog,'c','close')
  useindex='INDEX.SHT'
end
else do
   dog2=dostempname(datadir||'\SINDX???.HTM')
   foo=charout(dog2,thefh)
   if foo=0 then do
     say bold " Note: "normal " A sample SRE-http home page has been"
     say "    copied to " dog2
     say "It contains links to several useful configuration tools, "
     say " as well as links to SRE-http demos."
     call syssleep(2)
     useindex=filespec('n',dog2)
   end
end

/* --- customize mediatyp.rxx -- */
say " "
say ' Copying the user defined MIME type file (MEDIATYP.RXX) to ' workdir
thefh=grab_file("MEDIATYP.RX0")
if thefh=0 then do
   Say " ERROR : Could not find user-defined MEDIATYPE file"
   say "         You may need to unzip SRE-http  again? "
   signal done1
end
dog=workdir||'\MEDIATYP.RXX'

drop foo1
tmp=sysfiletree(dog,foo1,'F')
ok=1
if foo1.0>0 & copyall=0 then do
  say " Overwrite " dog " -- your customized MIME types list? "
  ok=yesno(" Overwrite "||dog"?")
end
if ok=1 then do
  foo=sysfiledelete(dog)          /* delete any prior version */
  aa=stream(dog,'c','open write')
  if aa<>'READY:' then do
    say " ERROR: could not write " dog
    signal done1
  end
  foo=charout(dog,thefh)
  if foo>0 then do
     say " ERROR: Problem writing " dog
     signal done1
  end
  aa=stream(dog,'c','close')
end




/*-- Modifying the INITFILT.80 file -- */

say " "

say " Modifying the INITFILT.80 parameters file "
thefh=grab_file("INITFILT.A80")
if thefh=0 then do
   Say " ERROR : Could not find  INITFILT.A80 parameters file. "
   say "         You may need to unzip SRE-http  again? "
   signal done1
end

thefh=replacestrg(thefh,'workingdirectory',workdir,'ALL')
thefh=replacestrg(thefh,'workingdir',workdir,'ALL')

thefh=replacestrg(thefh,'cfgsdirectory',cfgsdir,'ALL')

thefh=replacestrg(thefh,'messageboxdir',mboxdir,'ALL')

thefh=replacestrg(thefh,'mailboxdir',mailboxdir,'ALL')

thefh=replacestrg(thefh,'workingdatadir',sdatadir,'ALL')
thefh=replacestrg(thefh,'temporarydir',tempdir,'ALL')
thefh=replacestrg(thefh,'tempdatadir',tempdatadir,'ALL')
thefh=replacestrg(thefh,'userinfodir',userinfodir,'ALL')

thefh=replacestrg(thefh,'owneraddress',ipaddr,'ALL')
thefh=replacestrg(thefh,'uploaddir',upload_dir,'ALL')
thefh=replacestrg(thefh,'cgibindirectory',cgibin_dir,'ALL')
thefh=replacestrg(thefh,'addondirectory',addon_dir,'ALL')



thefh=replacestrg(thefh,'configuredir',config_dir,'ALL')


/* Set some  "common parameters" */
thefh=replacestrg(thefh,'aautoname',aautoname,'ALL')
thefh=replacestrg(thefh,'adefault',adefault,'ALL')
thefh=replacestrg(thefh,'assishtml',assi,'ALL')
thefh=replacestrg(thefh,'ahomename',ahomename,'ALL')
thefh=replacestrg(thefh,'arealm',arealm,'ALL')
thefh=replacestrg(thefh,'awebmaster',awebmaster,'ALL')
thefh=replacestrg(thefh,'assicache',assicache,'ALL')
thefh=replacestrg(thefh,'ahomedir',ahomedir,'ALL')

dog=cfgsdir||'\INITFILT.80'
initfilt_File=dog
drop foo1
tmp=sysfiletree(dog,foo1,'F')
ok=1
if foo1.0>0  & copyall=0 then do
  ok=yesno(" Overwrite "||dog"?")
  if ok=1 then do
      say dog " is your SRE-http configuration file... "
      ok=yesno(normal"       "re_wh" are you sure you want to overwrite it?")
  end
end

if ok=1 then do
  isadog=stream(dog,'c','query exists')
  if isadog<>'' then do
     dog2=dostempname(cfgsdir||'\INITFILT.B??')
     foo=dosrename(dog,dog2)
     say bold "Note: " normal " The old INITFILT.80 file has been moved to: "
     say      "          " dog2
     foo=sysfiledelete(dog)          /* delete any prior version */
  end
  aa=stream(dog,'c','open write')
  if aa<>'READY:' then do
     say " ERROR: could not write " dog
     signal done1
  end
  foo=charout(dog,thefh)
  if foo>0 then do
     say " ERROR: Problem writing " dog
     signal done1
  end
  aa=stream(dog,'c','close')
end


done1: nop

call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")

done1A: nop

a=scrclear()

call lineout, bold cy_ye  " SRE-http has been installed... " normal
say " "
say ' Your web site is now ready to be built!  '
say '      (just add documents, images, links, etc...)'
say ' '
say ' Notes:'
say '    * 'useindex ', the sample SRE-http home page, contains a number of '
say '      useful links to configuration tools, demos, and on-line documentation.'
say "      It's located in your GoServe data directory ("datadir")"
say '    * If you use a  different File name as your "home page",'
say "      be sure to change SRE-http's " bold "DEFAULT " normal " initialization parameter."
if issta='' then do
  say "    * SREFILTR.80 no longer contains parameters: please edit INIT_STA.80 "
end 
signal on syntax name gogo
signal on error name gogo
gonotes:
say " "
say bold " Would you like to read some additional configuration hints? "normal
say " "bold"1"normal") Setting up GoServe "
say " "bold"2"normal") Configuring SRE-http "
say " "bold"3"normal") Finding Help on SRE-http "
say " "bold"4"normal") A note on ports "
say " "bold"5"normal") A note on SRE-http addons "
say " "bold"6"normal") Notes for Upgraders  -- "bold"and an INITFILT.80 comparator!" normal
say " "bold"7"normal") Cleaning up and removing SRE-http "
say " "bold"8"normal") Viewing SRE-http status-information and error-log"
say " "bold"9"normal") Run the "cyanon" INIT_STA.80 "normal" or "cyanon" INITFILT.80"normal" editor. "
say " "bold"X"normal") Exit installation program ."
gonotes2:
call charout, reverse " Select an option from the above: " normal
pull anopt

select
   when  anopt="1" then signal note1
   when  anopt="2" then signal note2
   when  anopt="3" then signal note3
   when  anopt="4" then signal note4
   when  anopt="5" then signal note5
   when  anopt="6" then signal note6
   when  anopt="7" then signal note7
   when  anopt="8" then signal note8
   when  anopt="9" then signal note9


   when  anopt="X" then do
      if dropunz=1 then foo=zdropfunc()
      if droprxlib=1 then foo=rexxlibderegister()
      say " bye .. "
      exit
   end
   otherwise
        signal gonotes2
end  /* select */

gogo:
signal  off syntax


exit

note1: nop
say cy_ye " -----  Configuring GoServe:" normal
say "                 **  "bold "  Are you using GoServe 2.52? "normal " **"
say       " If not, you'll need to download it from http://www2.hursley.ibm.com/goserve"
say "" 
say " 1) Instruct GoServe that SREFILTR.80 is the working filter. To do this: "
say '     enter ' bold 'http filter srefiltr.80' normal ' in the'
say "  " bold " optional parameters line " normal " in GoServe's settings window,"
say "     (right-mouse click on the GoServe icon ...) "
say " 2) Make sure that GoServe knows your data directory "
say "     (use the OPTIONS-DataDir tab in the GoServe status window) "
say " 3) Set a few GoServe limits: "
say    " *  You must set the Options-Limit-Connection_maintain to some positive" 
say    "    number (say, 15)." 
say " 4)  You must have a properly defined TZ variable in your OS/2 CONFIG.SYS file"
say "     (TZ is used to set the time zone relative to Greenwich Mean Time)."
say " " 
say    " Advanced Users Note:"
say    "    If you are willing to sacrfice full compliance with http/1.1, you"  
say    "    can force SRE-http to ignore some of these prerequisites by" 
say    "    setting the CHECK_COMPLIANCE parameter in SREFMON.CMD. "



call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho") 
a= scrclear()
signal gonotes 




note2:
say cy_ye " -----  Configuring SRE-http:" normal

if thishost="" then thishost=get_hostname()
say ' To further configure SRE-http, you can run CONFIGUR.HTM '
say " (actually, you should probably read the documentation first!) "
say "  "
say " To do this: "
say "   a) Fire up your favorite web browser"
say '   b) Point it a http://'thishost'/CONFIGUR.HTM'
say '      (Note: you can also use /CONFIGURE, which is "aliased" to CONFIGUR.HTM)'
say '   c) You can then choose one of three configuration modes:'
say '      i) Simple mode: A well-documented, form based tool for modifying '
say '         the more important SRE-http parameters'
say '     ii) Intermediate mode: A less well-documented, but more powerful, '
say '         form based tool for modifying almost all of the parameters '
say '    iii) Expert mode: Edit the various text files containing the parameters'
say 'Notes: '
say '   * 'bold'parameters'normal' include: usernames, redirection aliases,'
say '     SEL-specific access controls, virtual directories, and HTACCESS files.'
say '   * the EDITSREF.CMD utility can be used to edit parameters contained '
say '     in SREFILTR.80'
say '   * It is a good idea to copy the .DLL (REXXLIB, UNZIPAPI, and FILEREXX) '
foo=value('system_ini',,'os2environment')
goo=filespec('d',foo)||filespec('p',foo)||'DLL'
say '     files to somewhere in your LIBPATH (i.e.; ' GOO ')'
say " "
call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")

say bold " A Note on Security: " normal
say "   SRE-http checks for SUPERUSER privileges before allowing access to "
say "   the configurator.  Note that the OWNER address (that you entered at the  "
say "   beginning of this installation), and the user you (may) have added"
say "   are both granted SUPERUSER status. "
say " "
say "  If you are "bold"very security conscious"normal", you can limit "
say "  configuration to requests issued from the server itself "
say '  by modifying the NO_REMOTE_CONFIGURE parameter in INIT_STA.80 '
say "  If you are " reverse "EXTREMELY " normal "cautious, you can use NO_REMOTE_CONFIGURE to "
say "  "bold"totally disable " normal " remote configuration (in which case, modification"
say "  of SRE-http parameters requires editing of ascii configuration files)"
say  ""
call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")
a= scrclear()
signal gonotes



note3:
say cy_ye " -----  Finding Help on SRE-http:" normal
say ' SRE-http comes with numerous help documents (you can find them '
say ' in ' helpdir ')'
say ' '
say ' The following are the more important help documents: '
say '   * INTRO.DOC    -- a 1 page description of SRE-http'
say '   * GUIDE.HTM    -- the Users Guide  ' bold ' -- A good place to start ' normal
say '   * SREHTTP.HTM -- the SRE-http manual'
say '   * SREHTTP.FAQ -- some frequently asked questions '
say "   * INITFILT.DOC -- a detailed description of SRE-http's initialization"
say '                     parameters, with possible choices described for each. '
say '   * HISTORY.TXT  -- history of changes '
say '   * IN_FILES.DOC -- description of selector-specific attributes files.'
say '   * OUTLINE.HTM  -- a technical outline of how SRE-http processes a request'
say '   * HELPLIST.HTM  -- a list of the SRE-http help documents. '
say "   * ENCRYPT.DOC   -- a discussion of SRE-http's encryption facility "
say ' '
say " Hint: the users guide is a good place to start (there's a link to it"
say '       on the SRE-http sample home page) '
say " For tough problems, you can contact DANIELH@ECON.AG.GOV "
say " "
call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")
a= scrclear()
signal gonotes

note4:
say cy_ye " -----  A Note on Ports:" normal
say '  If you can not use port 80, all you need to do is '
say '  change all the *.80 files (to *.new_port_number) -- see the '
say '  documentation for details '
call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")
a= scrclear()
signal gonotes

note5:
say cy_ye " -----  A Note on SRE-http addons:" normal
say ' SRE-http has a number of addons avaiable. You can download them '
say ' from the SRE-http home page at http://www.srehttp.org  '
say ' For example, you may be interested in: '
say '   'bold'GoSwish:'normal' A directory-indexer/search-engine '
say '   'bold'FORUM:'normal' A  "news-group and list-server" discussion-group package '
say '   'bold'BBS:'normal' A full featured "web based bulletin board system" '
say '   'bold'GETAFILE:'normal' A  directory displayer, with user-settable display features'
say '   'bold'CALC:'normal' A character-mode scientific calculator with a web interface '
say '   'bold'CUSTOMIZ:'normal' Client customization tools (for the personal touch) '
say ' '
call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")
a= scrclear()
signal gonotes


/* */

note6: nop
say cy_ye " -----  Notes for Upgraders:" normal
say " A few of the recent changes included in ver 1.3g:"
say ''
say ' Support for hit-meter trees '
say ' Improved support for Transparent Content Negotiation'
say ' Support for XSSI "apache-style" server side includes '
say ' Many changes to the configurator '
say ' ATTRIBS.CFG can be used to define REALMS (instead of using the .IN files)'
say ' SRE-http can now encrypt responses (using a proprietary, non-SSL, algorithim)'
say ' The default subdirectory for initializations file is CFGS\ (instead of DATA\)'
say ' Host & port specific configuration info can be specified in CFGLIST.CFG'
say'  SCHEDULE.CFG can be used to specify scheduled events'
say ' Static-parameters are no longer set in SREFILTR.80; use INIT_STA.80 instead '
say ' "Secret-privileges" can now be defined (i.e.; for use in secondary logons) '
say ' A "pre-reply" hook is now available (PREREPLY.DOC)'
say ' A find-filename-matches variant of a 404 response is available (MTCHFILE.DOC)'
say ' sreLite (a smaller/quicker) version of SRE-http is now available'
say " SRE-http 1.3g is  http/1.1 compliant"
say " SRE-http 1.3g is  Y2K compliant"
say " "
say bold">>> The new home page for SRE-http is www.srehttp.org <<<"normal ' (38.152.44.14)'
SAY " "
IF YESNO(normal||'HISTORY.TXT documents the latest changes to SRE-http.'||bold||' View it?')=1 then do
    say " Okay, viewing the history of changes ... "
     '@START  "The SRE-http history of changesl" /C /F /WIN E HISTORY.TXT'
end
say ' '

say  cy_ye" Moving files to the CFG\ subdirectory "normal
say ""
say " As of SRE-http version 1.3d, the recommended subdirectory for "
say " configuration files is CFGS\ (the CFGS\ subdirectory of "GODIR')'
say
say " We also recommend using the host & port specific configuration files"
say " (as specified in CFGLIST.CFG) instead of using host-specific entries "
say " in a configuration file (such as INITFILT.80, ALIASES.IN and USERS.IN)"
SAY
say  " Alternatively, you should consider using the combined selector-specific-"
say  " options file (ATTRIBS.CFG) instead of the various .IN files"
say
say '  Please see: '
say "     * USE_CFGS.DOC for details on using CFGLIST.CFG, "
say "     * IN_FILES.DOC for info on using ATTRIBS.CFG  "
say
say
IF YESNO(normal||'    '||bold||"Would you like to view USE_CFGS.DOC")=1 then do
    say " Okay, viewing the history of changes ... "
     '@START  "The SRE-http history of changesl" /C /F /WIN E USE_CFGS.DOC'
end
say
IF YESNO(normal||'    '||bold||"Would you like to view IN_FILES.DOC")=1 then do
    say " Okay, viewing the history of changes ... "
     '@START  "The SRE-http history of changesl" /C /F /WIN E IN_FILES.DOC'
end

say ''



say " "
say " "
say  cy_ye ' Scan your initialization file? ' normal
say " If you did "bold"not"normal" update the INITFILT.80 file, there may be parameters "
say " that you'll need to add (or remove) by hand. "
say " To facilitate this process, you can search for all required parameters "
say " that are missing from the "bold"currently active initialization file"normal
say " It will also find incorrect (and obsolete) parameters."
say " "

say " Note: the "bold"currently active initialization file"normal" is: " 
say "                  " initfilt_file
say " "
ok=yesno(" Would you like to view these differences?")

if ok=1 then do
  a=sref_fileread('initfilt.a80',newl,,'E')
  if newl.0=0 | A<0 then do
    say "ERROR: Default INITFILT.80 file not found (error code= "a
    exit
  end
  IF A=" " then DO
       SAy " Error in FILEREAD procedure (are you using REXXFILE.DLL ?)"
       exit
  end  /* Do */
  else
  n1=0
  do nn=1 to newl.0
    aline=strip(newl.nn)
    if aline=' ' | abbrev(aline,';')=1 then iterate
    n1=n1+1
    parse var aline  atmp '=' news.n1.!stuff
    parse upper var atmp news.n1 '.' . ; news.n1=strip(news.n1)
  end /* do */
  news.0=n1

  do forever
    aa=initfilt_file
    if aa<>' ' then  aa=stream(aa,'c','query exists')
    if aa<>' ' then leave
    say  bold 'Could not find the old INITFILT.80 file ('initfilt_file')' normal
    say " Please enter it's (fully qualified) name: "
    parse pull initfilt_file
  end

  a=sref_fileread(initfilt_file,oldl,,'E')
  n2=0
  do nn=1 to oldl.0
     aline=strip(oldl.nn)
     if aline=' ' | abbrev(aline,';')=1 then iterate
     n2=n2+1
     parse var aline  atmp '=' olds.n2.!stuff
     parse upper var atmp  olds.n2 '.' . ;olds.n2=strip(olds.n2)
  end /* do */
  olds.0=n2

  Say reverse " ----- " normal " Looking for required parameters: "

  do iu=1 to news.0
     lookfor=strip(news.iu)
     okay=0
     do iu2=1 to olds.0
      if olds.iu2=lookfor then  do
        iterate iu
      end
    end /* do */
/* if here, could not find */
    parse var news.iu.!stuff goob '/*' .


     thefh=replacestrg(goob,'messageboxdir',mboxdir,'ALL')
     thefh=replacestrg(thefh,'mailboxdir',mailboxdir,'ALL')
     thefh=replacestrg(thefh,'workingdatadir',sdatadir,'ALL')
     thefh=replacestrg(thefh,'temporarydir',tempdir,'ALL')
     thefh=replacestrg(thefh,'tempdatadir',tempdatadir,'ALL')
     thefh=replacestrg(thefh,'userinfodir',userinfodir,'ALL')

     thefh=replacestrg(thefh,'uploaddir',upload_dir,'ALL')
     thefh=replacestrg(thefh,'cgibindirectory',cgibin_dir,'ALL')
     thefh=replacestrg(thefh,'addondirectory',addon_dir,'ALL')

     thefh=replacestrg(thefh,'aautoname',aautoname,'ALL')
    thefh =replacestrg(thefh,'adefault',adefault,'ALL')
    thefh=replacestrg(thefh,'assishtml',assi,'ALL')
    thefh=replacestrg(thefh,'ahomename',ahomename,'ALL')
    thefh=replacestrg(thefh,'arealm',arealm,'ALL')
    thefh=replacestrg(thefh,'awebmaster',awebmaster,'ALL')
   thefh=replacestrg(thefh,'assicache',assicache,'ALL')
   thefh=replacestrg(thefh,'ahomedir',ahomedir,'ALL')

     goob=replacestrg(thefh,'configuredir',config_dir,'ALL')

    say '    Could not find ' lookfor '(recommended value= 'goob
  end /* do */

  call charout,  cy_ye ' (hit any key to continue) ' normal
  foo=sysgetkey("noecho")
  say " "

  say reverse " ------------- " normal " Looking for incorrect & obsolete parameters "
  do iu=1 to olds.0
    lookfor=strip(olds.iu)
    if abbrev(lookfor,'$')=1 then do
       parse var lookfor . lookfor ; lookfor=strip(lookfor)
    end
    okay=0
    do iu2=1 to news.0
       if news.iu2=lookfor then  do
         iterate iu
       end
    end /* do */
/* if here, could not find */
    parse var olds.iu.!stuff goob '/*' .
    say '    Unused variable: ' lookfor '= ' goob
  end /* do */
say reverse " ------------- "normal
say " "
call charout,'Hint: if the above contain any entries, you can...'
  call charout , cy_ye ' (any key to continue) ' normal
  foo=sysgetkey("noecho")
say
say cy_ye'*'normal'   i) open a text editor in another OS/2 window (keep this window open)'
say cy_ye'*'normal'  ii) edit ' initfilt_file 
say cy_ye'*'normal' iii) make the changes '
call charout,cy_ye'*'normal'  iv) reselect the 'reverse"notes and hints for upgraders"normal" option",
cy_ye'(any key to continue)'normal
foo=sysgetkey("noecho")
say " "

end


a= scrclear()
signal gonotes



/* */

note7: nop
say cy_ye " -----  Cleaning up and Removing SRE-http:" normal
say " After you have finished installing SRE-http, you can delete the contents"
say " of the temporary directory ("nowdir"). "
say bold " *** "normal" You may be told that "bold"a process is locked .."normal
say " This refers to the DLL's used in the install process. At your convenience, "
say " you should  reboot, and then delete, to complete this cleanup process "
say " (sorry, but I don't want to bother using OS/2 locked files facility)"
say " "
say " To remove SRE-http, just delete the contents of:"
say "    " bold "*" normal " the GoServe working directory:"  reverse workdir normal
say "      before you do this, you may first want to back up the GOSERVE.* "
say "      (and MAKEICON.CMD) files in the " reverse workdir normal
say " and you may want to clean up the:"
say "    " bold "*" normal "  GoServe data directory:" reverse datadir normal


call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")
say " "

a= scrclear()
signal gonotes

note8: nop
say cy_ye " -----  SRE-http Status Information" normal
say " If you want to keep an eye on what's happening on your web-server "
say " we recommend obtaining the PMPRINTF facility. You can download it from:"
say "     http://www2.hursley.ibm.com/goserve/pmprtf.zip"
say " PMPRINTF will open a window within which status information will be shown, "
say " with optional save-to-file features."
say " "
say " We especially recommend the use of PMPRINTF if you intend to "
say " monkey with the innards of SRE-http, or if you take a crack at writing "
say " your own addons -- it's really the only way to find out where the bugs are! "
say " "
say " You can also set SRE-http's VERBOSE variable to set the amount of "
say " information SRE-http displays (0 means very little, 4 means too much)."
say " "
say " We also recommend examining the ERROR.LOG file (in the DATA subdirectory)."
say " SRE-http will write warnings and errors to this file. "
say " "
say " GOSERVE's AUDIT facility also contains useful (if somewhat arcane) information  "
say " (see GOSERVE.DOC for details on how to configure the AUDIT facility)."
say " "


call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")
say " "

a= scrclear()
signal gonotes


note9: nop
say 
say cy_ye " -----  The INITFILT.80 and INIT_STA.80 editors" normal
say " INITFILT.80 and INIT_STA.80 contain a number of configuration parameters."
say "    > INITFILT.80  contains dynamic-parameters."
say "      It is designed to be modified by the on-line configurator. "
say "      As a rule, it contains parameters that are more likely to be "
say "      changed by a typical server administrator."
say "    >  INIT_STA.80 contains static-parameters (that used to be set in "
say "       SREFILTR.80).It contains more advanced parameters; in many cases  "
say "       the default values need never be changed. "
say 
say "  Although you can edit these files with a text editor, you can also use two "
say "  special parameter-editor utilities."
say "  Would you like to: "
say "     1) Run the INIT_STA.80 editor (EDITSREF.CMD)"
say "        Note: you can use EDITSREF.CMD to edit COUNTER.RXX; just enter "
say "        "addon_dir"\COUNTER.RXX when asked for a filename."
say "     2) Run the INITFILT.80 editor (EDITINIT.CMD)"
call charout, reverse " Select 1  or 2: " normal
pull whiched


if whiched=1 then do
   if workdir_Notset=1 then  do
      say  ' '
        say " What is the GoServe working directory (where SREFILTR.80 is instalelled)"
        parse pull workdir
   end
   aa=directory(workdir)
   foo=EDITSREF('noexit ')
    foo=directory(nowdir)

end /* do */
if whiched=2 then do 
   if workdir_Notset=1 then  do
        say ' '
        say " What is the GoServe working directory (where SREFILTR.80 is instalelled)"
        parse pull workdir
   end
    aa=directory(workdir)
    foo=EDITINIT('noexit')
    foo=directory(nowdir)
end /* do */




/*call charout , cy_ye ' (hit any key to continue) ' normal
foo=sysgetkey("noecho")*/
say " "

a= scrclear()
signal gonotes





exit



/********/
/* copy files to backup directory  */
dobackup:

do mm=1 to words(in_workdir)
     a1=strip(word(in_workdir,mm))

     cto=backup_dir||'\'||a1
     cfrom=workdir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Archiving ' cfrom ' ... '
         'COPY 'cfrom ' ' cto ' > nul '
     end  /* Do */

end /* do */
do mm=1 to words(in_sdatadir)
     a1=strip(word(in_sdatadir,mm))
     cto=backup_dir||'\'||a1
     cfrom=sdatadir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Archiving ' cfrom ' ... '
         'COPY 'cfrom ' ' cto  ' > nul '
     end
end /* do */

do mm=1 to words(in_cfgsdir)
     a1=strip(word(in_cfgsdir,mm))
     cto=backup_dir||'\'||a1
     cfrom=cfgsdir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Archiving ' cfrom ' ... '
         'COPY 'cfrom ' ' cto  ' > nul '
     end
end /* do */

do mm=1 to words(in_mboxdir)
     a1=strip(word(in_mboxdir,mm))
     cto=backup_dir||'\'||a1
     cfrom=mboxdir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Archiving ' cfrom ' ... '
         'COPY 'cfrom ' ' cto  ' >nul'
     end  /* Do */
end

do mm=1 to words(in_datadir)
     a1=strip(word(in_datadir,mm))
     cto=backup_dir||'\'||a1
     cfrom=datadir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Copying ' cfrom ' ... '
         'COPY 'cfrom ' ' cto  ' > nul '
     end
end /* do */

do mm=1 to words(in_adddir)
     a1=strip(word(in_adddir,mm))
     cto=backup_dir||'\'||a1
     cfrom=addon_dir||'\'||a1
     if stream(cfrom,'c','query exists')<>"" then do
         call lineout,' Copying ' cfrom ' ... '
         'COPY 'cfrom ' ' cto  ' > nul '
     end
end /* do */



return 0




/*****************/
/* Add an entry to the users.in file */
add_user:procedure expose ipaddr expose reverse bold normal re_wh cy_ye aesc

parse arg sdatadir

say " "
say  bold " Add a SUPERUSER to the UserName database " normal
say " "
say " To facilitate remote configuration, we recommend that you add a "
say " user, with SUPERUSER privileges, to the SRE-http UserName database."

ok=yesno(normal'    're_wh' Would you like add a SUPERUSER ')
say " "
if ok=0 then do

    say ' Note: To run the SRE-http configurator, you will need to use a  '
    say '      browser on the computer with the OWNERS (' ipaddr ")IP address."
    return 0
end

bugs: nop
 call charout, bold " Enter a username: " normal
 uname=stringin(,23," ",80)
 say " "

 call charout, bold " Enter a password: " normal
 pwd=stringin(,23," ",80)
 say " "

 call charout, bold " Enter a shared-secret:      " normal
 epwd=stringin(,27," ",80)
 epwd=translate(epwd)
 say " "


if uname="" | pwd="" | epwd='' then do
    say " missing username or password: please reenter "
    signal bugs
end  /* Do */


/* read users.in, append uname pwd , write it*/
afile=strip(sdatadir,'t','\')||'\USERS.IN'
foo=sref_fileread(afile,inl,,'E')
oof=uname' 'pwd' SUPERUSER ?ENCRYPT:'||epwd
ii=inl.0+1
inl.ii=oof
inl.0=ii
foo=filewrite(afile,inl,'R')
if foo=0 then do
   say " Error: could not modify usernames database file: " afile
end
else do
   say "* If the configurator asks for a username & password, you can use"
   say bold uname normal " for the username, and " bold pwd normal " for the password "
   say "* When decrypting, you should use a shared-secret of: "epwd
end
return 1



/* ----------------------------------------------------------------------- */
/* HOST -- return the result of a HOST command  (a ping )                  */
/* ----------------------------------------------------------------------- */
/* This need not be in the main filter program                             */
/* It returns the GoServe command to send back the result                  */
  host: procedure
   parse arg eek
    do queued(); pull .; end                   /* flush */
    address cmd '@host' eek '| rxqueue'     /* execute the command */
    parse pull hostresult                      /* get result */
    return hostresult
/*
    crlf='0d0a'x
    return 'STRING host' arg(1)':'crlf crlf''hostresult
*/

/* -------------------- */
/* get a yes or no , return 1 if yes */
yesno0:procedure expose normal reverse bold
parse arg fooa , allopt
ayn='  '||bold||'Y'||normal||'es\'||bold||'N'||normal||'o'
if allopt=1 then
   ayn=ayn||'\'||bold||'A'||normal||'ll'
do forever
 foo1=normal||reverse||fooa||normal||ayn
 call charout,  foo1 normal ':'
 pull anans
 if abbrev(anans,'Y')=1 then return 1
 if abbrev(anans,'N')=1 then return 0
 if allopt=1 & abbrev(anans,'A')=1 then return 2

end

/* -------------------- */
/* get a yes or no , return 1 if yes */
yesno:procedure expose normal reverse bold
parse arg fooa , allopt,altans
if altans<>" " & words(altans)>1 then do
   w1=strip(word(altans,1))
   w2=strip(word(altans,2))
   a1=left(w1,1) ; a2=left(w2,1)
   a1a=substr(w1,2) ; a2a=substr(w2,2)
end
else do
    a1='Y' ; a1a='es'
    a2='N' ; a2a='o'
end  /* Do */
ayn='  '||bold||a1||normal||a1a||'\'||bold||a2||normal||a2a
if allopt=1 then  ayn=ayn||'\'||bold||'A'||normal||'ll'

do forever
 foo1=normal||reverse||fooa||normal||ayn
 call charout,  foo1 normal ':'
 pull anans
 if abbrev(anans,a1)=1 then return 1
 if abbrev(anans,a2)=1 then return 0
 if allopt=1 & abbrev(anans,'A')=1 then return 2
end


/* ------------------------ */
/* ask for directory name,use defname2 as default */
/* give user opportunity to create it */

get_dir:procedure expose normal reverse bold re_wh making
/* procedure expose reverse normal bold */
parse arg defname2 , mustsub
defname0=defname2

n2:
call charout ,  reverse ' <ENTER>=' defname2  normal ' ?'
pull godir

if godir=" " then godir=defname2
if godir="n.a." then signal n2


if mustsub<>"" then do    /* check 'must be subdirectory' option */
  if abbrev(godir,mustsub)=0 then do
     say " This directory MUST be under the " mustsub " directory! "
     say "  .. please re enter ! "
     signal n2
  end
end

godir=strip(godir,'t','\')
gdname=godir||"\*.*"


isme=directory()

isnew=directory(godir)
if isnew="" then do
   say "    Could not find  " godir
   if yesno(normal"        "re_wh"Would you like to create it")=1 then do
        making=1
        oo=sysmkdir2(godir)
        if oo=0  then
           say "      Directory created: " godir
        else do
           say "      Could not create " godir "(error = " oo
           if godir=defname2 then defname2= "n.a."
           signal n2
        end
   end
   else do
        say " please reenter directory name ... "
        if godir=defname2 then defname2= "n.a."
        signal n2
   end
end  /* Do */


isme=directory(isme)



return godir

/* ------------- */
sysmkdir2:procedure
parse arg adir

adir=strip(adir,'t','\')
ff=sysmkdir(adir)
if ff=0 then return ff

/* make the tree */
f2=adir'\'
dd=filespec('d',f2)
pp=filespec('p',f2)
if pp='\' | pp='' then return -1

pp2=strip(translate(pp,' ','\'))

do mm=1 to words(pp2)
   a1=subword(pp2,1,mm)
   a1=translate(a1,'\',' ')
   dd2=dd'\'a1
   hoo=sysmkdir(dd2)
   if hoo=0 then say ' ... creating: 'dd2  
end /* do */

return hoo


/* ------------- */
/* ----------------------------------------------------------------------- */
/* REPLACESTRG: In string astring, find first occurence substring target and
.   replace it with substring putme
.      if no target, return unchanged astring
.      if no putme, then remove target
.      if type=backward, then find/change LAST occurence
.      if type=all, find/change all occurences
.      if exactmatch=yes, then do not capitalize during search (exact match only */
/* ----------------------------------------------------------------------- */

replacestrg: procedure

exactmatch=0
backward=0 ; doall=0

parse arg astring ,  target   , putme , type , exactmatch

type = translate(type)
if type="BACKWARD" then backward="YES"
if type="ALL" then doall="YES"

iat=1
joelen=length(target)
joelen2=length(putme)

doagain:                /* here if doall=yes */
 if exactmatch="YES" then do
    if   backward="YES" then
        joe= lastpos(target,astring)
    else
        joe= pos(target,astring,iat)
 end
 else do
   if   backward="YES" then
        joe= lastpos(translate(target),translate(astring))
    else
        joe= pos(translate(target),translate(astring),iat)
 end
 if joe=0 then
         return astring

 astring=delstr(astring,joe,joelen)
 if putme<>' ' then
    astring=insert(putme,astring,joe-1)

 if doall="YES" then do
     iat=joe+joelen2
     signal doagain
 end
/* else, all done */
 return astring

/* ----------------------------------------------------------------------- */
/* GRAB_FILE read in a file, but first check to see if openable, and if
.   openable, open and read it.
.    Returns with the file, or with 0 if file not obtainable.
.    Note that file is closed before returning
.   in,
.    usage:   afile_string=grab_file(the_file,seconds_to_try_for)
*/
/* ----------------------------------------------------------------------- */


grab_file: procedure

parse arg afile

ause=stream(afile,'c','open read')
if ause<>"READY:" then
  return 0

ll=stream(afile,'c','query size')
goo=charin(afile,1,ll)

/* get rid of ending ctl-z */
if c2d(right(goo,1))=26 then
  goo=left(goo,length(goo)-1)

return goo


/*******************************************/
/* check for existence of file, then ask user to copy or not */
/* note that for X.* type copies, it only checks once
   (not for each file, but just for any one of them */
/********************************************/
check_copy: procedure expose copyall reverse bold normal re_wh
parse arg file1, dest1 , amess , noask

dest2=strip(dest1,'t','\')||'\'

filename=dest1
if pos('.',dest1)=0 then filename=dest2||file1


if copyall=1 then signal doit3

aa=sysfiletree(filename,isit,'F')
ok=1
if aa<>0 then do
   say " Warning: error when looking for pre-existing copy of: " filename
   ok=yesno(" Do you want to copy this file (or files) anyways? ")
   if ok=1 & amess<>""  then
      ok=yesno(amess)
end

if noask=1 then signal doit3

if isit.0>0 then do
  if pos('*',file1)=0 then do
      say " "
      say " A file exists with the name: " filename
      ok=yesno(" Do you want to overwrite this file? ",1)
      if ok=1 & amess<>""  then
           ok=yesno(amess)
  end
  else do
    say " "
      say " There is at least one file that matches: " filename
      say "  (this match may " bold " not " normal " be one of the files that will be copied!) "
      ok=yesno(" Do you want to copy these files? ",1)
      if ok=1 & amess<>""  then
           ok=yesno(amess)
  end  /* Do */

end

if ok=2 then do
  say " "
  say "SRE-http will overwrite all of it's configuration, etc. files. "
  copyall=yesno(normal"   ..."re_wh" Are you sure you want to do this?")
  if copyall=0 then
      ok=yesno(" Do you want to overwrite the current file (or files)? ")
end

if ok=0  then return 0

doit3:          /* jump here if copyall is on, or noask=1 */
'COPY ' file1 dest1 ' > NUL '

return 1




 /* ------------------------------------------------------------------ */
 /* function: Check if ANSI is activated                               */
 /*                                                                    */
 /* call:     CheckAnsi                                                */
 /*                                                                    */
 /* where:    -                                                        */
 /*                                                                    */
 /* returns:  1 - ANSI support detected                                */
 /*           0 - no ANSI support available                            */
 /*          -1 - error detecting ansi                                 */
 /*                                                                    */
 /* note:     Tested with the German and the US version of OS/2 3.0    */
 /*                                                                    */
 /*                                                                    */
 CheckAnsi: PROCEDURE
   thisRC = -1

   trace off
                         /* install a local error handler              */
   SIGNAL ON ERROR Name InitAnsiEnd

   "@ANSI 2>NUL | rxqueue 2>NUL"

   thisRC = 0

   do while queued() <> 0
     queueLine = lineIN( "QUEUE:" )
     if pos( " on.", queueLine ) <> 0 | ,                       /* USA */
        pos( " (ON).", queueLine ) <> 0 then                    /* GER */
       thisRC = 1
   end /* do while queued() <> 0 */

 InitAnsiEnd:
 signal off error
 RETURN thisRC




/* get the hostname (aa.bb.cc) for this machine */
get_hostname: procedure expose re_wh
    do queued(); pull .; end                   /* flush */
    address cmd '@hostname | rxqueue'

    parse pull hostname
    return hostname


set_params:procedure expose adefault aautoname awebmaster arealm ahomename assi ,
                CY_YE BOLD NORMAL REVERSE thishost assicache ahomedir re_wh

/* Set some  "common parameters" */
enterparams:
say " If you like, you can customize a few of the initialization parameters."
say " If you choose not to, default values will be used "
adefault='INDEX.SHTML INDEX.HTML INDEX.SHT INDEX.HTM '
aautoname=' *.HTML *.HTM  INDEX.HTML INDEX.HTM !CREATE '
awebmaster='The Webmaster '
parse var thishost  arealm '.' .
assi=0
ahomename='Our WWW site '
ahomedir='homedir/'
assicache='1'
ok=yesno(normal"   "re_wh'Would you like to customize a few initialization parameters')

if ok=1 then do
    say ' You will be asked to enter the values of several "initialization" parameters.'
    say ' You can edit the default values by using arrow keys, etc. '
   say ' '

   say bold "DEFAULT" normal " should be a (list of) HTML document to use as your site's Home Page. "
   say "    The " bold "DEFAULT" normal "is used when requests to the root directory "
   say "    of your server are recieved (that is, empty request selectors, "
   say "    as would be  generated by a URL of  http://xxx.yy.zzz/ )"
   thedef=adefault
    say reverse "DEFAULT? " normal
    adefault=stringin(,2,thedef,70)
    say " "
    say " "

   say bold "AUTO_NAME" normal " should contain a list of HTML documents that may be used as"
   say " the default document for a directory. These are used when requests to the "
   say " root of a" bold "directory" normal " are recieved. "
   say " For example: a URL of " bold " http://xxx.yy.zzz/books/classics/ " normal
   say "              would generate a request selector of: " bold "books/classics " normal
   say "              -- and SRE-http would use AUTO_NAME to determine which file "
   say "                 (in the books/classics/ subdirectory) to use. "
   thedef="INDEX.SHT INDEX.SHTML INDEX.HTM INDEX.HTML "
    say reverse "AUTO_NAME? " normal
    fooauto=stringin(,2,thedef,70)
    aautoname=fooauto
    say " "
    say " Before trying these files, SRE-http can look for  dirname.HTML (and .SHTML, "
    say " .HTM, and .SHT); where " bold "dirname" normal 'is the last subdirectory name '
    say "      For example, using the above example ( " bold " books/classics/" normal
    say "      SRE-http would first look for " bold "CLASSICS.HTML" normal "(& CLASSICS.SHTML, etc.)"
    if length(fooauto) < 30 then do
        say "    ("fooauto " would be tried only if CLASSICS.HTML (etc.)  "
        say "     did not exist)"
    end
    else do
        say "       ("fooauto
        say "        would be tried only if CLASSICS.HTML (etc.) did not exist)"
    end  /* Do */
    isdname=yesno(' Should SRE-http attempt this "directory name matching"?')
    if isdname=1 then aautoname="*.HTML *.SHTML *.HTM *.SHT "||aautoname
    say " Lastly, if none of the above work, SRE-http can display a list "
    say " of files and subdirectories. "
    isflist=yesno(' When all else fails, should SRE-http display a file listing?')
    if isflist=1 then aautoname=aautoname||' !CREATE '
    if isflist=1 then
        say " Note: by default, this file listing will NOT contain descriptions. "
    say ' '


    say  bold " WEBMASTER " normal " should contain the name (and address) of a contact person. "
    thedef=' <a href="mailto:webmaster@'thishost'">The WebMaster</a> '
    say reverse " WEBMASTER? " normal
    awebmaster=stringin(,2,thedef,80)
    awebmaster=replacestrg(awebmaster,"'","''",'ALL')

    say " ";say " "

    say bold " THE_REALM " normal "is used as your site's default " bold " realm. " normal
    say "       (the" bold "Realm" normal "is displayed when clients are asked to  "
    say "        enter a username and password). "
    parse var thishost thedef '.'
    say reverse " THE_REALM? " normal
    arealm=stringin(,2,thedef,40)
    arealm=replacestrg(arealm,"'","''",'ALL')

    say " "
    say " "

    say  bold " SSI_SHTML_ONLY " normal "is used to limit " bold " server side includes"
    say  normal  " to files that have " bold ' .SHTML ' normal "(or " bold " .SHT" normal ") extensions. "
    say  "      If SSI_SHTML_ONLY is not turned on, then all HTML document will "
    say  "      be checked for " bold "server side includes. " normal
    assi=yesno(' Only check .SHTML and .SHT files for server side includes? ')
    assi=word('NO YES',assi+1)
    say " "


    say  bold " SSI_CACHE_ON " normal "is used to enable the "bold"SSI-cache."normal
    say "The  "bold"SSI-cache"normal" is used to store pre-compiled versions of HTML documents "
    say "that contain server side includes (SSIs). When appropriate, "
    say "SRE-http will return these documents (perhaps with further modifications)."
    say  "    The use of the " bold"SSI-CACHE"normal" can significantly improve "
    say  "    response time. However, on very dynamic sites, there is a small "
    say  "    chance that an out-of-date document will be returned.  "
    assicache=yesno(' Enable the SSI-CACHE (YES), or disable it (NO)? ')
    assicache=word('NO YES',assicache+1)
    say " " ; say " "

    say   bold " HOME_NAME " normal " should contain the colloquial name of your site."
    say  bold "        HOME_NAME " normal "  is used in certain descriptive responses,  "
    say       "         such as when a client asks for a non-existent file. "
    thedef="Our WWW site "
    say reverse " HOME_NAME? " normal
    ahomename=stringin(,2,thedef,70)
    ahomename=replacestrg(ahomename,"'","''",'ALL')

    say " " ;    say " "

    say   bold " HOME_DIR " normal " should contain which subdirectory (of your Goserve "
    say   "  directory) to use  when resolving requests containing a ~ character. "
    say   '  For example, if ' bold ' HOME_DIR=students/personal/ ' normal
    say   '  then a request selector of ~gerry.htm' normal 'would be equivalent '
    say   '  to ' bold 'students/personal/gerry.htm ' normal
    thedef="HOMEDIR/ "
    say reverse " HOME_DIR " normal
    ahomedir=stringin(,2,thedef,40)
    say " "
    say " "

  say  cy_ye " You have chosen the following settings: " normal
  say  " " reverse "DEFAULT:" normal adefault
  say  " " reverse "AUTO_NAME:" normal fooauto

  select
   when isdname=1 & isflist=1 then
     say          "         (with dirname.HTML, etc. checking, and file-listing if all else fails)"
   when isdname=1 then
     say          "            (with dirname.HTML checking)"
   when isflist=1 then
     say          "            (with file-listing if none of these exists)"
   otherwise
     nop
  end
  say " " reverse "HOME_DIR:" normal ahomedir
  say " " reverse "WEBMASTER:" normal awebmaster
  say " " reverse "THE_REALM:" normal arealm
  say " " reverse "HOME_NAME:" normal ahomename
  say " " reverse "SSI_SHTML_ONLY:" normal  assi
  say " " reverse "SSI_CACHE_ON:" normal  assicache

  say " "
  foo=yesno(" Are these okay? ")
  if foo=0 then signal enterparams
end
return 0


/*************/
/* unzip stuff */
suzunzip:procedure
parse arg adir,azip

signal on error name foobar1
signal on syntax name foobar1
say " Unzipping " azip

hh=strip(adir,'t','\')
hh2=hh'\'azip

rc=uzunzip(' -q -o 'hh2 ' -d 'hh,foos)

return 1

foobar1:
signal off error ;signal off syntax
say "  >> could not use unzip procedure, trying UNZIP.EXE instead...."
/* if here, problem. try using unzip */
aa='UNZIP -q -o 'hh2 ' -d 'hh
address cmd aa

if rc<>0 then do
   say " Problem with UNZIP, error= " rc
   return 0
end /* do */

return 1


/******/
get_goserve_dir:
parse arg chk

say ' ' 
call lineout, bold  " What is GOSERVE's "working" directory? " normal
say "    *  The SRE-http program files will be written there. "
say "    *  This does "bold"not"normal"  have to be the directory that contains GOSERVE.EXE"

n1:
godir=get_dir(defname)

if godir=" " then godir=defname
if godir="n.a." then signal n1

godir=strip(godir,'t','\')
gsname=godir||"\GOSERVE.EXE"

call sysfiletree gsname,gname2,'F'
if gname2.0=0 then do
   say " Note: GOSERVE.EXE is not currently installed in "godir
end  /* Do */

if chk=0 then return ''         /* new install, no need to check for /cggs */

oo=stream(godir'\cfgs\initfilt.80','c','query exists')
if oo='' then do
   oo2=stream(godir'\initfilt.80','c','query exists')
end /* do */
select 
   when oo2='' & oo='' then do
       say 'Warning: could not find INITFILT.80 in 'Godir
       say bold' Are you sure this is the correct directory??' 
       exit
   end /* do */
   when oo='' then do
       say
       say "        "cy_ye' ------------ Recommendation:'normal
       say "   As of ver 1.3.0399e, we highly recommend moving all of your "
       say '   configuration files (including INITFILT.80) to 'godir'\cfgs'
       say bold' Please see the upgraders notes for more details! 'normal
       say "   ... hit any key to continue ";
       foo=SYSGETKEY("NOECHO")
   end /* do */
   otherwise nop
end

return ' '

/*** not currently used 
if useoo='' then return ''
say "    INSTALL can read file & dir info from: "useoo
aav=yesno(normal'   'bold' Use Defaults (D), or Read info from INITFILT.80 (R):',,'D R')
if aav=1 then return ''
return useoo
*****/



/**********/
get_www_dir:

say " "
call lineout, cy_ye" + + + + "normal BOLD " What is your data directory ?" normal
say  '    .. this is  the location of your "home page" document. '

datadir=get_dir(defname2)

return 0

/*********/
get_ip_address:
say "What is your IP address (it will be given OWNERS status)"
ipaddr=" "
thishost=get_hostname()
sagain:
call charout , BOLD "What is your IP address (ENTER="thishost "):? " normal
pull youraddr
if youraddr=' ' then youraddr=thishost

parse var youraddr t1 '.' .
isnum=0
if  datatype(t1)='NUM' then
  isnum=1
say " wait while that address is checked ... "
chk=host(youraddr)
if translate(word(chk,2))<>"IS" &  word(chk,2)<>"=" then do
    call lineout,re_wh " Unable to find  address: " youraddr normal
    say "    OWNER variable not assigned (but you can assign it later)"
    ipaddr=" "
end  /* Do */
else do
   if isnum then
     ipaddr=word(chk,1)
   else
     ipaddr=word(chk,3)

   say " Your IP address: " ipaddr
end
return 0

/***************/
init_it:

/* Load up advanced REXX functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

nowdir=directory()

initfilt_file=''
copyall=0
echo off


/* --- Load the tcp/ip function library, if necessary --- */
if RxFuncQuery("SockLoadFuncs")=1 then  do    /* not there */
  call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
  call SockLoadFuncs
end

thishost=' '


parse version  atype .
if atype<>"REXXSAA" then do
 say    " WARNING: SRE-http ver 1.3g is designed to work under Classic Rexx "
 say     " In particular, it does NOT work under Object Rexx. "
 say     " Other versions of REXX, such as Quercus's REXX, have not been tested."
 say " Note: You are using REXX version: " atype
 say " (hit ENTER to continue) "
  pull .
end  /* Do */


dropunz=0 ;
foo=rxfuncquery('UZLoadFuncs')   /* load UNZIP dll */
if foo=1 then do
  dropunz=1
  call RxFuncAdd 'UZLoadFuncs', 'UNZIPAPI', 'UZLoadFuncs'
  call UZLoadFuncs
end
foo=rxfuncquery('UZLoadFuncs')
gotunz=1
if foo=1 then do
    say " Can not find UNZIP procedure library: UNZIPAPI.DLL"
    say "  Did you download it? "
    say " (hit ENTER to continue)"
    parse pull gunk
    gotunz=0 ; dropunz=0
end  /* Do */

/*---- load the rexxlib library */
droprxlib=0 ; gotrxlib=1
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 droprxlib=1 ; gotrxlib=0
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
    say " Could not find the REXXLIB procedure library (REXXLIB.DLL). "
    say "  Did you download it? "
    exit
end  /* Do */

if rxfuncquery('sref_fileread')<>0 then do
  ik=rxfuncadd('sref_fileread','rexxlib','LIB_FILEREAD')
  if ik<>0 then call pmprintf_sref(' SRE-http Monitor: Warning: unable to register SREF_FILEREAD')
end

ansion=checkansi()
if ansion=1 then do
  aesc='1B'x
  cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
  normal=aesc||'[0;m'
  bold=aesc||'[1;m'
  re_wh=aesc||'[31;47;m'
  reverse=aesc||'[7;m'
end
else do
  say " Warning: Could not detect ANSI....  Install will look ugly ! "
  cy_ye="" ; normal="" ; bold="" ;re_wh="" ;
  reverse=""
end  /* Do */

/* some defaults */
    datadir="your GoServe Data-directory"
    workdir="your GoServe Working-directory"
   workdir_notset=1
    helpdir='the SAMPLES/ subdirectory of the GoServe Data-directory'
    useindex='  '


return 0


/*********/
check_macro:
if macroquery('SREF_VERSION')<>"" then do
     say " "
     say bold "A prior version of the SRE-http macrospace  procedures " normal " was detected."
     say " We recommend clearing macrospace before you install SRE-http."
     say " However, this might adversely impact other programs (that may also "
     say " use REXX's macrospace). "
     ok=yesno(" Clear macrospace now (Y) ?")
     if ok=1 then do
        say " .... clearing macrospace "
        foo=macroclear()
        say " "
     end  /* Do */
     else do
          say " "
        say  bold " Macrospace will not be cleared. " normal
        say " When you are ready to run GOSERVE with SRE-http, we recommend "
        say " that you first reboot your server (otherwise SRE-http will,"
        say " inappropriately, attempt to use the old procedure library)."
          say " "
     end  /* Do */
end  /* Do */
return 0


/************/
make_def_dirs:
parse arg checkcfg

    adir=filespec("drive",nowdir)
    defname=adir||'\GOSERVE'
    defname2=adir||'\WWW'
    call get_goserve_dir checkcfg  /* but ask for a few directories */
    useoo=result
    gmaking=making

    call get_www_dir
    workdir=godir
    addon_dir=workdir'\addon'
    sdatadir=workdir||'\DATA'
    mboxdir=workdir||'\MESSAGE'
    cgibin_dir=workdir||'\cgi-bin'
    lib_dir=workdir||'\lib'
    gifdir=datadir'\imgs'
    digitsdir=datadir'\digits'
    tempdir=datadir'\temp'

    helpdir=datadir'\samples'
    config_dir=workdir'\configs'
    cfgsdir=workdir'\cfgs'

    upload_dir=workdir'\upload'
    tempdatadir=workdir'\temp'
    mailboxdir=workdir'\MAIL'
    userinfodir=workdir'\userinfo'
    workdir_notset=0
    gosds='TEMP DATA  DATA\OLDDATA MESSAGE MAIL CONFIGS LIB UPLOAD CGI-BIN ADDON USERINFO CFGS CFGS\OLDCFGS'
    wwwds='IMGS DIGITS SAMPLES TEMP'
    do ii=1 to words(gosds)
       a1=strip(word(gosds,ii))
       mdd=workdir'\'a1
       if dosisdir(mdd)=0 then do
          oo=sysmkdir(mdd)
          if oo<>0 then do 
            say 'ERROR: Could not create 'mdd ', error code= ' oo
            exit
         end /* do */
       end
    end /* do */
    do ii=1 to words(wwwds)
       a1=strip(word(wwwds,ii))
       mdd=datadir'\'a1
       if dosisdir(mdd)=0 then do
          oo=sysmkdir(mdd)
          if oo<>0 then do then
            say 'ERROR: Could not create 'mdd ', error code= ' oo
            exit
          end /* do */
       end
    end /* do */
return useoo



/************/
read_initfilt_dirs:
parse arg theinit

isz=stream(theinit,'c','query size')
if isz='' | isz=0 then do
    say "ERROR: could not find "theinit
    exit
end /* do */

aa=stream(theinit,'c','open read')
if abbrev(translate(aa),'READY')=0 then do
   say "UNABLE TO OPEN: " theinit
   exit
end /* do */
goop=charin(theinit,1,isz)
foo=stream(theinit,'c','close')

crlf='0d0a'x
do forever
   if goop='' then leave
   parse var goop aline (crlf) goop
   aline=strip(aline)
   if abbrev(aline,';')=1 then iterate
   if aline=''  then iterate
   parse var aline avar '=' avalue ; avar=strip(translate(avar))
   avalue=translate(space(translate(avalue,' ',"'"||'"'),0))
say avar 
   select   
      when avar='ADDON_DIR' then addon_dir=avalue
      when avar='WORKDATA_DIR' then sdatadir=avalue
      when avar='MESSBOX_DIR' then mboxdir=avalue
      when avar='CGI_BIN_DIR' then cgibin_Dir=avalue
      when avar='TEMPFILE_DIR' then tempdir=avalue
      when avar='CFGS_DIR' then cfgsdir=avalue
      when avar="MAILBOX_DIR" then mailboxdir=avalue
      when avar="USERINFO_DIR" then userinfodir=avalue
   otherwise nop
   end  /* select */
end
return 1

