/* WebMail/2 v1.0 by Dimitris 'sehh' Michelinakis <sehh@altered.com> */

/* IP and Port of the WebManager */
Globals.!serv = 10.10.10.1
Globals.!port = 1924

/* Path to the dynamic parsed .wm files */
/* if you leave it as null ("") then its %etc%\webmailhtml by default */
Globals.!WMPath = ""

/* Maximum emails listed per page */
Globals.!MaxEmails = 5

/* WebMail/2 */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call RxFuncAdd 'SockLoadFuncs','RxSock','SockLoadFuncs'
call SockLoadFuncs(1)
Globals.!myinfo = "WebMail/2 for OS/2"
Globals.!myself = value("SCRIPT_NAME",,'os2environment')
if Globals.!WMPath = "" then Globals.!WMPath = value("ETC",,'os2environment')||"\webmailhtml"
if pos(Globals.!myself,value("HTTP_REFERER",,'os2environment'))<1 then call UserLoginScreen
if value("REQUEST_METHOD",,'os2environment')="GET" then do
 Globals.!querystring = URLDecode(value("QUERY_STRING",,'os2environment'))
 parse value Globals.!querystring with Globals.!stat1 "&" Globals.!stat2 "&" Globals.!stat3
 if pos("refresh",Globals.!stat1)=1 then call CheckLogon "checkemail"
 else if pos("read",Globals.!stat1)=1 then call CheckLogon "read"
 else if pos("new",Globals.!stat1)=1 then call CheckLogon "new"
 else if pos("delete",Globals.!stat1)=1 then call CheckLogon "delete"
 else if pos("logoff",Globals.!stat1)=1 then call CheckLogon "logoff"
 else if pos("download",Globals.!stat1)=1 then call CheckLogon "download"
end; else do
 Globals.!ContentLength = value("CONTENT_LENGTH",,'os2environment')
 if Globals.!ContentLength>0 then Globals.!querystring=charin(,,Globals.!ContentLength)
 else call ServerErrorScreen "Your browser doesn't support Froms correctly."
 Globals.!ContentType = value("CONTENT_TYPE",,'os2environment')
 if pos("multipart/form-data",Globals.!ContentType)>0 then do
  Globals.!stat1="postnew"
  call CheckLogon "postnew"
 end; else do
  Globals.!querystring=URLDecode(Globals.!querystring)
  parse value Globals.!querystring with Globals.!stat1 "&" Globals.!stat2 "&" Globals.!stat3
  if pos("flogin=",Globals.!stat1)=1 then call CheckLogon "fcheckemail"
 end
end
call UserLoginScreen
return

CheckLogon: procedure expose Globals.
socket = SockSocket("AF_INET","SOCK_STREAM",0)
if socket = -1 then call CGIErrorScreen "CheckLogon: Error open socket"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_RCVTIMEO", "10"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_SNDTIMEO", "10"
server.!family = "AF_INET"
server.!port   = Globals.!port
server.!addr   = Globals.!serv
rc = SockConnect(socket,"server.!")
if rc = -1 then call CGIErrorScreen "CheckLogon: Error on Socket/Port connection"
Globals.!clientIP = value("REMOTE_ADDR",,'os2environment')
if Globals.!clientIP = "" then call ServerErrorScreen "CheckLogon: Can't detect your client"
if ARG(1) = "fcheckemail" then tmp1=0
else if ARG(1) = "logoff" then tmp1=2
else tmp1=1
if tmp1=0 then do
 Globals.!user = substr(Globals.!stat2,3,length(Globals.!stat2)-2)
 Globals.!pazz = substr(Globals.!stat3,3,length(Globals.!stat3)-2)
 call SendData tmp1||":"||Globals.!user||":"||Globals.!pazz||":"||Globals.!clientIP||":"
end; else do
 cookie=value("HTTP_COOKIE",,'os2environment')
 if pos("WEBMAIL2=",cookie)<1 then do
  rc = SockSoClose(socket)
  call SysSleep 6
  if rc = -1 then call CGIErrorScreen "CheckLogon: Error on SockSoClose"
  call ServerErrorScreen "Login refused"
 end
 cookie=substr(cookie,pos("WEBMAIL2=",cookie)+9,33)
 call SendData tmp1||":"||cookie||":"||Globals.!clientIP||":"
end
if tmp1<>2 then do
 call ReceiveData
 rc = SockSoClose(socket)
 if rc = -1 then call CGIErrorScreen "CheckLogon: Error on SockSoClose"
 if pos("[WebManager2] OK",newData)<1 then do
  call SysSleep 6
  call ServerErrorScreen "Login refused"
 end
 parse value newData with . ":" Globals.!pop3 ":" Globals.!pop3p ":" Globals.!smtp ":" Globals.!smtpp ":" Globals.!AuthID ":" Globals.!user ":" Globals.!pazz ":"
 if ARG(1) = "checkemail" | ARG(1) = "fcheckemail" then do
  Globals.!SetCookie = "SET"
  call CheckEmail
 end; else if ARG(1) = "read" then call ReceiveEmail
 else if ARG(1) = "new" then call NewEmailScreen
 else if ARG(1) = "postnew" then call NewEmail
 else if ARG(1) = "delete" then call DeleteEmail
 else if ARG(1) = "download" then call Download
end; else do
 Globals.!SetCookie = "SET"
 Globals.!AuthID = ""
 call UserLoginScreen
end
call SysSleep 6
Globals.!SetCookie = "SET"
Globals.!AuthID = ""
call ServerErrorScreen "Login refused"
return

CheckEmail: procedure expose Globals.
socket = SockSocket("AF_INET","SOCK_STREAM",0)
if socket = -1 then call CGIErrorScreen "CheckEmail: Error open socket"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_RCVTIMEO", "10"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_SNDTIMEO", "10"
server.!family = "AF_INET"
server.!port   = Globals.!pop3p
server.!addr   = Globals.!pop3
rc = SockConnect(socket,"server.!")
if rc = -1 then call CGIErrorScreen "CheckEmail: Error on Socket/Port connection"
call ReceiveData
if substr(newData,1,3)<>"+OK" then call ServerErrorScreen "CheckEmail: Server refused connection"
if right(Globals.!AuthID,1)<>5 then parse value Globals.!user with tmpuser "@" tmpdomain
else tmpuser=Globals.!user
call SendData "USER "||tmpuser||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "CheckEmail: Server refused user login"
end
call SendData "PASS "||Globals.!pazz||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "CheckEmail: Failed login due to password error"
end
call SendData "STAT"||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "CheckEmail: Email server couldn't get status"
end
parse value newData with . Globals.!totalmail .
if datatype(Globals.!totalmail,"N")<>1 then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "CheckEmail: Server returned wrong value"
end
Globals.!JumpTable = ""
if Globals.!totalmail>Globals.!MaxEmails then do
 jumpnumber = Globals.!totalmail / Globals.!MaxEmails
 if pos(".",jumpnumber)>0 then jumpnumber=substr(jumpnumber,1,pos(".",jumpnumber)-1)+1
 do zz=1 to jumpnumber
  Globals.!JumpPage = zz
  Globals.!JumpTable = Globals.!JumpTable||ParseHTML( Globals.!WMPath || "\jump-table.wm",0,1 )
 end
end
if Globals.!stat2<>"" & Globals.!stat3="" then do
 zz = Globals.!stat2 * Globals.!MaxEmails
 EmailStart = zz - Globals.!MaxEmails + 1
 if zz>Globals.!totalmail then zz=Globals.!totalmail
 Globals.!totalmail = zz
end; else do
 if Globals.!totalmail>Globals.!MaxEmails then Globals.!totalmail=Globals.!MaxEmails
 EmailStart=1
end
zz=0
do i=EmailStart to Globals.!totalmail
 call SendData "TOP "||i||" 0"||'0d0a'x
 call ReceiveData(5)
 if substr(newData,1,3)="+OK" then do
  oldData=""
  do while pos('0d0a'x||"."||'0d0a'x,oldData)<1
   call ReceiveData(256)
   oldData=oldData||newData
  end
  zz=zz+1
  Globals.!mail.i=oldData
 end
end
Globals.!mail.0 = zz
ListMail.0 = 0
do i=EmailStart to Globals.!totalmail
 poz=1
 do while poz<length(Globals.!mail.i)
  rc = substr(Globals.!mail.i,poz,1)
  if rc=" " | rc='09'x then Globals.!mail.i = substr(Globals.!mail.i,1,poz-3)||" "||space(substr(Globals.!mail.i,poz+1))
  poz = pos('0d0a'x,Globals.!mail.i,poz)+2
 end
 if pos("From: ",Globals.!mail.i)>0 then do
  tmp1 = pos("From: ",Globals.!mail.i)+6
  tmp2 = pos('0d0a'x,Globals.!mail.i,tmp1)
  tmp3 = space(substr(Globals.!mail.i,tmp1,tmp2-tmp1))
  if pos("<",tmp3)>0 then tmp3 = translate(tmp3,"(","<")
  else tmp3 = "("||tmp3
  if pos(">",tmp3)>0 then tmp3 = translate(tmp3,")",">")
  else tmp3 = tmp3||")"
  ListMail.i.!From = tmp3
 end; else ListMail.i.!From="Unknown"
 if pos("Subject: ",Globals.!mail.i)>0 then do
  tmp1 = pos("Subject: ",Globals.!mail.i)+9
  tmp2 = pos('0d0a'x,Globals.!mail.i,tmp1)
  tmp3 = space(substr(Globals.!mail.i,tmp1,tmp2-tmp1))
  if pos("<",tmp3)>0 then tmp3 = translate(tmp3,"(","<")
  if pos(">",tmp3)>0 then tmp3 = translate(tmp3,")",">")
  ListMail.i.!Subject = tmp3
 end; else ListMail.i.!Subject=""
 if pos("Date: ",Globals.!mail.i)>0 then do
  tmp1 = pos("Date: ",Globals.!mail.i)+6
  ListMail.i.!Date = space(substr(Globals.!mail.i,tmp1,16))
 end; else ListMail.i.!Date = ""
 if pos("Content-Type: ",Globals.!mail.i)>0 then do
  tmp1 = pos("Content-Type: ",Globals.!mail.i)+14
  tmp2 = pos('0d0a'x,Globals.!mail.i,tmp1)
  tmp3 = space(substr(Globals.!mail.i,tmp1,tmp2-tmp1))
  if pos("multipart/mixed;",tmp3)>0 then ListMail.i.!ContentType = "YES"
 end
 if pos("Priority: ",Globals.!mail.i)>0 then do
  tmp1 = pos("Priority: ",Globals.!mail.i)+10
  tmp2 = pos('0d0a'x,Globals.!mail.i,tmp1)
  tmp3 = space(substr(Globals.!mail.i,tmp1,tmp2-tmp1))
  if tmp3 = "High" then ListMail.i.!Priority = "High"
  else if tmp3 = "Low" then ListMail.i.!Priority = "Low"
  else ListMail.i.!Priority = "Normal"
 end; else ListMail.i.!Priority = "Normal"
end
call SendData "QUIT"||'0d0a'x
rc = SockSoClose(socket)
if rc = -1 then call CGIErrorScreen "CheckEmail: Error on SockSoClose"
call ParseHTML Globals.!WMPath || "\header.wm", 1
if Globals.!mail.0 > 0 then do
 Globals.!ListTable = ""
 do i=EmailStart to Globals.!totalmail
  if ListMail.i.!ContentType = "YES" then Globals.!ContentType = ParseHTML( Globals.!WMPath || "\attachment-yes.wm",0,1 )
  else Globals.!ContentType = ParseHTML( Globals.!WMPath || "\attachment-no.wm",0,1 )
  if ListMail.i.!Priority = "High" then Globals.!Priority = ParseHTML( Globals.!WMPath || "\priority-high.wm",0,1 )
  else do
   if ListMail.i.!Priority = "Low" then Globals.!Priority = ParseHTML( Globals.!WMPath || "\priority-low.wm",0,1 )
   else Globals.!Priority = ParseHTML( Globals.!WMPath || "\priority-normal.wm",0,1 )
  end 
  Globals.!ListTable = Globals.!ListTable || ParseHTML( Globals.!WMPath || "\listemails-table.wm",0,1 )
 end
 call ParseHTML Globals.!WMPath || "\listemails.wm"
end; else call ParseHTML Globals.!WMPath || "\nomail.wm"
call ParseHTML Globals.!WMPath || "\footer.wm"
exit

ReceiveEmail: procedure expose Globals.
socket = SockSocket("AF_INET","SOCK_STREAM",0)
if socket = -1 then call CGIErrorScreen "ReceiveEmail: Error open socket"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_RCVTIMEO", "10"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_SNDTIMEO", "10"
server.!family = "AF_INET"
server.!port   = Globals.!pop3p
server.!addr   = Globals.!pop3
rc = SockConnect(socket,"server.!")
if rc = -1 then call CGIErrorScreen "ReceiveEmail: Error on Socket/Port connection"
call ReceiveData
if substr(newData,1,3)<>"+OK" then call ServerErrorScreen "ReceiveEmail: Server refused connection"
if right(Globals.!AuthID,1)<>5 then parse value Globals.!user with tmpuser "@" tmpdomain
else tmpuser=Globals.!user
call SendData "USER "||tmpuser||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "ReceiveEmail: Server refused user login"
end
call SendData "PASS "||Globals.!pazz||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "ReceiveEmail: Failed login due to password error"
end
call SendData "STAT"||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "ReceiveEmail: Email server couldn't get status"
end
parse value newData with . Globals.!totalmail .
if datatype(Globals.!totalmail,"N")<>1 then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "ReceiveEmail: Server returned wrong value"
end
call SendData "LIST "||Globals.!stat2||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "ReceiveEmail: Server couldn't list email"
end
parse value newData with . . tmpsize '0d0a'x
if tmpsize>2048000 then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "ReceiveEmail: Email size is too big."
end
call SendData "RETR "||Globals.!stat2||'0d0a'x
tmp=""
do while length(tmp) < tmpsize
 call ReceiveData
 tmp = tmp||newData
end
if substr(tmp,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "ReceiveEmail: Server couldn't retrieve email"
end
call SendData "QUIT"||'0d0a'x
rc = SockSoClose(socket)
if rc = -1 then call CGIErrorScreen "ReceiveEmail: Error on SockSoClose"
i=Globals.!stat2
poz=1
do while poz<pos(tmp,'0d0a'x||'0d0a'x)
 rc = substr(tmp,poz,1)
 if rc=" " | rc='09'x then tmp = substr(tmp,1,poz-3)||" "||space(substr(tmp,poz+1))
 poz = pos('0d0a'x,tmp,poz)+2
end
if pos("From: ",tmp)>0 then do
 tmp1 = pos("From: ",tmp)+6
 tmp2 = pos('0d0a'x,tmp,tmp1)
 tmp3 = space(substr(tmp,tmp1,tmp2-tmp1))
 if pos("<",tmp3)>0 then tmp3 = translate(tmp3,"(","<")
 else tmp3 = "("||tmp3
 if pos(">",tmp3)>0 then tmp3 = translate(tmp3,")",">")
 else tmp3 = tmp3||")"
 ListMail.i.!From = tmp3
end; else ListMail.i.!From="Unknown"
if pos("Subject: ",tmp)>0 then do
 tmp1 = pos("Subject: ",tmp)+9
 tmp2 = pos('0d0a'x,tmp,tmp1)
 tmp3 = space(substr(tmp,tmp1,tmp2-tmp1))
 if pos("<",tmp3)>0 then tmp3 = translate(tmp3,"(","<")
 if pos(">",tmp3)>0 then tmp3 = translate(tmp3,")",">")
 ListMail.i.!Subject = tmp3
end; else ListMail.i.!Subject=""
if pos("Date: ",tmp)>0 then do
 tmp1 = pos("Date: ",tmp)+6
 ListMail.i.!Date = space(substr(tmp,tmp1,16))
end; else ListMail.i.!Date = ""
/* call charout "c:\tcpip\os2httpd\cgi-bin\debug.txt", tmp */
ListMail.!Show = substr(tmp,1,lastpos('0d0a'x||"."||'0d0a'x,tmp)-1)
ListMail.!Show = substr(ListMail.!Show, pos('0d0a'x,ListMail.!Show)+2)
if pos("Content-Type: ",tmp)>0 then do
 tmp1 = pos("Content-Type: ",tmp)+14
 tmp2 = pos('0d0a'x,tmp,tmp1)
 tmp3 = space(substr(tmp,tmp1,tmp2-tmp1))
 if pos("multipart/mixed;",tmp3)>0 then do
  ListMail.i.!ContentType = "YES"
  boundary = substr(tmp3, pos("boundary=",tmp3)+10)
  boundary = '0d0a'x||"--"||substr(boundary, 1, length(boundary)-1)||'0d0a'x
  poz = pos(boundary,tmp)
  pozlength = pos('0d0a'x||'0d0a'x,tmp,poz)
  pozend = pos(boundary,tmp,pozlength+4)
  ListMail.!Show = substr(tmp,pozlength+4,pozend-pozlength-4)
  zi=0
  do while pos(boundary,tmp,pozlength)>0
   zi=zi+1
   poz = pos(boundary,tmp,pozlength)
   pozlength = pos('0d0a'x||'0d0a'x,tmp,poz)
   headerz = substr(tmp,poz,pozlength-poz)
   if pos("name=",headerz)>0 then
    parse value headerz with . "name=""" Globals.!AttachFiles.zi """" .
   else Globals.!AttachFiles.zi="unknown"
  end
  Globals.!AttachFiles.0=zi
 end; else do
  tmp1 = pos('0d0a'x||'0d0a'x,ListMail.!Show)+4
  ListMail.!Show = substr(ListMail.!Show, tmp1)
 end
end; else do
 tmp1 = pos('0d0a'x||'0d0a'x,ListMail.!Show)+4
 ListMail.!Show = substr(ListMail.!Show, tmp1)
end
if pos("Priority: ",tmp)>0 then do
 tmp1 = pos("Priority: ",tmp)+10
 tmp2 = pos('0d0a'x,tmp,tmp1)
 tmp3 = space(substr(tmp,tmp1,tmp2-tmp1))
 if tmp3 = "High" then Globals.!Priority = ParseHTML( Globals.!WMPath || "\priority-high.wm",0,1 ) || '0d0a'x
 else if tmp3 = "Low" then Globals.!Priority = ParseHTML( Globals.!WMPath || "\priority-low.wm",0,1 ) || '0d0a'x
 else Globals.!Priority = ParseHTML( Globals.!WMPath || "\priority-normal.wm",0,1 ) || '0d0a'x
end; else Globals.!Priority = ParseHTML( Globals.!WMPath || "\priority-normal.wm",0,1 ) || '0d0a'x
call ParseHTML Globals.!WMPath || "\header.wm", 1
if ListMail.i.!ContentType = "YES" then do
 Globals.!ContentType = ParseHTML( Globals.!WMPath || "\attachment-yes.wm",0,1 ) || '0d0a'x
 Globals.!AttachmentsTable=""
 do iz=1 to Globals.!AttachFiles.0
  Globals.!AttachFile = Globals.!AttachFiles.iz
  Globals.!AttachmentsTable = Globals.!AttachmentsTable || ParseHTML( Globals.!WMPath || "\attachment-table.wm",0,1 ) || '0d0a'x
 end
end; else do
 Globals.!ContentType=ParseHTML( Globals.!WMPath || "\attachment-no.wm",0,1 ) || '0d0a'x
 Globals.!AttachmentsTable=""
end
if i>1 then Globals.!PrevEmailNum=i-1
else Globals.!PrevEmailNum=Globals.!totalmail
if i>=Globals.!totalmail then Globals.!NextEmailNum=1
else Globals.!NextEmailNum=i+1
call ParseHTML Globals.!WMPath || "\reademail.wm"
call ParseHTML Globals.!WMPath || "\footer.wm"
exit

NewEmail: procedure expose Globals.
parse value Globals.!ContentType with . "boundary=" boundary
boundare="--"||boundary
boundary="--"||boundary||'0d0a'x
parse value Globals.!querystring with . (boundary) Globals.!querystring
epriority="Normal"
subject=""
ccto=""
bccto=""
do i=1 to 6
 parse value Globals.!querystring with headerz (boundary) Globals.!querystring
 parse value headerz with . 'Content-Disposition: form-data; name="' headval '"' '0d0a'x '0d0a'x bodyval '0d0a'x .
 if headval="" then call CGIErrorScreen "NewEmail: Error reading form"
 if headval="t" then sendto = bodyval
 else if headval="c" then ccto = bodyval
 else if headval="b" then bccto = bodyval
 else if headval="s" then subject = bodyval
 else if headval="p" then epriority = bodyval
end
parse value Globals.!querystring with headerz '0d0a'x '0d0a'x bodyval (boundary) Globals.!querystring
parse value headerz with . 'Content-Disposition: form-data; name="' headval '"' .
if headval="body" then body=bodyval
else body=""
parse value Globals.!querystring with . 'Content-Disposition: form-data; name="' headval '"; filename="' filename '"' . '0d0a'x '0d0a'x bodyval
if filename<>"" then do
 if pos(boundare,bodyval)>2 then bodyval = substr(bodyval,1,pos(boundare,bodyval)-3)
 else call CGIErrorScreen "NewEmail: Error reading form file attachment"
 filename=filespec("name",filename)
 bodyval = EnCode64(bodyval)
end
socket = SockSocket("AF_INET","SOCK_STREAM",0)
if socket = -1 then call CGIErrorScreen "NewEmail: Error open socket"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_RCVTIMEO", "10"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_SNDTIMEO", "10"
server.!family = "AF_INET"
server.!port   = Globals.!smtpp
server.!addr   = Globals.!smtp
rc = SockConnect(socket,"server.!")
if rc = -1 then call CGIErrorScreen "NewEmail: Error on Socket/Port connection"
call ReceiveData
if substr(newData,1,3)<>"220" then call ServerErrorScreen "NewEmail: Server refused connection"
call SendData "HELO "||server.!addr||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"250" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "NewEmail: Server dropped connection"
end
call SendData "MAIL FROM: <"||Globals.!user||">"||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"250" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "NewEmail: Server rejected email transfer"
end
if pos(" ",sendto)>0 then do
 tmp = sendto
 do while tmp<>""
  parse value tmp with sendto1 tmp
  call SendData "RCPT TO: <"||sendto1||">"||'0d0a'x
  call ReceiveData
  if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
   call SendData "QUIT"||'0d0a'x
   call ServerErrorScreen "NewEmail: Server rejected target email:<br>"||newData
  end
 end
end; else do
 call SendData "RCPT TO: <"||sendto||">"||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "NewEmail: Server rejected target email:<br>"||newData
 end
end
if pos(" ",ccto)>0 then do
 tmp = ccto
 do while tmp<>""
  parse value tmp with sendto1 tmp
  call SendData "RCPT TO: <"||sendto1||">"||'0d0a'x
  call ReceiveData
  if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
   call SendData "QUIT"||'0d0a'x
   call ServerErrorScreen "NewEmail: Server rejected target email"
  end
 end
end; else if ccto<>"" then do
 call SendData "RCPT TO: <"||ccto||">"||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "NewEmail: Server rejected target email"
 end
end
if pos(" ",bccto)>0 then do
 tmp = bccto
 do while tmp<>""
  parse value tmp with sendto1 tmp
  call SendData "RCPT TO: <"||sendto1||">"||'0d0a'x
  call ReceiveData
  if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
   call SendData "QUIT"||'0d0a'x
   call ServerErrorScreen "NewEmail: Server rejected target email"
  end
 end
end; else if bccto<>"" then do
 call SendData "RCPT TO: <"||bccto||">"||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"250" & substr(newData,1,3)<>"251" then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "NewEmail: Server rejected target email"
 end
end
call SendData "DATA"||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"354" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "NewEmail: Server rejected email data"
end
header = "From: <"||Globals.!user||">"||'0d0a'x
if pos(" ",sendto)>0 then do
 tmp = sendto
 parse value tmp with sendto1 tmp
 header = header||"To: <"||sendto1||">,"||'0d0a'x
 do while tmp<>""
  parse value tmp with sendto1 tmp
  header = header||"    <"||sendto1||">"
  if tmp<>"" then header=header||","||'0d0a'x
  else header=header||'0d0a'x
 end
end; else header = header||"To: <"||sendto||">"||'0d0a'x
if pos(" ",ccto)>0 then do
 tmp = sendto
 parse value tmp with sendto1 tmp
 header = header||"Cc: <"||sendto1||">,"||'0d0a'x
 do while tmp<>""
  parse value tmp with sendto1 tmp
  header = header||"    <"||sendto1||">"
  if tmp<>"" then header=header||","||'0d0a'x
  else header=header||'0d0a'x
 end
end; else if ccto<>"" then header = header||"Cc: <"||ccto||">"||'0d0a'x
tz = value("TZ",,'os2environment')
if pos(",",tz)>0 then tz=substr(tz,1,pos(",",tz)-1)
header = header||"Date: "||substr(date("W"),1,3)||", "||date('N')||" "||time()||" "||tz||'0d0a'x
header = header||"Priority: "||epriority||'0d0a'x
header = header||"X-Mailer: "||Globals.!myinfo||'0d0a'x
header = header||"MIME-Version: 1.0"||'0d0a'x
if filename="" then header = header||"Content-Type: text/plain"||'0d0a'x
else do
 boundary = "_=_=_=WBM.BOUNDARY."||date("B")||random()||"=_=_=_"
 header = header||'Content-Type: multipart/mixed; boundary="'||boundary||'"'||'0d0a'x
end
header = header||"Subject: "||subject||'0d0a'x||'0d0a'x
if filename="" then body=header||body
else do
 body=header||"--"||boundary||'0d0a'x||"Content-Type: text/plain"||'0d0a'x||"Content-Transfer-Encoding: 8bit"||'0d0a'x||'0d0a'x||body
 body=body||'0d0a'x||"--"||boundary||'0d0a'x||'Content-Type: application/octet-stream; name="'||filename||'"'||'0d0a'x||"Content-Transfer-Encoding: base64"||'0d0a'x||'0d0a'x||bodyval||'0d0a'x||"--"||boundary||"--"
end
call SendData body
call SendData '0d0a'x||"."||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"250" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "NewEmail: Server rejected email transfer"
end
call SendData "QUIT"||'0d0a'x
rc = SockSoClose(socket)
if rc = -1 then call CGIErrorScreen "NewEmail: Error on SockSoClose"
call CheckEmail
return

DeleteEmail: procedure expose Globals.
socket = SockSocket("AF_INET","SOCK_STREAM",0)
if socket = -1 then call CGIErrorScreen "DeleteEmail: Error open socket"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_RCVTIMEO", "10"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_SNDTIMEO", "10"
server.!family = "AF_INET"
server.!port   = Globals.!pop3p
server.!addr   = Globals.!pop3
rc = SockConnect(socket,"server.!")
if rc = -1 then call CGIErrorScreen "DeleteEmail: Error on Socket/Port connection"
call ReceiveData
if substr(newData,1,3)<>"+OK" then call ServerErrorScreen "DeleteEmail: Server refused connection"
if right(Globals.!AuthID,1)<>5 then parse value Globals.!user with tmpuser "@" tmpdomain
else tmpuser=Globals.!user
call SendData "USER "||tmpuser||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "DeleteEmail: Server refused user login"
end
call SendData "PASS "||Globals.!pazz||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "DeleteEmail: Failed login due to password error"
end
if pos("all",Globals.!stat2)>0 then do
 call SendData "STAT"||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"+OK" then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "DeleteEmail: Email server couldn't get status"
 end
 parse value newData with . Globals.!totalmail .
 if datatype(Globals.!totalmail,"N")<>1 then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "DeleteEmail: Server returned wrong value"
 end
 do i=1 to Globals.!totalmail
  call SendData "DELE "||i||'0d0a'x
  call ReceiveData
  if substr(newData,1,3)<>"+OK" then do
   call SendData "QUIT"||'0d0a'x
   call ServerErrorScreen "DeleteEmail: Server couldn't delete email<br> or email already deleted"
  end
 end
end; else do
 call SendData "DELE "||Globals.!stat2||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"+OK" then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "DeleteEmail: Server couldn't delete email<br> or email already deleted"
 end
end
call SendData "QUIT"||'0d0a'x
rc = SockSoClose(socket)
if rc = -1 then call CGIErrorScreen "DeleteEmail: Error on SockSoClose"
call SysSleep 2
call CheckEmail
return

Download: procedure expose Globals.
parse value Globals.!stat2 with EmailNumber ":" FileName
socket = SockSocket("AF_INET","SOCK_STREAM",0)
if socket = -1 then call CGIErrorScreen "Download: Error open socket"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_RCVTIMEO", "10"
call SockSetSockOpt socket, "SOL_SOCKET", "SO_SNDTIMEO", "10"
server.!family = "AF_INET"
server.!port   = Globals.!pop3p
server.!addr   = Globals.!pop3
rc = SockConnect(socket,"server.!")
if rc = -1 then call CGIErrorScreen "Download: Error on Socket/Port connection"
call ReceiveData
if substr(newData,1,3)<>"+OK" then call ServerErrorScreen "Download: Server refused connection"
if right(Globals.!AuthID,1)<>5 then parse value Globals.!user with tmpuser "@" tmpdomain
else tmpuser=Globals.!user
call SendData "USER "||tmpuser||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "Download: Server refused user login"
end
call SendData "PASS "||Globals.!pazz||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "Download: Failed login due to password error"
end
call SendData "LIST "||Globals.!stat2||'0d0a'x
call ReceiveData
if substr(newData,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "Download: Server couldn't list email"
end
parse value newData with . . tmpsize '0d0a'x
call SendData "RETR "||EmailNumber||'0d0a'x
tmp=""
do while length(tmp) < tmpsize
 call ReceiveData
 tmp = tmp||newData
end
if substr(tmp,1,3)<>"+OK" then do
 call SendData "QUIT"||'0d0a'x
 call ServerErrorScreen "Download: Server couldn't retrieve email"
end
call SendData "QUIT"||'0d0a'x
rc = SockSoClose(socket)
if rc = -1 then call CGIErrorScreen "Download: Error on SockSoClose"
if pos("Content-Type:",tmp)>0 then do
 tmp1 = pos("Content-Type:",tmp)+14
 tmp2 = pos('0d0a'x,tmp,tmp1)
 tmp3 = space(substr(tmp,tmp1,tmp2-tmp1))
 if pos("multipart/mixed;",tmp3)>0 then do
  boundary = substr(tmp3, pos("boundary=",tmp3)+10)
  boundary = '0d0a'x||"--"||substr(boundary, 1, length(boundary)-1)||'0d0a'x
  poz = pos(boundary,tmp)+2
  do while poz>0
   poz = pos(boundary,tmp,poz)+2
   pozlength = pos('0d0a'x||'0d0a'x,tmp,poz)
   headerz = substr(tmp,poz,pozlength-poz)
   if pos(FileName,headerz)>0 then do
    say 'Content-Type: application/octet-stream'
    say 'Content-Disposition: attachment; filename="'||FileName||'"'
    say "Connection: close"
    say "Cache-Control: private"
    say "Pragma: no-cache"
    say ""
    pozlength2 = pos('0d0a'x||'0d0a'x,tmp,pozlength+4)-4
    call DeBase64 space(translate(substr(tmp,pozlength+4,pozlength2-pozlength),,'0d0a'x),0)
   end
  end
 end
end
exit

SendData: procedure expose socket
rc = SockSend(socket,ARG(1))
if rc = -1 then call CGIErrorScreen "SendData: Error on SockSend"
return

ReceiveData: procedure expose socket newData
length = ARG(1)
if length = "" then length = 1024
rc = SockRecv(socket,"newData",length)
if rc = -1 then call CGIErrorScreen "ReceiveData: Error on SockRecv "||length
return

ParseHTML: procedure expose Globals. i ListMail.
findstring.1 = "*!WMVERSION!*:"||Globals.!myinfo
findstring.2 = "*!WMUSER!*:"||Globals.!user
findstring.3 = "*!WMPASS!*:"||Globals.!pazz
findstring.4 = "*!WMFILENAME!*:"||Globals.!myself
findstring.5 = "*!WMEMAILNUM!*:"||i
findstring.6 = "*!WMEMAILFROM!*:"||ListMail.i.!From
findstring.7 = "*!WMEMAILSUBJECT!*:"||ListMail.i.!Subject
findstring.8 = "*!WMEMAILDATE!*:"||ListMail.i.!Date
findstring.9 = "*!WMEMAILBODY!*:"||ListMail.!Show
findstring.10 = "*!WMEMAILTABLE!*:"||Globals.!ListTable
findstring.11 = "*!SERVERERROR!*:"||Globals.!ServerErr
findstring.12 = "*!WMATTACHMENT!*:"||Globals.!ContentType
findstring.13 = "*!WMEMAILPRIORITY!*:"||Globals.!Priority
findstring.14 = "*!WMAUTHID!*:"||Globals.!AuthID
findstring.15 = "*!WMATTACHMENTSTABLE!*:"||Globals.!AttachmentsTable
findstring.16 = "*!WMATTACHFILE!*:"||Globals.!AttachFile
findstring.17 = "*!WMJUMPTABLE!*:"||Globals.!JumpTable
findstring.18 = "*!WMJUMPPAGE!*:"||Globals.!JumpPage
findstring.19 = "*!WMPREVEMAILNUM!*:"||Globals.!PrevEmailNum
findstring.20 = "*!WMNEXTEMAILNUM!*:"||Globals.!NextEmailNum
findstring.0 = 20
if ARG(2)=1 then do
 say "Content-type: text/html"
 say "Cache-Control: private"
 say "Pragma: no-cache"
 say "Expires: NOW"
 if Globals.!SetCookie="SET" then say "Set-Cookie: WEBMAIL2="||Globals.!AuthID
 say ""
end
newstr = ""
istr = stream(ARG(1), 'c', 'open read')
do while lines(ARG(1))>0
 tmp = linein(ARG(1))
 do ii=1 to findstring.0
  parse value findstring.ii with tmp1 ":" tmp2
  rc = pos(tmp1,tmp)
  if rc >0 then tmp = ReplaceStr(tmp,tmp1,tmp2)
 end
 if ARG(3)<>1 then say tmp
 else newstr = newstr || tmp|| '0d0a'x
end
return newstr

ReplaceStr: procedure
tmp1 = ARG(1)
tmp2 = ARG(2)
tmp3 = ARG(3)
do forever
 iz = pos(tmp2,tmp1)
 if iz<1 then leave
 tmp = substr(tmp1,1,iz-1)
 tmpp = substr(tmp1,iz+length(tmp2),length(tmp1)-iz+length(tmp2))
 tmp1 = tmp||tmp3||tmpp
end
return tmp1

UserLoginScreen: procedure expose Globals.
call ParseHTML Globals.!WMPath || "\userlogin.wm", 1
exit

NewEmailScreen: procedure expose Globals.
ListMail.i.!From=""
ListMail.i.!Subject=""
ListMail.!Show=""
if Globals.!stat2<>"" then do
 socket = SockSocket("AF_INET","SOCK_STREAM",0)
 if socket = -1 then call CGIErrorScreen "NewEmailScreen: Error open socket"
 call SockSetSockOpt socket, "SOL_SOCKET", "SO_RCVTIMEO", "10"
 call SockSetSockOpt socket, "SOL_SOCKET", "SO_SNDTIMEO", "10"
 server.!family = "AF_INET"
 server.!port   = Globals.!pop3p
 server.!addr   = Globals.!pop3
 rc = SockConnect(socket,"server.!")
 if rc = -1 then call CGIErrorScreen "NewEmailScreen: Error on Socket/Port connection"
 call ReceiveData
 if substr(newData,1,3)<>"+OK" then call ServerErrorScreen "NewEmailScreen: Server refused connection"
 if right(Globals.!AuthID,1)<>5 then parse value Globals.!user with tmpuser "@" tmpdomain
 else tmpuser=Globals.!user
 call SendData "USER "||tmpuser||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"+OK" then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "NewEmailScreen: Server refused user login"
 end
 call SendData "PASS "||Globals.!pazz||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"+OK" then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "NewEmailScreen: Failed login due to password error"
 end
 call SendData "LIST "||Globals.!stat2||'0d0a'x
 call ReceiveData
 if substr(newData,1,3)<>"+OK" then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "NewEmailScreen: Server couldn't list email"
 end
 parse value newData with . . tmpsize '0d0a'x
 if tmpsize>2048000 then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "NewEmailScreen: Email size is too big."
 end
 call SendData "RETR "||Globals.!stat2||'0d0a'x
 tmp=""
 do while length(tmp) < tmpsize
  call ReceiveData
  tmp = tmp||newData
 end
 if substr(tmp,1,3)<>"+OK" then do
  call SendData "QUIT"||'0d0a'x
  call ServerErrorScreen "NewEmailScreen: Server couldn't retrieve email"
 end
 call SendData "QUIT"||'0d0a'x
 rc = SockSoClose(socket)
 if rc = -1 then call CGIErrorScreen "NewEmailScreen: Error on SockSoClose"
 i=Globals.!stat2
 poz=1
 do while poz<pos(tmp,'0d0a'x||'0d0a'x)
  rc = substr(tmp,poz,1)
  if rc=" " | rc='09'x then tmp = substr(tmp,1,poz-3)||" "||space(substr(tmp,poz+1))
  poz = pos('0d0a'x,tmp,poz)+2
 end
 if pos("From: ",tmp)>0 then do
  tmp1 = pos("From: ",tmp)+6
  tmp2 = pos('0d0a'x,tmp,tmp1)
  tmp3 = space(substr(tmp,tmp1,tmp2-tmp1))
  if pos("<",tmp3)>0 & pos(">",tmp3)>0 then do
   tmp1 = pos("<",tmp3)+1
   tmp2 = pos(">",tmp3,tmp1)
   tmp3 = space(substr(tmp3,tmp1,tmp2-tmp1))
  end
  ListMail.i.!From = tmp3
 end; else ListMail.i.!From=""
 if pos("Subject: ",tmp)>0 then do
  tmp1 = pos("Subject: ",tmp)+9
  tmp2 = pos('0d0a'x,tmp,tmp1)
  tmp3 = space(substr(tmp,tmp1,tmp2-tmp1))
  ListMail.i.!Subject = "Re: "||tmp3
 end; else ListMail.i.!Subject=""
 ListMail.!Show = substr(tmp,1,lastpos('0d0a'x||"."||'0d0a'x,tmp)-1)
 ListMail.!Show = substr(ListMail.!Show, pos('0d0a'x,ListMail.!Show)+2)
 if pos("Content-Type: ",tmp)>0 then do
  tmp1 = pos("Content-Type: ",tmp)+14
  tmp2 = pos('0d0a'x,tmp,tmp1)
  tmp3 = space(substr(tmp,tmp1,tmp2-tmp1))
  if pos("multipart/mixed;",tmp3)>0 then do
   boundary = substr(tmp3, pos("boundary=",tmp3)+10)
   boundary = '0d0a'x||"--"||substr(boundary, 1, length(boundary)-1)||'0d0a'x
   poz = pos(boundary,tmp)
   pozlength = pos('0d0a'x||'0d0a'x,tmp,poz)
   pozend = pos(boundary,tmp,pozlength+4)
   ListMail.!Show = substr(tmp,pozlength+4,pozend-pozlength-4)
  end; else do
   tmp1 = pos('0d0a'x||'0d0a'x,ListMail.!Show)+4
   ListMail.!Show = substr(ListMail.!Show, tmp1)
  end
 end; else do
  tmp1 = pos('0d0a'x||'0d0a'x,ListMail.!Show)+4
  ListMail.!Show = substr(ListMail.!Show, tmp1)
 end
 tmp=1
 ListMail.!Show = insert( ">", ListMail.!Show)
 do while pos('0d0a'x,ListMail.!Show,tmp)>0
  tmp=pos('0d0a'x,ListMail.!Show,tmp)+1
  ListMail.!Show = insert( ">", ListMail.!Show,tmp)
 end
end
call ParseHTML Globals.!WMPath || "\header.wm", 1
call ParseHTML Globals.!WMPath || "\composeemail.wm"
call ParseHTML Globals.!WMPath || "\footer.wm"
exit

ServerErrorScreen: procedure expose Globals.
Globals.!ServerErr = ARG(1)
call ParseHTML Globals.!WMPath || "\servererror.wm", 1
exit

CGIErrorScreen: procedure expose Globals.
socket = SockSocket("AF_INET","SOCK_STREAM",0)
server.!family = "AF_INET"
server.!port   = Globals.!port
server.!addr   = Globals.!serv
call SockConnect socket,"server.!"
call SockSend socket,"3:"||ARG(1)
call SockSoClose socket
call ServerErrorScreen "Email Server Error!"
exit

URLDecode: procedure
line = translate(ARG(1)," ","+")
lineLen= LENGTH(line)
newLine= ''
i=1
do while i <= lineLen
 c= substr(line, i, 1)
 if c \= '%' then newLine = newLine || c
 else if i+2 <= lineLen then do
  newLine= newLine || x2c(substr(line, i+1, 2))
  i=i+2
 end
 i= i+1
end
return newLine

DeBase64: procedure
charset='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
map_c6b.=""
do ind=0 to 63
 parse var charset char +1 charset
 map_c6b.char=right(x2b(d2x(ind)), 6, "0")
end
parse arg input_string
input_length=length(input_string)
do input_index=1 to input_length by 4
 parse var input_string =(input_index) q1 +1 q2 +1 q3 +1 q4 +1
 call charout , x2c(b2x(map_c6b.q1||map_c6b.q2||map_c6b.q3||map_c6b.q4))
end
exit

EnCode64: procedure
/* Encodes a file in Base64. */
/* Written by James L. Dean  */
char_set='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
input_eof=0
col_num=1
input_var=ARG(1)
output_var=""
poz=0
do while (input_eof = 0)
 num_octets=0
 triple=0
 do octet_num=1 to 3
  if input_eof = 0 then do
   poz=poz+1
   octet=substr(input_var,poz,1)
   if poz>length(input_var) then input_eof=-1
  end
  if input_eof = 0 then do
   triple=256*triple+C2D(octet)
   num_octets=num_octets+1
  end; else triple=256*triple
 end
 num_sextets=(8*num_octets)%6
 if 6*num_sextets < 8*num_octets then num_sextets=num_sextets+1
 if num_sextets > 0 then do
  sextet_num=1
  do while(sextet_num <= 4)
   quotient=triple%64
   stack.sextet_num=triple-64*quotient
   sextet_num=sextet_num+1
   triple=quotient
  end
  do while(num_sextets >= 1)
   sextet_num=sextet_num-1
   output_var = output_var||substr(char_set,1+stack.sextet_num,1)
   col_num=col_num+1
   if col_num > 76 then do
    output_var = output_var||d2c(13)
    output_var = output_var||d2c(10)
    col_num=1
   end
   num_sextets=num_sextets-1
  end
  do while(sextet_num > 1)
   output_var = output_var||'='
   col_num=col_num+1
   if col_num > 76 then do
    output_var = output_var||d2c(13)
    output_var = output_var||d2c(10)
    col_num=1
   end
   sextet_num=sextet_num-1
  end
 end
end
if col_num > 1 then do
 output_var = output_var||d2c(13)
 output_var = output_var||d2c(10)
end
return output_var
