/**********************
  15 Nov 1997. danielh@econ.ag.gov

  WWW-Count: A Graphical Counter for OS/2 Web Servers.
 
  See WWWCOUNT.DOC for details on installation and use.

Summary:
   WWW-Count can be invoked either as a CGI-BIN script, or as an EXEC server side
   include (assuming your server understands the NCSA HTTPD server side include
   syntax).

1) To use as a cgi-bin script, include URLS of the form:
        <IMG src="/cgi-bin/wwwcount/dirname/file.ext?options">
  THIS MODE REQUIRES  THE RXGDUTIL LIBRARY, from  
  http://www.bearsoft.com/abs/rexxgd.html

2) To use as an EXEC server side include, include SSI elements of the form:
          <!-- #exec CMD=jcount?&options-->
 You can this mode to generate a text counter, or a sequence of IMG elements that link to
 graphical digits.

*****************************************************/

signal on syntax name anerr ; signal on error name anerr
/*    ---- BEGIN USER CONFIGURABLE PARAMETERS SECTION ----------  
       ---- BEGIN USER CONFIGURABLE PARAMETERS SECTION ----------

   WWW-Count is controlled by the options included in the request, and by the
   user configurable parameters set below.  
*/

/* Fully qualified name of directory in which to store .cnt files. 
   This is used when the CGI-BIN PATH_TRANSLATED variable is unspecified */
counter_dir='\www'

/* If you want to ignore PATH_TRANSLATED, and always put .CNT files in
the counter_dir (this may be a security/privacy measure), set no_path_translated=1 */
no_path_translated=0

/* Set the RELATIVE directory that contains the "digit images". This
   is used when an EXEC SSI call is used to create a graphics counter.
   REL_COUNTER_IMAGE_DIR is used to form IMG SRC=...   urls to be 
   included in the html document
   Note that each different set of "digits"  should  be in it's own directory.
   under the rel_counter_image_dir. */
rel_counter_image_dir ='/digits'

/* Set the FULLY QUALIFIED directory that contains the digit images.
   This is used when an IMG src=... is used to create a graphics counter.*/
abs_counter_image_dir ='\www\digits'

/* 1=create a .cnt file if none exists, 0=do not
   if the counter file (passed to counter.rxx) does not exist,
   and create_file=0, counter.rxx will exit without doing anything */
create_file=1

/* 1 = do NOT allow line breaks in strings of  "graphical digits". 
   0 = Allow line breaks within the string of "graphical digits"
     Note: if =1, the <NOBR>  element is used -- but note that webex 
            and other html 2.0  browsers ignore <NOBR>.*/
digits_nobr=1

/* store info on each request. 0=no, 1=yes. Can be overridded by a LOGUSERS option */
write_users=0

/* 1 = Supress the "log users" option (a logusers option will override write_users)
    0= do not suppress  */
suppress_logusers=0

/* suppress inrementing if request is from a same client within
   suppress_recent minutes. If 0, or if write_users=0, this is ignored */
suppress_recent=0


/* END of user-configurable parameters ***********************************/
/* END of user-configurable parameters ***********************************/
/* END of user-configurable parameters ***********************************/

/* Load up advanced REXX functions */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end

if counter_dir=0 then counter_dir=' '

if no_path_translated<>1 then do
  pinfot=value('PATH_TRANSLATED',,'os2environment')
  if pinfot<>'' then
     counter_dir=pinfot
end

if counter_dir=' ' then foo=is_done('Error: no COUNTER_DIR  ') /* is error will exit */
counter_dir=strip(translate(counter_dir,'\','/'),'t','\')||'\'

method=value('REQUEST_METHOD',,'os2environment')
optlist=''
if method='GET' then do
    optlist=value('QUERY_STRING',,'os2environment')
end
else do
   len = value("CONTENT_LENGTH",,'os2environment')
   if len<>"" then optlist = charin(,,len)
end
optlist=translate(optlist,' ','+&')
if optlist="" then foo=is_done('Error: no option list ')

if write_users<>1 then suppress_recent=0
if datatype(suppress_recent)<>'NUM' then suppress_recent=0


issilent=0 ; nocommas=0; maxval=21740000 ; ndigits=0 ; minval=0
rollover=0 ; doith=0 ; incit=1 ; dographic=0 ; writesel=' ' ; duration=0
align_type=0 ; suppress_logusers=0; cfile=0 ;workdir=abs_counter_image_dir
frameit=0
is_img=0 ; numval=""
do until optlist=""
  parse var optlist anarg optlist
  if pos('=',anarg)=0 then do
      avar='FILE' ; aval=strip(translate(anarg))
  end
  else do
     parse var anarg avar '=' aval ;                             
     avar=strip(translate(avar)); aval=strip(strip(aval),,'"')
  end
  select
     when abbrev(avar,"FIL")=1 then do
          foo=lastpos('.',aval) 
          if foo=0 then
             cfile=counter_dir||aval
          else
             cfile=counter_dir||delstr(aval,foo)
     end
     when avar="SILENT" then issilent=1
     when abbrev(avar,"NOCOM")=1 then nocommas=1
     when avar="MAX" then
        if datatype(aval)='NUM' then maxval=aval
     when abbrev(avar,"WID")=1 then
        if datatype(aval)='NUM' then ndigits=aval
     when avar="MIN" then
        if datatype(aval)='NUM' then minval=aval
     when avar="ROLLOVER" then rollover=1

     when abbrev(avar,"FR")=1 then frameit=1

     when abbrev(avar,"DUR")=1 then do
        if datatype(aval)='NUM' then duration=aval
     end

     when avar="ITH" then  doith=1

     when abbrev(avar,'VAL')=1 then do
           if datatype(strip(aval))='NUM' then numval=strip(aval)
     end /* do */

     when avar="IMGALIGN" then align_type=strip(aval)

     when avar="LOGUSERS" & suppress_logusers<>1 then do
         select
           when wordpos(translate(aval),'Y YES 1')>0 then write_users = 1
           when wordpos(translate(aval),'N NO 0')>0 then write_users = 0
           otherwise nop
         end
     end
     when abbrev(avar,"GRAPHIC")=1 | abbrev(avar,'DIGIT')=1 | abbrev(avar,'FONT')=1 then do
        select
          when aval=0 then dographic=0
          otherwise do
             dographic=9
             rel_counter_image_dir = strip(rel_counter_image_dir,'t','/')||'/'||strip(aval,,'/')
             abs_counter_image_dir=translate(abs_counter_image_dir,'\','/')||'\'
             aval=strip(translate(aval,'\','/'),,'\')||'\'
             abs_counter_image_dir =abs_counter_image_dir||aval
          end
        end
     end
     when abbrev(avar,'IMG') then is_img=1

     when abbrev(avar,"INC")=1 then do
        if datatype(aval)="NUM" then incit=aval
     end
     otherwise nop
   end
end
if dographic>0 then do
   nocommas=0 ;
   doith=0 ;
end

if  ndigits>0 then nocommas=1

if numval<>'' then do
    ctval=numval
    signal writenow
end /* do */



if cfile=0 then foo=is_done(' Error: no file name given ')

if pos('.',cfile)=0 then cfile=cfile||'.cnt'
cfile=translate(cfile,'\','/')

/* if create_file=1, then check for existence of cfile, and create
if missing */
if create_file=1 then do
  if stream(cfile,'c','query exists')=' ' then do
     foo=charout(cfile,'0  ',1)
     if foo>0 then fo=is_done(" Error creating counter file: " cfile)
     foo=stream(cfile,'c','close')
  end
end

/* read it in */
crlf = '0d0a'x
ause=open_read(cfile,30,'BOTH')
if ause<0 then fo=is_done(" Error opening counter file: " cfile)

lily=chars(cfile)
ause=strip(charin(cfile,1,lily),'t','1a'x)

/* got a file, let's parse it */
filelins.0=0
iz=0
do until ause=""
      parse  var ause eeo (crlf) ause
     iz=iz+1
     filelins.iz=strip(eeo)
end
if iz=0 then do
   iz=1
   filelins.1=0
end
filelins.0=iz
opstat=iz


/* find count */
ctval=0
do ip=1 to opstat
  aline0=translate(filelins.ip,' ','00090d0a'x)
  select
     when aline0=' ' then iterate
     when  abbrev(aline0,';') then iterate
     when datatype(aline0)='NUM' then do
          ctval0=aline0
          ctval=ctval0+INCIT
          CTVAL=Max(CTVAL,MINVAL) ;
          IF ROLLOVER=1 & CTVAL>MAXVAL THEN CTVAL=MINVAL
          CTVAL=Min(CTVAL,MAXVAL)
          ct_line=ip
          leave
     end
     otherwise iterate
   end
end
if ctval=0 then do
     ctval=minval+incit
     ctval0=ctval
     itmp=filelins.0+1
     filelins.0=itmp
     ct_line=itmp
end

numeric digits 12
d1=date('b')
t1=time('m')/(24*60)
nowtime=d1+t1
anaddr=value('REMOTE_ADDR',,'os2environment')
nowrite=0


/* no augment? */
if noaugment=1 then do
  nowrite=1 ; write_users=0
  ctval=ctval0
end


/* if suppress_recent, check before incrementing */
if suppress_recent>0 & write_users=1 then do
  chktime=nowtime-(suppress_recent/(24*60))
  do iy=filelins.0 to ct_line+1 by -1
     aline00=filelins.iy
     if aline00=' ' then iterate
     if abbrev(aline00,';') then iterate
     parse var aline00 anip  ajulian  .
     ajulian=strip(ajulian)
     if datatype(ajulian)<>"NUM" then iterate
     if ajulian < chktime then leave
     if strip(anip)=anaddr then do
         nowrite=1 ; ctval=ctval0; leave
     end
  end
end
if incit=0 then nowrite=1   /* increment=0 is a "no augment" signal */

filelins.ct_line=ctval          /* record "augmented?" count */

/* if "duration" is <> 0, then check entries (this is used to report
"hits in last week" */

if duration>0  then do
  if write_users<>1 then do
      ctval="000"
   end
   else do
     ctval=0
     chkdate=trunc(1+nowtime-duration)
     do iy=filelins.0 to ct_line+1 by -1
         aline00=filelins.iy
         if aline00=' ' then iterate
         if abbrev(aline00,';') then iterate
         parse var aline00 anip ',' ajulian ',' poop
         ajulian=trunc(strip(ajulian))
         if datatype(ajulian)<>"NUM" then iterate
         if ajulian < chkdate then leave
         ctval=ctval+1
      end
  end   /* write_users */
end  /* duration>0 */

if write_users>0 then do
   d1=space(strip(date('n')));
      parse var d1 d1a d1b d1c
      if d1a<10 then d1a='0'||d1a
      d1=d1a||'/'||d1b||'/'||d1c
   t1=time('n')
   d1t1=d1||':'||t1
   aline=anaddr||'  '||nowtime||' ['||d1t1||']'
   if write_users=1 then do
      ll=filelins.0+1
      filelins.ll=aline
      filelins.0=ll
   end  /* Do */
end

/* write out stuff */ 

if nowrite=0 then do
  stuff=filelins.1
  do mm=2 to filelins.0
     stuff=stuff||crlf||filelins.mm
  end
  stuff=stuff||'             '
  wow=charout(cfile,stuff,1)
  if wow>0 & verbose>0 then say " Warning: problem writing .CNT file: " wow
end
foo=stream(cfile,'c','close')

if issilent=1 then fo=is_done(' ')   /* just record, do not display */

writenow: nop            /* skip here if numval specified */

/* format ctval */
ctval=strip(ctval)
ctlen=length(ctval)

if ndigits>0 then do
    if ctlen<ndigits then do
        ctval=copies('0',ndigits-ctlen)||ctval
    end
end

if nocommas=0 then do
  il=length(ctval)
  if il>3 then do
      oop=""
      do mm=il to 3 by -3
         tt=substr(ctval,mm-2,3)
         if mm=il then
            oop=tt
         else
            oop=tt||','||oop
      end /* do */
      if mm<>0 then oop=substr(ctval,1,mm)||','||oop
      ctval=oop
  end
end

if doith=1 then do
  lval2=right(strip(ctval),2)
  if lval2>10 & lval2<20 then
        ctval=ctval||'th'
  else do
     lval=right(strip(ctval),1)
     select
       when lval=0 then  ctval=ctval||'th'
       when lval=1 then ctval=ctval||'st'
       when lval=2 then ctval=ctval||'nd'
       when lval=3 then ctval=ctval||'rd'
       otherwise ctval=ctval||'th'
     end
  end
end

if dographic=0 then fo=is_done(ctval)

/*  Ship image tags to the browser ?    */

if dographic=9 then do


   minlen = 5
   totalreads = ctval
   len = Length(totalreads)
   if ndigits > 0 then minlen = ndigits
   if len < minLen Then len = minlen
   formattedcount = right(totalreads, len, '0')
   if is_img=1 then do                  /*make_image will EXIT */
       foo=make_image(abs_counter_image_dir,formattedcount,len,workdir)
   end  /* Do */
   todo=''              /* else, it's an ssi */
   if digits_nobr=1 then todo='<NOBR>'
   if align_type="CENTER"  then align_type='MIDDLE'
   if wordpos(translate(align_type),"TOP BOTTOM MIDDLE")=0 then align_type='MIDDLE'
 
   if frameit=1 then 
        todo=todo||'<img src="'rel_counter_image_dir'/l.gif" alt="|" align="'align_type'">'
   do x = 1 to len
      digit = substr(formattedCount,x,1)
      if datatype(digit)='NUM' then 
        todo=todo||'<img src="'rel_counter_image_dir'/'digit'.gif" alt="'digit'" align="'align_type'">'
   end
   if frameit=1 then 
        todo=todo||'<img src="'rel_counter_image_dir'/r.gif" alt="|" align="'align_type'">'

   if digits_Nobr=1 then todo=todo||' </nobr>'
   fo=is_done(todo)
end

/******/
is_done:procedure
parse arg aval
say aval
exit 0


/* ----------------------------------------------------------------------- */
/* OPEN_READ: keep trying to open a file (for msec seconds
. Argumentes:
        afile == file to open
        msec == quit trying after msec seconds
        howopen = open mode (READ WRITE BOTH READ ) -- default is READ
  Returns
    Status, with values
        -1 = no such file
        -2 = error opening (say, NEW specified but file exists), or timeout
        >0 = seconds it took to open
*/
/* ----------------------------------------------------------------------- */

open_read:procedure
parse upper arg afile , msec , howopen .
debug=0

howopen=translate(howopen)

if afile=0 | afile="" then do
   if debug=1 then   say "OPEN_READ: No file name provided "
   return -1             /*no such file flat */
end

/* DISALLOW wildcarded files (they cause trouble below */
if pos('*',afile)>0 | pos('?',afile)>0 then do
    if debug=1 then  say "OPEN_READ: No wildcards allowed "
    return -1
end

isfile=stream(afile,'c','query exists') ;
if howopen="NEW"  then do
    if isfile="" then
        isfile=afile
    else do
        if debug=1 then  say "OPEN_READ: NEW file already exists "
       return -1
    end  /* Do */
end
else do
   if isfile=""  then do
       if debug=1 then  say 'OPEN_READ: Could not find ' afile
      return -1             /*no such file */
   end 
end

sec1=time('RESET')
foy=time('ELAPSED')

do until time('ELAPSED') > msec
    select
    when howopen='BOTH' then
       inuse=stream(isfile,'c','open')
    when howopen='WRITE'| howopen="NEW" then do
         inuse=stream(isfile,'c','open write')
    end
    otherwise do
        inuse=stream(isfile,'c','open read')
    end
    end
    if inuse<>'READY:' then do
        foo=syssleep(1)                  /* wait a second, and try again */
        iterate
      end
/* Else, it's openable */
    gog=time('ELAPSED')
    return gog+0.01
end
 if debug=1 then  say " OPEN_READ: no time "
return -2                /* could not open in alloted time */


/*****************/
/* create img/gif for return to IMG SRC=...  url */
make_image:procedure

parse arg cdir,ict,len,workdir
foo=rxfuncquery('rxgdloadfuncs')
if foo=1 then do
  Call RxFuncAdd 'RxgdLoadFuncs', 'RXGDUTIL', 'RxgdLoadFuncs'
  Call RxgdLoadFuncs
end
ii=rxfuncquery('rxgdimagecreate')
if ii<>0 then fo=is_done(' Error: RXGDUTIL not available')

nx=0; ny=0 ; igot=0
do x = 1 to len
   digit = substr(ict,x,1)
   afile=cdir||digit||'.gif'

   if stream(afile,'c','query exists')=' ' then iterate

   im=rxgdimagecreatefromgif(afile)

   if im=1 | im=0 then iterate
   igot=igot+1
   imlist.igot=im 
   imlist.igot.!x=rxgdimagesx(im)
   nx=nx+imlist.igot.!x
   imlist.igot.!y=rxgdimagesy(im)
   ny=max(ny,imlist.igot.!y)
end
/* ready to append */
if igot=0 then fo=is_done(' Error: no digits found ')
im2=rxgdimagecreate(nx,ny)
xat=0
do mm=1 to igot
    im1=imlist.mm
    xs=imlist.mm.!x ; ys=imlist.mm.!y
    foo=rxgdimagecopy(im2,im1,xat,0,0,0,xs,ys)
    xat=xat+xs
    oo=rxgdimagedestroy(im1)
end /* do */

gfile=systempfilename(strip(translate(workdir,'\','/'),'t','\')||'\TMP?????.GIF')

foo=rxgdimagegif(im2,gfile)
oo=rxgdimagedestroy(im2)
arf=charin(gfile,1,chars(gfile))
a=stream(gfile,'c','close')
a=sysfiledelete(gfile)

crlf='0d0a'x
arf='Content-type:image/gif'||crlf||'Content-length:'||length(arf)||crlf||crlf||arf
call charout,arf
exit 0


anerr:
say " error at " sigl
exit 0
