; Application : BBC386.ASM
; Description : BBC emulator for 386 MS-DOS based machines
; Author      : Stephen Quan, 119 Norma St, Howrah, Tasmania, Australia, 7018
; Date        : August 1994
;
.MODEL large
.386P
.STACK 1000h
;
; DS0000
;
; This assembly code does not have a data segment.
; All variables, and tables will be stored in the code segment.
;
.CODE
  jmp   @main
;
; CS0000 (INIT) - EMS memory definitions.
;
; This application requires 19 16K EMS page memory.  (ie 304K EMS)
; EMS pages 0..15 correspond to BBC sideways ram.
; EMS pages 16&17 correspond to the BBC RAM section.
; EMS page 18 is reserved for the operating system.
;
; The EMS page frame will be segmented as follows :
;   logical page 0 : BBC RAM 0000-3FFF (ie. EMS page 16).
;   logical page 1 : BBC RAM 4000-7FFF (ie. EMS page 17).
;   logical page 2 : BBC sideways RAM  (ie. EMS page 0..15 mapped here).
;   logical page 3 : BBC OS  C000-FFFF (ie. EMS page 18).
;
; Variables for EMS page and EMS handle.
;
@ems_page:
  dw    0
@ems_handle:
  dw    0
;
;
; CS0001 (INIT) - Sideways RAM latch.
;
; Sideways Ram latch (initialise holds the SRAM containing BASIC).
;
@sram_latch:
  db    0bh
;
@N0V0Z0C0:
  dw @BRK0   ,@ORAix0 ,@er0    ,@er0    ,@er0    ,@ORAzp0 ,@ASLzp0 ,@er0    
  dw @PHP0   ,@ORAim0 ,@ASLac0 ,@er0    ,@er0    ,@ORAab0 ,@ASLab0 ,@er0    
  dw @BPLre0 ,@ORAiy0 ,@er0    ,@er0    ,@er0    ,@ORAzx0 ,@ASLzx0 ,@er0    
  dw @CLC0   ,@ORAay0 ,@er0    ,@er0    ,@er0    ,@ORAax0 ,@ASLax0 ,@er0    
  dw @JSRab0 ,@ANDix0 ,@er0    ,@er0    ,@BITzp0 ,@ANDzp0 ,@ROLzp0 ,@er0    
  dw @PLP0   ,@ANDim0 ,@ROLac0 ,@er0    ,@BITab0 ,@ANDab0 ,@ROLab0 ,@er0    
  dw @BMIre0 ,@ANDiy0 ,@er0    ,@er0    ,@er0    ,@ANDzx0 ,@ROLzx0 ,@er0    
  dw @SEC0   ,@ANDay0 ,@er0    ,@er0    ,@er0    ,@ANDax0 ,@ROLax0 ,@er0    
  dw @RTI0   ,@EORix0 ,@er0    ,@er0    ,@er0    ,@EORzp0 ,@LSRzp0 ,@er0    
  dw @PHA0   ,@EORim0 ,@LSRac0 ,@er0    ,@JMPab0 ,@EORab0 ,@LSRab0 ,@er0    
  dw @BVCre0 ,@EORiy0 ,@er0    ,@er0    ,@er0    ,@EORzx0 ,@LSRzx0 ,@er0    
  dw @CLI0   ,@EORay0 ,@er0    ,@er0    ,@er0    ,@EORax0 ,@LSRax0 ,@er0    
  dw @RTS0   ,@ADCix0 ,@er0    ,@er0    ,@er0    ,@ADCzp0 ,@RORzp0 ,@er0    
  dw @PLA0   ,@ADCim0 ,@RORac0 ,@er0    ,@JMPid0 ,@ADCab0 ,@RORab0 ,@er0    
  dw @BVSre0 ,@ADCiy0 ,@er0    ,@er0    ,@er0    ,@ADCzx0 ,@RORzx0 ,@er0    
  dw @SEI0   ,@ADCay0 ,@er0    ,@er0    ,@er0    ,@ADCax0 ,@RORax0 ,@er0    
  dw @er0    ,@STAix0 ,@er0    ,@er0    ,@STYzp0 ,@STAzp0 ,@STXzp0 ,@er0    
  dw @DEY0   ,@er0    ,@TXA0   ,@er0    ,@STYab0 ,@STAab0 ,@STXab0 ,@er0    
  dw @BCCre0 ,@STAiy0 ,@er0    ,@er0    ,@STYzx0 ,@STAzx0 ,@STXzy0 ,@er0    
  dw @TYA0   ,@STAay0 ,@TXS0   ,@er0    ,@er0    ,@STAax0 ,@er0    ,@er0    
  dw @LDYim0 ,@LDAix0 ,@LDXim0 ,@er0    ,@LDYzp0 ,@LDAzp0 ,@LDXzp0 ,@er0    
  dw @TAY0   ,@LDAim0 ,@TAX0   ,@er0    ,@LDYab0 ,@LDAab0 ,@LDXab0 ,@er0    
  dw @BCSre0 ,@LDAiy0 ,@er0    ,@er0    ,@LDYzx0 ,@LDAzx0 ,@LDXzy0 ,@er0    
  dw @CLV0   ,@LDAay0 ,@TSX0   ,@er0    ,@LDYax0 ,@LDAax0 ,@LDXay0 ,@er0    
  dw @CPYim0 ,@CMPix0 ,@er0    ,@er0    ,@CPYzp0 ,@CMPzp0 ,@DECzp0 ,@er0    
  dw @INY0   ,@CMPim0 ,@DEX0   ,@er0    ,@CPYab0 ,@CMPab0 ,@DECab0 ,@er0    
  dw @BNEre0 ,@CMPiy0 ,@er0    ,@er0    ,@HACK0  ,@CMPzx0 ,@DECzx0 ,@er0
  dw @CLD0   ,@CMPay0 ,@er0    ,@er0    ,@er0    ,@CMPax0 ,@DECax0 ,@er0    
  dw @CPXim0 ,@SBCix0 ,@er0    ,@er0    ,@CPXzp0 ,@SBCzp0 ,@INCzp0 ,@er0    
  dw @INX0   ,@SBCim0 ,@NOP0   ,@er0    ,@CPXab0 ,@SBCab0 ,@INCab0 ,@er0    
  dw @BEQre0 ,@SBCiy0 ,@er0    ,@er0    ,@er0    ,@SBCzx0 ,@INCzx0 ,@er0    
  dw @SED0   ,@SBCay0 ,@er0    ,@er0    ,@er0    ,@SBCax0 ,@INCax0 ,@er0    

@N0V0Z0C1:
  dw @BRK1   ,@ORAix1 ,@er1    ,@er1    ,@er1    ,@ORAzp1 ,@ASLzp1 ,@er1    
  dw @PHP1   ,@ORAim1 ,@ASLac1 ,@er1    ,@er1    ,@ORAab1 ,@ASLab1 ,@er1    
  dw @BPLre1 ,@ORAiy1 ,@er1    ,@er1    ,@er1    ,@ORAzx1 ,@ASLzx1 ,@er1    
  dw @CLC1   ,@ORAay1 ,@er1    ,@er1    ,@er1    ,@ORAax1 ,@ASLax1 ,@er1    
  dw @JSRab1 ,@ANDix1 ,@er1    ,@er1    ,@BITzp1 ,@ANDzp1 ,@ROLzp1 ,@er1    
  dw @PLP1   ,@ANDim1 ,@ROLac1 ,@er1    ,@BITab1 ,@ANDab1 ,@ROLab1 ,@er1    
  dw @BMIre1 ,@ANDiy1 ,@er1    ,@er1    ,@er1    ,@ANDzx1 ,@ROLzx1 ,@er1    
  dw @SEC1   ,@ANDay1 ,@er1    ,@er1    ,@er1    ,@ANDax1 ,@ROLax1 ,@er1    
  dw @RTI1   ,@EORix1 ,@er1    ,@er1    ,@er1    ,@EORzp1 ,@LSRzp1 ,@er1    
  dw @PHA1   ,@EORim1 ,@LSRac1 ,@er1    ,@JMPab1 ,@EORab1 ,@LSRab1 ,@er1    
  dw @BVCre1 ,@EORiy1 ,@er1    ,@er1    ,@er1    ,@EORzx1 ,@LSRzx1 ,@er1    
  dw @CLI1   ,@EORay1 ,@er1    ,@er1    ,@er1    ,@EORax1 ,@LSRax1 ,@er1    
  dw @RTS1   ,@ADCix1 ,@er1    ,@er1    ,@er1    ,@ADCzp1 ,@RORzp1 ,@er1    
  dw @PLA1   ,@ADCim1 ,@RORac1 ,@er1    ,@JMPid1 ,@ADCab1 ,@RORab1 ,@er1    
  dw @BVSre1 ,@ADCiy1 ,@er1    ,@er1    ,@er1    ,@ADCzx1 ,@RORzx1 ,@er1    
  dw @SEI1   ,@ADCay1 ,@er1    ,@er1    ,@er1    ,@ADCax1 ,@RORax1 ,@er1    
  dw @er1    ,@STAix1 ,@er1    ,@er1    ,@STYzp1 ,@STAzp1 ,@STXzp1 ,@er1    
  dw @DEY1   ,@er1    ,@TXA1   ,@er1    ,@STYab1 ,@STAab1 ,@STXab1 ,@er1    
  dw @BCCre1 ,@STAiy1 ,@er1    ,@er1    ,@STYzx1 ,@STAzx1 ,@STXzy1 ,@er1    
  dw @TYA1   ,@STAay1 ,@TXS1   ,@er1    ,@er1    ,@STAax1 ,@er1    ,@er1    
  dw @LDYim1 ,@LDAix1 ,@LDXim1 ,@er1    ,@LDYzp1 ,@LDAzp1 ,@LDXzp1 ,@er1    
  dw @TAY1   ,@LDAim1 ,@TAX1   ,@er1    ,@LDYab1 ,@LDAab1 ,@LDXab1 ,@er1    
  dw @BCSre1 ,@LDAiy1 ,@er1    ,@er1    ,@LDYzx1 ,@LDAzx1 ,@LDXzy1 ,@er1    
  dw @CLV1   ,@LDAay1 ,@TSX1   ,@er1    ,@LDYax1 ,@LDAax1 ,@LDXay1 ,@er1    
  dw @CPYim1 ,@CMPix1 ,@er1    ,@er1    ,@CPYzp1 ,@CMPzp1 ,@DECzp1 ,@er1    
  dw @INY1   ,@CMPim1 ,@DEX1   ,@er1    ,@CPYab1 ,@CMPab1 ,@DECab1 ,@er1    
  dw @BNEre1 ,@CMPiy1 ,@er1    ,@er1    ,@HACK1  ,@CMPzx1 ,@DECzx1 ,@er1
  dw @CLD1   ,@CMPay1 ,@er1    ,@er1    ,@er1    ,@CMPax1 ,@DECax1 ,@er1    
  dw @CPXim1 ,@SBCix1 ,@er1    ,@er1    ,@CPXzp1 ,@SBCzp1 ,@INCzp1 ,@er1    
  dw @INX1   ,@SBCim1 ,@NOP1   ,@er1    ,@CPXab1 ,@SBCab1 ,@INCab1 ,@er1    
  dw @BEQre1 ,@SBCiy1 ,@er1    ,@er1    ,@er1    ,@SBCzx1 ,@INCzx1 ,@er1    
  dw @SED1   ,@SBCay1 ,@er1    ,@er1    ,@er1    ,@SBCax1 ,@INCax1 ,@er1    

@N0V0Z1C0:
  dw @BRK2   ,@ORAix2 ,@er2    ,@er2    ,@er2    ,@ORAzp2 ,@ASLzp2 ,@er2    
  dw @PHP2   ,@ORAim2 ,@ASLac2 ,@er2    ,@er2    ,@ORAab2 ,@ASLab2 ,@er2    
  dw @BPLre2 ,@ORAiy2 ,@er2    ,@er2    ,@er2    ,@ORAzx2 ,@ASLzx2 ,@er2    
  dw @CLC2   ,@ORAay2 ,@er2    ,@er2    ,@er2    ,@ORAax2 ,@ASLax2 ,@er2    
  dw @JSRab2 ,@ANDix2 ,@er2    ,@er2    ,@BITzp2 ,@ANDzp2 ,@ROLzp2 ,@er2    
  dw @PLP2   ,@ANDim2 ,@ROLac2 ,@er2    ,@BITab2 ,@ANDab2 ,@ROLab2 ,@er2    
  dw @BMIre2 ,@ANDiy2 ,@er2    ,@er2    ,@er2    ,@ANDzx2 ,@ROLzx2 ,@er2    
  dw @SEC2   ,@ANDay2 ,@er2    ,@er2    ,@er2    ,@ANDax2 ,@ROLax2 ,@er2    
  dw @RTI2   ,@EORix2 ,@er2    ,@er2    ,@er2    ,@EORzp2 ,@LSRzp2 ,@er2    
  dw @PHA2   ,@EORim2 ,@LSRac2 ,@er2    ,@JMPab2 ,@EORab2 ,@LSRab2 ,@er2    
  dw @BVCre2 ,@EORiy2 ,@er2    ,@er2    ,@er2    ,@EORzx2 ,@LSRzx2 ,@er2    
  dw @CLI2   ,@EORay2 ,@er2    ,@er2    ,@er2    ,@EORax2 ,@LSRax2 ,@er2    
  dw @RTS2   ,@ADCix2 ,@er2    ,@er2    ,@er2    ,@ADCzp2 ,@RORzp2 ,@er2    
  dw @PLA2   ,@ADCim2 ,@RORac2 ,@er2    ,@JMPid2 ,@ADCab2 ,@RORab2 ,@er2    
  dw @BVSre2 ,@ADCiy2 ,@er2    ,@er2    ,@er2    ,@ADCzx2 ,@RORzx2 ,@er2    
  dw @SEI2   ,@ADCay2 ,@er2    ,@er2    ,@er2    ,@ADCax2 ,@RORax2 ,@er2    
  dw @er2    ,@STAix2 ,@er2    ,@er2    ,@STYzp2 ,@STAzp2 ,@STXzp2 ,@er2    
  dw @DEY2   ,@er2    ,@TXA2   ,@er2    ,@STYab2 ,@STAab2 ,@STXab2 ,@er2    
  dw @BCCre2 ,@STAiy2 ,@er2    ,@er2    ,@STYzx2 ,@STAzx2 ,@STXzy2 ,@er2    
  dw @TYA2   ,@STAay2 ,@TXS2   ,@er2    ,@er2    ,@STAax2 ,@er2    ,@er2    
  dw @LDYim2 ,@LDAix2 ,@LDXim2 ,@er2    ,@LDYzp2 ,@LDAzp2 ,@LDXzp2 ,@er2    
  dw @TAY2   ,@LDAim2 ,@TAX2   ,@er2    ,@LDYab2 ,@LDAab2 ,@LDXab2 ,@er2    
  dw @BCSre2 ,@LDAiy2 ,@er2    ,@er2    ,@LDYzx2 ,@LDAzx2 ,@LDXzy2 ,@er2    
  dw @CLV2   ,@LDAay2 ,@TSX2   ,@er2    ,@LDYax2 ,@LDAax2 ,@LDXay2 ,@er2    
  dw @CPYim2 ,@CMPix2 ,@er2    ,@er2    ,@CPYzp2 ,@CMPzp2 ,@DECzp2 ,@er2    
  dw @INY2   ,@CMPim2 ,@DEX2   ,@er2    ,@CPYab2 ,@CMPab2 ,@DECab2 ,@er2    
  dw @BNEre2 ,@CMPiy2 ,@er2    ,@er2    ,@HACK2  ,@CMPzx2 ,@DECzx2 ,@er2
  dw @CLD2   ,@CMPay2 ,@er2    ,@er2    ,@er2    ,@CMPax2 ,@DECax2 ,@er2    
  dw @CPXim2 ,@SBCix2 ,@er2    ,@er2    ,@CPXzp2 ,@SBCzp2 ,@INCzp2 ,@er2    
  dw @INX2   ,@SBCim2 ,@NOP2   ,@er2    ,@CPXab2 ,@SBCab2 ,@INCab2 ,@er2    
  dw @BEQre2 ,@SBCiy2 ,@er2    ,@er2    ,@er2    ,@SBCzx2 ,@INCzx2 ,@er2    
  dw @SED2   ,@SBCay2 ,@er2    ,@er2    ,@er2    ,@SBCax2 ,@INCax2 ,@er2    

@N0V0Z1C1:
  dw @BRK3   ,@ORAix3 ,@er3    ,@er3    ,@er3    ,@ORAzp3 ,@ASLzp3 ,@er3    
  dw @PHP3   ,@ORAim3 ,@ASLac3 ,@er3    ,@er3    ,@ORAab3 ,@ASLab3 ,@er3    
  dw @BPLre3 ,@ORAiy3 ,@er3    ,@er3    ,@er3    ,@ORAzx3 ,@ASLzx3 ,@er3    
  dw @CLC3   ,@ORAay3 ,@er3    ,@er3    ,@er3    ,@ORAax3 ,@ASLax3 ,@er3    
  dw @JSRab3 ,@ANDix3 ,@er3    ,@er3    ,@BITzp3 ,@ANDzp3 ,@ROLzp3 ,@er3    
  dw @PLP3   ,@ANDim3 ,@ROLac3 ,@er3    ,@BITab3 ,@ANDab3 ,@ROLab3 ,@er3    
  dw @BMIre3 ,@ANDiy3 ,@er3    ,@er3    ,@er3    ,@ANDzx3 ,@ROLzx3 ,@er3    
  dw @SEC3   ,@ANDay3 ,@er3    ,@er3    ,@er3    ,@ANDax3 ,@ROLax3 ,@er3    
  dw @RTI3   ,@EORix3 ,@er3    ,@er3    ,@er3    ,@EORzp3 ,@LSRzp3 ,@er3    
  dw @PHA3   ,@EORim3 ,@LSRac3 ,@er3    ,@JMPab3 ,@EORab3 ,@LSRab3 ,@er3    
  dw @BVCre3 ,@EORiy3 ,@er3    ,@er3    ,@er3    ,@EORzx3 ,@LSRzx3 ,@er3    
  dw @CLI3   ,@EORay3 ,@er3    ,@er3    ,@er3    ,@EORax3 ,@LSRax3 ,@er3    
  dw @RTS3   ,@ADCix3 ,@er3    ,@er3    ,@er3    ,@ADCzp3 ,@RORzp3 ,@er3    
  dw @PLA3   ,@ADCim3 ,@RORac3 ,@er3    ,@JMPid3 ,@ADCab3 ,@RORab3 ,@er3    
  dw @BVSre3 ,@ADCiy3 ,@er3    ,@er3    ,@er3    ,@ADCzx3 ,@RORzx3 ,@er3    
  dw @SEI3   ,@ADCay3 ,@er3    ,@er3    ,@er3    ,@ADCax3 ,@RORax3 ,@er3    
  dw @er3    ,@STAix3 ,@er3    ,@er3    ,@STYzp3 ,@STAzp3 ,@STXzp3 ,@er3    
  dw @DEY3   ,@er3    ,@TXA3   ,@er3    ,@STYab3 ,@STAab3 ,@STXab3 ,@er3    
  dw @BCCre3 ,@STAiy3 ,@er3    ,@er3    ,@STYzx3 ,@STAzx3 ,@STXzy3 ,@er3    
  dw @TYA3   ,@STAay3 ,@TXS3   ,@er3    ,@er3    ,@STAax3 ,@er3    ,@er3    
  dw @LDYim3 ,@LDAix3 ,@LDXim3 ,@er3    ,@LDYzp3 ,@LDAzp3 ,@LDXzp3 ,@er3    
  dw @TAY3   ,@LDAim3 ,@TAX3   ,@er3    ,@LDYab3 ,@LDAab3 ,@LDXab3 ,@er3    
  dw @BCSre3 ,@LDAiy3 ,@er3    ,@er3    ,@LDYzx3 ,@LDAzx3 ,@LDXzy3 ,@er3    
  dw @CLV3   ,@LDAay3 ,@TSX3   ,@er3    ,@LDYax3 ,@LDAax3 ,@LDXay3 ,@er3    
  dw @CPYim3 ,@CMPix3 ,@er3    ,@er3    ,@CPYzp3 ,@CMPzp3 ,@DECzp3 ,@er3    
  dw @INY3   ,@CMPim3 ,@DEX3   ,@er3    ,@CPYab3 ,@CMPab3 ,@DECab3 ,@er3    
  dw @BNEre3 ,@CMPiy3 ,@er3    ,@er3    ,@HACK3  ,@CMPzx3 ,@DECzx3 ,@er3
  dw @CLD3   ,@CMPay3 ,@er3    ,@er3    ,@er3    ,@CMPax3 ,@DECax3 ,@er3    
  dw @CPXim3 ,@SBCix3 ,@er3    ,@er3    ,@CPXzp3 ,@SBCzp3 ,@INCzp3 ,@er3    
  dw @INX3   ,@SBCim3 ,@NOP3   ,@er3    ,@CPXab3 ,@SBCab3 ,@INCab3 ,@er3    
  dw @BEQre3 ,@SBCiy3 ,@er3    ,@er3    ,@er3    ,@SBCzx3 ,@INCzx3 ,@er3    
  dw @SED3   ,@SBCay3 ,@er3    ,@er3    ,@er3    ,@SBCax3 ,@INCax3 ,@er3    

@N0V1Z0C0:
  dw @BRK4   ,@ORAix4 ,@er4    ,@er4    ,@er4    ,@ORAzp4 ,@ASLzp4 ,@er4    
  dw @PHP4   ,@ORAim4 ,@ASLac4 ,@er4    ,@er4    ,@ORAab4 ,@ASLab4 ,@er4    
  dw @BPLre4 ,@ORAiy4 ,@er4    ,@er4    ,@er4    ,@ORAzx4 ,@ASLzx4 ,@er4    
  dw @CLC4   ,@ORAay4 ,@er4    ,@er4    ,@er4    ,@ORAax4 ,@ASLax4 ,@er4    
  dw @JSRab4 ,@ANDix4 ,@er4    ,@er4    ,@BITzp4 ,@ANDzp4 ,@ROLzp4 ,@er4    
  dw @PLP4   ,@ANDim4 ,@ROLac4 ,@er4    ,@BITab4 ,@ANDab4 ,@ROLab4 ,@er4    
  dw @BMIre4 ,@ANDiy4 ,@er4    ,@er4    ,@er4    ,@ANDzx4 ,@ROLzx4 ,@er4    
  dw @SEC4   ,@ANDay4 ,@er4    ,@er4    ,@er4    ,@ANDax4 ,@ROLax4 ,@er4    
  dw @RTI4   ,@EORix4 ,@er4    ,@er4    ,@er4    ,@EORzp4 ,@LSRzp4 ,@er4    
  dw @PHA4   ,@EORim4 ,@LSRac4 ,@er4    ,@JMPab4 ,@EORab4 ,@LSRab4 ,@er4    
  dw @BVCre4 ,@EORiy4 ,@er4    ,@er4    ,@er4    ,@EORzx4 ,@LSRzx4 ,@er4    
  dw @CLI4   ,@EORay4 ,@er4    ,@er4    ,@er4    ,@EORax4 ,@LSRax4 ,@er4    
  dw @RTS4   ,@ADCix4 ,@er4    ,@er4    ,@er4    ,@ADCzp4 ,@RORzp4 ,@er4    
  dw @PLA4   ,@ADCim4 ,@RORac4 ,@er4    ,@JMPid4 ,@ADCab4 ,@RORab4 ,@er4    
  dw @BVSre4 ,@ADCiy4 ,@er4    ,@er4    ,@er4    ,@ADCzx4 ,@RORzx4 ,@er4    
  dw @SEI4   ,@ADCay4 ,@er4    ,@er4    ,@er4    ,@ADCax4 ,@RORax4 ,@er4    
  dw @er4    ,@STAix4 ,@er4    ,@er4    ,@STYzp4 ,@STAzp4 ,@STXzp4 ,@er4    
  dw @DEY4   ,@er4    ,@TXA4   ,@er4    ,@STYab4 ,@STAab4 ,@STXab4 ,@er4    
  dw @BCCre4 ,@STAiy4 ,@er4    ,@er4    ,@STYzx4 ,@STAzx4 ,@STXzy4 ,@er4    
  dw @TYA4   ,@STAay4 ,@TXS4   ,@er4    ,@er4    ,@STAax4 ,@er4    ,@er4    
  dw @LDYim4 ,@LDAix4 ,@LDXim4 ,@er4    ,@LDYzp4 ,@LDAzp4 ,@LDXzp4 ,@er4    
  dw @TAY4   ,@LDAim4 ,@TAX4   ,@er4    ,@LDYab4 ,@LDAab4 ,@LDXab4 ,@er4    
  dw @BCSre4 ,@LDAiy4 ,@er4    ,@er4    ,@LDYzx4 ,@LDAzx4 ,@LDXzy4 ,@er4    
  dw @CLV4   ,@LDAay4 ,@TSX4   ,@er4    ,@LDYax4 ,@LDAax4 ,@LDXay4 ,@er4    
  dw @CPYim4 ,@CMPix4 ,@er4    ,@er4    ,@CPYzp4 ,@CMPzp4 ,@DECzp4 ,@er4    
  dw @INY4   ,@CMPim4 ,@DEX4   ,@er4    ,@CPYab4 ,@CMPab4 ,@DECab4 ,@er4    
  dw @BNEre4 ,@CMPiy4 ,@er4    ,@er4    ,@HACK4  ,@CMPzx4 ,@DECzx4 ,@er4
  dw @CLD4   ,@CMPay4 ,@er4    ,@er4    ,@er4    ,@CMPax4 ,@DECax4 ,@er4
  dw @CPXim4 ,@SBCix4 ,@er4    ,@er4    ,@CPXzp4 ,@SBCzp4 ,@INCzp4 ,@er4    
  dw @INX4   ,@SBCim4 ,@NOP4   ,@er4    ,@CPXab4 ,@SBCab4 ,@INCab4 ,@er4    
  dw @BEQre4 ,@SBCiy4 ,@er4    ,@er4    ,@er4    ,@SBCzx4 ,@INCzx4 ,@er4    
  dw @SED4   ,@SBCay4 ,@er4    ,@er4    ,@er4    ,@SBCax4 ,@INCax4 ,@er4    

@N0V1Z0C1:
  dw @BRK5   ,@ORAix5 ,@er5    ,@er5    ,@er5    ,@ORAzp5 ,@ASLzp5 ,@er5    
  dw @PHP5   ,@ORAim5 ,@ASLac5 ,@er5    ,@er5    ,@ORAab5 ,@ASLab5 ,@er5    
  dw @BPLre5 ,@ORAiy5 ,@er5    ,@er5    ,@er5    ,@ORAzx5 ,@ASLzx5 ,@er5    
  dw @CLC5   ,@ORAay5 ,@er5    ,@er5    ,@er5    ,@ORAax5 ,@ASLax5 ,@er5    
  dw @JSRab5 ,@ANDix5 ,@er5    ,@er5    ,@BITzp5 ,@ANDzp5 ,@ROLzp5 ,@er5    
  dw @PLP5   ,@ANDim5 ,@ROLac5 ,@er5    ,@BITab5 ,@ANDab5 ,@ROLab5 ,@er5    
  dw @BMIre5 ,@ANDiy5 ,@er5    ,@er5    ,@er5    ,@ANDzx5 ,@ROLzx5 ,@er5    
  dw @SEC5   ,@ANDay5 ,@er5    ,@er5    ,@er5    ,@ANDax5 ,@ROLax5 ,@er5    
  dw @RTI5   ,@EORix5 ,@er5    ,@er5    ,@er5    ,@EORzp5 ,@LSRzp5 ,@er5    
  dw @PHA5   ,@EORim5 ,@LSRac5 ,@er5    ,@JMPab5 ,@EORab5 ,@LSRab5 ,@er5    
  dw @BVCre5 ,@EORiy5 ,@er5    ,@er5    ,@er5    ,@EORzx5 ,@LSRzx5 ,@er5    
  dw @CLI5   ,@EORay5 ,@er5    ,@er5    ,@er5    ,@EORax5 ,@LSRax5 ,@er5    
  dw @RTS5   ,@ADCix5 ,@er5    ,@er5    ,@er5    ,@ADCzp5 ,@RORzp5 ,@er5    
  dw @PLA5   ,@ADCim5 ,@RORac5 ,@er5    ,@JMPid5 ,@ADCab5 ,@RORab5 ,@er5    
  dw @BVSre5 ,@ADCiy5 ,@er5    ,@er5    ,@er5    ,@ADCzx5 ,@RORzx5 ,@er5    
  dw @SEI5   ,@ADCay5 ,@er5    ,@er5    ,@er5    ,@ADCax5 ,@RORax5 ,@er5    
  dw @er5    ,@STAix5 ,@er5    ,@er5    ,@STYzp5 ,@STAzp5 ,@STXzp5 ,@er5    
  dw @DEY5   ,@er5    ,@TXA5   ,@er5    ,@STYab5 ,@STAab5 ,@STXab5 ,@er5    
  dw @BCCre5 ,@STAiy5 ,@er5    ,@er5    ,@STYzx5 ,@STAzx5 ,@STXzy5 ,@er5    
  dw @TYA5   ,@STAay5 ,@TXS5   ,@er5    ,@er5    ,@STAax5 ,@er5    ,@er5    
  dw @LDYim5 ,@LDAix5 ,@LDXim5 ,@er5    ,@LDYzp5 ,@LDAzp5 ,@LDXzp5 ,@er5    
  dw @TAY5   ,@LDAim5 ,@TAX5   ,@er5    ,@LDYab5 ,@LDAab5 ,@LDXab5 ,@er5    
  dw @BCSre5 ,@LDAiy5 ,@er5    ,@er5    ,@LDYzx5 ,@LDAzx5 ,@LDXzy5 ,@er5    
  dw @CLV5   ,@LDAay5 ,@TSX5   ,@er5    ,@LDYax5 ,@LDAax5 ,@LDXay5 ,@er5    
  dw @CPYim5 ,@CMPix5 ,@er5    ,@er5    ,@CPYzp5 ,@CMPzp5 ,@DECzp5 ,@er5    
  dw @INY5   ,@CMPim5 ,@DEX5   ,@er5    ,@CPYab5 ,@CMPab5 ,@DECab5 ,@er5    
  dw @BNEre5 ,@CMPiy5 ,@er5    ,@er5    ,@HACK5  ,@CMPzx5 ,@DECzx5 ,@er5
  dw @CLD5   ,@CMPay5 ,@er5    ,@er5    ,@er5    ,@CMPax5 ,@DECax5 ,@er5
  dw @CPXim5 ,@SBCix5 ,@er5    ,@er5    ,@CPXzp5 ,@SBCzp5 ,@INCzp5 ,@er5    
  dw @INX5   ,@SBCim5 ,@NOP5   ,@er5    ,@CPXab5 ,@SBCab5 ,@INCab5 ,@er5    
  dw @BEQre5 ,@SBCiy5 ,@er5    ,@er5    ,@er5    ,@SBCzx5 ,@INCzx5 ,@er5    
  dw @SED5   ,@SBCay5 ,@er5    ,@er5    ,@er5    ,@SBCax5 ,@INCax5 ,@er5    

@N0V1Z1C0:
  dw @BRK6   ,@ORAix6 ,@er6    ,@er6    ,@er6    ,@ORAzp6 ,@ASLzp6 ,@er6    
  dw @PHP6   ,@ORAim6 ,@ASLac6 ,@er6    ,@er6    ,@ORAab6 ,@ASLab6 ,@er6    
  dw @BPLre6 ,@ORAiy6 ,@er6    ,@er6    ,@er6    ,@ORAzx6 ,@ASLzx6 ,@er6    
  dw @CLC6   ,@ORAay6 ,@er6    ,@er6    ,@er6    ,@ORAax6 ,@ASLax6 ,@er6    
  dw @JSRab6 ,@ANDix6 ,@er6    ,@er6    ,@BITzp6 ,@ANDzp6 ,@ROLzp6 ,@er6    
  dw @PLP6   ,@ANDim6 ,@ROLac6 ,@er6    ,@BITab6 ,@ANDab6 ,@ROLab6 ,@er6    
  dw @BMIre6 ,@ANDiy6 ,@er6    ,@er6    ,@er6    ,@ANDzx6 ,@ROLzx6 ,@er6    
  dw @SEC6   ,@ANDay6 ,@er6    ,@er6    ,@er6    ,@ANDax6 ,@ROLax6 ,@er6    
  dw @RTI6   ,@EORix6 ,@er6    ,@er6    ,@er6    ,@EORzp6 ,@LSRzp6 ,@er6    
  dw @PHA6   ,@EORim6 ,@LSRac6 ,@er6    ,@JMPab6 ,@EORab6 ,@LSRab6 ,@er6    
  dw @BVCre6 ,@EORiy6 ,@er6    ,@er6    ,@er6    ,@EORzx6 ,@LSRzx6 ,@er6    
  dw @CLI6   ,@EORay6 ,@er6    ,@er6    ,@er6    ,@EORax6 ,@LSRax6 ,@er6    
  dw @RTS6   ,@ADCix6 ,@er6    ,@er6    ,@er6    ,@ADCzp6 ,@RORzp6 ,@er6    
  dw @PLA6   ,@ADCim6 ,@RORac6 ,@er6    ,@JMPid6 ,@ADCab6 ,@RORab6 ,@er6    
  dw @BVSre6 ,@ADCiy6 ,@er6    ,@er6    ,@er6    ,@ADCzx6 ,@RORzx6 ,@er6    
  dw @SEI6   ,@ADCay6 ,@er6    ,@er6    ,@er6    ,@ADCax6 ,@RORax6 ,@er6    
  dw @er6    ,@STAix6 ,@er6    ,@er6    ,@STYzp6 ,@STAzp6 ,@STXzp6 ,@er6    
  dw @DEY6   ,@er6    ,@TXA6   ,@er6    ,@STYab6 ,@STAab6 ,@STXab6 ,@er6    
  dw @BCCre6 ,@STAiy6 ,@er6    ,@er6    ,@STYzx6 ,@STAzx6 ,@STXzy6 ,@er6    
  dw @TYA6   ,@STAay6 ,@TXS6   ,@er6    ,@er6    ,@STAax6 ,@er6    ,@er6    
  dw @LDYim6 ,@LDAix6 ,@LDXim6 ,@er6    ,@LDYzp6 ,@LDAzp6 ,@LDXzp6 ,@er6    
  dw @TAY6   ,@LDAim6 ,@TAX6   ,@er6    ,@LDYab6 ,@LDAab6 ,@LDXab6 ,@er6    
  dw @BCSre6 ,@LDAiy6 ,@er6    ,@er6    ,@LDYzx6 ,@LDAzx6 ,@LDXzy6 ,@er6    
  dw @CLV6   ,@LDAay6 ,@TSX6   ,@er6    ,@LDYax6 ,@LDAax6 ,@LDXay6 ,@er6    
  dw @CPYim6 ,@CMPix6 ,@er6    ,@er6    ,@CPYzp6 ,@CMPzp6 ,@DECzp6 ,@er6    
  dw @INY6   ,@CMPim6 ,@DEX6   ,@er6    ,@CPYab6 ,@CMPab6 ,@DECab6 ,@er6    
  dw @BNEre6 ,@CMPiy6 ,@er6    ,@er6    ,@HACK6  ,@CMPzx6 ,@DECzx6 ,@er6
  dw @CLD6   ,@CMPay6 ,@er6    ,@er6    ,@er6    ,@CMPax6 ,@DECax6 ,@er6    
  dw @CPXim6 ,@SBCix6 ,@er6    ,@er6    ,@CPXzp6 ,@SBCzp6 ,@INCzp6 ,@er6    
  dw @INX6   ,@SBCim6 ,@NOP6   ,@er6    ,@CPXab6 ,@SBCab6 ,@INCab6 ,@er6    
  dw @BEQre6 ,@SBCiy6 ,@er6    ,@er6    ,@er6    ,@SBCzx6 ,@INCzx6 ,@er6    
  dw @SED6   ,@SBCay6 ,@er6    ,@er6    ,@er6    ,@SBCax6 ,@INCax6 ,@er6    

@N0V1Z1C1:
  dw @BRK7   ,@ORAix7 ,@er7    ,@er7    ,@er7    ,@ORAzp7 ,@ASLzp7 ,@er7    
  dw @PHP7   ,@ORAim7 ,@ASLac7 ,@er7    ,@er7    ,@ORAab7 ,@ASLab7 ,@er7    
  dw @BPLre7 ,@ORAiy7 ,@er7    ,@er7    ,@er7    ,@ORAzx7 ,@ASLzx7 ,@er7    
  dw @CLC7   ,@ORAay7 ,@er7    ,@er7    ,@er7    ,@ORAax7 ,@ASLax7 ,@er7    
  dw @JSRab7 ,@ANDix7 ,@er7    ,@er7    ,@BITzp7 ,@ANDzp7 ,@ROLzp7 ,@er7    
  dw @PLP7   ,@ANDim7 ,@ROLac7 ,@er7    ,@BITab7 ,@ANDab7 ,@ROLab7 ,@er7    
  dw @BMIre7 ,@ANDiy7 ,@er7    ,@er7    ,@er7    ,@ANDzx7 ,@ROLzx7 ,@er7    
  dw @SEC7   ,@ANDay7 ,@er7    ,@er7    ,@er7    ,@ANDax7 ,@ROLax7 ,@er7    
  dw @RTI7   ,@EORix7 ,@er7    ,@er7    ,@er7    ,@EORzp7 ,@LSRzp7 ,@er7    
  dw @PHA7   ,@EORim7 ,@LSRac7 ,@er7    ,@JMPab7 ,@EORab7 ,@LSRab7 ,@er7    
  dw @BVCre7 ,@EORiy7 ,@er7    ,@er7    ,@er7    ,@EORzx7 ,@LSRzx7 ,@er7    
  dw @CLI7   ,@EORay7 ,@er7    ,@er7    ,@er7    ,@EORax7 ,@LSRax7 ,@er7    
  dw @RTS7   ,@ADCix7 ,@er7    ,@er7    ,@er7    ,@ADCzp7 ,@RORzp7 ,@er7    
  dw @PLA7   ,@ADCim7 ,@RORac7 ,@er7    ,@JMPid7 ,@ADCab7 ,@RORab7 ,@er7    
  dw @BVSre7 ,@ADCiy7 ,@er7    ,@er7    ,@er7    ,@ADCzx7 ,@RORzx7 ,@er7    
  dw @SEI7   ,@ADCay7 ,@er7    ,@er7    ,@er7    ,@ADCax7 ,@RORax7 ,@er7    
  dw @er7    ,@STAix7 ,@er7    ,@er7    ,@STYzp7 ,@STAzp7 ,@STXzp7 ,@er7    
  dw @DEY7   ,@er7    ,@TXA7   ,@er7    ,@STYab7 ,@STAab7 ,@STXab7 ,@er7    
  dw @BCCre7 ,@STAiy7 ,@er7    ,@er7    ,@STYzx7 ,@STAzx7 ,@STXzy7 ,@er7    
  dw @TYA7   ,@STAay7 ,@TXS7   ,@er7    ,@er7    ,@STAax7 ,@er7    ,@er7    
  dw @LDYim7 ,@LDAix7 ,@LDXim7 ,@er7    ,@LDYzp7 ,@LDAzp7 ,@LDXzp7 ,@er7    
  dw @TAY7   ,@LDAim7 ,@TAX7   ,@er7    ,@LDYab7 ,@LDAab7 ,@LDXab7 ,@er7    
  dw @BCSre7 ,@LDAiy7 ,@er7    ,@er7    ,@LDYzx7 ,@LDAzx7 ,@LDXzy7 ,@er7    
  dw @CLV7   ,@LDAay7 ,@TSX7   ,@er7    ,@LDYax7 ,@LDAax7 ,@LDXay7 ,@er7    
  dw @CPYim7 ,@CMPix7 ,@er7    ,@er7    ,@CPYzp7 ,@CMPzp7 ,@DECzp7 ,@er7    
  dw @INY7   ,@CMPim7 ,@DEX7   ,@er7    ,@CPYab7 ,@CMPab7 ,@DECab7 ,@er7    
  dw @BNEre7 ,@CMPiy7 ,@er7    ,@er7    ,@HACK7  ,@CMPzx7 ,@DECzx7 ,@er7
  dw @CLD7   ,@CMPay7 ,@er7    ,@er7    ,@er7    ,@CMPax7 ,@DECax7 ,@er7    
  dw @CPXim7 ,@SBCix7 ,@er7    ,@er7    ,@CPXzp7 ,@SBCzp7 ,@INCzp7 ,@er7    
  dw @INX7   ,@SBCim7 ,@NOP7   ,@er7    ,@CPXab7 ,@SBCab7 ,@INCab7 ,@er7    
  dw @BEQre7 ,@SBCiy7 ,@er7    ,@er7    ,@er7    ,@SBCzx7 ,@INCzx7 ,@er7    
  dw @SED7   ,@SBCay7 ,@er7    ,@er7    ,@er7    ,@SBCax7 ,@INCax7 ,@er7    

@N1V0Z0C0:
  dw @BRK8   ,@ORAix8 ,@er8    ,@er8    ,@er8    ,@ORAzp8 ,@ASLzp8 ,@er8    
  dw @PHP8   ,@ORAim8 ,@ASLac8 ,@er8    ,@er8    ,@ORAab8 ,@ASLab8 ,@er8    
  dw @BPLre8 ,@ORAiy8 ,@er8    ,@er8    ,@er8    ,@ORAzx8 ,@ASLzx8 ,@er8    
  dw @CLC8   ,@ORAay8 ,@er8    ,@er8    ,@er8    ,@ORAax8 ,@ASLax8 ,@er8    
  dw @JSRab8 ,@ANDix8 ,@er8    ,@er8    ,@BITzp8 ,@ANDzp8 ,@ROLzp8 ,@er8    
  dw @PLP8   ,@ANDim8 ,@ROLac8 ,@er8    ,@BITab8 ,@ANDab8 ,@ROLab8 ,@er8    
  dw @BMIre8 ,@ANDiy8 ,@er8    ,@er8    ,@er8    ,@ANDzx8 ,@ROLzx8 ,@er8    
  dw @SEC8   ,@ANDay8 ,@er8    ,@er8    ,@er8    ,@ANDax8 ,@ROLax8 ,@er8    
  dw @RTI8   ,@EORix8 ,@er8    ,@er8    ,@er8    ,@EORzp8 ,@LSRzp8 ,@er8    
  dw @PHA8   ,@EORim8 ,@LSRac8 ,@er8    ,@JMPab8 ,@EORab8 ,@LSRab8 ,@er8    
  dw @BVCre8 ,@EORiy8 ,@er8    ,@er8    ,@er8    ,@EORzx8 ,@LSRzx8 ,@er8    
  dw @CLI8   ,@EORay8 ,@er8    ,@er8    ,@er8    ,@EORax8 ,@LSRax8 ,@er8    
  dw @RTS8   ,@ADCix8 ,@er8    ,@er8    ,@er8    ,@ADCzp8 ,@RORzp8 ,@er8    
  dw @PLA8   ,@ADCim8 ,@RORac8 ,@er8    ,@JMPid8 ,@ADCab8 ,@RORab8 ,@er8    
  dw @BVSre8 ,@ADCiy8 ,@er8    ,@er8    ,@er8    ,@ADCzx8 ,@RORzx8 ,@er8    
  dw @SEI8   ,@ADCay8 ,@er8    ,@er8    ,@er8    ,@ADCax8 ,@RORax8 ,@er8    
  dw @er8    ,@STAix8 ,@er8    ,@er8    ,@STYzp8 ,@STAzp8 ,@STXzp8 ,@er8    
  dw @DEY8   ,@er8    ,@TXA8   ,@er8    ,@STYab8 ,@STAab8 ,@STXab8 ,@er8    
  dw @BCCre8 ,@STAiy8 ,@er8    ,@er8    ,@STYzx8 ,@STAzx8 ,@STXzy8 ,@er8    
  dw @TYA8   ,@STAay8 ,@TXS8   ,@er8    ,@er8    ,@STAax8 ,@er8    ,@er8    
  dw @LDYim8 ,@LDAix8 ,@LDXim8 ,@er8    ,@LDYzp8 ,@LDAzp8 ,@LDXzp8 ,@er8    
  dw @TAY8   ,@LDAim8 ,@TAX8   ,@er8    ,@LDYab8 ,@LDAab8 ,@LDXab8 ,@er8    
  dw @BCSre8 ,@LDAiy8 ,@er8    ,@er8    ,@LDYzx8 ,@LDAzx8 ,@LDXzy8 ,@er8    
  dw @CLV8   ,@LDAay8 ,@TSX8   ,@er8    ,@LDYax8 ,@LDAax8 ,@LDXay8 ,@er8    
  dw @CPYim8 ,@CMPix8 ,@er8    ,@er8    ,@CPYzp8 ,@CMPzp8 ,@DECzp8 ,@er8    
  dw @INY8   ,@CMPim8 ,@DEX8   ,@er8    ,@CPYab8 ,@CMPab8 ,@DECab8 ,@er8    
  dw @BNEre8 ,@CMPiy8 ,@er8    ,@er8    ,@HACK8  ,@CMPzx8 ,@DECzx8 ,@er8
  dw @CLD8   ,@CMPay8 ,@er8    ,@er8    ,@er8    ,@CMPax8 ,@DECax8 ,@er8    
  dw @CPXim8 ,@SBCix8 ,@er8    ,@er8    ,@CPXzp8 ,@SBCzp8 ,@INCzp8 ,@er8    
  dw @INX8   ,@SBCim8 ,@NOP8   ,@er8    ,@CPXab8 ,@SBCab8 ,@INCab8 ,@er8    
  dw @BEQre8 ,@SBCiy8 ,@er8    ,@er8    ,@er8    ,@SBCzx8 ,@INCzx8 ,@er8    
  dw @SED8   ,@SBCay8 ,@er8    ,@er8    ,@er8    ,@SBCax8 ,@INCax8 ,@er8    

@N1V0Z0C1:
  dw @BRK9   ,@ORAix9 ,@er9    ,@er9    ,@er9    ,@ORAzp9 ,@ASLzp9 ,@er9    
  dw @PHP9   ,@ORAim9 ,@ASLac9 ,@er9    ,@er9    ,@ORAab9 ,@ASLab9 ,@er9    
  dw @BPLre9 ,@ORAiy9 ,@er9    ,@er9    ,@er9    ,@ORAzx9 ,@ASLzx9 ,@er9    
  dw @CLC9   ,@ORAay9 ,@er9    ,@er9    ,@er9    ,@ORAax9 ,@ASLax9 ,@er9    
  dw @JSRab9 ,@ANDix9 ,@er9    ,@er9    ,@BITzp9 ,@ANDzp9 ,@ROLzp9 ,@er9    
  dw @PLP9   ,@ANDim9 ,@ROLac9 ,@er9    ,@BITab9 ,@ANDab9 ,@ROLab9 ,@er9    
  dw @BMIre9 ,@ANDiy9 ,@er9    ,@er9    ,@er9    ,@ANDzx9 ,@ROLzx9 ,@er9    
  dw @SEC9   ,@ANDay9 ,@er9    ,@er9    ,@er9    ,@ANDax9 ,@ROLax9 ,@er9    
  dw @RTI9   ,@EORix9 ,@er9    ,@er9    ,@er9    ,@EORzp9 ,@LSRzp9 ,@er9    
  dw @PHA9   ,@EORim9 ,@LSRac9 ,@er9    ,@JMPab9 ,@EORab9 ,@LSRab9 ,@er9    
  dw @BVCre9 ,@EORiy9 ,@er9    ,@er9    ,@er9    ,@EORzx9 ,@LSRzx9 ,@er9    
  dw @CLI9   ,@EORay9 ,@er9    ,@er9    ,@er9    ,@EORax9 ,@LSRax9 ,@er9    
  dw @RTS9   ,@ADCix9 ,@er9    ,@er9    ,@er9    ,@ADCzp9 ,@RORzp9 ,@er9    
  dw @PLA9   ,@ADCim9 ,@RORac9 ,@er9    ,@JMPid9 ,@ADCab9 ,@RORab9 ,@er9    
  dw @BVSre9 ,@ADCiy9 ,@er9    ,@er9    ,@er9    ,@ADCzx9 ,@RORzx9 ,@er9    
  dw @SEI9   ,@ADCay9 ,@er9    ,@er9    ,@er9    ,@ADCax9 ,@RORax9 ,@er9    
  dw @er9    ,@STAix9 ,@er9    ,@er9    ,@STYzp9 ,@STAzp9 ,@STXzp9 ,@er9    
  dw @DEY9   ,@er9    ,@TXA9   ,@er9    ,@STYab9 ,@STAab9 ,@STXab9 ,@er9    
  dw @BCCre9 ,@STAiy9 ,@er9    ,@er9    ,@STYzx9 ,@STAzx9 ,@STXzy9 ,@er9    
  dw @TYA9   ,@STAay9 ,@TXS9   ,@er9    ,@er9    ,@STAax9 ,@er9    ,@er9    
  dw @LDYim9 ,@LDAix9 ,@LDXim9 ,@er9    ,@LDYzp9 ,@LDAzp9 ,@LDXzp9 ,@er9    
  dw @TAY9   ,@LDAim9 ,@TAX9   ,@er9    ,@LDYab9 ,@LDAab9 ,@LDXab9 ,@er9    
  dw @BCSre9 ,@LDAiy9 ,@er9    ,@er9    ,@LDYzx9 ,@LDAzx9 ,@LDXzy9 ,@er9    
  dw @CLV9   ,@LDAay9 ,@TSX9   ,@er9    ,@LDYax9 ,@LDAax9 ,@LDXay9 ,@er9    
  dw @CPYim9 ,@CMPix9 ,@er9    ,@er9    ,@CPYzp9 ,@CMPzp9 ,@DECzp9 ,@er9    
  dw @INY9   ,@CMPim9 ,@DEX9   ,@er9    ,@CPYab9 ,@CMPab9 ,@DECab9 ,@er9    
  dw @BNEre9 ,@CMPiy9 ,@er9    ,@er9    ,@HACK9  ,@CMPzx9 ,@DECzx9 ,@er9
  dw @CLD9   ,@CMPay9 ,@er9    ,@er9    ,@er9    ,@CMPax9 ,@DECax9 ,@er9
  dw @CPXim9 ,@SBCix9 ,@er9    ,@er9    ,@CPXzp9 ,@SBCzp9 ,@INCzp9 ,@er9
  dw @INX9   ,@SBCim9 ,@NOP9   ,@er9    ,@CPXab9 ,@SBCab9 ,@INCab9 ,@er9
  dw @BEQre9 ,@SBCiy9 ,@er9    ,@er9    ,@er9    ,@SBCzx9 ,@INCzx9 ,@er9
  dw @SED9   ,@SBCay9 ,@er9    ,@er9    ,@er9    ,@SBCax9 ,@INCax9 ,@er9

@N1V0Z1C0:
  dw @BRKa   ,@ORAixa ,@era    ,@era    ,@era    ,@ORAzpa ,@ASLzpa ,@era    
  dw @PHPa   ,@ORAima ,@ASLaca ,@era    ,@era    ,@ORAaba ,@ASLaba ,@era    
  dw @BPLrea ,@ORAiya ,@era    ,@era    ,@era    ,@ORAzxa ,@ASLzxa ,@era    
  dw @CLCa   ,@ORAaya ,@era    ,@era    ,@era    ,@ORAaxa ,@ASLaxa ,@era    
  dw @JSRaba ,@ANDixa ,@era    ,@era    ,@BITzpa ,@ANDzpa ,@ROLzpa ,@era    
  dw @PLPa   ,@ANDima ,@ROLaca ,@era    ,@BITaba ,@ANDaba ,@ROLaba ,@era    
  dw @BMIrea ,@ANDiya ,@era    ,@era    ,@era    ,@ANDzxa ,@ROLzxa ,@era    
  dw @SECa   ,@ANDaya ,@era    ,@era    ,@era    ,@ANDaxa ,@ROLaxa ,@era    
  dw @RTIa   ,@EORixa ,@era    ,@era    ,@era    ,@EORzpa ,@LSRzpa ,@era    
  dw @PHAa   ,@EORima ,@LSRaca ,@era    ,@JMPaba ,@EORaba ,@LSRaba ,@era    
  dw @BVCrea ,@EORiya ,@era    ,@era    ,@era    ,@EORzxa ,@LSRzxa ,@era    
  dw @CLIa   ,@EORaya ,@era    ,@era    ,@era    ,@EORaxa ,@LSRaxa ,@era    
  dw @RTSa   ,@ADCixa ,@era    ,@era    ,@era    ,@ADCzpa ,@RORzpa ,@era    
  dw @PLAa   ,@ADCima ,@RORaca ,@era    ,@JMPida ,@ADCaba ,@RORaba ,@era    
  dw @BVSrea ,@ADCiya ,@era    ,@era    ,@era    ,@ADCzxa ,@RORzxa ,@era    
  dw @SEIa   ,@ADCaya ,@era    ,@era    ,@era    ,@ADCaxa ,@RORaxa ,@era    
  dw @era    ,@STAixa ,@era    ,@era    ,@STYzpa ,@STAzpa ,@STXzpa ,@era    
  dw @DEYa   ,@era    ,@TXAa   ,@era    ,@STYaba ,@STAaba ,@STXaba ,@era    
  dw @BCCrea ,@STAiya ,@era    ,@era    ,@STYzxa ,@STAzxa ,@STXzya ,@era    
  dw @TYAa   ,@STAaya ,@TXSa   ,@era    ,@era    ,@STAaxa ,@era    ,@era    
  dw @LDYima ,@LDAixa ,@LDXima ,@era    ,@LDYzpa ,@LDAzpa ,@LDXzpa ,@era    
  dw @TAYa   ,@LDAima ,@TAXa   ,@era    ,@LDYaba ,@LDAaba ,@LDXaba ,@era    
  dw @BCSrea ,@LDAiya ,@era    ,@era    ,@LDYzxa ,@LDAzxa ,@LDXzya ,@era    
  dw @CLVa   ,@LDAaya ,@TSXa   ,@era    ,@LDYaxa ,@LDAaxa ,@LDXaya ,@era    
  dw @CPYima ,@CMPixa ,@era    ,@era    ,@CPYzpa ,@CMPzpa ,@DECzpa ,@era    
  dw @INYa   ,@CMPima ,@DEXa   ,@era    ,@CPYaba ,@CMPaba ,@DECaba ,@era    
  dw @BNErea ,@CMPiya ,@era    ,@era    ,@HACKa  ,@CMPzxa ,@DECzxa ,@era
  dw @CLDa   ,@CMPaya ,@era    ,@era    ,@era    ,@CMPaxa ,@DECaxa ,@era    
  dw @CPXima ,@SBCixa ,@era    ,@era    ,@CPXzpa ,@SBCzpa ,@INCzpa ,@era    
  dw @INXa   ,@SBCima ,@NOPa   ,@era    ,@CPXaba ,@SBCaba ,@INCaba ,@era    
  dw @BEQrea ,@SBCiya ,@era    ,@era    ,@era    ,@SBCzxa ,@INCzxa ,@era    
  dw @SEDa   ,@SBCaya ,@era    ,@era    ,@era    ,@SBCaxa ,@INCaxa ,@era    

@N1V0Z1C1:
  dw @BRKb   ,@ORAixb ,@erb    ,@erb    ,@erb    ,@ORAzpb ,@ASLzpb ,@erb    
  dw @PHPb   ,@ORAimb ,@ASLacb ,@erb    ,@erb    ,@ORAabb ,@ASLabb ,@erb    
  dw @BPLreb ,@ORAiyb ,@erb    ,@erb    ,@erb    ,@ORAzxb ,@ASLzxb ,@erb    
  dw @CLCb   ,@ORAayb ,@erb    ,@erb    ,@erb    ,@ORAaxb ,@ASLaxb ,@erb    
  dw @JSRabb ,@ANDixb ,@erb    ,@erb    ,@BITzpb ,@ANDzpb ,@ROLzpb ,@erb    
  dw @PLPb   ,@ANDimb ,@ROLacb ,@erb    ,@BITabb ,@ANDabb ,@ROLabb ,@erb    
  dw @BMIreb ,@ANDiyb ,@erb    ,@erb    ,@erb    ,@ANDzxb ,@ROLzxb ,@erb    
  dw @SECb   ,@ANDayb ,@erb    ,@erb    ,@erb    ,@ANDaxb ,@ROLaxb ,@erb    
  dw @RTIb   ,@EORixb ,@erb    ,@erb    ,@erb    ,@EORzpb ,@LSRzpb ,@erb    
  dw @PHAb   ,@EORimb ,@LSRacb ,@erb    ,@JMPabb ,@EORabb ,@LSRabb ,@erb    
  dw @BVCreb ,@EORiyb ,@erb    ,@erb    ,@erb    ,@EORzxb ,@LSRzxb ,@erb    
  dw @CLIb   ,@EORayb ,@erb    ,@erb    ,@erb    ,@EORaxb ,@LSRaxb ,@erb    
  dw @RTSb   ,@ADCixb ,@erb    ,@erb    ,@erb    ,@ADCzpb ,@RORzpb ,@erb    
  dw @PLAb   ,@ADCimb ,@RORacb ,@erb    ,@JMPidb ,@ADCabb ,@RORabb ,@erb    
  dw @BVSreb ,@ADCiyb ,@erb    ,@erb    ,@erb    ,@ADCzxb ,@RORzxb ,@erb    
  dw @SEIb   ,@ADCayb ,@erb    ,@erb    ,@erb    ,@ADCaxb ,@RORaxb ,@erb    
  dw @erb    ,@STAixb ,@erb    ,@erb    ,@STYzpb ,@STAzpb ,@STXzpb ,@erb    
  dw @DEYb   ,@erb    ,@TXAb   ,@erb    ,@STYabb ,@STAabb ,@STXabb ,@erb    
  dw @BCCreb ,@STAiyb ,@erb    ,@erb    ,@STYzxb ,@STAzxb ,@STXzyb ,@erb    
  dw @TYAb   ,@STAayb ,@TXSb   ,@erb    ,@erb    ,@STAaxb ,@erb    ,@erb    
  dw @LDYimb ,@LDAixb ,@LDXimb ,@erb    ,@LDYzpb ,@LDAzpb ,@LDXzpb ,@erb    
  dw @TAYb   ,@LDAimb ,@TAXb   ,@erb    ,@LDYabb ,@LDAabb ,@LDXabb ,@erb    
  dw @BCSreb ,@LDAiyb ,@erb    ,@erb    ,@LDYzxb ,@LDAzxb ,@LDXzyb ,@erb    
  dw @CLVb   ,@LDAayb ,@TSXb   ,@erb    ,@LDYaxb ,@LDAaxb ,@LDXayb ,@erb    
  dw @CPYimb ,@CMPixb ,@erb    ,@erb    ,@CPYzpb ,@CMPzpb ,@DECzpb ,@erb    
  dw @INYb   ,@CMPimb ,@DEXb   ,@erb    ,@CPYabb ,@CMPabb ,@DECabb ,@erb    
  dw @BNEreb ,@CMPiyb ,@erb    ,@erb    ,@HACKb  ,@CMPzxb ,@DECzxb ,@erb
  dw @CLDb   ,@CMPayb ,@erb    ,@erb    ,@erb    ,@CMPaxb ,@DECaxb ,@erb    
  dw @CPXimb ,@SBCixb ,@erb    ,@erb    ,@CPXzpb ,@SBCzpb ,@INCzpb ,@erb    
  dw @INXb   ,@SBCimb ,@NOPb   ,@erb    ,@CPXabb ,@SBCabb ,@INCabb ,@erb    
  dw @BEQreb ,@SBCiyb ,@erb    ,@erb    ,@erb    ,@SBCzxb ,@INCzxb ,@erb    
  dw @SEDb   ,@SBCayb ,@erb    ,@erb    ,@erb    ,@SBCaxb ,@INCaxb ,@erb    

@N1V1Z0C0:
  dw @BRKc   ,@ORAixc ,@erc    ,@erc    ,@erc    ,@ORAzpc ,@ASLzpc ,@erc    
  dw @PHPc   ,@ORAimc ,@ASLacc ,@erc    ,@erc    ,@ORAabc ,@ASLabc ,@erc    
  dw @BPLrec ,@ORAiyc ,@erc    ,@erc    ,@erc    ,@ORAzxc ,@ASLzxc ,@erc    
  dw @CLCc   ,@ORAayc ,@erc    ,@erc    ,@erc    ,@ORAaxc ,@ASLaxc ,@erc    
  dw @JSRabc ,@ANDixc ,@erc    ,@erc    ,@BITzpc ,@ANDzpc ,@ROLzpc ,@erc    
  dw @PLPc   ,@ANDimc ,@ROLacc ,@erc    ,@BITabc ,@ANDabc ,@ROLabc ,@erc    
  dw @BMIrec ,@ANDiyc ,@erc    ,@erc    ,@erc    ,@ANDzxc ,@ROLzxc ,@erc    
  dw @SECc   ,@ANDayc ,@erc    ,@erc    ,@erc    ,@ANDaxc ,@ROLaxc ,@erc    
  dw @RTIc   ,@EORixc ,@erc    ,@erc    ,@erc    ,@EORzpc ,@LSRzpc ,@erc    
  dw @PHAc   ,@EORimc ,@LSRacc ,@erc    ,@JMPabc ,@EORabc ,@LSRabc ,@erc    
  dw @BVCrec ,@EORiyc ,@erc    ,@erc    ,@erc    ,@EORzxc ,@LSRzxc ,@erc    
  dw @CLIc   ,@EORayc ,@erc    ,@erc    ,@erc    ,@EORaxc ,@LSRaxc ,@erc    
  dw @RTSc   ,@ADCixc ,@erc    ,@erc    ,@erc    ,@ADCzpc ,@RORzpc ,@erc    
  dw @PLAc   ,@ADCimc ,@RORacc ,@erc    ,@JMPidc ,@ADCabc ,@RORabc ,@erc    
  dw @BVSrec ,@ADCiyc ,@erc    ,@erc    ,@erc    ,@ADCzxc ,@RORzxc ,@erc    
  dw @SEIc   ,@ADCayc ,@erc    ,@erc    ,@erc    ,@ADCaxc ,@RORaxc ,@erc    
  dw @erc    ,@STAixc ,@erc    ,@erc    ,@STYzpc ,@STAzpc ,@STXzpc ,@erc    
  dw @DEYc   ,@erc    ,@TXAc   ,@erc    ,@STYabc ,@STAabc ,@STXabc ,@erc    
  dw @BCCrec ,@STAiyc ,@erc    ,@erc    ,@STYzxc ,@STAzxc ,@STXzyc ,@erc    
  dw @TYAc   ,@STAayc ,@TXSc   ,@erc    ,@erc    ,@STAaxc ,@erc    ,@erc    
  dw @LDYimc ,@LDAixc ,@LDXimc ,@erc    ,@LDYzpc ,@LDAzpc ,@LDXzpc ,@erc    
  dw @TAYc   ,@LDAimc ,@TAXc   ,@erc    ,@LDYabc ,@LDAabc ,@LDXabc ,@erc    
  dw @BCSrec ,@LDAiyc ,@erc    ,@erc    ,@LDYzxc ,@LDAzxc ,@LDXzyc ,@erc    
  dw @CLVc   ,@LDAayc ,@TSXc   ,@erc    ,@LDYaxc ,@LDAaxc ,@LDXayc ,@erc    
  dw @CPYimc ,@CMPixc ,@erc    ,@erc    ,@CPYzpc ,@CMPzpc ,@DECzpc ,@erc    
  dw @INYc   ,@CMPimc ,@DEXc   ,@erc    ,@CPYabc ,@CMPabc ,@DECabc ,@erc    
  dw @BNErec ,@CMPiyc ,@erc    ,@erc    ,@HACKc  ,@CMPzxc ,@DECzxc ,@erc
  dw @CLDc   ,@CMPayc ,@erc    ,@erc    ,@erc    ,@CMPaxc ,@DECaxc ,@erc    
  dw @CPXimc ,@SBCixc ,@erc    ,@erc    ,@CPXzpc ,@SBCzpc ,@INCzpc ,@erc    
  dw @INXc   ,@SBCimc ,@NOPc   ,@erc    ,@CPXabc ,@SBCabc ,@INCabc ,@erc    
  dw @BEQrec ,@SBCiyc ,@erc    ,@erc    ,@erc    ,@SBCzxc ,@INCzxc ,@erc    
  dw @SEDc   ,@SBCayc ,@erc    ,@erc    ,@erc    ,@SBCaxc ,@INCaxc ,@erc    

@N1V1Z0C1:
  dw @BRKd   ,@ORAixd ,@erd    ,@erd    ,@erd    ,@ORAzpd ,@ASLzpd ,@erd    
  dw @PHPd   ,@ORAimd ,@ASLacd ,@erd    ,@erd    ,@ORAabd ,@ASLabd ,@erd    
  dw @BPLred ,@ORAiyd ,@erd    ,@erd    ,@erd    ,@ORAzxd ,@ASLzxd ,@erd    
  dw @CLCd   ,@ORAayd ,@erd    ,@erd    ,@erd    ,@ORAaxd ,@ASLaxd ,@erd    
  dw @JSRabd ,@ANDixd ,@erd    ,@erd    ,@BITzpd ,@ANDzpd ,@ROLzpd ,@erd    
  dw @PLPd   ,@ANDimd ,@ROLacd ,@erd    ,@BITabd ,@ANDabd ,@ROLabd ,@erd    
  dw @BMIred ,@ANDiyd ,@erd    ,@erd    ,@erd    ,@ANDzxd ,@ROLzxd ,@erd    
  dw @SECd   ,@ANDayd ,@erd    ,@erd    ,@erd    ,@ANDaxd ,@ROLaxd ,@erd    
  dw @RTId   ,@EORixd ,@erd    ,@erd    ,@erd    ,@EORzpd ,@LSRzpd ,@erd    
  dw @PHAd   ,@EORimd ,@LSRacd ,@erd    ,@JMPabd ,@EORabd ,@LSRabd ,@erd    
  dw @BVCred ,@EORiyd ,@erd    ,@erd    ,@erd    ,@EORzxd ,@LSRzxd ,@erd    
  dw @CLId   ,@EORayd ,@erd    ,@erd    ,@erd    ,@EORaxd ,@LSRaxd ,@erd    
  dw @RTSd   ,@ADCixd ,@erd    ,@erd    ,@erd    ,@ADCzpd ,@RORzpd ,@erd    
  dw @PLAd   ,@ADCimd ,@RORacd ,@erd    ,@JMPidd ,@ADCabd ,@RORabd ,@erd    
  dw @BVSred ,@ADCiyd ,@erd    ,@erd    ,@erd    ,@ADCzxd ,@RORzxd ,@erd    
  dw @SEId   ,@ADCayd ,@erd    ,@erd    ,@erd    ,@ADCaxd ,@RORaxd ,@erd    
  dw @erd    ,@STAixd ,@erd    ,@erd    ,@STYzpd ,@STAzpd ,@STXzpd ,@erd    
  dw @DEYd   ,@erd    ,@TXAd   ,@erd    ,@STYabd ,@STAabd ,@STXabd ,@erd    
  dw @BCCred ,@STAiyd ,@erd    ,@erd    ,@STYzxd ,@STAzxd ,@STXzyd ,@erd    
  dw @TYAd   ,@STAayd ,@TXSd   ,@erd    ,@erd    ,@STAaxd ,@erd    ,@erd    
  dw @LDYimd ,@LDAixd ,@LDXimd ,@erd    ,@LDYzpd ,@LDAzpd ,@LDXzpd ,@erd    
  dw @TAYd   ,@LDAimd ,@TAXd   ,@erd    ,@LDYabd ,@LDAabd ,@LDXabd ,@erd    
  dw @BCSred ,@LDAiyd ,@erd    ,@erd    ,@LDYzxd ,@LDAzxd ,@LDXzyd ,@erd    
  dw @CLVd   ,@LDAayd ,@TSXd   ,@erd    ,@LDYaxd ,@LDAaxd ,@LDXayd ,@erd    
  dw @CPYimd ,@CMPixd ,@erd    ,@erd    ,@CPYzpd ,@CMPzpd ,@DECzpd ,@erd    
  dw @INYd   ,@CMPimd ,@DEXd   ,@erd    ,@CPYabd ,@CMPabd ,@DECabd ,@erd    
  dw @BNEred ,@CMPiyd ,@erd    ,@erd    ,@HACKd  ,@CMPzxd ,@DECzxd ,@erd
  dw @CLDd   ,@CMPayd ,@erd    ,@erd    ,@erd    ,@CMPaxd ,@DECaxd ,@erd    
  dw @CPXimd ,@SBCixd ,@erd    ,@erd    ,@CPXzpd ,@SBCzpd ,@INCzpd ,@erd    
  dw @INXd   ,@SBCimd ,@NOPd   ,@erd    ,@CPXabd ,@SBCabd ,@INCabd ,@erd    
  dw @BEQred ,@SBCiyd ,@erd    ,@erd    ,@erd    ,@SBCzxd ,@INCzxd ,@erd    
  dw @SEDd   ,@SBCayd ,@erd    ,@erd    ,@erd    ,@SBCaxd ,@INCaxd ,@erd    

@N1V1Z1C0:
  dw @BRKe   ,@ORAixe ,@ere    ,@ere    ,@ere    ,@ORAzpe ,@ASLzpe ,@ere    
  dw @PHPe   ,@ORAime ,@ASLace ,@ere    ,@ere    ,@ORAabe ,@ASLabe ,@ere    
  dw @BPLree ,@ORAiye ,@ere    ,@ere    ,@ere    ,@ORAzxe ,@ASLzxe ,@ere    
  dw @CLCe   ,@ORAaye ,@ere    ,@ere    ,@ere    ,@ORAaxe ,@ASLaxe ,@ere    
  dw @JSRabe ,@ANDixe ,@ere    ,@ere    ,@BITzpe ,@ANDzpe ,@ROLzpe ,@ere    
  dw @PLPe   ,@ANDime ,@ROLace ,@ere    ,@BITabe ,@ANDabe ,@ROLabe ,@ere    
  dw @BMIree ,@ANDiye ,@ere    ,@ere    ,@ere    ,@ANDzxe ,@ROLzxe ,@ere    
  dw @SECe   ,@ANDaye ,@ere    ,@ere    ,@ere    ,@ANDaxe ,@ROLaxe ,@ere    
  dw @RTIe   ,@EORixe ,@ere    ,@ere    ,@ere    ,@EORzpe ,@LSRzpe ,@ere    
  dw @PHAe   ,@EORime ,@LSRace ,@ere    ,@JMPabe ,@EORabe ,@LSRabe ,@ere    
  dw @BVCree ,@EORiye ,@ere    ,@ere    ,@ere    ,@EORzxe ,@LSRzxe ,@ere    
  dw @CLIe   ,@EORaye ,@ere    ,@ere    ,@ere    ,@EORaxe ,@LSRaxe ,@ere    
  dw @RTSe   ,@ADCixe ,@ere    ,@ere    ,@ere    ,@ADCzpe ,@RORzpe ,@ere    
  dw @PLAe   ,@ADCime ,@RORace ,@ere    ,@JMPide ,@ADCabe ,@RORabe ,@ere    
  dw @BVSree ,@ADCiye ,@ere    ,@ere    ,@ere    ,@ADCzxe ,@RORzxe ,@ere    
  dw @SEIe   ,@ADCaye ,@ere    ,@ere    ,@ere    ,@ADCaxe ,@RORaxe ,@ere    
  dw @ere    ,@STAixe ,@ere    ,@ere    ,@STYzpe ,@STAzpe ,@STXzpe ,@ere    
  dw @DEYe   ,@ere    ,@TXAe   ,@ere    ,@STYabe ,@STAabe ,@STXabe ,@ere    
  dw @BCCree ,@STAiye ,@ere    ,@ere    ,@STYzxe ,@STAzxe ,@STXzye ,@ere    
  dw @TYAe   ,@STAaye ,@TXSe   ,@ere    ,@ere    ,@STAaxe ,@ere    ,@ere    
  dw @LDYime ,@LDAixe ,@LDXime ,@ere    ,@LDYzpe ,@LDAzpe ,@LDXzpe ,@ere    
  dw @TAYe   ,@LDAime ,@TAXe   ,@ere    ,@LDYabe ,@LDAabe ,@LDXabe ,@ere    
  dw @BCSree ,@LDAiye ,@ere    ,@ere    ,@LDYzxe ,@LDAzxe ,@LDXzye ,@ere    
  dw @CLVe   ,@LDAaye ,@TSXe   ,@ere    ,@LDYaxe ,@LDAaxe ,@LDXaye ,@ere    
  dw @CPYime ,@CMPixe ,@ere    ,@ere    ,@CPYzpe ,@CMPzpe ,@DECzpe ,@ere    
  dw @INYe   ,@CMPime ,@DEXe   ,@ere    ,@CPYabe ,@CMPabe ,@DECabe ,@ere    
  dw @BNEree ,@CMPiye ,@ere    ,@ere    ,@HACKe  ,@CMPzxe ,@DECzxe ,@ere
  dw @CLDe   ,@CMPaye ,@ere    ,@ere    ,@ere    ,@CMPaxe ,@DECaxe ,@ere    
  dw @CPXime ,@SBCixe ,@ere    ,@ere    ,@CPXzpe ,@SBCzpe ,@INCzpe ,@ere    
  dw @INXe   ,@SBCime ,@NOPe   ,@ere    ,@CPXabe ,@SBCabe ,@INCabe ,@ere    
  dw @BEQree ,@SBCiye ,@ere    ,@ere    ,@ere    ,@SBCzxe ,@INCzxe ,@ere    
  dw @SEDe   ,@SBCaye ,@ere    ,@ere    ,@ere    ,@SBCaxe ,@INCaxe ,@ere    

@N1V1Z1C1:
  dw @BRKf   ,@ORAixf ,@erf    ,@erf    ,@erf    ,@ORAzpf ,@ASLzpf ,@erf    
  dw @PHPf   ,@ORAimf ,@ASLacf ,@erf    ,@erf    ,@ORAabf ,@ASLabf ,@erf    
  dw @BPLref ,@ORAiyf ,@erf    ,@erf    ,@erf    ,@ORAzxf ,@ASLzxf ,@erf    
  dw @CLCf   ,@ORAayf ,@erf    ,@erf    ,@erf    ,@ORAaxf ,@ASLaxf ,@erf    
  dw @JSRabf ,@ANDixf ,@erf    ,@erf    ,@BITzpf ,@ANDzpf ,@ROLzpf ,@erf    
  dw @PLPf   ,@ANDimf ,@ROLacf ,@erf    ,@BITabf ,@ANDabf ,@ROLabf ,@erf    
  dw @BMIref ,@ANDiyf ,@erf    ,@erf    ,@erf    ,@ANDzxf ,@ROLzxf ,@erf    
  dw @SECf   ,@ANDayf ,@erf    ,@erf    ,@erf    ,@ANDaxf ,@ROLaxf ,@erf    
  dw @RTIf   ,@EORixf ,@erf    ,@erf    ,@erf    ,@EORzpf ,@LSRzpf ,@erf    
  dw @PHAf   ,@EORimf ,@LSRacf ,@erf    ,@JMPabf ,@EORabf ,@LSRabf ,@erf    
  dw @BVCref ,@EORiyf ,@erf    ,@erf    ,@erf    ,@EORzxf ,@LSRzxf ,@erf    
  dw @CLIf   ,@EORayf ,@erf    ,@erf    ,@erf    ,@EORaxf ,@LSRaxf ,@erf    
  dw @RTSf   ,@ADCixf ,@erf    ,@erf    ,@erf    ,@ADCzpf ,@RORzpf ,@erf    
  dw @PLAf   ,@ADCimf ,@RORacf ,@erf    ,@JMPidf ,@ADCabf ,@RORabf ,@erf    
  dw @BVSref ,@ADCiyf ,@erf    ,@erf    ,@erf    ,@ADCzxf ,@RORzxf ,@erf    
  dw @SEIf   ,@ADCayf ,@erf    ,@erf    ,@erf    ,@ADCaxf ,@RORaxf ,@erf    
  dw @erf    ,@STAixf ,@erf    ,@erf    ,@STYzpf ,@STAzpf ,@STXzpf ,@erf    
  dw @DEYf   ,@erf    ,@TXAf   ,@erf    ,@STYabf ,@STAabf ,@STXabf ,@erf    
  dw @BCCref ,@STAiyf ,@erf    ,@erf    ,@STYzxf ,@STAzxf ,@STXzyf ,@erf    
  dw @TYAf   ,@STAayf ,@TXSf   ,@erf    ,@erf    ,@STAaxf ,@erf    ,@erf    
  dw @LDYimf ,@LDAixf ,@LDXimf ,@erf    ,@LDYzpf ,@LDAzpf ,@LDXzpf ,@erf    
  dw @TAYf   ,@LDAimf ,@TAXf   ,@erf    ,@LDYabf ,@LDAabf ,@LDXabf ,@erf    
  dw @BCSref ,@LDAiyf ,@erf    ,@erf    ,@LDYzxf ,@LDAzxf ,@LDXzyf ,@erf    
  dw @CLVf   ,@LDAayf ,@TSXf   ,@erf    ,@LDYaxf ,@LDAaxf ,@LDXayf ,@erf    
  dw @CPYimf ,@CMPixf ,@erf    ,@erf    ,@CPYzpf ,@CMPzpf ,@DECzpf ,@erf    
  dw @INYf   ,@CMPimf ,@DEXf   ,@erf    ,@CPYabf ,@CMPabf ,@DECabf ,@erf    
  dw @BNEref ,@CMPiyf ,@erf    ,@erf    ,@HACKf  ,@CMPzxf ,@DECzxf ,@erf
  dw @CLDf   ,@CMPayf ,@erf    ,@erf    ,@erf    ,@CMPaxf ,@DECaxf ,@erf    
  dw @CPXimf ,@SBCixf ,@erf    ,@erf    ,@CPXzpf ,@SBCzpf ,@INCzpf ,@erf    
  dw @INXf   ,@SBCimf ,@NOPf   ,@erf    ,@CPXabf ,@SBCabf ,@INCabf ,@erf    
  dw @BEQref ,@SBCiyf ,@erf    ,@erf    ,@erf    ,@SBCzxf ,@INCzxf ,@erf    
  dw @SEDf   ,@SBCayf ,@erf    ,@erf    ,@erf    ,@SBCaxf ,@INCaxf ,@erf    

@PLPtable:
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V0Z0C0,@case_N0V0Z0C1,@case_N0V0Z1C0,@case_N0V0Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N0V1Z0C0,@case_N0V1Z0C1,@case_N0V1Z1C0,@case_N0V1Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V0Z0C0,@case_N1V0Z0C1,@case_N1V0Z1C0,@case_N1V0Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1
  dw @case_N1V1Z0C0,@case_N1V1Z0C1,@case_N1V1Z1C0,@case_N1V1Z1C1

@BITtable0:
  dw @case_N0V0Z1C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0,@case_N0V0Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0,@case_N0V1Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0,@case_N1V0Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0
  dw @case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0,@case_N1V1Z0C0

@BITtable1:
  dw @case_N0V0Z1C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1,@case_N0V0Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1,@case_N0V1Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1,@case_N1V0Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
  dw @case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1,@case_N1V1Z0C1
;
; CS0100 (MAIN) - Print AL and AX.
;
@printal_table: db '0123456789abcdef'
@printal:
  push  ax
  push  bx
  push  dx
  mov   bx,ax
  mov   bh,00h
  push  bx
  shr   bl,4
  mov   ah,02h
  mov   dl,byte ptr @printal_table[bx]
  int   21h
  pop   bx
  and   bl,15
  mov   ah,02h
  mov   dl,byte ptr @printal_table[bx]
  int   21h
  pop   dx
  pop   bx
  pop   ax
  retn
@printax:
  push  ax
  mov   al,ah
  call  @printal
  pop   ax
  call  @printal
  ret
;
; CS0101 (MAIN) - Disassemble 6502.
;
@dis_print_mem:
  push  ax
  push  dx
  push  si
  mov   al,[ds:si]
  inc   si
  call  @printal
  mov   ah,02h
  mov   dl,' '
  int   21h
  mov   al,[ds:si]
  inc   si
  call  @printal
  mov   ah,02h
  mov   dl,' '
  int   21h
  mov   al,[ds:si]
  inc   si
  call  @printal
  mov   ah,02h
  mov   dl,','
  int   21h
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   si
  pop   dx
  pop   ax
  ret
@dis_print_stack:
  push  ax
  push  dx
  push  si
  mov   al,[ds:00fah]
  inc   si
  call  @printal
  mov   ah,02h
  mov   dl,' '
  int   21h
  mov   al,[ds:00fbh]
  inc   si
  call  @printal
  mov   ah,02h
  mov   dl,' '
  int   21h
  mov   al,[ds:00fch]
  inc   si
  call  @printal
  mov   ah,02h
  mov   dl,','
  int   21h
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   si
  pop   dx
  pop   ax
  ret
@dis_print_PC:
  push  ax
  push  dx
  mov   ax,si
  call  @printax
  mov   ah,02h
  mov   dl,':'
  int   21h
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   dx
  pop   ax
  ret
@dis_print_A:
  push  ax
  push  dx
  mov   ah,02h
  mov   dl,'A'
  int   21h
  mov   ah,02h
  mov   dl,'='
  int   21h
  mov   al,ch
  call  @printal
  mov   ah,02h
  mov   dl,','
  int   21h
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   dx
  pop   ax
  ret
@dis_print_X:
  push  ax
  push  dx
  mov   ah,02h
  mov   dl,'X'
  int   21h
  mov   ah,02h
  mov   dl,'='
  int   21h
  mov   al,cl
  call  @printal
  mov   ah,02h
  mov   dl,','
  int   21h
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   dx
  pop   ax
  ret
@dis_print_Y:
  push  ax
  push  dx
  mov   ah,02h
  mov   dl,'Y'
  int   21h
  mov   ah,02h
  mov   dl,'='
  int   21h
  mov   al,dh
  call  @printal
  mov   ah,02h
  mov   dl,','
  int   21h
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   dx
  pop   ax
  ret
@dis_print_S:
  push  ax
  push  dx
  mov   ah,02h
  mov   dl,'S'
  int   21h
  mov   ah,02h
  mov   dl,'='
  int   21h
  mov   al,bl
  call  @printal
  mov   ah,02h
  mov   dl,','
  int   21h
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   dx
  pop   ax
  ret
@dis_print_Clk:
  push  ax
  push  bx
  push  dx
  mov   bx,dx
  mov   ah,02h
  mov   dl,'C'
  int   21h
  mov   ah,02h
  mov   dl,'='
  int   21h
  mov   al,bl
  call  @printal
  mov   ah,02h
  mov   dl,','
  int   21h
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   dx
  pop   bx
  pop   ax
  ret
@dis_print_P:
  push  ax
  push  dx
  mov   ah,02h
  mov   dl,'P'
  int   21h
  mov   ah,02h
  mov   dl,'='
  int   21h
  mov   ax,bp
  call  @printal
  mov   ah,02h
  mov   dl,' '
  int   21h
  mov   ah,02h
  mov   dl,';'
  int   21h
  pop   dx
  pop   ax
  ret
@dis_print_AH:
  push  ax
  push  dx
  push  bx
  mov   bx,ax
  mov   ah,02h
  mov   dl,'A'
  int   21h
  mov   ah,02h
  mov   dl,'H'
  int   21h
  mov   ah,02h
  mov   dl,'='
  int   21h
  mov   al,bh
  mov   al,[ds:00fch]
  mov   al,byte ptr @sram_latch
  call  @printal
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   bx
  pop   dx
  pop   ax
  ret
@dis_print_DI:
  push  ax
  push  dx
  mov   ax,di
  call  @printax
  mov   ah,02h
  mov   dl,':'
  int   21h
  mov   ah,02h
  mov   dl,' '
  int   21h
  pop   dx
  pop   ax
  ret
@dis_start: dw    1
@dis_end:   dw 6000
@dis_count: dw 0
@disassemble:
  ret
  cmp   si,08000h
  jc    @disassemble_ret
  cmp   si,0c000h
  jnc   @disassemble_ret
  push  ax
  push  bx
  push  cx
  push  dx
  push  si
  inc   word ptr @dis_count
  mov   ax,word ptr @dis_count
  cmp   ax,word ptr @dis_start
  jl    @disassemble_exit
  cmp   ax,word ptr @dis_end
  jg    @finish
  call  @dis_print_PC
  call  @dis_print_mem
  call  @dis_print_A
  call  @dis_print_X
  call  @dis_print_Y
  call  @dis_print_S
  call  @dis_print_P
  call  @dis_print_stack
  call  @dis_print_Clk
  call  @dis_print_di
  pop   si
  pop   dx
  pop   cx
  pop   bx
  pop   ax
  push  ax
  push  bx
  push  cx
  push  dx
  push  si
  call  @dis_print_AH
  mov   ah,02
  mov   dl,';'
  int   21h
  mov   ah,02
  mov   dl,13
  int   21h
  mov   ah,02
  mov   dl,10
  int   21h
@disassemble_exit:
  pop   si
  pop   dx
  pop   cx
  pop   bx
  pop   ax
@disassemble_ret:
  ret
;
; CS0102 (MAIN) - Store AL into [DS:DI] with BBC hardware mods.
;
@store:
  test  di,di
  jns   @store_yes
  cmp   di,0c000h
  jc    @store_sram
@store_os:
  cmp   di,0fe30h
  jnz   @store_no
  mov   byte ptr @sram_latch,al
  push  ax
  push  bx
  push  dx
  mov   dx,word ptr @ems_handle
  mov   bx,ax
  and   bx,000fh
  mov   ah,44h
  mov   al,02h
  int   67h
  pop   dx
  pop   bx
  pop   ax
  jmp   @store_no
@store_sram:
  test  byte ptr @sram_latch,04h
  jz    @store_no
@store_yes:
  mov   byte ptr [ds:di],al
@store_no:
  ret
;
; CS0103 (MAIN) - Load AL from [DS:DI] with BBC hardware mods.
;
@load:
  test  di,di
  jns   @load_yes
  cmp   di,0fc00h
  jc    @load_yes
  cmp   di,0ff00h
  jnc   @load_yes
  mov   al,0ffh
  ret
@load_yes:
  mov   al,byte ptr [ds:di]
  ret
;
@main:
;
; CS0001 (INIT) - ASSUME DS=CS (For INIT section only).
;
; In the initialisation (and initialiation only), assume DS=CS.
; Later on DS=EMS page pointing to the EMS memory.
;
  mov   bx,cs
  mov   ds,bx
;
; CS0002 (INIT) - Display program title.
;
; Display application banner.
;
  mov   ah,09h
  mov   dx,OFFSET @title
  int   21h
  jmp   @init_ems_pageframe
@title:
  db    'BBC emulator for 386 machines.',13,10
  db    '(C) 1994 by Stephen Quan.',13,10,13,10,'$'
;
; CS0003 (INIT) - EMS PAGE FRAME.
;
; Determine where the EMS page frame is.
;
@init_ems_pageframe:
  mov   ah,41h
  int   67h
  test  ah,ah
  jz    @init_ems_allocate
  mov   ah,09
  mov   dx,OFFSET @init_ems_pageframe_error
  int   21h
  jmp   @finish
@init_ems_pageframe_error:
  db    'Cannot determine EMS page frame.',13,10,'$'
;
; CS0004 (INIT) - Allocate EMS memory.
;
; Get a EMS handle to 19 newly allocated EMS pages.
;
@init_ems_allocate:
  mov   word ptr @ems_page,bx
  mov   ah,43h
  mov   bx,19
  int   67h
  test  ah,ah
  jnz   @init_ems_allocate_printerror
  push  ds
  mov   word ptr @ems_handle,dx
  mov   bx,word ptr @ems_page
  mov   ds,bx
  mov   bx,00
@init_ems_allocate_loop:
  mov   dx,word ptr @ems_handle
  mov   ah,44h
  mov   al,00h
  int   67h
  mov   di,00
@init_ems_allocate_clear_loop:
  mov   byte ptr [ds:di],00h
  inc   di
  cmp   di,4000h
  jnz   @init_ems_allocate_clear_loop
  inc   bx
  cmp   bx,19
  jnz   @init_ems_allocate_loop
  pop   ds
  jmp   @init_ram
@init_ems_allocate_printerror:
  mov   ah,09h
  mov   dx,OFFSET @init_ems_allocate_error
  int   21h
  jmp   @finish
@init_ems_allocate_error:
  db    'Cannot allocate 19 EMS pages.',13,10
  db    'This application requires 304K EMS memory.',13,10,'$'
;
; CS0005 (INIT) - Load 0000-0DFF BBC memory image.
;
; BBC RAM resides in EMS pages 16&17.  These EMS pages will be mapped
; into logical page 0 and 1 of the EMS page frame and left here for the
; remainder of the application.  After we map these pages in, we can
; load the first 0E00 bytes.
;
@init_ram:
  mov   dx,word ptr @ems_handle
  mov   ah,44h
  mov   al,00h
  mov   bx,16
  int   67h
  mov   ah,44h
  mov   al,00h
  mov   bx,17
  int   67h
  mov   ah,3dh
  mov   al,00h
  mov   dx,OFFSET @init_ram_asciiz
  int   21h
  jc    @init_ram_error_open
  mov   bx,ax
  mov   ah,3fh
  mov   cx,0e00h
  push  ds
  mov   dx,word ptr @ems_page
  mov   ds,dx
  mov   dx,0000h
  int   21h
  pop   ds
  mov   ah,3eh
  int   21h
  jmp   @init_ramtest
@init_ram_asciiz:
  db    '00000dff.dmp',0
@init_ram_error_open_string:
  db    'FATAL: cannot open RAM image 00000dff.dmp.',13,10,'$'
@init_ram_error_open:
  mov   ah,09h
  mov   dx,OFFSET @init_ram_error_open_string
  int   21h
  jmp   @free_ems
;
; CS0006 (INIT) - Load 1000-???? BBC test program.
;
; Load in a test program at 1000.
; I will start the emulator at 1000.
;
@init_ramtest:
  mov   ah,3dh
  mov   al,00h
  mov   dx,OFFSET @init_ramtest_asciiz
  int   21h
  jc    @init_ramtest_error_open
  mov   bx,ax
  mov   ah,3fh
  mov   cx,4000h
  push  ds
  mov   dx,word ptr @ems_page
  mov   ds,dx
  mov   dx,1000h
  int   21h
  pop   ds
  mov   ah,3eh
  int   21h
  jmp   @init_osrom
@init_ramtest_asciiz:
  db    '1000.dmp',0
@init_ramtest_error_open_string:
  db    'WARNING: cannot open RAM image 1000.dmp.',13,10,'$'
@init_ramtest_error_open:
  mov   ah,09h
  mov   dx,OFFSET @init_ramtest_error_open_string
  int   21h
;
; CS0006 (INIT) - Load C000-FFFF BBC OS ROM image.
;
; BBC OS ROM resides in EMS pages 18.  This EMS page will be mapped
; into logical page 3 and left here for the remainder of the application.
; After we map this page in, the rom image (4000 bytes) is loaded in.
;
@init_osrom:
  mov   dx,word ptr @ems_handle
  mov   ah,44h
  mov   al,03h
  mov   bx,18
  int   67h
  mov   ah,3dh
  mov   al,00h
  mov   dx,OFFSET @init_osrom_asciiz
  int   21h
  jc    @init_osrom_error_open
  mov   bx,ax
  mov   ah,3fh
  mov   cx,4000h
  push  ds
  mov   dx,word ptr @ems_page
  mov   ds,dx
  mov   dx,0c000h
  int   21h
  pop   ds
  mov   ah,3eh
  int   21h
  jmp   @init_6502assrom
@init_osrom_asciiz:
  db    'os.bbc',0
@init_osrom_error_open_string:
  db    'FATA: cannot open ROM image os.bbc.',13,10,'$'
@init_osrom_error_open:
  mov   ah,09h
  mov   dx,OFFSET @init_osrom_error_open_string
  int   21h
  jmp   @free_ems
;
; CS0007 (INIT) - 6502ASS.BBC into BBC Sideways Ram slot 8.
;
; BBC Sideways RAM 8 is in EMS page 8.  This EMS page will be mapped into
; logical page 2 (temporarily).  When this page is mapped in the 6502ASS.BBC
; ram image is loaded in.
;
@init_6502assrom:
  mov   dx,word ptr @ems_handle
  mov   ah,44h
  mov   al,02h
  mov   bx,8
  int   67h
  mov   ah,3dh
  mov   al,00h
  mov   dx,OFFSET @init_6502assrom_asciiz
  int   21h
  jc    @init_6502assrom_error_open
  mov   bx,ax
  mov   ah,3fh
  mov   cx,4000h
  push  ds
  mov   dx,word ptr @ems_page
  mov   ds,dx
  mov   dx,08000h
  int   21h
  pop   ds
  mov   ah,3eh
  int   21h
  jmp   @init_hackrom
@init_6502assrom_asciiz:
  db    '6502ass.bbc',0
@init_6502assrom_error_open_string:
  db    'WARNING: cannot open ROM image 6502ass.bbc.',13,10,'$'
@init_6502assrom_error_open:
  mov   ah,09h
  mov   dx,OFFSET @init_6502assrom_error_open_string
  int   21h
;
; CS0008 (INIT) - HACKROM.BBC into BBC Sideways Ram slot 9.
;
; BBC Sideways RAM 8 is in EMS page 9.  This EMS page will be mapped into
; logical page 2 (temporarily).  When this page is mapped in the HACKROM.BBC
; ram image is loaded in.
;
@init_hackrom:
  mov   dx,word ptr @ems_handle
  mov   ah,44h
  mov   al,02h
  mov   bx,9
  int   67h
  mov   ah,3dh
  mov   al,00h
  mov   dx,OFFSET @init_hackrom_asciiz
  int   21h
  jc    @init_hackrom_error_open
  mov   bx,ax
  mov   ah,3fh
  mov   cx,4000h
  push  ds
  mov   dx,word ptr @ems_page
  mov   ds,dx
  mov   dx,08000h
  int   21h
  pop   ds
  mov   ah,3eh
  int   21h
  jmp   @init_basicrom
@init_hackrom_asciiz:
  db    'hackrom.bbc',0
@init_hackrom_error_open_string:
  db    'WARNING: cannot open ROM image hackrom.bbc.',13,10,'$'
@init_hackrom_error_open:
  mov   ah,09h
  mov   dx,OFFSET @init_hackrom_error_open_string
  int   21h
;
; CS0009 (INIT) - BASIC.BBC into BBC Sideways Ram slot B (indicated by latch).
;
; BBC Sideways RAM B is in EMS page B.  This EMS page will be mapped into
; logical page 2 (temporarily).  When this page is mapped in the BASIC.BBC
; rom image is loaded in.
;
@init_basicrom:
  mov   dx,word ptr @ems_handle
  mov   ah,44h
  mov   al,02h
  mov   bl,byte ptr @sram_latch
  mov   bh,00h
  int   67h
  mov   ah,3dh
  mov   al,00h
  mov   dx,OFFSET @init_basicrom_asciiz
  int   21h
  jc    @init_basicrom_error_open
  mov   bx,ax
  mov   ah,3fh
  mov   cx,4000h
  push  ds
  mov   dx,word ptr @ems_page
  mov   ds,dx
  mov   dx,08000h
  int   21h
  pop   ds
  mov   ah,3eh
  int   21h
  jmp   @hackos
@init_basicrom_asciiz:
  db    'basic.bbc',0
@init_basicrom_error_open_string:
  db    'WARNING: cannot open ROM image basic.bbc.',13,10,'$'
@init_basicrom_error_open:
  mov   ah,09h
  mov   dx,OFFSET @init_basicrom_error_open_string
  int   21h
;
; CS0010 (INIT) - Redirect OSWRCH and OSRDCH.
;
; This is a temporary hack of the OS so that OSWRCH and OSRDCH will be
; mapped directly into user supplied functions by making use of undocumented
; opcode 0xd4.  0xd4 0x0e replaces (&20E) and 0xd4 0x10 replaces (&210).
;
@hackos:
  mov   dx,word ptr @ems_page
  mov   ds,dx
  mov   bx,word ptr [ds:020eh]
  mov   byte ptr [ds:bx  ],0d4h
  mov   byte ptr [ds:bx+1],00eh
  mov   byte ptr [ds:bx+2],060h
  mov   bx,word ptr [ds:0210h]
  mov   byte ptr [ds:bx  ],0d4h
  mov   byte ptr [ds:bx+1],010h
  mov   byte ptr [ds:bx+2],060h
;
; CS0500 (MAIN) - Initialise main emulator registors.
;
;   DS - EMS page frame (data segment for BBC 64K memory).
;   SI - 6502 program counter.
;   AX - 6502 opcode (actuall AL=opcode, AH=00)
;   BX - stack pointer (actually BL=SP, BH=01).
;   CH - 6502 register A.
;   CL - 6502 register X.
;   DH - 6502 register Y.
;   DL - clock counter for 6845 synchronisation.
;   BP - 6502 status register (correct for B,I and unknown bits).
;
@start:
  mov   ax,word ptr @ems_page
  mov   ds,ax
  mov   ax,word ptr [ds:0fffch]
;  mov   ax,01000h
  mov   si,ax
  mov   ax,0b800h
  mov   es,ax
  mov   ax,0000h
  mov   bx,01ffh
  mov   cx,0000h
  mov   dx,0000h
  mov   bp,0030h
  jmp   @case_N0V0Z0C0
;
;
;
@maxcycles:
  dw    00100h
@ROM6845:
  and   dl,7fh
  RETN

INCLUDE 6502.asm

@HACK:
  lodsb
  cmp   al,0eh
  jz    @HACK_OSWRCH
  cmp   al,10h
  jz    @HACK_OSRDCH
@HACK_OSWRCH:
  push  ax
  push  bx
  push  cx
  push  dx
  push  bp
  mov   ah,02h
  mov   dl,ch
  int   21h
  pop   bp
  pop   dx
  pop   cx
  pop   bx
  pop   ax
  retn
@HACK_OSRDCH:
  push  ax
  push  bx
  push  dx
  push  bp
  mov   ah,08h
  int   21h
  mov   ch,al
  pop   bp
  pop   dx
  pop   bx
  pop   ax
  cmp   ch,254
  jz    @finish
  retn

@HACK0:
  call  @HACK
  jmp   @case_N0V0Z0C0

@HACK1:
  call  @HACK
  jmp   @case_N0V0Z0C1

@HACK2:
  call  @HACK
  jmp   @case_N0V0Z1C0

@HACK3:
  call  @HACK
  jmp   @case_N0V0Z1C1

@HACK4:
  call  @HACK
  jmp   @case_N0V1Z0C0

@HACK5:
  call  @HACK
  jmp   @case_N0V1Z0C1

@HACK6:
  call  @HACK
  jmp   @case_N0V1Z1C0

@HACK7:
  call  @HACK
  jmp   @case_N0V1Z1C1

@HACK8:
  call  @HACK
  jmp   @case_N1V0Z0C0

@HACK9:
  call  @HACK
  jmp   @case_N1V0Z0C1

@HACKa:
  call  @HACK
  jmp   @case_N1V0Z1C0

@HACKb:
  call  @HACK
  jmp   @case_N1V0Z1C1

@HACKc:
  call  @HACK
  jmp   @case_N1V1Z0C0

@HACKd:
  call  @HACK
  jmp   @case_N1V1Z0C1

@HACKe:
  call  @HACK
  jmp   @case_N1V1Z1C0

@HACKf:
  call  @HACK
  jmp   @case_N1V1Z1C1

;
; CS9900 (FINISH) - Free EMS memory.
;
@finish:
@showreg:
  push   ax
  mov    ax,0b800h
  mov    es,ax
  pop    ax
  mov    word ptr [es:0000h],ax
  mov    word ptr [es:0002h],bx
  mov    word ptr [es:0004h],cx
  mov    word ptr [es:0006h],dx
  mov    word ptr [es:0008h],bp
  mov    ax,di
  mov    word ptr [es:000ah],ax
  mov    ax,si
  mov    word ptr [es:000ch],ax
@free_ems:
  mov   ah,45h
  mov   dx,word ptr @ems_handle
  int   67h
;
; CS9999 (FINISH) - Standard DOS exit.
;
@backtodos:
  mov   ah,4ch
  int   21h
END
