#ifndef _6522_H_
#define _6522_H_

#include "defs.h"

typedef struct _6522_ {
    /* public */
#   include "public_template.h"

    /* private */
    byte regs[16];
} t_6522;

extern t_6522 i_6522;

/* some defines to aid referencing the regs array */
#define ORB	regs[0]
#define IRB	regs[0]
#define ORA	regs[1]
#define IRA	regs[1]
#define DDRB	regs[2]
#define DDRA	regs[3]
#define T1C_L	regs[4]
#define T1C_H	regs[5]
#define T1L_L	regs[6]
#define T1L_H	regs[7]
#define T2C_L	regs[8]
#define T2C_H	regs[9]
#define SR	regs[10]
#define ACR	regs[11]
#define PCR	regs[12]
#define IFR	regs[13]
#define IER	regs[14]
#define ORA_nh	regs[15]
#define IRA_nh	regs[15]

#endif /* _6522_H_ */
