char *keys=" ,-./0123456789:;@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_\033\r\n\t";
char *rows="661662331113212454465324552445653313523624463751274456";
char *colm="267787011234456877142223346566556703135312418888809990";

int key_column[256];
int key_row[256];

int main() {
    char *k = keys, *c = colm, *r = rows;
    int i;

    for (i=0; i<256; i++) {
	key_column[i] = -1;
	key_row[i] = -1;
    }

    while (*k) {
	key_column[*k] = *c-'0';
	key_column[tolower(*k)] = *c-'0';
	key_row[*k]    = *r-'0';
	key_row[tolower(*k)]    = *r-'0';
	k++; c++; r++;
    }

    puts("static int key_column[256] = {");
    for (i=0; i<256; i++) {
	printf("    %2d, /* '%c' */\n",
	       key_column[i], 
	       key_column[i] != -1 ? i : '?');
    }
    puts("};");

    puts("static int key_row[256] = {");
    for (i=0; i<256; i++) {
	printf("    %2d, /* '%c' */\n",
	       key_row[i], 
	       key_row[i] != -1 ? i : '?');
    }
    puts("};");
}
