#include "6502.h"
#include "6522.h"
#include "memory.h"

typedef struct _template {
#    include "public_template.h"
} t_template;

/*
 * Define module list in order of initialisation required.
 * We currently have no mechanism to work around the case where two modules
 * may be required for 'simultaneous' initialisation. This is exceptionally
 * rare as most modules are either entirely standalone, or only require
 * the memory module first.
 *
 * This all needs throwing away anyway; we no longer support the concept of
 * modules. It all became far too hacky long ago! :-)
 */
#define N_MODULES (sizeof(module) / sizeof(*module))
t_template *module[] = {
    (t_template *)&i_memory,
    (t_template *)&i_6502,
#ifdef USER_VIA
    (t_template *)&i_6522_user,
#endif
#ifdef SYSTEM_VIA
    (t_template *)&i_6522_system,
#endif
};
