/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include "bbc.h"
#include "fs.h"
#include "fs-file.h"

#define MIN_HANDLE 0x11
#define MAX_HANDLE 0x15

void OSFSC()
{
  Processor.CFlag=0; // no text to display
  Processor.VFlag=0; // no error

    switch (Processor.AReg)
    {
      case 0 : // *OPT
               {
                 FILE * FH=fopen("OPT.LOG","at");
                 fprintf(FH,"OPT %d,%d\n",Processor.XReg,Processor.YReg);
                 fclose(FH);
               }
               break;
      case 1 : // EOF check for handle X, on exit X=0 !EOF, X=0xff if EOF
               FatalError("EOF check");
               break;
      case 2 : // */ command
      case 4 : // *RUN
                 if (!ExecFile())
                   FSError(0xd6); //file not found
               break;
      case 3 : // unknown *command, so try *RUN - if not do BAD COMMAND
                 if (!ExecFile())
                   FSError(0xfe); //BAD COMMAND
               break;
      case 5 : // *CAT
               MakeTextFile("*CAT doesn't work yet, sorry!\n",0);
               break;
      case 6 : // new fs about to take over.. close *SPOOL/*EXEC
               break;
      case 7 : // return range of file handles in min,max (X,Y)
               Processor.XReg=MIN_HANDLE;
               Processor.YReg=MAX_HANDLE;
               break;
      case 8 : // about to issue a *COMMAND
               break;
       
      default : FatalError("Unknown OSFSC command %.2x",Processor.AReg);
    }
}
