/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>

#include "6845crtc.h"
#include "bbc.h"
#include "modex.h"
#include "modexc.h"
#include "sysvia.h"
#include "TwkUser.h" // get Register definition

volatile BYTE Byte; // do not allow to re-order

static Register ModeXScreenRegs[] =
	{
	{ 0x3c2, 0x0, 0xa3},
	{ 0x3d4, 0x0, 0x5f},
	{ 0x3d4, 0x1, 0x4f},
	{ 0x3d4, 0x2, 0x50},
	{ 0x3d4, 0x3, 0x82},
	{ 0x3d4, 0x4, 0x54},
	{ 0x3d4, 0x5, 0x80},
	{ 0x3d4, 0x6, 0xbf},
	{ 0x3d4, 0x7, 0x1f},
	{ 0x3d4, 0x8, 0x0},
	{ 0x3d4, 0x9, 0x40},
	{ 0x3d4, 0x10, 0x83},
	{ 0x3d4, 0x11, 0x85},
	{ 0x3d4, 0x12, 0x7},
	{ 0x3d4, 0x13, 0x28},
	{ 0x3d4, 0x14, 0xf},
	{ 0x3d4, 0x15, 0x63},
	{ 0x3d4, 0x16, 0xba},
	{ 0x3d4, 0x17, 0xe3},
	{ 0x3c4, 0x1, 0x1},
	{ 0x3c4, 0x3, 0x0},
	{ 0x3c4, 0x4, 0x6},
	{ 0x3ce, 0x5, 0x0},
	{ 0x3ce, 0x6, 0x5},
	{ 0x3c0, 0x10, 0x1},
	{ 0x3c0, 0x11, 0x0},
	{ 0x3c0, 0x12, 0xf},
	{ 0x3c0, 0x13, 0x0},
	{ 0x3c0, 0x14, 0x0}
	};


const  char Colours[16][4]={{0,   00,00,00}, // red background
                            {1,   63,00,00},
                            {2,   00,63,00},
                            {3,   63,63,00},
                            {4,   00,00,63},
                            {5,   63,00,63},
                            {20,  00,63,63},
                            {7,   63,63,63},
                            {56,  00,00,00}, // Repeated again
                            {57,  63,00,00},
                            {58,  00,63,00},
                            {59,  63,63,00},
                            {60,  00,00,63},
                            {61,  63,00,63},
                            {62,  00,63,63},
                            {63,  63,63,63} };


void InitModeX()
{
  int Count;
  union REGS regs;

  ResetCRTC(); // reset it with decent values

  regs.w.ax=0x12;
  int386( 0x10, &regs, &regs );

  outRegArray(ModeXScreenRegs,29);
  _disable();
  outp(0x3c6,0xff);
    for (Count=0; Count<8; Count++) // do colours 0-7
    {
      inp(0x3da); // read to reset attribute controller toggle in index mode
      outp(0x3c8,Colours[Count][0]);
      outp(0x3c9,Colours[Count][1]);
      outp(0x3c9,Colours[Count][2]);
      outp(0x3c9,Colours[Count][3]);
    }
  _enable();
  ModeXFlashColours(FlashSelectColour); // do colours 8-15

// always keep these values
  outpw(0x03ce,0x0003); //  replace
  outpw(0x03ce,0xff08); // bit mask register
  outpw(0x03ce,0x0105); // write mode 1
  outp(0x03c4,2);  // access to...
  outp(0x3c5,15);  // all planes

// xfer LED gfx to VGA memory here
// DrawVGALEDs();

  ClearMode03Colours();
  ClearMode1Colours();
  ClearMode2Colours();
  ClearMode46Colours();
  ClearMode5Colours();
  ClearMode8Colours();
  ColoursChanged=TRUE;

  PhysicalScreenBase=0xa0000; // screen at a0000 displayed now.

    if (DoubleBuffering>0)
      LogicalScreenBase= 0xa5300;
    else
      LogicalScreenBase= 0xa0000;

  DisplayModeXScreen(); //sort out colours
}


void AgePalettes()
{
  AgeMode03();
  AgeMode1();
  AgeMode2();
  AgeMode46();
  AgeMode5();
  AgeMode8();
}


void DisplayModeXScreen()
{
  LogicalScreen=(DWORD) LogicalScreenBase + (DWORD) (LinesToSkipFromScreenTop)*80;
  OldColoursChanged=ColoursChanged;

    switch (GraphicVideoMode)
    {
      case 0 :   if (ScreenStart==0x4000)
                   DisplayMode3Screen();
                 else
                   DisplayMode0Screen();
               break;
      case 1 : DisplayMode1Screen();
               break;
      case 2 : DisplayMode2Screen();
               break;
      case 4 :   if (ScreenStart==0x6000)
                   DisplayMode6Screen();
                 else
                   DisplayMode4Screen();
               break;
      case 5 : DisplayMode5Screen();
               break;
      case 8 : DisplayMode8Screen();
               break;
    }
}


void DisplayModeXRow()
{
    if (SplitScanLineStartOffset)
    {
      OldGraphicVideoMode=GraphicVideoMode;
      OldColoursChanged=ColoursChanged;
    }

    switch (OldGraphicVideoMode)
    {
      case 0 : DisplayMode0Row();
               break;
      case 1 : DisplayMode1Row();
               break;
      case 2 : DisplayMode2Row();
               break;
      case 4 : DisplayMode4Row();
               break;
      case 5 : DisplayMode5Row();
               break;
      case 8 : DisplayMode8Row();
               break;
    }
  OldGraphicVideoMode=GraphicVideoMode;
  OldColoursChanged=ColoursChanged;
}


void ModeXFlashColours(int PaletteOffset)
{
  int Count;

  _disable();
  outp(0x3c6,0xff);
  inp(0x3da); // read to reset attribute controller toggle in index mode
    for (Count=0; Count<8; Count++)
    {
      outp(0x3c8,Colours[Count+8][0]); // change 8-15
        if (PaletteOffset)
        {
          // with either 7-0
          outp(0x3c9,Colours[7-Count][1]); 
          outp(0x3c9,Colours[7-Count][2]);
          outp(0x3c9,Colours[7-Count][3]);
        }
        else
        {
          // with either 0-7
          outp(0x3c9,Colours[Count][1]); 
          outp(0x3c9,Colours[Count][2]);
          outp(0x3c9,Colours[Count][3]);
        }
    }
  _enable();
}


void DumpLogicalColours(FILE * F)
{
  fprintf(F,"Logical %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x\n",
          LogicalColours[0],
          LogicalColours[1],
          LogicalColours[2],
          LogicalColours[3],
          LogicalColours[4],
          LogicalColours[5],
          LogicalColours[6],
          LogicalColours[7],
          LogicalColours[8],
          LogicalColours[9],
          LogicalColours[10],
          LogicalColours[11],
          LogicalColours[12],
          LogicalColours[13],
          LogicalColours[14],
          LogicalColours[15]);
}
