/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include "bbc.h"

#include "mode7c.h"
#include "modeXc.h"
#include "6845crtc.h"
#include "videoula.h"
#include "sysvia.h"

BYTE LogicalColours[NUMCOLS];

BYTE LargeCursor,
     CursorWidthInBytes,
     TeleTextModeOn=TRUE,OldTeleTextModeOn=FALSE,
     FlashSelectColour,OldFlashSelectColour=FALSE;

BYTE OldColoursChanged,ColoursChanged,
     OldGraphicVideoMode,GraphicVideoMode;

static BYTE VideoControlRegister,PaletteRegisterValue;

void ResetVideoULA()
{
  TeleTextModeOn=TRUE;
  OldTeleTextModeOn=FALSE;
  ColoursChanged=TRUE;
  OldColoursChanged=FALSE;
}


BYTE ReadVideoULA(WORD Address)
{
  Address&=1; // now the correct register

    if (Address==0) // set the Video Control Register
      return (0xae); // Econet station ID register
    else
      return (PaletteRegisterValue);
}


void WriteVideoULA(WORD Address,BYTE Value)
{
  Address&=1;
    if (Address==0) // set the Video Control Register
    {
      VideoControlRegister=Value;

      LargeCursor=(Value & 0x80>0);
      CursorWidthInBytes=(Value & 0x60)>>5;

        switch ( (Value & 0x1c)>>2)
        {
          case 0x7 : GraphicVideoMode=0;
                     break;
          case 0x6 : GraphicVideoMode=1;
                     break;
          case 0x5 : GraphicVideoMode=2;
                     break;
          case 0x2 : GraphicVideoMode=4;
                     break;
          case 0x1 : GraphicVideoMode=5;
                     break;
          case 0x0 : GraphicVideoMode=8;
                     break;

          default: FatalError("Unsupported video mode %d",(Value & 0x1c)>>2);
        }

      TeleTextModeOn=(Value & 0x02);

        if (OldTeleTextModeOn!=TeleTextModeOn)
        {
          OldTeleTextModeOn=TeleTextModeOn;
            if (TeleTextModeOn)
              InitMode7();
            else
              InitModeX();
          CalcNewCRTC();
        }

      FlashSelectColour=(Value & 1);
        if (OldFlashSelectColour!=FlashSelectColour)
        {
          OldFlashSelectColour=FlashSelectColour;
            if (!TeleTextModeOn)
              ModeXFlashColours(FlashSelectColour);
        }

    }
    else
    {
      // setting the palette
      PaletteRegisterValue=Value;

        if (LogicalColours[Value>>4]!=(Value & 0xf) ^ 7)
        {
          LogicalColours[Value>>4]=(Value & 0xf) ^ 7;
          ColoursChanged=TRUE;
        }
    }
}


void DumpVideoULA(FILE * FileHandle)
{
  short C;
  fprintf(FileHandle," ULA Video Control Register = %x\nPalette:\n",
          VideoControlRegister);

    for (C=0; C<NUMCOLS; C++)
      fprintf(FileHandle,"Colour %2d = %x\n",C,LogicalColours[C]);
}
