#ifndef CPU_H
#define CPU_H

#include "gfx.h"
#include "defines.h"
#include "sound.h"
#include <stdio.h>

enum inst_types{
	BRK, RTI, RTS, PHx, PLx, JSR, IMPLIED, IMMEDIATE, ABS_JMP,

	ABS_READ, ABS_MODIFY, ABS_WRITE,
	ZERO_READ, ZERO_MODIFY, ZERO_WRITE,
	ZIND_READ, ZIND_MODIFY, ZIND_WRITE,
	AIND_READ_NCROSS, AIND_READ_CROSS, AIND_MODIFY, AIND_WRITE,
	REL,
	IIND_READ_NCROSS, IIND_READ_CROSS, IIND_MODIFY, IIND_WRITE,
	INDI_READ, INDI_MODIFY, INDI_WRITE,

	ABSOLUTE_IND, COUNT
};

enum access_type_major{read_op, write_op};
enum access_type_minor{ULA, EXTERNAL, ROM, RAM, FINISH};

struct memory_access
{
	access_type_major type;
	access_type_minor place;
	bool comp;
};

class C_6502ULA	//I am your 6502 & ULA powers combined! I run the show.
{
	public:
		unsigned __int8 a, x, y, p, s, mdr;
		broken_word pc, mar;

		C_6502ULA(C_sound_api &snd);
		~C_6502ULA(void);

		bool Setup(void);
		bool LoadRom(int num, char *name);
		bool LoadCassette(char *name);
		void Reset(void);
		void SuperReset(void);
		void GoNormal(void);
		void GoMulti(void);
		void SetIRQ(unsigned __int8 intbit);
		void TriggerIRQ(unsigned __int8 intbit);
                
		void RemoveTapeHack(void);
		void InstallTapeHack(void);
		bool TapeHackPresent(void);
		void DoPush(unsigned __int16 addr);

		int SetNMI(void);
		void ResetNMI(int val);

		void TriggerNMI(void);

		void FixULA(void);

		unsigned __int8 *GetNormalPtr(unsigned __int16 addr);
		unsigned __int32 *GetMultiPtr(unsigned __int16 addr);

		bool quit;
		bool *ram_available, no_line[148], thin_line[148], wide_line[148];

		//interrupt control and status
		unsigned __int8 int_control, int_status, ulavalues[16], nowpage;
	private:
		void external_keepalive(void);

		//functions dealing with memory mapped i/o
		unsigned __int8 o_read(broken_word addr);
		int o_write(broken_word addr, unsigned __int8 value);
		unsigned __int8 f_read(broken_word addr);
		int f_write(broken_word addr, unsigned __int8 o_value, unsigned __int32 f_value);

		//counter functions
		void ChangeCounterMode(unsigned __int8 newmode);
		void SendToCounter(unsigned __int8 newvalue);

		//normal memory variables
		unsigned __int8 **o_r_mem, **o_w_mem, *o_mem, *o_junk;
		unsigned __int8 **o_rom_ptrs;

		//multiplexed memory variables
		unsigned __int32 **f_r_mem, **f_w_mem, *f_mem, *f_junk;
		unsigned __int32 **f_rom_ptrs;

		bool mapped_flags[256], rom_present[16];
		access_type_minor *style_flags;

		unsigned __int8 *nz_table;

		//the classes upon which input/output is based
		C_gfx_api *gfxptr;
		C_sound_api *soundptr;

		//counter mode
		int counter_mode;

		//interrupt flags
		bool irq, irqm, nmi;

		memory_access *lblock;
		memory_access **types;

		unsigned __int8 lastpage;
		unsigned __int16 normal_tape_entry;

		unsigned char backup_bytes[14];

		FILE *out;
};

#define C_FLAG	0x01
#define Z_FLAG	0x02
#define I_FLAG	0x04
#define D_FLAG	0x08
#define B_FLAG	0x10
#define A_FLAG	0x20	//always flag
#define V_FLAG	0x40
#define N_FLAG	0x80

#define o_r_memory(addr, val)	val = (mapped_flags[addr.b.h] ? o_read(addr) : o_r_mem[addr.b.h][addr.b.l]); //fprintf(out, "r %04x\n", addr.a);
#define o_w_memory(addr, val)	mapped_flags[addr.b.h] ? o_write(addr, val) : (o_w_mem[addr.b.h][addr.b.l] = val); //fprintf(out, "w %04x\n", addr.a);

#define o_s_r_memory(addr, val)	val = o_r_mem[0x01][addr]; //fprintf(out, "r 01%02x\n", addr);
#define o_s_w_memory(addr, val)	o_w_mem[0x01][addr] = val; //fprintf(out, "w 01%02x\n", addr);
#define o_z_r_memory(addr, val)	val = o_r_mem[0x00][addr]; //fprintf(out, "r 00%02x\n", addr);
#define o_z_w_memory(addr, val)	o_w_mem[0x00][addr] = val; //fprintf(out, "w 00%02x\n", addr);

#define HIGH_TONE_IRQ		0x40
#define DATA_RECEIVE_IRQ	0x20
#define DATA_SEND_IRQ		0x10
#define RTC_IRQ				0x08
#define DISPLAY_IRQ			0x04
#define POWER_IRQ			0x02
#define MASTER_IRQ			0x01

#define NMI_CLEAR			0x80
#define HIGH_TONE_CLEAR		0x40
#define RTC_CLEAR			0x20
#define DISPLAY_CLEAR		0x10

/* TAPE FAST-LOAD HACK */
#define TAPE_SERVICE		0x8b

#endif