/*

	ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

	This is open software, distributed under the GPL 2, see 'Copying' for details

	counter.cpp
	===========

	A very small source file, which deals with writes to the Electron counter

*/
#include "6502.h"

#include "tape.h"
extern C_Tape tape;

void C_6502ULA::ChangeCounterMode(unsigned __int8 newmode)
{
	unsigned __int8 oldmode;

	oldmode = counter_mode;
	counter_mode = newmode;

	switch(counter_mode)
	{
		case 0 : //switching to casette input
			tape.tape_read = true;
			soundptr->SetOff();
		break;

		case 1 : //switching to sound generator
			soundptr->SetOn();
		break;

		case 2 : //switching to casette output
			tape.tape_read = false;
			soundptr->SetOff();
		break;

		case 3 : //'not used'
//			fprintf(out, "switching to 'unused' counter mode\n");
		break;
	}
}

void C_6502ULA::SendToCounter(unsigned __int8 newvalue)
{
	switch(counter_mode)
	{
		case 0 :
		break;

		case 1 :
			soundptr->SetFrequency(1000000 / (newvalue+1));
		break;
	}
}

