#ifndef DEFINES_H
#define DEFINES_H

#define name_string "ElectrEm beta 2"
#define error_string "ElectrEm beta 2 FATAL ERROR"

#ifdef TARGET_ALLEGRO
#include <allegro.h>

#define mainproc() main(void)
#define target_setup() allegro_init(); install_timer();
#define target_vars() //nothing
#define Error(x) {allegro_exit(); printf("FATAL ERROR : %s\n", x); exit(1);}
#endif

#ifdef TARGET_SVGALIB
#define mainproc() main(void)
#define target_setup() //nothing
#define target_vars() //nothing
#define Error(x) {printf("ERROR : %s\n", x); exit(1);}
#endif

#ifdef TARGET_WIN32

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#define mainproc() WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
#define target_setup() {winfo.hInstance = hInstance; winfo.nShowCmd = nShowCmd; winfo.hWnd = GetDesktopWindow();}
#define END_OF_MAIN() //nothing

struct win_details
{
	HINSTANCE hInstance;
	HWND hWnd;
	int nShowCmd;
};

extern win_details winfo;
#define Error(x) {MessageBox(winfo.hWnd, x, error_string, MB_OK | MB_ICONERROR); PostQuitMessage(0); return 1;}

#define target_vars() win_details winfo;

#else

#ifndef __int8
#define __int8 char
#endif

#ifndef __int16
#define __int16 short
#endif

#ifndef __int32
#define __int32 int
#endif

#endif

union broken_word
{
	unsigned __int16 a;

	struct
	{
		unsigned __int8 l, h;
	}b;
};

union broken_quad
{
	unsigned __int32 a;

	struct
	{
		unsigned __int8 b0, b1, b2, b3;
	}b;
};

#endif