#ifndef ELECSCREEN_H
#define ELECSCREEN_H

#include "gfx.h"

struct conv_element
{
	broken_quad h1, h2, l1, l2;
};

struct conv_table
{
	conv_element *b_table_wide, *b_table_thin;
	bool spaced, wide;
	int pitch;
};

class C_screen_pels
{
	public :
		virtual void DrawPelLine(void) = 0;
		virtual void DrawBlankLine(void) = 0;
		virtual void InitDisplay(void) = 0;
		virtual void EndDisplay(void) = 0;
		virtual void Setup(void) = 0;
		virtual void End(void) = 0;

		bool locked;
		conv_table *c_table;
		int l_ptr;
		unsigned __int8 *mptr;
		C_bitmap img;
};

class C_screen_big : public C_screen_pels
{
	public :
		void DrawPelLine(void);
		void DrawBlankLine(void);
		void InitDisplay(void);
		void EndDisplay(void);
		void Setup(void);
		void End(void);
};

class C_screen_small : public C_screen_pels
{
	public :
		void DrawPelLine(void);
		void DrawBlankLine(void);
		void InitDisplay(void);
		void EndDisplay(void);
		void Setup(void);
		void End(void);
};

class C_screen_wide : public C_screen_pels
{
	public :
		void DrawPelLine(void);
		void DrawBlankLine(void);
		void InitDisplay(void);
		void EndDisplay(void);
		void Setup(void);
		void End(void);
};

class C_screen
{
	public :
		C_screen(C_gfx_api &api);
		~C_screen(void);

		void Kill(void);

		void Keepalive(void);
		bool Setup(void);
		void SetPalette(unsigned __int8 addr, unsigned __int8 val, bool valid);
		void ChangeGFXMode(unsigned __int8 newmode);
		void SaveImage(char *name);
		void SetSize(bool big, int scalelevel, bool scaletype);
		bool GetSize(void);

		broken_word vid_addr;
		bool wide, save;

	private :
		bool saved;
		C_gfx_api *gfxptr;

		C_screen_pels *peldraw;

		C_screen_big big_pels;
		C_screen_small small_pels;
		C_screen_wide wide_pels;

		int line, linebig, y;
		conv_table *gfx_tables;

		conv_element cols_2_m[256], cols_4_m[256], cols_16_m[256];
		conv_element cols_2_w[256], cols_4_w[256], cols_16_w[256];
		conv_element cols_2_t[256], cols_4_t[256];

		int blank;

		unsigned __int8 cols[16];

		friend C_screen_big;
		friend C_screen_small;
		friend C_screen_wide;
};

#endif
