#ifndef GFX_H
#define GFX_H

#include "defines.h"
#include "input.h"
#include <stdio.h>

#ifdef TARGET_WIN32
#include <ddraw.h>
#define DDRAW_INIT_STRUCT(x) { memset(&x, 0, sizeof(x)); x.dwSize = sizeof(x);}
extern bool lbutton;
#endif

#ifdef TARGET_SVGALIB
#include <vga.h>
#endif

#ifndef TARGET_WIN32
struct RECT
{
	int top, bottom, left, right;
};
#endif

#ifdef TARGET_ALLEGRO
#include <allegro.h>
#endif

class C_bitmap;

struct character
{
	unsigned char w, h;
	unsigned char *data;
};

class C_gfx_api
{
	public :
		int Setup(unsigned int w, unsigned int h, char *appname);
		void shutdown(void);
		void SetNormalResolution(unsigned int w, unsigned int h);

		void FinishPalette(void);
		void SetPaletteEntry(int id, float r, float g, float b);

		bool LoadFont(char *name);

		void Clean(void);
		void Rectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, int colour);
		void HorizLine(int x1, int y1, int x2, int colour);

		int WriteChar(char letter, int x, int y, int cbase);
		int WriteString(char *text, int x, int y, int cbase);
		int StrLen(char *text);

		bool EnableGUI(void);
		bool DisableGUI(void);
		bool GetButtonOneState(void);
		void BeginRedraw(void);
		void EndRedraw(void);

		void SetTextArea(int x1, int y1, int x2, int y2);
		void DrawLogo(void);

		void SetStretchLevel(int newlev, bool cleanscale);

		int GetStretchLevel(void);
		bool GetCleanScale(void);

		~C_gfx_api(void);
		C_gfx_api(void);

		unsigned int c_bpp, scw, sch, tx, ty, mx, my, fonth;

		#ifdef TARGET_SVGALIB
		void UpdateMouse(int button, int dx, int dy);
		#endif TARGET_SVGALIB

		#ifdef TARGET_WIN32
		bool gui_active;
		void Restore(void);
		#endif

	friend C_bitmap;

	private :
		int charstart, charend;
		character *chars;
		int lockcount, mbutton, oldw, oldh;
		bool SetResolution(unsigned int w, unsigned int h);

		int slevel, rslevel;
		bool cleanscale;

		void SelectStretchLevel(int truew, int trueh);

		RECT TextArea, StretchArea;

		#ifdef TARGET_SVGALIB
		char *backup;
		char *cursor;
		int mwidth, mheight;

		struct {
			__int8 red, green, blue;
			}cols[256];
		void EnableMouse(void);
		void DisableMouse(void);

		#endif TARGET_SVGALIB

		#if TARGET_WIN32 || TARGET_SVGALIB
		char *blogo, *backupscr;
		int lwidth, lheight;
		#endif

		#ifdef TARGET_ALLEGRO
		BITMAP *curs, *logo, *backupscr;
		PALETTE cols;
		#endif

		#ifdef TARGET_WIN32
		PALETTEENTRY cols[256];
		HWND hWnd;
		char *className;

		LPDIRECTDRAW lpdd;
		LPDIRECTDRAW4 lpdd4;
		LPDIRECTDRAWSURFACE4 front4;
		LPDIRECTDRAWPALETTE pal;
		DDSURFACEDESC2 ddsd;
		#endif
};

class C_bitmap
{
	public:
		C_bitmap(void);
		~C_bitmap(void);

		bool Create(C_gfx_api &apiref, int w, int h);
		bool Destroy(void);

		bool BeginDraw(void);
		bool BeginRead(void);
		void EndOperation(void);

		void DumpToFile(char *name);

		unsigned __int8 *GetLinePtr(int y);
		void ReleaseLinePtr(void);

		void Blit(void);

		int pitch;
		char *errtext;
	private :
		C_gfx_api *api;

		#ifdef TARGET_ALLEGRO
		BITMAP *surface;
		#endif

		#ifdef TARGET_WIN32
		LPDIRECTDRAWSURFACE4 surface;
		DDSURFACEDESC2 sdesc;
		unsigned __int8 *base;
		#endif

		#ifdef TARGET_SVGALIB
		unsigned __int8 *surface;
		#endif

		int width, height;
};

extern C_gfx_api *mouse;

#endif