/*

  ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

  This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "gfx.h"
extern C_gfx_api gfxdrvr;

#include "elecscreen.h"
extern C_screen elec_screen;

#include "6502.h"
extern C_6502ULA electron;

#include "tape.h"
extern C_Tape tape;

#include "wd1770.h"
extern C_WD1770 disk;

#include "input.h"
extern C_input_api inputdrvr;

#include <string.h>
#include <malloc.h>
#include "gui.h"

struct down_slide
{
	char *name;
	void (* click)(void);
};

struct top_entry
{
	char *name;
	down_slide *down;
};

bool done, malld;
gui_element *elements[5]; //assume list will never go more than 3 deep
unsigned char keybuf[8], keyfirst;

void free_gui(gui_element *first)
{
	gui_element *top = first;

	if(first)
	{
		while(first->proc)
		{
			first->proc(GUIMSG_KILL, 0, 0, first);

			if(first->data)
				free(first->data);

			if(first->data2)
				free(first->data2);

			first++;
		}
	}

	free(top);
}

gui_messages gui_left_element(gui_messages message, int x, int y, gui_element *owner)
{
	switch(message)
	{
		case GUIMSG_DRAW :
		return gui_left_string(message, x, y, owner);

		case GUIMSG_LCLICK :
			callfunc sel;

			sel = *((callfunc *)owner->data2);
			sel();
		return GUIMSG_REDRAW;
	}

	return GUIMSG_NONE;
}

gui_messages gui_top_element(gui_messages message, int x, int y, gui_element *owner)
{
	switch(message)
	{
		case GUIMSG_DRAW :
		return gui_left_string(message, x, y, owner);

		case GUIMSG_LCLICK :
			down_slide *top, *c, *tmp;
			gui_element *ret;
			int x1, x2;
			int num = 0, num2 = 0, c2, highwidth = 0, width, ypos;

			c = top = *((down_slide **)owner->data2);
			while(c->name)
			{
				if(strcmp(c->name, "<>"))
				{
					num++;
					width = gfxdrvr.StrLen(c->name);
					if(width > highwidth)
						highwidth = width;
				}

				num2++;
				c++;
			}

			highwidth += 10;
			kill_front();
			malld = true;
			ret = elements[2] = (gui_element *)malloc(sizeof(gui_element)*(num+2));

			c2 = 0;

			x1 = owner->x1; x2 = owner->x1+highwidth;
			if(x2 >= 640)
			{
				x1 -= (x2 - 639);
				x2 = 639;
			}

			ret[c2].x1 = x1; ret[c2].y1 = owner->y2+1;
			ret[c2].x2 = x2; ret[c2].y2 = (FONT_H*num2)+owner->y2+1;
		 	ret[c2].c = 132; ret[c2].proc = gui_draw_rect;
			ret[c2].data = NULL; ret[c2].data2 = NULL;
			c2++;

			ypos = owner->y2+1;
			tmp = top;
			while(tmp->name)
			{
				if(strcmp(tmp->name, "<>"))
				{
					ret[c2].x1 = x1+5; ret[c2].y1 = ypos;
					ypos += FONT_H;
					ret[c2].x2 = x2; ret[c2].y2 = ypos;

					if(tmp->click)
					{
						ret[c2].c = 144; ret[c2].proc = gui_left_element;

						ret[c2].data = malloc(strlen(tmp->name)+1);
						memcpy(ret[c2].data, tmp->name, strlen(tmp->name)+1);

						ret[c2].data2 = malloc(sizeof(void *));
						*((callfunc *)ret[c2].data2) = tmp->click;
					}
					else
					{
						ret[c2].c = 152; ret[c2].proc = gui_left_string;

						ret[c2].data = malloc(strlen(tmp->name)+1);
						memcpy(ret[c2].data, tmp->name, strlen(tmp->name)+1);

						ret[c2].data2 = NULL;
					}

					c2++;
				}
				else
					ypos += FONT_H;

				tmp++;
			}

			ret[c2].proc = NULL;
			ret[c2].data = ret[c2].data2 = NULL;
		return GUIMSG_REDRAW;
	}

	return GUIMSG_NONE;
}

gui_messages gui_draw_logo(gui_messages message, int x, int y, gui_element *owner)
{
	if(message == GUIMSG_DRAW)
		gfxdrvr.DrawLogo();

	return GUIMSG_NONE;
}

gui_element backdrop[] =
{
	{0, FONT_H+3, 640, 511, 0, gui_draw_rect, NULL},
	{0, 0, 0, 0, 0, gui_draw_logo, NULL},

	{0, FONT_H+3, 640, (FONT_H*2)+3, 176, gui_centre_string, name_string},

	{0, (FONT_H*3)+3, 640, (FONT_H*4)+3, 184, gui_left_string, "Programming & that : "},
	{0, (FONT_H*4)+3, 640, (FONT_H*5)+3, 160, gui_centre_string, "Thomas Harte (T.Harte@excite.com)"},
	{0, (FONT_H*5)+3, 640, (FONT_H*6)+3, 160, gui_centre_string, "http://www.softysoft.cjb.net"},

	{0, (FONT_H*7)+3, 640, (FONT_H*8)+3, 184, gui_left_string, "Electron image & emulator name supplied by : "},
	{0, (FONT_H*8)+3, 640, (FONT_H*9)+3, 160, gui_centre_string, "Ian Marshall (ian@imarshall.karoo.co.uk)"},
	{0, (FONT_H*9)+3, 640, (FONT_H*10)+3, 160, gui_centre_string, "http://www.imarshall.karoo.net"},

	{0, 0, 0, 0, 0, NULL, NULL}
};

void redraw_gui(void)
{
	gui_element *cg, **top;

	gfxdrvr.BeginRedraw();

	top = elements;
	while(*top)
	{
		cg = *top;
		while(cg->proc)
		{
			cg->proc(GUIMSG_DRAW, 0, 0, cg);
			cg++;
		}
		top++;
	}

	gfxdrvr.EndRedraw();
};

void handle_gui(void)
{
	gui_element *cg, **top, *claimant;
	bool onfront, redraw;
	bool one, oldone;
	#ifdef TARGET_WIN32
	MSG msg;
	#endif

	gfxdrvr.EnableGUI();
	redraw_gui();
	inputdrvr.ClearBuffer();

	one = gfxdrvr.GetButtonOneState();
	done = false;
	while(!done)
	{
		redraw = false;

		oldone = one;
		one = gfxdrvr.GetButtonOneState();
		if(one && !oldone)
		{
			claimant = NULL;
			top = elements;
			while(*top)
			{
				cg = *top;

				while(cg->proc)
				{
					if( (gfxdrvr.mx >= cg->x1) && (gfxdrvr.my >= cg->y1) && (gfxdrvr.mx < cg->x2) && (gfxdrvr.my < cg->y2))
					{
						claimant = cg;

						onfront = *top == elements[2];
					}
					cg++;
				}

				top++;
			}

			if(!onfront && elements[2])
			{
				kill_front();
				redraw = true;
			}

			if(claimant)
			{
				switch(claimant->proc(GUIMSG_LCLICK, gfxdrvr.mx, gfxdrvr.my, claimant))
				{
					case GUIMSG_DONE :
						done = true;
					break;

					case GUIMSG_REDRAW :
						redraw = true;
					break;
				}
			}

		}

		inputdrvr.UpdateKeyStates();
		if(inputdrvr.NewKey())
		{
			top = elements;
			while(*top)
			{
				cg = *top;

				while(cg->proc)
				{
					switch(cg->proc(GUIMSG_KEYPRESS, gfxdrvr.mx, gfxdrvr.my, cg))
					{
						case GUIMSG_DONE :
							done = true;
						break;

						case GUIMSG_REDRAW :
							redraw = true;
						break;
					}
					cg++;
				}

				top++;
			}
		}


		if(redraw)
			redraw_gui();

		#ifdef TARGET_WIN32
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{ 
			if (msg.message == WM_QUIT)
				done = electron.quit = true;
	
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		#endif
	}

	gfxdrvr.DisableGUI();
}

gui_element *create_topbar(top_entry *top)
{
	top_entry *tmp;
	gui_element *ret;
	int c = 0, c2, xpos;

	tmp = top;
	while(tmp->name)
	{
		if(strcmp(tmp->name, "<>"))
			c++;
		tmp++;
	}

	ret = (gui_element *)malloc(sizeof(gui_element)*(c+2));

	c2 = 0;

	ret[c2].x1 = 0; ret[c2].y1 = 0;
	ret[c2].x2 = 639; ret[c2].y2 = FONT_H+2;
 	ret[c2].c = 131; ret[c2].proc = gui_draw_rect;
	ret[c2].data = NULL; ret[c2].data2 = NULL;
	c2++;

	xpos = 1;
	tmp = top;
	while(tmp->name)
	{
		if(strcmp(tmp->name, "<>"))
		{
			ret[c2].x1 = xpos; ret[c2].y1 = 1;
			xpos += gfxdrvr.StrLen(tmp->name);
			ret[c2].x2 = xpos; ret[c2].y2 = FONT_H+1;
			xpos += 24;
			ret[c2].c = 136; ret[c2].proc = gui_top_element;

			ret[c2].data = malloc(strlen(tmp->name)+1);
			memcpy(ret[c2].data, tmp->name, strlen(tmp->name)+1);

			ret[c2].data2 = malloc(sizeof(down_slide *));
			*((down_slide **)ret[c2].data2) = tmp->down;

			c2++;
			tmp++;
		}
		else
		{
			tmp++;
			xpos = 638 - gfxdrvr.StrLen(tmp->name);
		}
	}

	ret[c2].proc = NULL;
	ret[c2].data = ret[c2].data2 = NULL;

	return ret;
}

void exit_now(void)
{
	done = true;
}

void quit_now(void)
{
	done = true;
	electron.quit = true;
}

void quicksave_image(void)
{
	elec_screen.SaveImage(NULL);
	kill_front();
}

#include "snapshot.h"

void quicksave_snapshot(void)
{
	SaveSnapshot("kwiksave.uef");
	kill_front();
}

void quickload_snapshot(void)
{
	LoadSnapshot("kwiksave.uef");
	kill_front();
}

#include "load.h"

down_slide file_menu[] =
{
	{"Open UEF (tape or disk)...", load_uef},
	{"<>", NULL},
	{"Save state...", NULL},
	{"Quick Save state", quicksave_snapshot},
	{"Quick Load state", quickload_snapshot},
	{"<>", NULL},
	{"Save screen grab...", NULL},
	{"Quick screen grab", quicksave_image},
	{"<>", NULL},
	{"Back to Electron", exit_now},
	{"<>", NULL},
	{"Exit to operating system", quit_now},
	{NULL, NULL},
};

//#include "elksetup.h"

down_slide options_menu[] =
{
	{"Set screen / load mode...", setup_gfx},
	{"<>", NULL},
	{"Set hardware configuration...", NULL},
	{"Select multiplex options...", NULL},
	{"<>", NULL},
	{"Select key map...", NULL},
	{NULL, NULL},
};

void eject_tape(void)
{
	tape.Close();
	kill_front();
}

void rewind_tape(void)
{
	tape.Rewind();
	kill_front();
}

down_slide tape_menu[] =
{
	{"Browse tape blocks...", NULL},
	{"Rewind tape", rewind_tape},
	{"Eject tape", eject_tape},
	{NULL, NULL},
};

void eject_disk(void)
{
	disk.Close();
	kill_front();
}

down_slide disc_menu[] =
{
	{"Browse disc blocks...", NULL},
	{"Eject disc", eject_disk},
	{NULL, NULL},
};

void reboot_elk(void)
{
	electron.SuperReset();
	kill_front();
}

down_slide control_menu[] =
{
	{"Super-hard reset", reboot_elk},
	{NULL, NULL},
};

#include "cheat.h"

down_slide cheat_menu[] =
{
	{"Enable/Disable...", NULL},
	{"Find new...", find_new_cheat},
	{NULL, NULL},
};

top_entry menu[] =
{
	{"File", {file_menu}},
	{"Options", {options_menu}},
	{"Control", {control_menu}},
	{"Tape", {tape_menu}},
	{"Disc", {disc_menu}},
	{"<>", NULL},
	{"Cheats", {cheat_menu}},
	{NULL, NULL},
};

void do_gui(void)
{
	keyfirst = 0;
	elements[0] = backdrop;
	elements[1] = create_topbar(menu);
	elements[2] =
	elements[3] =
	elements[4] = NULL;

	handle_gui();

	free_gui(elements[1]);
}
