/*

  ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

  This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "keyboard.h"
#include <string.h>

#include "gui.h"

#include "input.h"
extern C_input_api inputdrvr;

#include "6502.h"
extern C_6502ULA electron;

#include "elecscreen.h"
extern C_screen elec_screen;

unsigned __int8 keystates[16];

#define LINE0	0
#define LINE1	16
#define LINE2	32
#define LINE3	48
#define LINE4	64
#define LINE5	80
#define LINE6	96
#define LINE7	112
#define LINE8	128
#define LINE9	144
#define LINE10	160
#define LINE11	176
#define LINE12	194
#define LINE13	210

unsigned __int8 get_keyboard(broken_word addr)
{
	return 	((addr.a&0x0001) ? 0 : keystates[0]) |
		((addr.a&0x0002) ? 0 : keystates[1]) |
		((addr.a&0x0004) ? 0 : keystates[2]) |
		((addr.a&0x0008) ? 0 : keystates[3]) |
		((addr.a&0x0010) ? 0 : keystates[4]) |
		((addr.a&0x0020) ? 0 : keystates[5]) |
		((addr.a&0x0040) ? 0 : keystates[6]) |
		((addr.a&0x0080) ? 0 : keystates[7]) |
		((addr.a&0x0100) ? 0 : keystates[8]) |
		((addr.a&0x0200) ? 0 : keystates[9]) |
		((addr.a&0x0400) ? 0 : keystates[10]) |
		((addr.a&0x0800) ? 0 : keystates[11]) |
		((addr.a&0x1000) ? 0 : keystates[12]) |
		((addr.a&0x2000) ? 0 : keystates[13]);
}

#define keys inputdrvr.array

#ifdef TARGET_WIN32
int msgc;
#endif

void update_keyboard(void)
{
	memset(keystates, 0, 14);
	inputdrvr.UpdateKeyStates();

	/* */
	if(keys[EKEY_RIGHT])		keystates[0] |= 1;
	if(keys[EKEY_INSERT])		keystates[0] |= 2;
	if(keys[EKEY_SPACE])		keystates[0] |= 8;
	/* */
	if(keys[EKEY_LEFT])			keystates[1] |= 1;
	if(keys[EKEY_DOWN])			keystates[1] |= 2;
	if(keys[EKEY_ENTER])		keystates[1] |= 4;
	if(keys[EKEY_BACKSPACE])	keystates[1] |= 8;
	/* */
	if(keys[EKEY_MINUS])		keystates[2] |= 1;
	if(keys[EKEY_UP])			keystates[2] |= 2;
	if(keys[EKEY_QUOTE])		keystates[2] |= 4;
	/* */
	if(keys[EKEY_0])			keystates[3] |= 1;
	if(keys[EKEY_P])			keystates[3] |= 2;
	if(keys[EKEY_COLON])		keystates[3] |= 4;
	if(keys[EKEY_SLASH])		keystates[3] |= 8;
	/* */
	if(keys[EKEY_9])			keystates[4] |= 1;
	if(keys[EKEY_O])			keystates[4] |= 2;
	if(keys[EKEY_L])			keystates[4] |= 4;
	if(keys[EKEY_STOP])			keystates[4] |= 8;
	/* */
	if(keys[EKEY_8])			keystates[5] |= 1;
	if(keys[EKEY_I])			keystates[5] |= 2;
	if(keys[EKEY_K])			keystates[5] |= 4;
	if(keys[EKEY_COMMA])		keystates[5] |= 8;
	/* */
	if(keys[EKEY_7])			keystates[6] |= 1;
	if(keys[EKEY_U])			keystates[6] |= 2;
	if(keys[EKEY_J])			keystates[6] |= 4;
	if(keys[EKEY_M])			keystates[6] |= 8;
	/* */
	if(keys[EKEY_6])			keystates[7] |= 1;
	if(keys[EKEY_Y])			keystates[7] |= 2;
	if(keys[EKEY_H])			keystates[7] |= 4;
	if(keys[EKEY_N])			keystates[7] |= 8;
	/* */
	if(keys[EKEY_5])			keystates[8] |= 1;
	if(keys[EKEY_T])			keystates[8] |= 2;
	if(keys[EKEY_G])			keystates[8] |= 4;
	if(keys[EKEY_B])			keystates[8] |= 8;
	/* */
	if(keys[EKEY_4])			keystates[9] |= 1;
	if(keys[EKEY_R])			keystates[9] |= 2;
	if(keys[EKEY_F])			keystates[9] |= 4;
	if(keys[EKEY_V])			keystates[9] |= 8;
	/* */
	if(keys[EKEY_3])			keystates[10] |= 1;
	if(keys[EKEY_E])			keystates[10] |= 2;
	if(keys[EKEY_D])			keystates[10] |= 4;
	if(keys[EKEY_C])			keystates[10] |= 8;
	/* */
	if(keys[EKEY_2])			keystates[11] |= 1;
	if(keys[EKEY_W])			keystates[11] |= 2;
	if(keys[EKEY_S])			keystates[11] |= 4;
	if(keys[EKEY_X])			keystates[11] |= 8;
	/* */
	if(keys[EKEY_1])			keystates[12] |= 1;
	if(keys[EKEY_Q])			keystates[12] |= 2;
	if(keys[EKEY_A])			keystates[12] |= 4;
	if(keys[EKEY_Z])			keystates[12] |= 8;
	/* */
	if(keys[EKEY_ESC])			keystates[13] |= 1;
	if(keys[EKEY_TAB])			keystates[13] |= 2;

	if(keys[EKEY_LCTRL] || keys[EKEY_RCTRL] || keys[EKEY_CAPSLCK])
		keystates[13] |= 4;

	if(keys[EKEY_LSHIFT] || keys[EKEY_RSHIFT])
		keystates[13] |= 8;
	/* */

	if(keys[EKEY_F1])
		do_gui();

	if(keys[EKEY_PGUP])
		electron.Reset();

	if(keys[EKEY_F12])
		electron.quit = true;

	#ifdef TARGET_WIN32
	msgc++;

	if(!(msgc&15))
	{
		MSG msg;

		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{ 
			if (msg.message == WM_QUIT)
				electron.quit = true;
	
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	#endif
}

#undef keys