/*

	ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

	This is open software, distributed under the GPL 2, see 'Copying' for details

	This source file just loads the various ROMs and says 'go'

*/
#include "gfx.h"
#include "input.h"
#include "6502.h"
#include "sound.h"
#include "tape.h"
#include "elecscreen.h"
#include "wd1770.h"
#include "load.h"
#include "config.h"
#include "cheat.h"
#include <stdio.h>

target_vars();

C_input_api inputdrvr;

C_gfx_api gfxdrvr;
C_screen elec_screen(gfxdrvr);

C_sound_api sounddrvr;
C_6502ULA electron(sounddrvr);

C_WD1770 disk;

C_Tape tape;
C_config settings;

int mainproc()
{
	settings.Open("electrem.cfg");

	target_setup();

	seed_cdir();
	init_cheat_list();

	if(electron.LoadRom(-1, "roms/os.rom"))
		Error("Cannot load operating system rom (should be roms/os.[rom|rgz|rom.gz])");

	if(electron.LoadRom(10, "roms/basic.rom"))
		Error("Cannot load BASIC rom (should be roms/basic.[rom|rgz|rom.gz])");

	electron.LoadRom(12, "roms/plus1.rom");
	electron.LoadRom(4, "roms/adfs.rom");

	if(settings.FindSetting("tapespeed"))
	{
		if(settings.ReadSetting().result_int == 3)
			electron.InstallTapeHack();
	}

	if(elec_screen.Setup())
		Error("Cannot setup graphics subsystem");

	if(inputdrvr.Setup())
		Error("Cannot setup input devices");

	sounddrvr.Setup();
	sounddrvr.SetOff();
	sounddrvr.SetVolume(1.0f);

	//default Acorn ROM mappings are :
	//
	//	0, 1	- second external socket on expansion module (sk2)
	//	2, 3	- first external socket on the expansion module (sk1)
	//	4	- disc
	//	5, 6	- USER applications
	//	7	- modem interface ROM
	//	8, 9	- keyboard
	//	10, 11	- BASIC
	//	12	- expansion module operating system
	//	13	- high priority slot in expansion module
	//	14	- ECONET
	//	15	- reserved (plus 1 rom?)


	// things to implement for this ROM set :
	//
	//	ADC/centronics/control at fc70/1/2
	//	6850 ACIA at fc60 to fc6f
	//	more full WD1770 at fcc0 to fccf
	//	tube as far as 'I'm not here' (?)

	electron.Reset();

	electron.GoNormal();

	kill_cdir();
	free_cheat_list();
	elec_screen.Kill();
	settings.Close();

	return 0;
}

END_OF_MAIN();
