/*

  ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

  This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "uef.h"
#include "6502.h"
#include <stdio.h>
#include <stdlib.h>

extern C_6502ULA electron;

void C_6502ULA::FixULA(void)
{
	int c, rc;
	broken_word addr;
	unsigned __int8 *rptr;

	c = 16;
	while(c--)
	{
		addr.a = 0xfe00 | c;
		o_write(addr, ulavalues[c]);
	}

	if(int_status&1)
		irq = true;

	c = nowpage;
	if((rptr = o_rom_ptrs[c]) && rom_present[c])
	{
		rc = 64;
		while(rc--)
		{
			mapped_flags[128+rc] = false;
			o_r_mem[128+rc] = &rptr[rc << 8];
		}
	}
	else
	{
		rc = 64;
		while(rc--)
		{
			mapped_flags[128+rc] = true;
		}
	}
}

bool LoadSnapshot(char *name)
{
	C_UEF in;
	unsigned char temp;

	if(!in.Open(name, "r", 5, 0))
	{
		in.FindId(0x0400);
		in.ReadSome(&temp, 1);
		in.ReadSome(&electron.a, 1);
		in.ReadSome(&electron.p, 1);
		in.ReadSome(&electron.x, 1);
		in.ReadSome(&electron.y, 1);
		in.ReadSome(&electron.s, 1);
		in.ReadSome(&electron.pc.b.l, 1);
		in.ReadSome(&electron.pc.b.h, 1);

		in.FindId(0x0401);
		in.ReadSome(&temp, 1);
		in.ReadSome(&electron.int_control, 1);
		in.ReadSome(&electron.int_status, 1);
		in.ReadSome(&electron.ulavalues[2], 4);
		in.ReadSome(&electron.nowpage, 1);
		in.ReadSome(&electron.ulavalues[6], 9);
		electron.FixULA();

		in.FindId(0x0410);
		in.ReadSome(&temp, 1);
		in.ReadSome(&temp, 1);
		if(!temp)
		{
			in.ReadSome(electron.GetNormalPtr(0), 32768);
		}
	}

	return false;
}

bool SaveSnapshot(char *name)
{
	C_UEF out;
	unsigned char temp, buffer[22], *mbuf;

	if(!out.Open(name, "w", 5, 0))
	{
		temp = 17;
		out.WriteChunk(0x0005, 1, &temp);

		//6502 state
		buffer[0] = 0;
		buffer[1] = electron.a;
		buffer[2] = electron.p;
		buffer[3] = electron.x;
		buffer[4] = electron.y;
		buffer[5] = electron.s;
		buffer[6] = electron.pc.b.l;
		buffer[7] = electron.pc.b.h;
		out.WriteChunk(0x0400, 8, buffer);

		//ULA state
		buffer[1] = electron.int_control;
		buffer[2] = electron.int_status;
		buffer[3] = electron.ulavalues[2];
		buffer[4] = electron.ulavalues[3];
		buffer[5] = electron.ulavalues[4];
		buffer[6] = electron.ulavalues[5];
		buffer[7] = electron.nowpage;
		memcpy(&buffer[8], &electron.ulavalues[6], 9);
		buffer[17] = buffer[18] = buffer[19] = buffer[20] = 0;
		out.WriteChunk(0x0401, 21, buffer);

		//memory state
		mbuf = (unsigned char *)malloc(32768 + 2);
		mbuf[0] = mbuf[1] = 0;
		memcpy(&mbuf[2], electron.GetNormalPtr(0), 32768);
		out.WriteChunk(0x0410, 32768 + 2, mbuf);
		free(mbuf);

		out.Close();
	}

	return false;
}
