#ifndef SOUND_H
#define SOUND_H

#include "defines.h"

#ifdef TARGET_WIN32
#include <mmreg.h>
#include <dsound.h>

#define MIN_VOLUME	DSBVOLUME_MIN
#define MAX_VOLUME	DSBVOLUME_MAX
#endif

#ifdef TARGET_SVGALIB
#define MIN_VOLUME	0
#define MAX_VOLUME	256
#endif

#ifdef TARGET_ALLEGRO
#define MIN_VOLUME	0
#define MAX_VOLUME	255
#endif

class C_sound_api
{
	public :
		C_sound_api(void);
		~C_sound_api(void);

		bool Setup(void);
		void SetVolume(float vol);
		void SetFrequency(int freq);
		void SetOn(void);
		void SetOff(void);

	private :
		#ifdef TARGET_WIN32
		LPDIRECTSOUND lpds;
		LPDIRECTSOUNDBUFFER dsbuffer;
		#endif

		#ifdef TARGET_ALLEGRO
		__int8 channum;
		SAMPLE *square;
		#endif
		
		#ifdef TARGET_SVGALIB
		int audio_fd;
		#endif

		int volume;
		bool vol_override;
};

#endif