/*

	ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

	This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "timing.h"

#ifdef TARGET_ALLEGRO
#include <allegro.h>
volatile int timevar;

void timing_func(void)
{
	timevar++;
}

END_OF_FUNCTION(timing_func);
#endif

#ifdef TARGET_SVGALIB

#include <sys/time.h>
#include <signal.h>
#include <stdio.h>
volatile sig_atomic_t timevar;

void timing_func(int sig)
{
	timevar++;
	signal(sig, timing_func);
}
#endif

bool C_timer::SetBeatsPerSecond(int beats)
{
	#ifdef TARGET_SVGALIB
	struct itimerval itrm;
	int nans;

	if(beats > 100)
	{
		subtotal = beats / 100;
		nans = 100000 / beats;
	}
	else
	{
		subtotal = 1;
		nans = 1000 / beats;
	}

	signal(SIGALRM, timing_func);

	itrm.it_interval.tv_sec = 0;
	itrm.it_interval.tv_usec = nans;

	itrm.it_value = itrm.it_interval;

	setitimer(ITIMER_REAL, &itrm ,NULL);
	#endif

	#ifdef TARGET_ALLEGRO
	LOCK_FUNCTION(timing_func);
	LOCK_VARIABLE(timevar);

	if(beats > 100)
	{
		subtotal = beats / 100;
		beats /= subtotal;
	}
	else
		subtotal = 1;

	install_int_ex(timing_func, BPS_TO_TIMER(beats));
	#endif

	#ifdef TARGET_WIN32
	if(beats > 50)
	{
		aim = beats / 50;
		beats = 50;
	}

	add = 1000 / beats;
	target = GetTickCount() + add;
	subtotal = aim;
	#endif

	return false;
}

void C_timer::RegisterBeat(void)
{
	#if TARGET_ALLEGRO || TARGET_SVGALIB
	current++;
	if(current >= subtotal)
	{
		current = 0;
		while(!timevar);
		timevar = 0;
	}
	#endif

	#ifdef TARGET_WIN32
	DWORD current;

	if(!(subtotal--))
	{
		do{
			current = GetTickCount();
		}while(current < target);

		while(target < current)
			target += add;

		subtotal = aim;
	}
	#endif
}
