#ifndef UEF_H
#define UEF_H

#include "defines.h"
#include <zlib.h>

class C_UEF
{
	public :
		C_UEF(void);
		~C_UEF(void);

		bool Open(char *name, char *mode, unsigned __int8 minor, unsigned __int8 major);
		bool Restart(void);
		bool Close(void);

		bool FindNext(void);
		bool FindIdMajor(unsigned __int8 id);
		bool FindId(unsigned __int16 id);

		unsigned __int32 GetLength(void);
		unsigned __int16 GetId(void);

		unsigned __int32 ReadSome(unsigned __int8 *ptr, unsigned __int32 length);
		unsigned __int32 ReadAll(unsigned __int8 *ptr);
		bool WriteChunk(unsigned __int16 id, unsigned __int32 len, unsigned __int8 *ptr);

		bool HasFile(void);

		bool EOC(void);
		bool OverRan(void);

	private :
		gzFile file;

		broken_quad chunk_len;
		unsigned __int32 len_remaining;
		broken_word chunk_id;
		bool overeof, input;
};

#endif