#ifndef DEFINES_H
#define DEFINES_H

#include <stdio.h>

#define MIN_WAVE_FREQ	22050
#define BUFFER_SIZE	65536

extern char *error;

class C_snd_input
{
	public:

	virtual bool Open(char *name) = 0;
	virtual bool Close(void) = 0;
	virtual char GetNextValue(void) = 0;
	int GetFrequency(void);
	virtual bool Finished(void) = 0;

	int freq;
};

class C_raw : public C_snd_input
{
	public:

	bool Open(char *name);
	bool Close(void);
	char GetNextValue(void);
	bool Finished(void);
	int GetFrequency(void);

	void SetSigned(bool arg);
	void SetFrequency(int freq);

	private :

	FILE *infile;

	char *buffer, *sbuffer;
	int pos, target;
	bool last;

	bool signd;

	void NewBlock(void);
};

class C_wav : public C_snd_input
{
	public:

	bool Open(char *name);
	bool Close(void);
	char GetNextValue(void);
	bool Finished(void);
	int GetFrequency(void);

	private :

	char *buffer, *fbuffer;
	int pos, target;
	FILE *infile;
	bool small, last;

	int pos_inc, start_offs, wave_size;
	void NewBlock(void);
};

class C_voc : public C_snd_input
{
	public:

	bool Open(char *name);
	bool Close(void);
	char GetNextValue(void);
	bool Finished(void);
	int GetFrequency(void);

	private :

	char *buffer;
	int pos;
	FILE *infile;
	void NewBlock(void);
};

class C_sndcard : public C_snd_input
{
	public:

	bool Open(char *name);
	bool Close(void);
	char GetNextValue(void);
	bool Finished(void);
	int GetFrequency(void);

	private :

	void NewBlock(void);

	int bufsize, pos;
	char *data;
};

#endif
