#ifndef bbcMODEL_H_
#define bbcMODEL_H_

#include "bbcDebugTrace.h"

class bbcModel {
public:
	virtual ~bbcModel();

	virtual void Init()=0;
	virtual void InitialiseCpuState()=0;
	virtual void Reset6502()=0;
	virtual void Run()=0;
	virtual int DisassembleBytes(const t65::byte *bytes,t65::Word bytes_addr,
		char *opcode_buf,char *operand_buf)=0;
	virtual bbcReadMmioFn RomSelReadFn() const=0;
	virtual bbcWriteMmioFn RomSelWriteFn() const=0;
protected:
	bbcModel();
};

template<class Sim>
class bbcModelGeneric:
public bbcModel
{
public:
	void Init();
	void InitialiseCpuState();
	void Reset6502();
	void Run();
	int DisassembleBytes(const t65::byte *bytes,t65::Word bytes_addr,
		char *opcode_buf,char *operand_buf);
	bbcReadMmioFn RomSelReadFn() const;
	bbcWriteMmioFn RomSelWriteFn() const;

	static bbcModelGeneric<Sim> model;
private:
	static t65TYPENAME Sim::MachineType the_machine_;
#ifdef bbcDEBUG_TRACE
	bbcDebugTrace::Instr *AddInstrTrace();
#endif
};

template<class Sim>
bbcModelGeneric<Sim> bbcModelGeneric<Sim>::model;

template<class Sim>
t65TYPENAME Sim::MachineType bbcModelGeneric<Sim>::the_machine_;

template<class Sim>
int bbcModelGeneric<Sim>::DisassembleBytes(const t65::byte *bytes,
	t65::Word bytes_addr,char *opcode_buf,char *operand_buf)
{
	return Sim::DisassemblerType::Disassemble(bytes_addr,bytes,opcode_buf,
		operand_buf);
}

template<class Sim>
void bbcModelGeneric<Sim>::Init() {
	Sim::Init();
}

template<class Sim>
void bbcModelGeneric<Sim>::InitialiseCpuState() {
	Sim::InitialiseCpuState(the_machine_);
}

template<class Sim>
void bbcModelGeneric<Sim>::Reset6502() {
	Sim::Reset6502(the_machine_);
}

#ifdef bbcDEBUG_TRACE
template<class Sim>
bbcDebugTrace::Instr *bbcModelGeneric<Sim>::AddInstrTrace() {
	typedef t65TYPENAME Sim::MachineType Machine;
	bbcDebugTrace::Instr *ins=Machine::trace->NewInstr();
	t65::Word addr=ins->pc=bbcComputer::cpustate.pc;
	bbcModelBSim::ByteReader br;
	ins->bytes[0]=br(addr);
	++addr.w;
	ins->bytes[1]=br(addr);
	++addr.w;
	ins->bytes[2]=br(addr);
}
#endif

template<class Sim>
void bbcModelGeneric<Sim>::Run() {
	typedef t65TYPENAME Sim::MachineType Machine;
	typedef t65TYPENAME Sim::CPUType Cpu;

#ifdef bbcDEBUG_MAIN_LOOP
#ifdef bbcDEBUG_TRACE
	bbcDebugTrace::Instr *instr;
	if(Machine::trace) {
		instr=AddInstrTrace();
		//				instr=Machine::trace->NewInstr();
		//				instr->pc=Machine::cpustate.pc;
	}
#endif
	Sim::RunSingleInstruction(the_machine_);
#ifdef bbcDEBUG_TRACE
	if(Machine::trace) {
		instr->a=Machine::cpustate.a;
		instr->p=Machine::cpustate.p;
		instr->x=Machine::cpustate.x;
		instr->y=Machine::cpustate.y;
		instr->s=Machine::cpustate.s.l;
	}
#endif
	if(Machine::irq_flags_) {
#ifdef bbcDEBUG_TRACE
		if(Machine::trace) {
			Machine::AddIrqTrace();
		}
#endif
		if(Machine::irq_flags_&IRQ_NMI) {
			Machine::irq_flags_&=~IRQ_NMI;
			Cpu::NMI(the_machine_);
		} else {
			Cpu::IRQ(the_machine_);
		}
	}
#else
	if(Machine::cpustate.p&t65::I_MASK) {
		//Interrupts disabled. Run until next stop.
		do {
			BASSERT(Machine::cpustate.p&t65::I_MASK);
#ifdef bbcDEBUG_TRACE
			bbcDebugTrace::Instr *instr;
			if(Machine::trace) {
				instr=AddInstrTrace();
//				instr=Machine::trace->NewInstr();
//				instr->pc=Machine::cpustate.pc;
			}
#endif
			Sim::RunSingleInstruction(the_machine_);
#ifdef bbcDEBUG_TRACE
			if(Machine::trace) {
				instr->a=Machine::cpustate.a;
				instr->p=Machine::cpustate.p;
				instr->x=Machine::cpustate.x;
				instr->y=Machine::cpustate.y;
				instr->s=Machine::cpustate.s.l;
			}
#endif
		} while(int(Machine::cycles-Machine::next_stop)<0);
	} else {
		//nterrupts enabled. Run until next stop or until interrupt happens.
		do {
#ifdef bbcDEBUG_TRACE
			bbcDebugTrace::Instr *instr;
			if(Machine::trace) {
				instr=AddInstrTrace();
//				instr=Machine::trace->NewInstr();
//				instr->pc=Machine::cpustate.pc;
			}
#endif
			Sim::RunSingleInstruction(the_beeb);
#ifdef bbcDEBUG_TRACE
			if(Machine::trace) {
				instr->a=Machine::cpustate.a;
				instr->p=Machine::cpustate.p;
				instr->x=Machine::cpustate.x;
				instr->y=Machine::cpustate.y;
				instr->s=Machine::cpustate.s.l;
			}
#endif
		} while(!Machine::irq_flags_&&int(Machine::cycles-Machine::next_stop)<0);
	}
	if(Machine::irq_flags_) {
#ifdef bbcDEBUG_TRACE
		if(Machine::trace) {
			Machine::AddIrqTrace();
		}
#endif
		if(Machine::irq_flags_&IRQ_NMI) {
			Machine::irq_flags_&=~IRQ_NMI;
			Cpu::NMI(the_machine_);
		} else {
			Cpu::IRQ(the_machine_);
		}
	}
#endif//bbcDEBUG_MAIN_LOOP
}

//TODO: this is so shit it's not even funny.
template<class Sim>
bbcReadMmioFn bbcModelGeneric<Sim>::RomSelReadFn() const {
	return Sim::CPUType::Config::romsel_read_fn;
}

template<class Sim>
bbcWriteMmioFn bbcModelGeneric<Sim>::RomSelWriteFn() const {
	return Sim::CPUType::Config::romsel_write_fn;
}

//the old code!!
/*
		if(bbcComputer::irq_flags_) {
#ifdef BEEB_DEBUG_DISASSEMBLY
			if(disassembling_) {
				this->DisassemblyAddIrq();
			}
#endif
			if(bbcComputer::irq_flags_&IRQ_NMI) {
				bbcComputer::irq_flags_&=~IRQ_NMI;
				bbcModelBSim::CPUType::NMI(the_beeb);
			} else {
				bbcModelBSim::CPUType::IRQ(the_beeb);
			}
		}
#ifdef BEEB_DEBUG_DISASSEMBLY
		//This is a quick breakpoint hack for me to use.
		if(bbcComputer::cpustate.pc.w==0xe31) {
			int brk=0;
		}
#endif
		if(bbcComputer::cpustate.p&t65::I_MASK) {
			//Interrupts disabled. Run until next stop.
			while(int(bbcComputer::cycles-bbcComputer::next_stop)<0) {//bbcComputer::cycles<bbcComputer::next_stop) {
				wxASSERT(bbcComputer::cpustate.p&t65::I_MASK);
#ifdef BEEB_DEBUG_DISASSEMBLY
				//bbcComputer::StateType old_state=bbcComputer::cpustate;
				t65::Word dis_addr=bbcComputer::cpustate.pc;
				int dis_cycles=bbcComputer::cycles;
#endif
				bbcModelBSim::RunSingleInstruction(the_beeb);
#ifdef BEEB_DEBUG_DISASSEMBLY
				if(disassembling_) {
					//bbcComputer::StateType new_state=bbcComputer::cpustate;
					this->DisassemblyAddLine(dis_addr,dis_cycles);
				}
#endif
			}
		} else {
			//nterrupts enabled. Run until next stop or until interrupt happens.
			//twPROFILE_BLOCK(pexec);
			while(!bbcComputer::irq_flags_&&
				int(bbcComputer::cycles-bbcComputer::next_stop)<0)
			{
#ifdef BEEB_DEBUG_DISASSEMBLY
				//bbcComputer::StateType old_state=bbcComputer::cpustate;
				t65::Word dis_addr=bbcComputer::cpustate.pc;
				int dis_cycles=bbcComputer::cycles;
#endif
				bbcModelBSim::RunSingleInstruction(the_beeb);
#ifdef BEEB_DEBUG_DISASSEMBLY
				if(disassembling_) {
					//bbcComputer::StateType new_state=bbcComputer::cpustate;
					this->DisassemblyAddLine(dis_addr,dis_cycles);
				}
#endif
			}
		}
*/

#endif
