#include "pch.h"
#include "bbcTeletextFont.h"

void bbcTeletextFont::Init() {
	Convert(normal_chars_src,normal_chars);
	Convert(graphics_chars_src,graphics_chars);
	Convert(sep_graphics_chars_src,sep_graphics_chars);
}

void bbcTeletextFont::Convert(const t65::byte src[96*60],t65::word dest[96][10]) {
	for(unsigned i=0;i<96;++i) {
		for(unsigned j=0;j<10;++j) {
			const t65::byte *this_line=&src[i*60+j*6];
			dest[i][j]=0;
			for(unsigned k=0;k<6;++k) {
				const int shift=(5-k)*2;
				t65::word left_bits=2<<shift;
				t65::word right_bits=1<<shift;
				t65::word bits=left_bits|right_bits;//expand 2x horizontally

				if(this_line[k]) {
					dest[i][j]|=bits;
				}
				if(j>0&&k>0) {
					const t65::byte *prev_line=this_line-6;
					// A B
					// C D (d = dest[i][j])
					bool a=!!prev_line[k-1];
					bool b=!!prev_line[k];
					bool c=!!this_line[k-1];
					bool d=!!this_line[k];

					if(a&&d) {
						dest[i][j-1]|=right_bits;
					}
					if(b&&c) {
						dest[i][j]|=left_bits;
					}
				}
			}
		}
	}
}

t65::word bbcTeletextFont::normal_chars[96][10];
t65::word bbcTeletextFont::graphics_chars[96][10];
t65::word bbcTeletextFont::sep_graphics_chars[96][10];

/* Normal Character Set */
//static char g_teletextCharacters[96*60] = {
const t65::byte bbcTeletextFont::normal_chars_src[96*60]={
  // 0x20 ' '
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x21 '!'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x22 '"'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x23 ' British Pound'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x24 '$'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x25 '%'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x26 '&'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x27 '''
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x28 '('
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x29 ')'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2a '*'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2b '+'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2c ','
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2d '-'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2e '.'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2f '/'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x30 '0'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x31 '1'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x32 '2'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x33 '3'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x34 '4'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x35 '5'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x36 '6'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x37 '7'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x38 '8'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x39 '9'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x3a ':'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x3b ';'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x3c '<'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x3d '='
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x3e '>'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x3f '?'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x40 '@'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x41 'A'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x42 'B'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x43 'C'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x44 'D'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x45 'E'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x46 'F'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x47 'G'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x48 'H'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x49 'I'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4a 'J'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4b 'K'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4c 'L'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4d 'M'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0x00,0xFF,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4e 'N'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4f 'O'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x50 'P'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x51 'Q'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x52 'R'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x53 'S'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x54 'T'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x55 'U'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x56 'V'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x57 'W'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x58 'X'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x59 'Y'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5a 'Z'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5b Left Arrow
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5c ' 1/2 symbol'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5d Right Arrow
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5e Up Arrow
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5f '#'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x60 '_'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x61 'a'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x62 'b'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x63 'c'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x64 'd'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x65 'e'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x66 'f'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x67 'g'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
// 0x68 'h'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x69 'i'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x6a 'j'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x6b 'k'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x6c 'l'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x6d 'm'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x6e 'n'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x6f 'o'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x70 'p'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
// 0x71 'q'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
// 0x72 'r'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0xFF,
  0x00,0x00,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x73 's'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x74 't'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x75 'u'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x76 'v'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x77 'w'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x78 'x'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x79 'y'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
// 0x7a 'z'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x7b 'one fourth symbol'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x7c '|'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x7d ' three fourths symbol'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0xFF,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
// 0x7e Divide
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x7f Block
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
};


/* Graphics Character Set */

const t65::byte bbcTeletextFont::graphics_chars_src[96*60] = {
  // 0x20x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x20xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x22
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x23
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x24
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x25
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x26
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x27
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x28
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x29
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2a
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2b
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2c
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2d
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2e
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x2f
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x30x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x30xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x32
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x33
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x34
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x35
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x36
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x37
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x38
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x39
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x3a
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x3b
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x3c
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x3d
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x3e
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x3f
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
// 0x40 '@'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x41 'A'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x42 'B'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x43 'C'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x44 'D'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x45 'E'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x46 'F'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x47 'G'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x48 'H'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x49 'I'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4a 'J'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4b 'K'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4c 'L'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4d 'M'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0x00,0xFF,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4e 'N'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x4f 'O'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x50 'P'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x51 'Q'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x52 'R'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x53 'S'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x54 'T'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x55 'U'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x56 'V'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x57 'W'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x58 'X'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x59 'Y'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5a 'Z'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5b Left Arrow
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5c ''
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5d Right Arrow
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5e Up Arrow
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x5f '#'
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
// 0x60x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x60xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x62
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x63
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x64
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x65
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x66
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x67
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x68
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x69
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x6a
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x6b
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x6c
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x6d
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x6e
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x6f
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
// 0x70x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x70xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x72
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x73
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x74
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x75
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x76
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x77
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x78
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x79
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x7a
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x7b
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x7c
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x7d
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x7e
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// 0x7f
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
};

/* Separated Graphics Character Set */

const t65::byte bbcTeletextFont::sep_graphics_chars_src[96*60] = {
  // Character ' ' (32)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  // Character '!' (33)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  // Character '"' (34)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '#' (35)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '$' (36)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '%' (37)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '&' (38)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character ''' (39)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '(' (40)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character ')' (41)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '*' (42)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '+' (43)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character ',' (44)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '-' (45)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '.' (46)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '/' (47)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '0' (48)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '1' (49)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '2' (50)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '3' (51)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '4' (52)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '5' (53)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '6' (54)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '7' (55)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '8' (56)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '9' (57)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character ':' (58)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character ';' (59)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '<' (60)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '=' (61)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '>' (62)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '?' (63)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '@' (64)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'A' (65)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'B' (66)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'C' (67)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'D' (68)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'E' (69)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'F' (70)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'G' (71)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'H' (72)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'I' (73)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'J' (74)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'K' (75)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'L' (76)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'M' (77)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0x00,0xFF,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'N' (78)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'O' (79)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'P' (80)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'Q' (81)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'R' (82)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0x00,
  0x00,0xFF,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'S' (83)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'T' (84)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'U' (85)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'V' (86)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'W' (87)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'X' (88)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'Y' (89)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0xFF,0x00,0x00,0x00,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'Z' (90)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '[' (91)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '\' (92)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0x00,0x00,0x00,
  0x00,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character ']' (93)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '^' (94)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0xFF,0xFF,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '_' (95)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '`' (96)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'a' (97)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'b' (98)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'c' (99)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'd' (100)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'e' (101)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'f' (102)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'g' (103)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'h' (104)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'i' (105)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'j' (106)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'k' (107)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'l' (108)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'm' (109)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'n' (110)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'o' (111)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'p' (112)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'q' (113)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'r' (114)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 's' (115)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 't' (116)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'u' (117)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'v' (118)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'w' (119)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'x' (120)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'y' (121)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0x00,
  0xFF,0xFF,0xFF,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character 'z' (122)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '{' (123)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '|' (124)
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '}' (125)
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '~' (126)
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,

  // Character '' (127)
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0xFF,0xFF,0x00,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,
};
