#ifndef mbMISC_H_
#define mbMISC_H_

#include <vector>

bool mbSaveFile(const wxString &filename,const std::vector<wxByte> &contents);
bool mbLoadFile(const wxString &filename,std::vector<wxByte> &contents);
void mbGetMatchingFileNames(const wxFileName &root,const wxString &name_spec,
	std::vector<wxFileName> *file_names);
void mbGetDirectoryNames(const wxFileName &root,std::vector<wxFileName> *dir_names);

//C is probably container of T
//returns true if user clicked ok, false if clicked cancel.
//
//parent -- parent window
//items -- strings representing items in cont
//cont -- the items
//title -- title for the dialog
//caption -- caption in the dialog

static int mbIntCompare(int *a,int *b) {
	return *b-*a;
}

template<class C>
static bool mbRemoveItemsUi(wxWindow *parent,const wxArrayString &items,C *cont,
	const wxString &title,const wxString &caption)
{
	wxASSERT(cont);
	wxASSERT(items.Count()==cont->size());
	wxArrayInt indices;
	wxGetMultipleChoices(indices,caption,title,items,parent);
	
	//Remove the indices starting at the greatest, for obvious reasons,
	//regrettably std::vector will delete only by iterator hence the
	//palaver.
	indices.Sort(&mbIntCompare);
	C::iterator end;
	end=cont->end();
	for(unsigned i=indices.GetCount();i;--i) {
		int idx=indices[i-1];
		std::swap(*--end,cont->at(idx));//oops, C must be a vector or deque for now!
	}
	cont->erase(end,cont->end());
	return indices.Count()>0;
}

wxString mbNormalizedFileName(const wxString &file_name);
wxString mbRelativeFileName(const wxString &file_name,const wxString &base_dir);

#endif
