#include "pch.h"
#include "mbStatusBar.h"

DEFINE_LOCAL_EVENT_TYPE(mbEVT_VOLUME)
DEFINE_LOCAL_EVENT_TYPE(mbEVT_DROPFILE)

enum {
	id_volume=1,
};

mbStatusBar::mbFileDropTarget::mbFileDropTarget(mbStatusBar *owner):
owner_(owner)
{
}

wxDragResult mbStatusBar::mbFileDropTarget::OnDragOver(wxCoord x,wxCoord y,
	wxDragResult def)
{
	bool ok=this->DriveFromPoint(x,y)>=0;
	return ok?wxDragCopy:wxDragNone;
}

int mbStatusBar::mbFileDropTarget::DriveFromPoint(wxCoord x,wxCoord y) {
	int i;

	for(i=0;i<bbcFdd::num_drives;++i) {
		if(owner_->drive_states_[i].rect.Inside(wxPoint(x,y))) {
			break;
		}
	}
	if(i==bbcFdd::num_drives) {
		return -1;
	}
	if(bbcFdd::DriveStatus(i)==bbcFdd::DRIVE_SIDE2) {
		return -1;
	}
	return i;
}

bool mbStatusBar::mbFileDropTarget::OnDropFiles(wxCoord x,wxCoord y,
	const wxArrayString &filenames)
{
	int drive=this->DriveFromPoint(x,y);
	if(filenames.Count()!=1||drive<0) {
		return false;
	}

	wxCommandEvent event(mbEVT_DROPFILE,owner_->GetId());
	event.m_commandInt=drive;
	event.m_commandString=filenames[0];
	//printf("DND: drive %d: \"%s\"\n",event.m_commandInt,event.m_commandString.c_str());
	owner_->ProcessEvent(event);
	return true;
}

mbStatusBar::DriveState::DriveState():
action(bbc1770::ACTION_IDLE),
track(0),
sector(0),
rect(0,0,0,0)
{
}

mbStatusBar::mbStatusBar(wxWindow *parent,int id):
wxStatusBar(parent,id,0)//,wxST_SIZEGRIP)
{
	volume_=new wxSlider(this,id_volume,0,0,100);
	this->SetVolumeEnabled(false);
	this->SetDropTarget(new mbFileDropTarget(this));
}

void mbStatusBar::SetScreenSize(int width,int height) {
	this->SetStatusText(wxString::Format("%dx%d",width,height),1);
}

void mbStatusBar::SetMhz(float mhz) {
	this->SetStatusText(wxString::Format("%.2fMHz",mhz),0);
}

void mbStatusBar::SetFdcStatus(bbc1770::FdcAction action,int drive,int track,
	int sector)
{
	const char *action_name="unknown";
	switch(action) {
	case bbc1770::ACTION_IDLE:
		action_name="idle";
		break;
	case bbc1770::ACTION_OTHER:
		action_name="active";
		break;
	case bbc1770::ACTION_READ:
		action_name="read";
		break;
	case bbc1770::ACTION_WRITE:
		action_name="write";
		break;
	}
	for(int i=0;i<4;++i) {
		int field=3+i;
		if(i!=drive||action==bbc1770::ACTION_IDLE) {
			this->SetStatusText(wxString::Format("%d: idle",i),field);
		} else {
			this->SetStatusText(
				wxString::Format("%d: %s T%d S%d",i,action_name,drive,track,sector),
				field);
		}
	}
}

void mbStatusBar::OnSize(wxSizeEvent &event) {
	int widths[3+bbcFdd::num_drives];
	int w=event.GetSize().GetWidth();
	int third=w/3;
	int rest=w-third;
	int i=0,num_fields=0,drive_fields_base;
	wxRect r;

	widths[num_fields++]=third/3;
	widths[num_fields++]=third/3;
	widths[num_fields++]=third/3;
	drive_fields_base=num_fields;
	for(i=0;i<bbcFdd::num_drives;++i) {
		widths[num_fields++]=rest/bbcFdd::num_drives;
	}
	wxASSERT(i<sizeof widths/sizeof widths[0]);

	this->SetFieldsCount(num_fields);
	this->SetStatusWidths(num_fields,widths);
	this->GetFieldRect(2,r);
	volume_->SetSize(r);

	for(i=0;i<bbcFdd::num_drives;++i) {
		this->GetFieldRect(drive_fields_base+i,drive_states_[i].rect);
	}
}

void mbStatusBar::OnVolume(wxScrollEvent &event) {
	wxCommandEvent evt(mbEVT_VOLUME,this->GetId());
	evt.m_extraLong=volume_->GetValue();
	//wxLogDebug("mbStatusBar::OnVolume: value=%ld\n",evt.m_extraLong);
	this->ProcessEvent(evt);//AddPendingEvent(evt);
}

void mbStatusBar::SetVolume(int volume) {
	wxASSERT(volume>=0&&volume<=100);
	volume_->SetValue(volume);
}

void mbStatusBar::SetVolumeEnabled(bool enabled) {
	volume_->Enable(enabled);
}

BEGIN_EVENT_TABLE(mbStatusBar,wxStatusBar)
	EVT_SIZE(mbStatusBar::OnSize)
	EVT_COMMAND_SCROLL(id_volume,mbStatusBar::OnVolume)
END_EVENT_TABLE()
