/**************************************************************************/
/*                                                                        */
/*            em6502 - An X Based 6502 Emulator & Teaching Aid            */
/*            ------------------------------------------------            */
/*              (c) Neil Pollard, University of Bristol 1994              */
/*                                                                        */
/*            Please read the file README for more information            */
/*                                                                        */
/**************************************************************************/
/* create_win.c */

/* Various functions for preparing the windows for display.
 *
 * The functions in this module have been based (broadly) on 
 * examples from The Xlib Programming Manual,
 * Copyright 1989, 1990, 1991 O'Reilly and Associates, Inc.
 * 
 * Please see the file Xlib.Copyright for full details
 *
 * They really need to be completely re-written to take
 * notice of command line conventions, such as the
 * -display parameter */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include "bitmaps/cpu_icon"
#include "bitmaps/mon_icon"
 
Display *display;
int screen_num;

XEvent emu_report, mon_report;
Window emu_win, mon_win;
XFontStruct *emu_font_info, *mon_font_info;
GC emu_gc, mon_gc;

extern char *progname;

/*=======================================================================*/
/* Connect the program to a server for window display.
 * The display should really be settable from the command line, but
 * this is not yet implemented */

void connect_to_server()
{

char *display_name = NULL;

/* connect to X server */
if ( (display=XOpenDisplay(display_name)) == NULL )
	{
	fprintf( stderr, "%s: cannot connect to X server %s\n", 
				progname, XDisplayName(display_name));
	exit( -1 );
	}
}

/*=======================================================================*/
/* Open the emulator window ready for text display.
 * A number of options should be taken from the command line, but
 * are not implemented yet */

void create_emu_window(argc,argv)
int argc;
char **argv;
{
	unsigned int emu_width, emu_height;		/* window size */
	int emu_x,emu_y;				/* window position */
	unsigned int emu_border_width = 4;		/* border width */
	unsigned int icon_width, icon_height;		
	char *emu_window_name = "6502 Emulator v1.0";	
	char *cpu_icon_name = "em6502";
	Pixmap cpu_icon_pixmap;
	XSizeHints emu_size_hints;
	XIconSize *size_list;

	/* get screen size */
	screen_num = DefaultScreen(display);

	/* At the moment, the position of the window is not
	settable from the command line */
	emu_x = emu_y = 0;

	/* size window to 40x25 characters */
	emu_width = 360, emu_height = 375;

	/* create opaque window */
	emu_win = XCreateSimpleWindow(display, RootWindow(display,screen_num), 
			emu_x, emu_y, emu_width, emu_height, emu_border_width, 
			BlackPixel(display,screen_num), 
			WhitePixel(display,screen_num));

	/* Create bitmap for the icon */
	cpu_icon_pixmap = XCreateBitmapFromData(display, emu_win, cpu_icon_bits, 
			cpu_icon_width, cpu_icon_height);

	/* Set size hints for window manager. */

#ifdef X11R3
	emu_size_hints.flags = PPosition | PSize | PMinSize | PMaxSize;
	emu_size_hints.x = emu_x;
	emu_size_hints.y = emu_y;
	emu_size_hints.width = emu_width;
	emu_size_hints.height = emu_height;
	emu_size_hints.min_width = 360;
	emu_size_hints.min_height = 375;
	emu_size_hints.max_width = 360;
	emu_size_hints.max_height =375;

#else /* X11R4 or later */

	emu_size_hints.flags = PPosition | PSize | PMinSize | PMaxSize;
	emu_size_hints.min_width = 360;
	emu_size_hints.min_height = 375;
	emu_size_hints.max_width = 360;
	emu_size_hints.max_height =375;
#endif

#ifdef X11R3
	/* set Properties for window manager */
	XSetStandardProperties(display, emu_win, window_name, cpu_icon_name, 
			cpu_icon_pixmap, argv, argc, &emu_size_hints);

#else /* X11R4 or later */
	{
	XWMHints wm_hints;
	XClassHint class_hints;

	/* format of the window name and icon name 
	 * arguments has changed in R4 */
	XTextProperty windowName, iconName;

	/* These calls store window_name and icon_name into
	 * XTextProperty structures and set their other 
	 * fields properly. */
	if (XStringListToTextProperty(&emu_window_name, 1, &windowName) == 0) {
		(void) fprintf( stderr, "%s: structure allocation for windowName failed.\n", 
				progname);
		exit(-1);
	}
		
	if (XStringListToTextProperty(&cpu_icon_name, 1, &iconName) == 0) {
		(void) fprintf( stderr, "%s: structure allocation for iconName failed.\n", 
				progname);
		exit(-1);
	}

	wm_hints.initial_state = NormalState;
	wm_hints.input = True;
	wm_hints.icon_pixmap = cpu_icon_pixmap;
	wm_hints.flags = StateHint | IconPixmapHint | InputHint;

	class_hints.res_name = progname;
	class_hints.res_class = "6502";

	XSetWMProperties(display, emu_win, &windowName, &iconName, 
			argv, argc, &emu_size_hints, &wm_hints, 
			&class_hints);
	}
#endif

	/* Select event types wanted */
	XSelectInput(display, emu_win, ExposureMask | KeyPressMask 
				| StructureNotifyMask);

	load_font(&emu_font_info);

	/* create GC for text */
	get_emu_GC(emu_win, &emu_gc, emu_font_info);

	/* Display window */
	XMapWindow(display, emu_win);

}
/*=======================================================================*/
/* Open the monitor window ready for text and graphics
 * The window size is fixed (subject to cooperation from the wm)
 */
void create_mon_window(argc,argv)
int argc;
char **argv;
{
	unsigned int mon_width, mon_height;		/* window size */
	int mon_x,mon_y;				/* window position */
	unsigned int mon_border_width = 4;
	unsigned int icon_width, icon_height;
	char *mon_window_name = "6502 Monitor";
	char *mon_icon_name = "Monitor";
	Pixmap mon_icon_pixmap;
	XSizeHints mon_size_hints;
	XIconSize *size_list;

	/* get screen size from display structure macro */
	screen_num = DefaultScreen(display);

	/* At the moment, the position of the window is not
	settable from the command line */
	mon_x = 400;
	mon_y = 0;

	/* size window */
	mon_width = 500, mon_height = 350;

	/* create opaque window */
	mon_win = XCreateSimpleWindow(display, RootWindow(display,screen_num), 
			mon_x, mon_y, mon_width, mon_height, mon_border_width, 
			BlackPixel(display,screen_num), 
			WhitePixel(display,screen_num));

	/* Create bitmap for the icon */
	mon_icon_pixmap = XCreateBitmapFromData(display, mon_win, mon_icon_bits, 
			mon_icon_width, mon_icon_height);

	/* Set size hints for window manager. */

#ifdef X11R3
	mon_size_hints.flags = PPosition | PSize | PMinSize | PMaxSize;
	mon_size_hints.x = mon_x;
	mon_size_hints.y = mon_y;
	mon_size_hints.width = mon_width;
	mon_size_hints.height = mon_height;
	mon_size_hints.min_width = 500;
	mon_size_hints.min_height = 350;

#else /* X11R4 or later */

	mon_size_hints.flags = PPosition | PSize | PMinSize | PMaxSize;
	mon_size_hints.min_width = 500;
	mon_size_hints.min_height = 350;
#endif

#ifdef X11R3
	/* set Properties for window manager (always before mapping) */
	XSetStandardProperties(display, mon_win, window_name, mon_icon_name, 
			mon_icon_pixmap, argv, argc, &mon_size_hints);

#else /* X11R4 or later */
	{
	XWMHints wm_hints;
	XClassHint class_hints;

	/* format of the window name and icon name 
	 * arguments has changed in R4 */
	XTextProperty windowName, iconName;

	/* These calls store window_name and icon_name into
	 * XTextProperty structures and set their other 
	 * fields properly. */
	if (XStringListToTextProperty(&mon_window_name, 1, &windowName) == 0) {
		(void) fprintf( stderr, "%s: structure allocation for windowName failed.\n", 
				progname);
		exit(-1);
	}
		
	if (XStringListToTextProperty(&mon_icon_name, 1, &iconName) == 0) {
		(void) fprintf( stderr, "%s: structure allocation for iconName failed.\n", 
				progname);
		exit(-1);
	}

	wm_hints.initial_state = NormalState;
	wm_hints.input = True;
	wm_hints.icon_pixmap = mon_icon_pixmap;
	wm_hints.flags = StateHint | IconPixmapHint | InputHint;

	class_hints.res_name = progname;
	class_hints.res_class = "6502";

	XSetWMProperties(display, mon_win, &windowName, &iconName, 
			argv, argc, &mon_size_hints, &wm_hints, 
			&class_hints);
	}
#endif

	/* Select event types wanted */
	XSelectInput(display, mon_win, ExposureMask | KeyPressMask |
		PointerMotionHintMask |
		ButtonPressMask	| StructureNotifyMask);

	load_font(&mon_font_info);

	/* create GC for text and graphics */
	get_mon_GC(mon_win, &mon_gc, mon_font_info);

	/* Display window */
	XMapWindow(display, mon_win);

}
