/**************************************************************************/
/*                                                                        */
/*            em6502 - An X Based 6502 Emulator & Teaching Aid            */
/*            ------------------------------------------------            */
/*              (c) Neil Pollard, University of Bristol 1994              */
/*                                                                        */
/*            Please read the file README for more information            */
/*                                                                        */
/**************************************************************************/
/* memory.h */

/* 64K of main memory, 32K RAM, 32K ROM */
extern unsigned char M[0x10000];

/* 16 banks of sideways ROM, which can be paged in and out of the
 * memory locations 0x8000 to 0xc000.
 * Languages normally live here */

extern unsigned char paged_rom[16][0x4000];

/* Macro for memory read operation */
#define readmem(A) M[A]

/* Macro for write operations
 * ROM cannot be written to, except for location 0xfe30 which is
 * a switch to page in one of the 16 paged ROMS */

#define writemem(A,B)\
 if ((A<0x8000) || (A==0xfe30))\
	M[A]=(B)

