/**************************************************************************/
/*                                                                        */
/*            em6502 - An X Based 6502 Emulator & Teaching Aid            */
/*            ------------------------------------------------            */
/*              (c) Neil Pollard, University of Bristol 1994              */
/*                                                                        */
/*            Please read the file README for more information            */
/*                                                                        */
/**************************************************************************/
/* win_utils.c */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include "memory.h"
#include "window.h"

extern char *progname;

/*======================================================================*/
/* Get graphic context for the emulator window */
get_emu_GC(win, gc, font_info)
Window win;
GC *gc;
XFontStruct *font_info;
{
	unsigned long valuemask = 0;
	XGCValues values;

	/* Create default Graphics Context */
	*gc = XCreateGC(display, win, valuemask, &values);

	XSetFont(display, *gc, font_info->fid);

	XSetForeground(display, *gc, BlackPixel(display,screen_num));

}
/*======================================================================*/
/* Get graphics context for the monitor window */

get_mon_GC(win, gc, font_info)
Window win;
GC *gc;
XFontStruct *font_info;
{
	unsigned long valuemask = 0;
	XGCValues values;
	
	/* Create default Graphics Context */
	*gc = XCreateGC(display, win, valuemask, &values);

	XSetFont(display, *gc, font_info->fid);

	XSetForeground(display, *gc, BlackPixel(display,screen_num));
	
}

/*======================================================================*/
/* Load a window font */

load_font(font_info)
XFontStruct **font_info;
{
	char *fontname = "9x15";

	/* Load 9x15 font */
	if ((*font_info = XLoadQueryFont(display,fontname)) == NULL)
	{
		fprintf(stderr, "%s: Cannot open 9x15 font\n",progname);
		exit(-1);
	}
}

/*======================================================================*/
/* This function transfers a section of screen memory imto the main 
 * window.
 * The format is that of the BBC Micro's MODE 7:
 * 
 * Each byte represents the ASCII code of one character.
 * Each of the 25 lines consists of 40 characters.
 * The start address of the screen memory is stored in memory 0x350,0x351
 * (screen start address is never below 0x7c00)
 * If the screen continues beyond 0x8000, it wraps around to 0x7c00
 *
 */

inline void draw_emu_window(win, gc, font_info)

Window win;
GC gc;
XFontStruct *font_info;

{
/* current line and character within that line */
unsigned char line_number, char_number;

/* current cell (byte) to be rpinted */
int  current_cell;

/* The start address of the screen is stored in 0x350,351 */
current_cell = M[0x350]+( M[0x351] << 8);

/* Clear the window */
XClearWindow(display,win);

/* Draw each line in turn */
for (line_number = 0; line_number < 25; line_number++)
	{
	/* Draw each character within the current line */
	for (char_number = 0; char_number < 40; char_number++)
		{
		XDrawString(display, win, gc, (9*char_number), 
		(15*(line_number+1)),(M+current_cell), 1);
		

		/* Advance to next byte of screen memory */
		current_cell++;

		/* The screen wraps around from 0x8000 to 0x7c00 */
		if (current_cell==0x8000)
			current_cell=0x7c00;
		}
	}	
}
/*======================================================================*/
/* TO DO:
 *
 * Provide a more general method of writing to the screen.
 * Provide graphics support. 
 */
