/*
 * Model B+ emulation
 */

#ifndef BPLUS_H
#define BPLUS_H

#include "CompEmul.h"
#include "VIA6522.h"
#include "MemEmul.h"

#define SYSVIA BPlusSysVIA
#include "StdSysVIA.h"
#undef SYSVIA

#define USRVIA BPlusUsrVIA
#include "StdUsrVIA.h"
#undef USRVIA

class ACIA;
class BPlusEmul;

class BPlusMem: public MemEmul
{
protected:
	BPlusSysVIA *sysVIA;
	BPlusUsrVIA *usrVIA;
	ACIA *acia;
	
	byte paged12K[0x3000];
	byte shadowRAM[0x5000];
	int paged_in;
	int shadow;
	
	BPlusEmul *parent;

public:
	BPlusMem (BPlusEmul *p);
	virtual ~BPlusMem (void);
	
	inline void Write (int addr, byte val);
	inline byte Read (int addr);
};

class BPlusEmul: public CompEmul
{
protected:
	friend class BPlusMem;

public:
	BPlusEmul (void);
	virtual ~BPlusEmul (void);
	
	virtual void ExecThread (void);
};

#endif /* BPLUS_H */

/* End of file. */
