/*
 * ByteFIFO class
 * Provides a variable-length FIFO of bytes.
 * (used by AcornTUBE etc.)
 */

#ifndef BYTEFIFO_H
#define BYTEFIFO_H

#include "types.h"

// Utility classes
class ByteFIFO
{
protected:
	byte *data;
	int len;
	int first, last;
	friend class TUBE;

public:
	ByteFIFO (int size);
	~ByteFIFO (void);
	byte Read (void);
	void Write (byte val);
	int Empty (void) const;
	int Full (void) const;
	int GetFirst (void) const { return first; }
	int GetLast (void) const { return last; }
	void Reset (void);
};

#endif /* BYTEFIFO_H */

/* End of file. */
