/*
 * Generic "computer" emulation.
 */

#include "CompEmul.h"

#include "MemEmul.h"
#include "utils.h"

#include <stdlib.h>

CompEmul::CompEmul (void)
{
	num_tickers = 0;
}

void CompEmul::DoTicks (int ticks)
{
	int i;
	
	for (i = 0; i < num_tickers; i++)
		tickers[i]->DoTicks (ticks);
}

void CompEmul::Break (void)
{
	cpu->ResetCPU ();
	for (ListElem<MMIO_Dev *> *e = mem->mmio.getFirst (); e != NULL; e = e->getNext ())
		(**e)->Break ();
}

void CompEmul::Reset (void)
{
	cpu->ResetCPU ();
	for (ListElem<MMIO_Dev *> *e = mem->mmio.getFirst (); e != NULL; e = e->getNext ())
		(**e)->Reset ();
}

void CompEmul::Add_Ticker (MMIO_Dev *dev, int add_dev, int dev_mask,
	int dev_addr)
{
	if (add_dev)
		AddDev (dev, dev_mask, dev_addr);
	tickers[num_tickers++] = dev;
}

void CompEmul::Remove_Ticker (MMIO_Dev *dev, int remove_dev)
{
	int i;
	
	for (i = 0; i < num_tickers; i++)
		if (tickers[i] == dev)
			break;
	if (i < num_tickers)
		for (; i < (num_tickers - 1); i++)
			tickers[i] = tickers[i + 1];
	num_tickers--;
	if (remove_dev)
		RemoveDev (dev);
}

void CompEmul::AddDev (MMIO_Dev *dev, int mask, int addr)
{
	mem->AddDev (dev, mask, addr);
	dev->AddOK ();
}

void CompEmul::RemoveDev (MMIO_Dev *dev)
{
	mem->RemoveDev (dev);
	dev->RemoveOK ();
}

void CompEmul::SetArgs (char *args)
{
	if (strlen (args) > 0)
	{
		fprintf (stderr, "%s: This model does not take any options.\n",
			args);
		exit (0);
	}
}

void CompEmul::ReadROM (int slot, char *fname)
{
	mem->ReadROM (slot, fname);
}

void CompEmul::SetRAM (int slot)
{
	mem->SetSW (slot, 1);
}

/* End of file. */
