/*
 * Generic "computer" emulation.
 */

#ifndef COMPEMUL_H
#define COMPEMUL_H

/*
 Basically this is a holding class for the main
 bits and pieces which go to make up the basic
 computer. This is the base class for "model"
 emulation.
*/

#include "dlc/dlc_base.h"

class CPUEmul;
class MemEmul;
class MMIO_Dev;

#define MAX_TICKERS 100

// Make this class dynamically loadable
class CompEmul: public DLC_BASE
{
public:
	CPUEmul *cpu;
	MemEmul *mem;
	void DoTicks (int ticks);
	int num_tickers;
	MMIO_Dev *tickers[MAX_TICKERS];
	
	virtual void Reset (void);
	virtual void Break (void);
	virtual void Add_Ticker (MMIO_Dev *dev, int add_dev = 0,
		int dev_mask = -1, int dev_addr = -1);
	virtual void Remove_Ticker (MMIO_Dev *dev, int remove_dev = 0);
	virtual void AddDev (MMIO_Dev *dev, int mask = -1, int addr = -1);
	virtual void RemoveDev (MMIO_Dev *dev);
	
	virtual void ReadROM (int slot, char *fname);
	virtual void SetRAM (int slot);
	
	CompEmul (void);
	
	virtual void SetArgs (char *args);
	
	virtual void ExecThread (void) = 0;
};

#endif /* COMPEMUL_H */

/* End of file. */
