/*
 * General disc emulation classes
 */

#ifndef DISCEMUL_H
#define DISCEMUL_H

#include <stdio.h>
#include <string.h>
#include "Registry.h"

#define MAXDRIVES 3

class DiscEmul
{
protected:
	FILE *disc[MAXDRIVES];
	char *disc_fname[MAXDRIVES];
	int disc_rdonly[MAXDRIVES];
	int disc_nsectors[MAXDRIVES];
	
	char *description;
	int ndrives;
	
	int cur_drive;

public:
	FILE *dfile;
	int rdonly;
	int nsectors;
	
	int flags;
#define DISC_FLG_WD1770 1
	
	inline DiscEmul (int ndrv, char *desc);
	inline ~DiscEmul (void);
	inline void OpenDiscFile (char *fname, int drive = 0,
		int ro = 0, int spt = 10);
	inline void SelectDriveNum (int drv);
	const char *getDescrip (void) { return (const char *)description; }
	const char *getDiscFName (int drive) { return disc_fname[drive]; }
	int getDrives (void) { return ndrives; }
};

DiscEmul::DiscEmul (int ndrv, char *desc)
{
	int i;
	
	ndrives = ndrv;
	description = desc;
	
	for (i = 0; i < MAXDRIVES; i++)
	{
		disc[i] = NULL;
		disc_rdonly[i] = 0;
		disc_nsectors[i] = 0;
		disc_fname[i] = 0;
	}
	
	dfile = NULL;
	rdonly = 0;
	
	flags = 0;
	
	cur_drive = 0;
	
	// Register it.
	Register_Disc (this);
}

DiscEmul::~DiscEmul (void)
{
	Unregister_Disc (this);
}

void DiscEmul::OpenDiscFile (char *fname, int drive, int ro, int spt)
{
	printf ("OpenDiscFile %d\n", drive);
	
	if (disc[drive])
		fclose (disc[drive]);
	if (disc_fname[drive])
		free (disc_fname[drive]);
	disc_fname[drive] = strdup (fname);
	if (ro)
	{
		disc[drive] = fopen (fname, "r");
		disc_rdonly[drive] = 1;
	}
	else
	{
		disc[drive] = fopen (fname, "r+");
		disc_rdonly[drive] = 0;
	}
	disc_nsectors[drive] = spt;
	if (drive == cur_drive)
	{
		printf ("Update DiscEmul.\n");
		dfile = disc[drive];
		rdonly = disc_rdonly[drive];
		nsectors = disc_nsectors[drive];
	}
}

void DiscEmul::SelectDriveNum (int drv)
{
	if (drv < 0 || drv > MAXDRIVES) return;
	
	dfile = disc[drv];
	rdonly = disc_rdonly[drv];
	nsectors = disc_nsectors[drv];
	cur_drive = drv;
}

#endif /* DISCEMUL_H */

/* End of file. */
