/*
 * Western Digital 1770 disc controller emulation
 */

#ifndef WD1770_H
#define WD1770_H

#include <stdio.h>
#include "MemEmul.h"

class DiscEmul;

class WD1770: public MMIO_Dev
{
protected:
	byte status;
	byte buf[256];
	
	int cur_side, cur_track;
	int r_status, r_track, r_sector, r_data;
	// Cycles to command completion
	int cycles;
	int step_dir;
	
	int motor, spinup, busy, data, data_repeats, data_ready, data_read;
	int nf_err;
	int bytes;
	int type;
	
	int sector_end;
	
	virtual void SignalInt (void);
	
	DiscEmul *the_disc;

public:
	WD1770 (void);
	virtual ~WD1770 (void);
	virtual byte MMIO_Read (int reg);
	virtual void MMIO_Write (int reg, byte val);
	// Functions controlled by drive select
	virtual void DoTicks (int ticks);
	virtual void Reset (void);
};

// B/B+/Electron
class DrvCtrl: public MMIO_Dev
{
protected:
	DiscEmul *disc;
	int status;

public:
	DrvCtrl (void);
	virtual byte MMIO_Read (int addr);
	virtual void MMIO_Write (int addr, byte val);
};

#endif /* WD1770_H */

/* End of file. */
