#include "misc.hpp"

/*
 * JOYSTICK.HPP
 *
 * Together with JOYSTICK.CPP, this file provides the basic functionality
 * needed to:
 *  - test wether a joystick is present
 *  - automatically calibrating the joystick
 *  - reading the joystick position
 *
 * As I have only one joystick, I have not added complete support for a
 * second joystick, but it should be straightforward to add.
 */


class Gamecard;
class Joystick;

class Gamecard
	{
	friend Joystick;

		Gamecard() {};
		static UINT xa,ya,xb,yb;
		static UCHAR buttons;
		static BOOL present;

	public:
		static BOOL poll();
		static BOOL	isPresent()
			{ return present; }
		static BOOL reset(BOOL = TRUE);
	};

class Joystick
	{
	public:
		Joystick(int, UINT = 0xffff);
		void getPosition(int &, int &);
		BOOL isPresent()
			{ return minX != 0; }
		void setResolution(UINT res)
			{ resolution = res; }
		UINT getResolution()
			{ return resolution; }
        void calibrate();
		BOOL isButtonPressed(int);

	protected:
		UINT joyNo, resolution;
		UCHAR button1;
		UINT &dx, &dy;
		int minX, minY, maxX, maxY;

	};

extern Joystick joystickA;
